# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetVolumesResult',
    'AwaitableGetVolumesResult',
    'get_volumes',
    'get_volumes_output',
]

@pulumi.output_type
class GetVolumesResult:
    """
    A collection of values returned by getVolumes.
    """
    def __init__(__self__, availability_zone=None, enterprise_project_id=None, id=None, region=None, server_id=None, shareable=None, status=None, tags=None, volumes=None):
        if availability_zone and not isinstance(availability_zone, str):
            raise TypeError("Expected argument 'availability_zone' to be a str")
        pulumi.set(__self__, "availability_zone", availability_zone)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if server_id and not isinstance(server_id, str):
            raise TypeError("Expected argument 'server_id' to be a str")
        pulumi.set(__self__, "server_id", server_id)
        if shareable and not isinstance(shareable, bool):
            raise TypeError("Expected argument 'shareable' to be a bool")
        pulumi.set(__self__, "shareable", shareable)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if volumes and not isinstance(volumes, list):
            raise TypeError("Expected argument 'volumes' to be a list")
        pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[str]:
        """
        The availability zone of the disk.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[str]:
        """
        The ID of the enterprise project associated with the disk.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> Optional[str]:
        """
        The ID of the server to which the disk is attached.
        """
        return pulumi.get(self, "server_id")

    @property
    @pulumi.getter
    def shareable(self) -> Optional[bool]:
        """
        Whether the disk is shareable.
        """
        return pulumi.get(self, "shareable")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The disk status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        The disk tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.GetVolumesVolumeResult']:
        """
        The detailed information of the disks. Structure is documented below.
        """
        return pulumi.get(self, "volumes")


class AwaitableGetVolumesResult(GetVolumesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVolumesResult(
            availability_zone=self.availability_zone,
            enterprise_project_id=self.enterprise_project_id,
            id=self.id,
            region=self.region,
            server_id=self.server_id,
            shareable=self.shareable,
            status=self.status,
            tags=self.tags,
            volumes=self.volumes)


def get_volumes(availability_zone: Optional[str] = None,
                enterprise_project_id: Optional[str] = None,
                region: Optional[str] = None,
                server_id: Optional[str] = None,
                shareable: Optional[bool] = None,
                status: Optional[str] = None,
                tags: Optional[Mapping[str, str]] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVolumesResult:
    """
    Use this data source to query the detailed information list of the EVS disks within HuaweiCloud.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    target_server = config.require_object("targetServer")
    test = huaweicloud.Evs.get_volumes(server_id=target_server)
    ```


    :param str availability_zone: Specifies the availability zone for the disks.
    :param str enterprise_project_id: Specifies the enterprise project ID for filtering.
    :param str region: Specifies the region in which to query the disk list.
           If omitted, the provider-level region will be used.
    :param str server_id: Specifies the server ID to which the disks are attached.
    :param bool shareable: Specifies whether the disk is shareable.
    :param str status: Specifies the disk status. The valid values are as following:
           + **FREEZED**
           + **BIND_ERROR**
           + **BINDING**
           + **PENDING_DELETE**
           + **PENDING_CREATE**
           + **NOTIFYING**
           + **NOTIFY_DELETE**
           + **PENDING_UPDATE**
           + **DOWN**
           + **ACTIVE**
           + **ELB**
           + **ERROR**
           + **VPN**
    :param Mapping[str, str] tags: Specifies the included key/value pairs which associated with the desired disk.
    """
    __args__ = dict()
    __args__['availabilityZone'] = availability_zone
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['region'] = region
    __args__['serverId'] = server_id
    __args__['shareable'] = shareable
    __args__['status'] = status
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Evs/getVolumes:getVolumes', __args__, opts=opts, typ=GetVolumesResult).value

    return AwaitableGetVolumesResult(
        availability_zone=__ret__.availability_zone,
        enterprise_project_id=__ret__.enterprise_project_id,
        id=__ret__.id,
        region=__ret__.region,
        server_id=__ret__.server_id,
        shareable=__ret__.shareable,
        status=__ret__.status,
        tags=__ret__.tags,
        volumes=__ret__.volumes)


@_utilities.lift_output_func(get_volumes)
def get_volumes_output(availability_zone: Optional[pulumi.Input[Optional[str]]] = None,
                       enterprise_project_id: Optional[pulumi.Input[Optional[str]]] = None,
                       region: Optional[pulumi.Input[Optional[str]]] = None,
                       server_id: Optional[pulumi.Input[Optional[str]]] = None,
                       shareable: Optional[pulumi.Input[Optional[bool]]] = None,
                       status: Optional[pulumi.Input[Optional[str]]] = None,
                       tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVolumesResult]:
    """
    Use this data source to query the detailed information list of the EVS disks within HuaweiCloud.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    target_server = config.require_object("targetServer")
    test = huaweicloud.Evs.get_volumes(server_id=target_server)
    ```


    :param str availability_zone: Specifies the availability zone for the disks.
    :param str enterprise_project_id: Specifies the enterprise project ID for filtering.
    :param str region: Specifies the region in which to query the disk list.
           If omitted, the provider-level region will be used.
    :param str server_id: Specifies the server ID to which the disks are attached.
    :param bool shareable: Specifies whether the disk is shareable.
    :param str status: Specifies the disk status. The valid values are as following:
           + **FREEZED**
           + **BIND_ERROR**
           + **BINDING**
           + **PENDING_DELETE**
           + **PENDING_CREATE**
           + **NOTIFYING**
           + **NOTIFY_DELETE**
           + **PENDING_UPDATE**
           + **DOWN**
           + **ACTIVE**
           + **ELB**
           + **ERROR**
           + **VPN**
    :param Mapping[str, str] tags: Specifies the included key/value pairs which associated with the desired disk.
    """
    ...
