# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetCertificateResult',
    'AwaitableGetCertificateResult',
    'get_certificate',
    'get_certificate_output',
]

@pulumi.output_type
class GetCertificateResult:
    """
    A collection of values returned by getCertificate.
    """
    def __init__(__self__, description=None, domain=None, expiration=None, id=None, name=None, region=None, type=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if expiration and not isinstance(expiration, str):
            raise TypeError("Expected argument 'expiration' to be a str")
        pulumi.set(__self__, "expiration", expiration)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Human-readable description for the Certificate.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        The domain of the Certificate. This parameter is valid only when `type` is "server".
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def expiration(self) -> str:
        """
        Indicates the time when the certificate expires.
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")


class AwaitableGetCertificateResult(GetCertificateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificateResult(
            description=self.description,
            domain=self.domain,
            expiration=self.expiration,
            id=self.id,
            name=self.name,
            region=self.region,
            type=self.type)


def get_certificate(name: Optional[str] = None,
                    region: Optional[str] = None,
                    type: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCertificateResult:
    """
    Use this data source to get the certificates in HuaweiCloud Elastic Load Balance (ELB).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    certificate_name = config.require_object("certificateName")
    test = huaweicloud.Elb.get_certificate(name=certificate_name,
        type="server")
    ```


    :param str name: The name of certificate. The value is case sensitive and does not supports fuzzy matching.
    :param str region: The region in which to obtain the ELB certificate. If omitted, the provider-level region
           will be used.
    :param str type: Specifies the certificate type. The default value is `server`. The value can be one of the
           following:
           + `server`: indicates the server certificate.
           + `client`: indicates the CA certificate.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Elb/getCertificate:getCertificate', __args__, opts=opts, typ=GetCertificateResult).value

    return AwaitableGetCertificateResult(
        description=__ret__.description,
        domain=__ret__.domain,
        expiration=__ret__.expiration,
        id=__ret__.id,
        name=__ret__.name,
        region=__ret__.region,
        type=__ret__.type)


@_utilities.lift_output_func(get_certificate)
def get_certificate_output(name: Optional[pulumi.Input[str]] = None,
                           region: Optional[pulumi.Input[Optional[str]]] = None,
                           type: Optional[pulumi.Input[Optional[str]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCertificateResult]:
    """
    Use this data source to get the certificates in HuaweiCloud Elastic Load Balance (ELB).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    certificate_name = config.require_object("certificateName")
    test = huaweicloud.Elb.get_certificate(name=certificate_name,
        type="server")
    ```


    :param str name: The name of certificate. The value is case sensitive and does not supports fuzzy matching.
    :param str region: The region in which to obtain the ELB certificate. If omitted, the provider-level region
           will be used.
    :param str type: Specifies the certificate type. The default value is `server`. The value can be one of the
           following:
           + `server`: indicates the server certificate.
           + `client`: indicates the CA certificate.
    """
    ...
