# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'InstanceBandwidthArgs',
    'InstanceBlockDeviceArgs',
    'InstanceDataDiskArgs',
    'InstanceNetworkArgs',
    'InstanceSchedulerHintArgs',
    'InstanceVolumeAttachedArgs',
    'GetInstanceSchedulerHintArgs',
]

@pulumi.input_type
class InstanceBandwidthArgs:
    def __init__(__self__, *,
                 share_type: pulumi.Input[str],
                 charge_mode: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] share_type: Specifies the bandwidth sharing type. Changing this creates a new instance.
               Possible values are as follows:
               + **PER**: Dedicated bandwidth
               + **WHOLE**: Shared bandwidth
        :param pulumi.Input[str] charge_mode: Specifies the bandwidth billing mode. The value can be *traffic* or *bandwidth*.
               Changing this creates a new instance.
        :param pulumi.Input[str] id: Specifies the **shared** bandwidth id. This parameter is mandatory when
               `share_type` is set to **WHOLE**. Changing this creates a new instance.
        :param pulumi.Input[int] size: Specifies the bandwidth size. The value ranges from 1 to 300 Mbit/s.
               This parameter is mandatory when `share_type` is set to **PER**. Changing this creates a new instance.
        """
        pulumi.set(__self__, "share_type", share_type)
        if charge_mode is not None:
            pulumi.set(__self__, "charge_mode", charge_mode)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter(name="shareType")
    def share_type(self) -> pulumi.Input[str]:
        """
        Specifies the bandwidth sharing type. Changing this creates a new instance.
        Possible values are as follows:
        + **PER**: Dedicated bandwidth
        + **WHOLE**: Shared bandwidth
        """
        return pulumi.get(self, "share_type")

    @share_type.setter
    def share_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "share_type", value)

    @property
    @pulumi.getter(name="chargeMode")
    def charge_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the bandwidth billing mode. The value can be *traffic* or *bandwidth*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "charge_mode")

    @charge_mode.setter
    def charge_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charge_mode", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the **shared** bandwidth id. This parameter is mandatory when
        `share_type` is set to **WHOLE**. Changing this creates a new instance.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the bandwidth size. The value ranges from 1 to 300 Mbit/s.
        This parameter is mandatory when `share_type` is set to **PER**. Changing this creates a new instance.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)


@pulumi.input_type
class InstanceBlockDeviceArgs:
    def __init__(__self__, *,
                 source_type: pulumi.Input[str],
                 boot_index: Optional[pulumi.Input[int]] = None,
                 delete_on_termination: Optional[pulumi.Input[bool]] = None,
                 destination_type: Optional[pulumi.Input[str]] = None,
                 guest_format: Optional[pulumi.Input[str]] = None,
                 uuid: Optional[pulumi.Input[str]] = None,
                 volume_size: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] uuid: Specifies the network UUID to attach to the instance.
               Changing this creates a new instance.
        """
        pulumi.set(__self__, "source_type", source_type)
        if boot_index is not None:
            pulumi.set(__self__, "boot_index", boot_index)
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if destination_type is not None:
            pulumi.set(__self__, "destination_type", destination_type)
        if guest_format is not None:
            pulumi.set(__self__, "guest_format", guest_format)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_type", value)

    @property
    @pulumi.getter(name="bootIndex")
    def boot_index(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "boot_index")

    @boot_index.setter
    def boot_index(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "boot_index", value)

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "delete_on_termination")

    @delete_on_termination.setter
    def delete_on_termination(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_on_termination", value)

    @property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "destination_type")

    @destination_type.setter
    def destination_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_type", value)

    @property
    @pulumi.getter(name="guestFormat")
    def guest_format(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "guest_format")

    @guest_format.setter
    def guest_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "guest_format", value)

    @property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the network UUID to attach to the instance.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uuid", value)

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "volume_size")

    @volume_size.setter
    def volume_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "volume_size", value)


@pulumi.input_type
class InstanceDataDiskArgs:
    def __init__(__self__, *,
                 size: pulumi.Input[int],
                 type: pulumi.Input[str],
                 snapshot_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] size: Specifies the bandwidth size. The value ranges from 1 to 300 Mbit/s.
               This parameter is mandatory when `share_type` is set to **PER**. Changing this creates a new instance.
        :param pulumi.Input[str] type: Specifies the ECS data disk type, which must be one of available disk types,
               contains of *SSD*, *GPSSD* and *SAS*. Changing this creates a new instance.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        Specifies the bandwidth size. The value ranges from 1 to 300 Mbit/s.
        This parameter is mandatory when `share_type` is set to **PER**. Changing this creates a new instance.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the ECS data disk type, which must be one of available disk types,
        contains of *SSD*, *GPSSD* and *SAS*. Changing this creates a new instance.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_id", value)


@pulumi.input_type
class InstanceNetworkArgs:
    def __init__(__self__, *,
                 access_network: Optional[pulumi.Input[bool]] = None,
                 fixed_ip_v4: Optional[pulumi.Input[str]] = None,
                 fixed_ip_v6: Optional[pulumi.Input[str]] = None,
                 ipv6_enable: Optional[pulumi.Input[bool]] = None,
                 mac: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[str]] = None,
                 source_dest_check: Optional[pulumi.Input[bool]] = None,
                 uuid: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] access_network: Specifies if this network should be used for provisioning access.
               Accepts true or false. Defaults to false.
        :param pulumi.Input[str] fixed_ip_v4: Specifies a fixed IPv4 address to be used on this network.
               Changing this creates a new instance.
        :param pulumi.Input[bool] ipv6_enable: Specifies whether the IPv6 function is enabled for the nic.
               Defaults to false. Changing this creates a new instance.
        :param pulumi.Input[bool] source_dest_check: Specifies whether the ECS processes only traffic that is destined specifically
               for it. This function is enabled by default but should be disabled if the ECS functions as a SNAT server or has a
               virtual IP address bound to it.
        :param pulumi.Input[str] uuid: Specifies the network UUID to attach to the instance.
               Changing this creates a new instance.
        """
        if access_network is not None:
            pulumi.set(__self__, "access_network", access_network)
        if fixed_ip_v4 is not None:
            pulumi.set(__self__, "fixed_ip_v4", fixed_ip_v4)
        if fixed_ip_v6 is not None:
            pulumi.set(__self__, "fixed_ip_v6", fixed_ip_v6)
        if ipv6_enable is not None:
            pulumi.set(__self__, "ipv6_enable", ipv6_enable)
        if mac is not None:
            pulumi.set(__self__, "mac", mac)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if source_dest_check is not None:
            pulumi.set(__self__, "source_dest_check", source_dest_check)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter(name="accessNetwork")
    def access_network(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if this network should be used for provisioning access.
        Accepts true or false. Defaults to false.
        """
        return pulumi.get(self, "access_network")

    @access_network.setter
    def access_network(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "access_network", value)

    @property
    @pulumi.getter(name="fixedIpV4")
    def fixed_ip_v4(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a fixed IPv4 address to be used on this network.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "fixed_ip_v4")

    @fixed_ip_v4.setter
    def fixed_ip_v4(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fixed_ip_v4", value)

    @property
    @pulumi.getter(name="fixedIpV6")
    def fixed_ip_v6(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "fixed_ip_v6")

    @fixed_ip_v6.setter
    def fixed_ip_v6(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fixed_ip_v6", value)

    @property
    @pulumi.getter(name="ipv6Enable")
    def ipv6_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the IPv6 function is enabled for the nic.
        Defaults to false. Changing this creates a new instance.
        """
        return pulumi.get(self, "ipv6_enable")

    @ipv6_enable.setter
    def ipv6_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv6_enable", value)

    @property
    @pulumi.getter
    def mac(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "mac")

    @mac.setter
    def mac(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mac", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="sourceDestCheck")
    def source_dest_check(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the ECS processes only traffic that is destined specifically
        for it. This function is enabled by default but should be disabled if the ECS functions as a SNAT server or has a
        virtual IP address bound to it.
        """
        return pulumi.get(self, "source_dest_check")

    @source_dest_check.setter
    def source_dest_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "source_dest_check", value)

    @property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the network UUID to attach to the instance.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uuid", value)


@pulumi.input_type
class InstanceSchedulerHintArgs:
    def __init__(__self__, *,
                 deh_id: Optional[pulumi.Input[str]] = None,
                 fault_domain: Optional[pulumi.Input[str]] = None,
                 group: Optional[pulumi.Input[str]] = None,
                 tenancy: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] deh_id: Specifies the ID of DeH.
               This parameter takes effect only when the value of tenancy is dedicated. Changing this creates a new instance.
        :param pulumi.Input[str] group: Specifies a UUID of a Server Group.
               The instance will be placed into that group. Changing this creates a new instance.
        :param pulumi.Input[str] tenancy: Specifies the tenancy specifies whether the ECS is to be created on a
               Dedicated Host
               (DeH) or in a shared pool. Changing this creates a new instance.
        """
        if deh_id is not None:
            pulumi.set(__self__, "deh_id", deh_id)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if tenancy is not None:
            pulumi.set(__self__, "tenancy", tenancy)

    @property
    @pulumi.getter(name="dehId")
    def deh_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of DeH.
        This parameter takes effect only when the value of tenancy is dedicated. Changing this creates a new instance.
        """
        return pulumi.get(self, "deh_id")

    @deh_id.setter
    def deh_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deh_id", value)

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "fault_domain")

    @fault_domain.setter
    def fault_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fault_domain", value)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a UUID of a Server Group.
        The instance will be placed into that group. Changing this creates a new instance.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter
    def tenancy(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the tenancy specifies whether the ECS is to be created on a
        Dedicated Host
        (DeH) or in a shared pool. Changing this creates a new instance.
        """
        return pulumi.get(self, "tenancy")

    @tenancy.setter
    def tenancy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenancy", value)


@pulumi.input_type
class InstanceVolumeAttachedArgs:
    def __init__(__self__, *,
                 boot_index: Optional[pulumi.Input[int]] = None,
                 pci_address: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 volume_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] size: Specifies the bandwidth size. The value ranges from 1 to 300 Mbit/s.
               This parameter is mandatory when `share_type` is set to **PER**. Changing this creates a new instance.
        :param pulumi.Input[str] type: Specifies the ECS data disk type, which must be one of available disk types,
               contains of *SSD*, *GPSSD* and *SAS*. Changing this creates a new instance.
        """
        if boot_index is not None:
            pulumi.set(__self__, "boot_index", boot_index)
        if pci_address is not None:
            pulumi.set(__self__, "pci_address", pci_address)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)

    @property
    @pulumi.getter(name="bootIndex")
    def boot_index(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "boot_index")

    @boot_index.setter
    def boot_index(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "boot_index", value)

    @property
    @pulumi.getter(name="pciAddress")
    def pci_address(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "pci_address")

    @pci_address.setter
    def pci_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pci_address", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the bandwidth size. The value ranges from 1 to 300 Mbit/s.
        This parameter is mandatory when `share_type` is set to **PER**. Changing this creates a new instance.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ECS data disk type, which must be one of available disk types,
        contains of *SSD*, *GPSSD* and *SAS*. Changing this creates a new instance.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_id", value)


@pulumi.input_type
class GetInstanceSchedulerHintArgs:
    def __init__(__self__, *,
                 group: str):
        """
        :param str group: The UUID of a Server Group where the instance will be placed into.
        """
        pulumi.set(__self__, "group", group)

    @property
    @pulumi.getter
    def group(self) -> str:
        """
        The UUID of a Server Group where the instance will be placed into.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: str):
        pulumi.set(self, "group", value)


