# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['RabbitmqInstanceArgs', 'RabbitmqInstance']

@pulumi.input_type
class RabbitmqInstanceArgs:
    def __init__(__self__, *,
                 access_user: pulumi.Input[str],
                 network_id: pulumi.Input[str],
                 password: pulumi.Input[str],
                 product_id: pulumi.Input[str],
                 security_group_id: pulumi.Input[str],
                 storage_spec_code: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 maintain_begin: Optional[pulumi.Input[str]] = None,
                 maintain_end: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 public_ip_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 ssl_enable: Optional[pulumi.Input[bool]] = None,
                 storage_space: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a RabbitmqInstance resource.
        :param pulumi.Input[str] access_user: Specifies a username. A username consists of 4 to 64 characters and
               supports only letters, digits, and hyphens (-). Changing this creates a new instance resource.
        :param pulumi.Input[str] network_id: Specifies the ID of a subnet. Changing this creates a new instance
               resource.
        :param pulumi.Input[str] password: Specifies the password of the DMS RabbitMQ instance. A password must meet
               the following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of the following
               character types: lowercase letters, uppercase letters, digits,
               and special characters (`~!@#$%^&*()-_=+\\\\|[{}]:'",<.>/?).
               Changing this creates a new instance resource.
        :param pulumi.Input[str] product_id: Specifies a product ID. Changing this creates a new instance resource.
        :param pulumi.Input[str] security_group_id: Specifies the ID of a security group.
        :param pulumi.Input[str] storage_spec_code: Specifies the storage I/O specification.
               Valid values are **dms.physical.storage.high** and **dms.physical.storage.ultra**.
               Changing this creates a new instance resource.
        :param pulumi.Input[str] vpc_id: Specifies the ID of a VPC. Changing this creates a new instance resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: Specifies the names of an AZ.
               The parameter value can not be left blank or an empty array.
               Changing this creates a new instance resource.
        :param pulumi.Input[str] description: Specifies the description of the DMS RabbitMQ instance.
               It is a character string containing not more than 1,024 characters.
        :param pulumi.Input[str] engine_version: Specifies the version of the RabbitMQ engine. Default to "3.7.17".
               Changing this creates a new instance resource.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project ID of the RabbitMQ instance.
        :param pulumi.Input[str] maintain_begin: Specifies the time at which a maintenance time window starts. Format: HH:mm.
               The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
               time window.
               The start time must be set to 22:00, 02:00, 06:00, 10:00, 14:00, or 18:00. Parameters `maintain_begin`
               and `maintain_end` must be set in pairs. If parameter `maintain_begin` is left blank, parameter `maintain_end` is also
               blank. In this case, the system automatically allocates the default start time 02:00.
        :param pulumi.Input[str] maintain_end: Specifies the time at which a maintenance time window ends. Format: HH:mm.
               The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
               time window. The end time is four hours later than the start time.
               For example, if the start time is 22:00, the end time is 02:00.
               Parameters `maintain_begin` and `maintain_end` must be set in pairs.
               If parameter `maintain_end` is left  blank, parameter `maintain_begin` is also blank.
               In this case, the system automatically allocates the default end time 06:00.
        :param pulumi.Input[str] name: Specifies the name of the DMS RabbitMQ instance. An instance name starts with a letter,
               consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        :param pulumi.Input[str] public_ip_id: Specifies the ID of the elastic IP address (EIP)
               bound to the DMS RabbitMQ instance.
        :param pulumi.Input[str] region: The region in which to create the DMS RabbitMQ instance resource. If omitted,
               the provider-level region will be used. Changing this creates a new instance resource.
        :param pulumi.Input[bool] ssl_enable: Specifies whether to enable public access for the DMS RabbitMQ instance.
               Changing this creates a new instance resource.
        :param pulumi.Input[int] storage_space: Specifies the message storage space, unit is GB. Value range:
               + Single-node RabbitMQ instance: 100–90,000 GB
               + Cluster RabbitMQ instance: 100 GB x number of nodes to 90,000 GB, 200 GB x number of nodes to 90,000 GB,
               and 300 GB x number of nodes to 90,000 GB
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the DMS RabbitMQ instance.
        """
        pulumi.set(__self__, "access_user", access_user)
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "product_id", product_id)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "storage_spec_code", storage_spec_code)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if available_zones is not None:
            warnings.warn("""available_zones has deprecated, please use \"availability_zones\" instead.""", DeprecationWarning)
            pulumi.log.warn("""available_zones is deprecated: available_zones has deprecated, please use \"availability_zones\" instead.""")
        if available_zones is not None:
            pulumi.set(__self__, "available_zones", available_zones)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if maintain_begin is not None:
            pulumi.set(__self__, "maintain_begin", maintain_begin)
        if maintain_end is not None:
            pulumi.set(__self__, "maintain_end", maintain_end)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_ip_id is not None:
            pulumi.set(__self__, "public_ip_id", public_ip_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if ssl_enable is not None:
            pulumi.set(__self__, "ssl_enable", ssl_enable)
        if storage_space is not None:
            pulumi.set(__self__, "storage_space", storage_space)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="accessUser")
    def access_user(self) -> pulumi.Input[str]:
        """
        Specifies a username. A username consists of 4 to 64 characters and
        supports only letters, digits, and hyphens (-). Changing this creates a new instance resource.
        """
        return pulumi.get(self, "access_user")

    @access_user.setter
    def access_user(self, value: pulumi.Input[str]):
        pulumi.set(self, "access_user", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of a subnet. Changing this creates a new instance
        resource.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        Specifies the password of the DMS RabbitMQ instance. A password must meet
        the following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of the following
        character types: lowercase letters, uppercase letters, digits,
        and special characters (`~!@#$%^&*()-_=+\\\\|[{}]:'",<.>/?).
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Input[str]:
        """
        Specifies a product ID. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of a security group.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="storageSpecCode")
    def storage_spec_code(self) -> pulumi.Input[str]:
        """
        Specifies the storage I/O specification.
        Valid values are **dms.physical.storage.high** and **dms.physical.storage.ultra**.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "storage_spec_code")

    @storage_spec_code.setter
    def storage_spec_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_spec_code", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of a VPC. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the names of an AZ.
        The parameter value can not be left blank or an empty array.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="availableZones")
    def available_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "available_zones")

    @available_zones.setter
    def available_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "available_zones", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the DMS RabbitMQ instance.
        It is a character string containing not more than 1,024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the version of the RabbitMQ engine. Default to "3.7.17".
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project ID of the RabbitMQ instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the time at which a maintenance time window starts. Format: HH:mm.
        The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
        time window.
        The start time must be set to 22:00, 02:00, 06:00, 10:00, 14:00, or 18:00. Parameters `maintain_begin`
        and `maintain_end` must be set in pairs. If parameter `maintain_begin` is left blank, parameter `maintain_end` is also
        blank. In this case, the system automatically allocates the default start time 02:00.
        """
        return pulumi.get(self, "maintain_begin")

    @maintain_begin.setter
    def maintain_begin(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintain_begin", value)

    @property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the time at which a maintenance time window ends. Format: HH:mm.
        The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
        time window. The end time is four hours later than the start time.
        For example, if the start time is 22:00, the end time is 02:00.
        Parameters `maintain_begin` and `maintain_end` must be set in pairs.
        If parameter `maintain_end` is left  blank, parameter `maintain_begin` is also blank.
        In this case, the system automatically allocates the default end time 06:00.
        """
        return pulumi.get(self, "maintain_end")

    @maintain_end.setter
    def maintain_end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintain_end", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the DMS RabbitMQ instance. An instance name starts with a letter,
        consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publicIpId")
    def public_ip_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the elastic IP address (EIP)
        bound to the DMS RabbitMQ instance.
        """
        return pulumi.get(self, "public_ip_id")

    @public_ip_id.setter
    def public_ip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the DMS RabbitMQ instance resource. If omitted,
        the provider-level region will be used. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable public access for the DMS RabbitMQ instance.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "ssl_enable")

    @ssl_enable.setter
    def ssl_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ssl_enable", value)

    @property
    @pulumi.getter(name="storageSpace")
    def storage_space(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the message storage space, unit is GB. Value range:
        + Single-node RabbitMQ instance: 100–90,000 GB
        + Cluster RabbitMQ instance: 100 GB x number of nodes to 90,000 GB, 200 GB x number of nodes to 90,000 GB,
        and 300 GB x number of nodes to 90,000 GB
        """
        return pulumi.get(self, "storage_space")

    @storage_space.setter
    def storage_space(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_space", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value pairs to associate with the DMS RabbitMQ instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _RabbitmqInstanceState:
    def __init__(__self__, *,
                 access_user: Optional[pulumi.Input[str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 connect_address: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_public_ip: Optional[pulumi.Input[bool]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 maintain_begin: Optional[pulumi.Input[str]] = None,
                 maintain_end: Optional[pulumi.Input[str]] = None,
                 manegement_connect_address: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 public_ip_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resource_spec_code: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 specification: Optional[pulumi.Input[str]] = None,
                 ssl_enable: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 storage_space: Optional[pulumi.Input[int]] = None,
                 storage_spec_code: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 used_storage_space: Optional[pulumi.Input[int]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RabbitmqInstance resources.
        :param pulumi.Input[str] access_user: Specifies a username. A username consists of 4 to 64 characters and
               supports only letters, digits, and hyphens (-). Changing this creates a new instance resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: Specifies the names of an AZ.
               The parameter value can not be left blank or an empty array.
               Changing this creates a new instance resource.
        :param pulumi.Input[str] connect_address: Indicates the IP address of the DMS RabbitMQ instance.
        :param pulumi.Input[str] description: Specifies the description of the DMS RabbitMQ instance.
               It is a character string containing not more than 1,024 characters.
        :param pulumi.Input[bool] enable_public_ip: Indicates whether public access to the DMS RabbitMQ instance is enabled.
        :param pulumi.Input[str] engine: Indicates the message engine.
        :param pulumi.Input[str] engine_version: Specifies the version of the RabbitMQ engine. Default to "3.7.17".
               Changing this creates a new instance resource.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project ID of the RabbitMQ instance.
        :param pulumi.Input[str] maintain_begin: Specifies the time at which a maintenance time window starts. Format: HH:mm.
               The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
               time window.
               The start time must be set to 22:00, 02:00, 06:00, 10:00, 14:00, or 18:00. Parameters `maintain_begin`
               and `maintain_end` must be set in pairs. If parameter `maintain_begin` is left blank, parameter `maintain_end` is also
               blank. In this case, the system automatically allocates the default start time 02:00.
        :param pulumi.Input[str] maintain_end: Specifies the time at which a maintenance time window ends. Format: HH:mm.
               The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
               time window. The end time is four hours later than the start time.
               For example, if the start time is 22:00, the end time is 02:00.
               Parameters `maintain_begin` and `maintain_end` must be set in pairs.
               If parameter `maintain_end` is left  blank, parameter `maintain_begin` is also blank.
               In this case, the system automatically allocates the default end time 06:00.
        :param pulumi.Input[str] manegement_connect_address: Indicates the management address of the DMS RabbitMQ instance.
        :param pulumi.Input[str] name: Specifies the name of the DMS RabbitMQ instance. An instance name starts with a letter,
               consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        :param pulumi.Input[str] network_id: Specifies the ID of a subnet. Changing this creates a new instance
               resource.
        :param pulumi.Input[str] password: Specifies the password of the DMS RabbitMQ instance. A password must meet
               the following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of the following
               character types: lowercase letters, uppercase letters, digits,
               and special characters (`~!@#$%^&*()-_=+\\\\|[{}]:'",<.>/?).
               Changing this creates a new instance resource.
        :param pulumi.Input[int] port: Indicates the port number of the DMS RabbitMQ instance.
        :param pulumi.Input[str] product_id: Specifies a product ID. Changing this creates a new instance resource.
        :param pulumi.Input[str] public_ip_id: Specifies the ID of the elastic IP address (EIP)
               bound to the DMS RabbitMQ instance.
        :param pulumi.Input[str] region: The region in which to create the DMS RabbitMQ instance resource. If omitted,
               the provider-level region will be used. Changing this creates a new instance resource.
        :param pulumi.Input[str] resource_spec_code: Indicates a resource specifications identifier.
        :param pulumi.Input[str] security_group_id: Specifies the ID of a security group.
        :param pulumi.Input[str] specification: Indicates the instance specification. For a single-node DMS RabbitMQ instance, VM specifications are
               returned. For a cluster DMS RabbitMQ instance, VM specifications and the number of nodes are returned.
        :param pulumi.Input[bool] ssl_enable: Specifies whether to enable public access for the DMS RabbitMQ instance.
               Changing this creates a new instance resource.
        :param pulumi.Input[str] status: Indicates the status of the DMS RabbitMQ instance.
        :param pulumi.Input[int] storage_space: Specifies the message storage space, unit is GB. Value range:
               + Single-node RabbitMQ instance: 100–90,000 GB
               + Cluster RabbitMQ instance: 100 GB x number of nodes to 90,000 GB, 200 GB x number of nodes to 90,000 GB,
               and 300 GB x number of nodes to 90,000 GB
        :param pulumi.Input[str] storage_spec_code: Specifies the storage I/O specification.
               Valid values are **dms.physical.storage.high** and **dms.physical.storage.ultra**.
               Changing this creates a new instance resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the DMS RabbitMQ instance.
        :param pulumi.Input[str] type: Indicates the DMS RabbitMQ instance type.
        :param pulumi.Input[int] used_storage_space: Indicates the used message storage space. Unit: GB
        :param pulumi.Input[str] user_id: Indicates the ID of the user who created the DMS RabbitMQ instance
        :param pulumi.Input[str] user_name: Indicates the name of the user who created the DMS RabbitMQ instance
        :param pulumi.Input[str] vpc_id: Specifies the ID of a VPC. Changing this creates a new instance resource.
        """
        if access_user is not None:
            pulumi.set(__self__, "access_user", access_user)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if available_zones is not None:
            warnings.warn("""available_zones has deprecated, please use \"availability_zones\" instead.""", DeprecationWarning)
            pulumi.log.warn("""available_zones is deprecated: available_zones has deprecated, please use \"availability_zones\" instead.""")
        if available_zones is not None:
            pulumi.set(__self__, "available_zones", available_zones)
        if connect_address is not None:
            pulumi.set(__self__, "connect_address", connect_address)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_public_ip is not None:
            pulumi.set(__self__, "enable_public_ip", enable_public_ip)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if maintain_begin is not None:
            pulumi.set(__self__, "maintain_begin", maintain_begin)
        if maintain_end is not None:
            pulumi.set(__self__, "maintain_end", maintain_end)
        if manegement_connect_address is not None:
            pulumi.set(__self__, "manegement_connect_address", manegement_connect_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if public_ip_id is not None:
            pulumi.set(__self__, "public_ip_id", public_ip_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_spec_code is not None:
            pulumi.set(__self__, "resource_spec_code", resource_spec_code)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if specification is not None:
            pulumi.set(__self__, "specification", specification)
        if ssl_enable is not None:
            pulumi.set(__self__, "ssl_enable", ssl_enable)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_space is not None:
            pulumi.set(__self__, "storage_space", storage_space)
        if storage_spec_code is not None:
            pulumi.set(__self__, "storage_spec_code", storage_spec_code)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if used_storage_space is not None:
            pulumi.set(__self__, "used_storage_space", used_storage_space)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="accessUser")
    def access_user(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a username. A username consists of 4 to 64 characters and
        supports only letters, digits, and hyphens (-). Changing this creates a new instance resource.
        """
        return pulumi.get(self, "access_user")

    @access_user.setter
    def access_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_user", value)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the names of an AZ.
        The parameter value can not be left blank or an empty array.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="availableZones")
    def available_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "available_zones")

    @available_zones.setter
    def available_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "available_zones", value)

    @property
    @pulumi.getter(name="connectAddress")
    def connect_address(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the IP address of the DMS RabbitMQ instance.
        """
        return pulumi.get(self, "connect_address")

    @connect_address.setter
    def connect_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connect_address", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the DMS RabbitMQ instance.
        It is a character string containing not more than 1,024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enablePublicIp")
    def enable_public_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether public access to the DMS RabbitMQ instance is enabled.
        """
        return pulumi.get(self, "enable_public_ip")

    @enable_public_ip.setter
    def enable_public_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_public_ip", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the message engine.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the version of the RabbitMQ engine. Default to "3.7.17".
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project ID of the RabbitMQ instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the time at which a maintenance time window starts. Format: HH:mm.
        The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
        time window.
        The start time must be set to 22:00, 02:00, 06:00, 10:00, 14:00, or 18:00. Parameters `maintain_begin`
        and `maintain_end` must be set in pairs. If parameter `maintain_begin` is left blank, parameter `maintain_end` is also
        blank. In this case, the system automatically allocates the default start time 02:00.
        """
        return pulumi.get(self, "maintain_begin")

    @maintain_begin.setter
    def maintain_begin(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintain_begin", value)

    @property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the time at which a maintenance time window ends. Format: HH:mm.
        The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
        time window. The end time is four hours later than the start time.
        For example, if the start time is 22:00, the end time is 02:00.
        Parameters `maintain_begin` and `maintain_end` must be set in pairs.
        If parameter `maintain_end` is left  blank, parameter `maintain_begin` is also blank.
        In this case, the system automatically allocates the default end time 06:00.
        """
        return pulumi.get(self, "maintain_end")

    @maintain_end.setter
    def maintain_end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintain_end", value)

    @property
    @pulumi.getter(name="manegementConnectAddress")
    def manegement_connect_address(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the management address of the DMS RabbitMQ instance.
        """
        return pulumi.get(self, "manegement_connect_address")

    @manegement_connect_address.setter
    def manegement_connect_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manegement_connect_address", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the DMS RabbitMQ instance. An instance name starts with a letter,
        consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of a subnet. Changing this creates a new instance
        resource.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the password of the DMS RabbitMQ instance. A password must meet
        the following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of the following
        character types: lowercase letters, uppercase letters, digits,
        and special characters (`~!@#$%^&*()-_=+\\\\|[{}]:'",<.>/?).
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates the port number of the DMS RabbitMQ instance.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a product ID. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter(name="publicIpId")
    def public_ip_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the elastic IP address (EIP)
        bound to the DMS RabbitMQ instance.
        """
        return pulumi.get(self, "public_ip_id")

    @public_ip_id.setter
    def public_ip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the DMS RabbitMQ instance resource. If omitted,
        the provider-level region will be used. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resourceSpecCode")
    def resource_spec_code(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates a resource specifications identifier.
        """
        return pulumi.get(self, "resource_spec_code")

    @resource_spec_code.setter
    def resource_spec_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_spec_code", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of a security group.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter
    def specification(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the instance specification. For a single-node DMS RabbitMQ instance, VM specifications are
        returned. For a cluster DMS RabbitMQ instance, VM specifications and the number of nodes are returned.
        """
        return pulumi.get(self, "specification")

    @specification.setter
    def specification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "specification", value)

    @property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable public access for the DMS RabbitMQ instance.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "ssl_enable")

    @ssl_enable.setter
    def ssl_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ssl_enable", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the status of the DMS RabbitMQ instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="storageSpace")
    def storage_space(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the message storage space, unit is GB. Value range:
        + Single-node RabbitMQ instance: 100–90,000 GB
        + Cluster RabbitMQ instance: 100 GB x number of nodes to 90,000 GB, 200 GB x number of nodes to 90,000 GB,
        and 300 GB x number of nodes to 90,000 GB
        """
        return pulumi.get(self, "storage_space")

    @storage_space.setter
    def storage_space(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_space", value)

    @property
    @pulumi.getter(name="storageSpecCode")
    def storage_spec_code(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the storage I/O specification.
        Valid values are **dms.physical.storage.high** and **dms.physical.storage.ultra**.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "storage_spec_code")

    @storage_spec_code.setter
    def storage_spec_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_spec_code", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value pairs to associate with the DMS RabbitMQ instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the DMS RabbitMQ instance type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="usedStorageSpace")
    def used_storage_space(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates the used message storage space. Unit: GB
        """
        return pulumi.get(self, "used_storage_space")

    @used_storage_space.setter
    def used_storage_space(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "used_storage_space", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the ID of the user who created the DMS RabbitMQ instance
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the name of the user who created the DMS RabbitMQ instance
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of a VPC. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class RabbitmqInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_user: Optional[pulumi.Input[str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 maintain_begin: Optional[pulumi.Input[str]] = None,
                 maintain_end: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 public_ip_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 ssl_enable: Optional[pulumi.Input[bool]] = None,
                 storage_space: Optional[pulumi.Input[int]] = None,
                 storage_spec_code: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manage DMS RabbitMQ instance resources within HuaweiCloud.

        ## Example Usage
        ### Basic Instance

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        security_group_id = config.require_object("securityGroupId")
        zones = huaweicloud.get_availability_zones()
        test_product = huaweicloud.Dms.get_product(engine="rabbitmq",
            instance_type="cluster",
            version="3.7.17",
            node_num="3")
        test_rabbitmq_instance = huaweicloud.dms.RabbitmqInstance("testRabbitmqInstance",
            product_id=test_product.id,
            engine_version=test_product.version,
            storage_spec_code=test_product.storage_spec_code,
            vpc_id=vpc_id,
            network_id=subnet_id,
            security_group_id=security_group_id,
            availability_zones=[zones.names[0]],
            access_user="user",
            password="Rabbitmqtest@123")
        ```

        ## Import

        DMS RabbitMQ instance can be imported using the instance id, e.g.

        ```sh
         $ pulumi import huaweicloud:Dms/rabbitmqInstance:RabbitmqInstance huaweicloud_dms_rabbitmq_instance.instance_1 8d3c7938-dc47-4937-a30f-c80de381c5e3
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`password`. It is generally recommended running `terraform plan` after importing a DMS RabbitMQ instance. You can then decide if changes should be applied to the instance, or the resource definition should be updated to align with the instance. Also you can ignore changes as below. resource "huaweicloud_dms_rabbitmq_instance" "instance_1" {

         ...

         lifecycle {

         ignore_changes = [

         password

         ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_user: Specifies a username. A username consists of 4 to 64 characters and
               supports only letters, digits, and hyphens (-). Changing this creates a new instance resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: Specifies the names of an AZ.
               The parameter value can not be left blank or an empty array.
               Changing this creates a new instance resource.
        :param pulumi.Input[str] description: Specifies the description of the DMS RabbitMQ instance.
               It is a character string containing not more than 1,024 characters.
        :param pulumi.Input[str] engine_version: Specifies the version of the RabbitMQ engine. Default to "3.7.17".
               Changing this creates a new instance resource.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project ID of the RabbitMQ instance.
        :param pulumi.Input[str] maintain_begin: Specifies the time at which a maintenance time window starts. Format: HH:mm.
               The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
               time window.
               The start time must be set to 22:00, 02:00, 06:00, 10:00, 14:00, or 18:00. Parameters `maintain_begin`
               and `maintain_end` must be set in pairs. If parameter `maintain_begin` is left blank, parameter `maintain_end` is also
               blank. In this case, the system automatically allocates the default start time 02:00.
        :param pulumi.Input[str] maintain_end: Specifies the time at which a maintenance time window ends. Format: HH:mm.
               The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
               time window. The end time is four hours later than the start time.
               For example, if the start time is 22:00, the end time is 02:00.
               Parameters `maintain_begin` and `maintain_end` must be set in pairs.
               If parameter `maintain_end` is left  blank, parameter `maintain_begin` is also blank.
               In this case, the system automatically allocates the default end time 06:00.
        :param pulumi.Input[str] name: Specifies the name of the DMS RabbitMQ instance. An instance name starts with a letter,
               consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        :param pulumi.Input[str] network_id: Specifies the ID of a subnet. Changing this creates a new instance
               resource.
        :param pulumi.Input[str] password: Specifies the password of the DMS RabbitMQ instance. A password must meet
               the following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of the following
               character types: lowercase letters, uppercase letters, digits,
               and special characters (`~!@#$%^&*()-_=+\\\\|[{}]:'",<.>/?).
               Changing this creates a new instance resource.
        :param pulumi.Input[str] product_id: Specifies a product ID. Changing this creates a new instance resource.
        :param pulumi.Input[str] public_ip_id: Specifies the ID of the elastic IP address (EIP)
               bound to the DMS RabbitMQ instance.
        :param pulumi.Input[str] region: The region in which to create the DMS RabbitMQ instance resource. If omitted,
               the provider-level region will be used. Changing this creates a new instance resource.
        :param pulumi.Input[str] security_group_id: Specifies the ID of a security group.
        :param pulumi.Input[bool] ssl_enable: Specifies whether to enable public access for the DMS RabbitMQ instance.
               Changing this creates a new instance resource.
        :param pulumi.Input[int] storage_space: Specifies the message storage space, unit is GB. Value range:
               + Single-node RabbitMQ instance: 100–90,000 GB
               + Cluster RabbitMQ instance: 100 GB x number of nodes to 90,000 GB, 200 GB x number of nodes to 90,000 GB,
               and 300 GB x number of nodes to 90,000 GB
        :param pulumi.Input[str] storage_spec_code: Specifies the storage I/O specification.
               Valid values are **dms.physical.storage.high** and **dms.physical.storage.ultra**.
               Changing this creates a new instance resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the DMS RabbitMQ instance.
        :param pulumi.Input[str] vpc_id: Specifies the ID of a VPC. Changing this creates a new instance resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RabbitmqInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage DMS RabbitMQ instance resources within HuaweiCloud.

        ## Example Usage
        ### Basic Instance

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        security_group_id = config.require_object("securityGroupId")
        zones = huaweicloud.get_availability_zones()
        test_product = huaweicloud.Dms.get_product(engine="rabbitmq",
            instance_type="cluster",
            version="3.7.17",
            node_num="3")
        test_rabbitmq_instance = huaweicloud.dms.RabbitmqInstance("testRabbitmqInstance",
            product_id=test_product.id,
            engine_version=test_product.version,
            storage_spec_code=test_product.storage_spec_code,
            vpc_id=vpc_id,
            network_id=subnet_id,
            security_group_id=security_group_id,
            availability_zones=[zones.names[0]],
            access_user="user",
            password="Rabbitmqtest@123")
        ```

        ## Import

        DMS RabbitMQ instance can be imported using the instance id, e.g.

        ```sh
         $ pulumi import huaweicloud:Dms/rabbitmqInstance:RabbitmqInstance huaweicloud_dms_rabbitmq_instance.instance_1 8d3c7938-dc47-4937-a30f-c80de381c5e3
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`password`. It is generally recommended running `terraform plan` after importing a DMS RabbitMQ instance. You can then decide if changes should be applied to the instance, or the resource definition should be updated to align with the instance. Also you can ignore changes as below. resource "huaweicloud_dms_rabbitmq_instance" "instance_1" {

         ...

         lifecycle {

         ignore_changes = [

         password

         ]

         } }

        :param str resource_name: The name of the resource.
        :param RabbitmqInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RabbitmqInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_user: Optional[pulumi.Input[str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 maintain_begin: Optional[pulumi.Input[str]] = None,
                 maintain_end: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 public_ip_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 ssl_enable: Optional[pulumi.Input[bool]] = None,
                 storage_space: Optional[pulumi.Input[int]] = None,
                 storage_spec_code: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RabbitmqInstanceArgs.__new__(RabbitmqInstanceArgs)

            if access_user is None and not opts.urn:
                raise TypeError("Missing required property 'access_user'")
            __props__.__dict__["access_user"] = access_user
            __props__.__dict__["availability_zones"] = availability_zones
            if available_zones is not None and not opts.urn:
                warnings.warn("""available_zones has deprecated, please use \"availability_zones\" instead.""", DeprecationWarning)
                pulumi.log.warn("""available_zones is deprecated: available_zones has deprecated, please use \"availability_zones\" instead.""")
            __props__.__dict__["available_zones"] = available_zones
            __props__.__dict__["description"] = description
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["maintain_begin"] = maintain_begin
            __props__.__dict__["maintain_end"] = maintain_end
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = password
            if product_id is None and not opts.urn:
                raise TypeError("Missing required property 'product_id'")
            __props__.__dict__["product_id"] = product_id
            __props__.__dict__["public_ip_id"] = public_ip_id
            __props__.__dict__["region"] = region
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["ssl_enable"] = ssl_enable
            __props__.__dict__["storage_space"] = storage_space
            if storage_spec_code is None and not opts.urn:
                raise TypeError("Missing required property 'storage_spec_code'")
            __props__.__dict__["storage_spec_code"] = storage_spec_code
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["connect_address"] = None
            __props__.__dict__["enable_public_ip"] = None
            __props__.__dict__["engine"] = None
            __props__.__dict__["manegement_connect_address"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["resource_spec_code"] = None
            __props__.__dict__["specification"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["used_storage_space"] = None
            __props__.__dict__["user_id"] = None
            __props__.__dict__["user_name"] = None
        super(RabbitmqInstance, __self__).__init__(
            'huaweicloud:Dms/rabbitmqInstance:RabbitmqInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_user: Optional[pulumi.Input[str]] = None,
            availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            connect_address: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enable_public_ip: Optional[pulumi.Input[bool]] = None,
            engine: Optional[pulumi.Input[str]] = None,
            engine_version: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            maintain_begin: Optional[pulumi.Input[str]] = None,
            maintain_end: Optional[pulumi.Input[str]] = None,
            manegement_connect_address: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[int]] = None,
            product_id: Optional[pulumi.Input[str]] = None,
            public_ip_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            resource_spec_code: Optional[pulumi.Input[str]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            specification: Optional[pulumi.Input[str]] = None,
            ssl_enable: Optional[pulumi.Input[bool]] = None,
            status: Optional[pulumi.Input[str]] = None,
            storage_space: Optional[pulumi.Input[int]] = None,
            storage_spec_code: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            type: Optional[pulumi.Input[str]] = None,
            used_storage_space: Optional[pulumi.Input[int]] = None,
            user_id: Optional[pulumi.Input[str]] = None,
            user_name: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'RabbitmqInstance':
        """
        Get an existing RabbitmqInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_user: Specifies a username. A username consists of 4 to 64 characters and
               supports only letters, digits, and hyphens (-). Changing this creates a new instance resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: Specifies the names of an AZ.
               The parameter value can not be left blank or an empty array.
               Changing this creates a new instance resource.
        :param pulumi.Input[str] connect_address: Indicates the IP address of the DMS RabbitMQ instance.
        :param pulumi.Input[str] description: Specifies the description of the DMS RabbitMQ instance.
               It is a character string containing not more than 1,024 characters.
        :param pulumi.Input[bool] enable_public_ip: Indicates whether public access to the DMS RabbitMQ instance is enabled.
        :param pulumi.Input[str] engine: Indicates the message engine.
        :param pulumi.Input[str] engine_version: Specifies the version of the RabbitMQ engine. Default to "3.7.17".
               Changing this creates a new instance resource.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project ID of the RabbitMQ instance.
        :param pulumi.Input[str] maintain_begin: Specifies the time at which a maintenance time window starts. Format: HH:mm.
               The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
               time window.
               The start time must be set to 22:00, 02:00, 06:00, 10:00, 14:00, or 18:00. Parameters `maintain_begin`
               and `maintain_end` must be set in pairs. If parameter `maintain_begin` is left blank, parameter `maintain_end` is also
               blank. In this case, the system automatically allocates the default start time 02:00.
        :param pulumi.Input[str] maintain_end: Specifies the time at which a maintenance time window ends. Format: HH:mm.
               The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
               time window. The end time is four hours later than the start time.
               For example, if the start time is 22:00, the end time is 02:00.
               Parameters `maintain_begin` and `maintain_end` must be set in pairs.
               If parameter `maintain_end` is left  blank, parameter `maintain_begin` is also blank.
               In this case, the system automatically allocates the default end time 06:00.
        :param pulumi.Input[str] manegement_connect_address: Indicates the management address of the DMS RabbitMQ instance.
        :param pulumi.Input[str] name: Specifies the name of the DMS RabbitMQ instance. An instance name starts with a letter,
               consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        :param pulumi.Input[str] network_id: Specifies the ID of a subnet. Changing this creates a new instance
               resource.
        :param pulumi.Input[str] password: Specifies the password of the DMS RabbitMQ instance. A password must meet
               the following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of the following
               character types: lowercase letters, uppercase letters, digits,
               and special characters (`~!@#$%^&*()-_=+\\\\|[{}]:'",<.>/?).
               Changing this creates a new instance resource.
        :param pulumi.Input[int] port: Indicates the port number of the DMS RabbitMQ instance.
        :param pulumi.Input[str] product_id: Specifies a product ID. Changing this creates a new instance resource.
        :param pulumi.Input[str] public_ip_id: Specifies the ID of the elastic IP address (EIP)
               bound to the DMS RabbitMQ instance.
        :param pulumi.Input[str] region: The region in which to create the DMS RabbitMQ instance resource. If omitted,
               the provider-level region will be used. Changing this creates a new instance resource.
        :param pulumi.Input[str] resource_spec_code: Indicates a resource specifications identifier.
        :param pulumi.Input[str] security_group_id: Specifies the ID of a security group.
        :param pulumi.Input[str] specification: Indicates the instance specification. For a single-node DMS RabbitMQ instance, VM specifications are
               returned. For a cluster DMS RabbitMQ instance, VM specifications and the number of nodes are returned.
        :param pulumi.Input[bool] ssl_enable: Specifies whether to enable public access for the DMS RabbitMQ instance.
               Changing this creates a new instance resource.
        :param pulumi.Input[str] status: Indicates the status of the DMS RabbitMQ instance.
        :param pulumi.Input[int] storage_space: Specifies the message storage space, unit is GB. Value range:
               + Single-node RabbitMQ instance: 100–90,000 GB
               + Cluster RabbitMQ instance: 100 GB x number of nodes to 90,000 GB, 200 GB x number of nodes to 90,000 GB,
               and 300 GB x number of nodes to 90,000 GB
        :param pulumi.Input[str] storage_spec_code: Specifies the storage I/O specification.
               Valid values are **dms.physical.storage.high** and **dms.physical.storage.ultra**.
               Changing this creates a new instance resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the DMS RabbitMQ instance.
        :param pulumi.Input[str] type: Indicates the DMS RabbitMQ instance type.
        :param pulumi.Input[int] used_storage_space: Indicates the used message storage space. Unit: GB
        :param pulumi.Input[str] user_id: Indicates the ID of the user who created the DMS RabbitMQ instance
        :param pulumi.Input[str] user_name: Indicates the name of the user who created the DMS RabbitMQ instance
        :param pulumi.Input[str] vpc_id: Specifies the ID of a VPC. Changing this creates a new instance resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RabbitmqInstanceState.__new__(_RabbitmqInstanceState)

        __props__.__dict__["access_user"] = access_user
        __props__.__dict__["availability_zones"] = availability_zones
        __props__.__dict__["available_zones"] = available_zones
        __props__.__dict__["connect_address"] = connect_address
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_public_ip"] = enable_public_ip
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["maintain_begin"] = maintain_begin
        __props__.__dict__["maintain_end"] = maintain_end
        __props__.__dict__["manegement_connect_address"] = manegement_connect_address
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["password"] = password
        __props__.__dict__["port"] = port
        __props__.__dict__["product_id"] = product_id
        __props__.__dict__["public_ip_id"] = public_ip_id
        __props__.__dict__["region"] = region
        __props__.__dict__["resource_spec_code"] = resource_spec_code
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["specification"] = specification
        __props__.__dict__["ssl_enable"] = ssl_enable
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_space"] = storage_space
        __props__.__dict__["storage_spec_code"] = storage_spec_code
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["used_storage_space"] = used_storage_space
        __props__.__dict__["user_id"] = user_id
        __props__.__dict__["user_name"] = user_name
        __props__.__dict__["vpc_id"] = vpc_id
        return RabbitmqInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessUser")
    def access_user(self) -> pulumi.Output[str]:
        """
        Specifies a username. A username consists of 4 to 64 characters and
        supports only letters, digits, and hyphens (-). Changing this creates a new instance resource.
        """
        return pulumi.get(self, "access_user")

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Sequence[str]]:
        """
        Specifies the names of an AZ.
        The parameter value can not be left blank or an empty array.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="availableZones")
    def available_zones(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "available_zones")

    @property
    @pulumi.getter(name="connectAddress")
    def connect_address(self) -> pulumi.Output[str]:
        """
        Indicates the IP address of the DMS RabbitMQ instance.
        """
        return pulumi.get(self, "connect_address")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description of the DMS RabbitMQ instance.
        It is a character string containing not more than 1,024 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enablePublicIp")
    def enable_public_ip(self) -> pulumi.Output[bool]:
        """
        Indicates whether public access to the DMS RabbitMQ instance is enabled.
        """
        return pulumi.get(self, "enable_public_ip")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[str]:
        """
        Indicates the message engine.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the version of the RabbitMQ engine. Default to "3.7.17".
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        Specifies the enterprise project ID of the RabbitMQ instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> pulumi.Output[str]:
        """
        Specifies the time at which a maintenance time window starts. Format: HH:mm.
        The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
        time window.
        The start time must be set to 22:00, 02:00, 06:00, 10:00, 14:00, or 18:00. Parameters `maintain_begin`
        and `maintain_end` must be set in pairs. If parameter `maintain_begin` is left blank, parameter `maintain_end` is also
        blank. In this case, the system automatically allocates the default start time 02:00.
        """
        return pulumi.get(self, "maintain_begin")

    @property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> pulumi.Output[str]:
        """
        Specifies the time at which a maintenance time window ends. Format: HH:mm.
        The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
        time window. The end time is four hours later than the start time.
        For example, if the start time is 22:00, the end time is 02:00.
        Parameters `maintain_begin` and `maintain_end` must be set in pairs.
        If parameter `maintain_end` is left  blank, parameter `maintain_begin` is also blank.
        In this case, the system automatically allocates the default end time 06:00.
        """
        return pulumi.get(self, "maintain_end")

    @property
    @pulumi.getter(name="manegementConnectAddress")
    def manegement_connect_address(self) -> pulumi.Output[str]:
        """
        Indicates the management address of the DMS RabbitMQ instance.
        """
        return pulumi.get(self, "manegement_connect_address")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the DMS RabbitMQ instance. An instance name starts with a letter,
        consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of a subnet. Changing this creates a new instance
        resource.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        Specifies the password of the DMS RabbitMQ instance. A password must meet
        the following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of the following
        character types: lowercase letters, uppercase letters, digits,
        and special characters (`~!@#$%^&*()-_=+\\\\|[{}]:'",<.>/?).
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        Indicates the port number of the DMS RabbitMQ instance.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Output[str]:
        """
        Specifies a product ID. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "product_id")

    @property
    @pulumi.getter(name="publicIpId")
    def public_ip_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the ID of the elastic IP address (EIP)
        bound to the DMS RabbitMQ instance.
        """
        return pulumi.get(self, "public_ip_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the DMS RabbitMQ instance resource. If omitted,
        the provider-level region will be used. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resourceSpecCode")
    def resource_spec_code(self) -> pulumi.Output[str]:
        """
        Indicates a resource specifications identifier.
        """
        return pulumi.get(self, "resource_spec_code")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of a security group.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter
    def specification(self) -> pulumi.Output[str]:
        """
        Indicates the instance specification. For a single-node DMS RabbitMQ instance, VM specifications are
        returned. For a cluster DMS RabbitMQ instance, VM specifications and the number of nodes are returned.
        """
        return pulumi.get(self, "specification")

    @property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to enable public access for the DMS RabbitMQ instance.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "ssl_enable")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Indicates the status of the DMS RabbitMQ instance.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storageSpace")
    def storage_space(self) -> pulumi.Output[int]:
        """
        Specifies the message storage space, unit is GB. Value range:
        + Single-node RabbitMQ instance: 100–90,000 GB
        + Cluster RabbitMQ instance: 100 GB x number of nodes to 90,000 GB, 200 GB x number of nodes to 90,000 GB,
        and 300 GB x number of nodes to 90,000 GB
        """
        return pulumi.get(self, "storage_space")

    @property
    @pulumi.getter(name="storageSpecCode")
    def storage_spec_code(self) -> pulumi.Output[str]:
        """
        Specifies the storage I/O specification.
        Valid values are **dms.physical.storage.high** and **dms.physical.storage.ultra**.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "storage_spec_code")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The key/value pairs to associate with the DMS RabbitMQ instance.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Indicates the DMS RabbitMQ instance type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="usedStorageSpace")
    def used_storage_space(self) -> pulumi.Output[int]:
        """
        Indicates the used message storage space. Unit: GB
        """
        return pulumi.get(self, "used_storage_space")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        """
        Indicates the ID of the user who created the DMS RabbitMQ instance
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[str]:
        """
        Indicates the name of the user who created the DMS RabbitMQ instance
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of a VPC. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "vpc_id")

