# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KafkaPermissionsArgs', 'KafkaPermissions']

@pulumi.input_type
class KafkaPermissionsArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[str],
                 policies: pulumi.Input[Sequence[pulumi.Input['KafkaPermissionsPolicyArgs']]],
                 topic_name: pulumi.Input[str],
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a KafkaPermissions resource.
        :param pulumi.Input[str] instance_id: Specifies the ID of the DMS kafka instance to which the permissions belongs.
               Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['KafkaPermissionsPolicyArgs']]] policies: Specifies the permissions policies. The object structure is
               documented below.
        :param pulumi.Input[str] topic_name: Specifies the name of the topic to which the permissions belongs.
               Changing this creates a new resource.
        :param pulumi.Input[str] region: The region in which to create the DMS kafka permissions resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "policies", policies)
        pulumi.set(__self__, "topic_name", topic_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of the DMS kafka instance to which the permissions belongs.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def policies(self) -> pulumi.Input[Sequence[pulumi.Input['KafkaPermissionsPolicyArgs']]]:
        """
        Specifies the permissions policies. The object structure is
        documented below.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: pulumi.Input[Sequence[pulumi.Input['KafkaPermissionsPolicyArgs']]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> pulumi.Input[str]:
        """
        Specifies the name of the topic to which the permissions belongs.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "topic_name")

    @topic_name.setter
    def topic_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "topic_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the DMS kafka permissions resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _KafkaPermissionsState:
    def __init__(__self__, *,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaPermissionsPolicyArgs']]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 topic_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering KafkaPermissions resources.
        :param pulumi.Input[str] instance_id: Specifies the ID of the DMS kafka instance to which the permissions belongs.
               Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['KafkaPermissionsPolicyArgs']]] policies: Specifies the permissions policies. The object structure is
               documented below.
        :param pulumi.Input[str] region: The region in which to create the DMS kafka permissions resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] topic_name: Specifies the name of the topic to which the permissions belongs.
               Changing this creates a new resource.
        """
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if topic_name is not None:
            pulumi.set(__self__, "topic_name", topic_name)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the DMS kafka instance to which the permissions belongs.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KafkaPermissionsPolicyArgs']]]]:
        """
        Specifies the permissions policies. The object structure is
        documented below.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaPermissionsPolicyArgs']]]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the DMS kafka permissions resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the topic to which the permissions belongs.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "topic_name")

    @topic_name.setter
    def topic_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic_name", value)


class KafkaPermissions(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KafkaPermissionsPolicyArgs']]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 topic_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Use the resource to grant user permissions of a kafka topic within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        kafka_instance_id = config.require_object("kafkaInstanceId")
        kafka_topic_name = config.require_object("kafkaTopicName")
        user1 = config.require_object("user1")
        user2 = config.require_object("user2")
        test = huaweicloud.dms.KafkaPermissions("test",
            instance_id=kafka_instance_id,
            topic_name=kafka_topic_name,
            policies=[
                huaweicloud.dms.KafkaPermissionsPolicyArgs(
                    user_name=user1,
                    access_policy="all",
                ),
                huaweicloud.dms.KafkaPermissionsPolicyArgs(
                    user_name=user2,
                    access_policy="pub",
                ),
            ])
        ```

        ## Import

        DMS kafka permissions can be imported using the kafka instance ID and topic name separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Dms/kafkaPermissions:KafkaPermissions permissions c8057fe5-23a8-46ef-ad83-c0055b4e0c5c/topic_1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] instance_id: Specifies the ID of the DMS kafka instance to which the permissions belongs.
               Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KafkaPermissionsPolicyArgs']]]] policies: Specifies the permissions policies. The object structure is
               documented below.
        :param pulumi.Input[str] region: The region in which to create the DMS kafka permissions resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] topic_name: Specifies the name of the topic to which the permissions belongs.
               Changing this creates a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KafkaPermissionsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Use the resource to grant user permissions of a kafka topic within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        kafka_instance_id = config.require_object("kafkaInstanceId")
        kafka_topic_name = config.require_object("kafkaTopicName")
        user1 = config.require_object("user1")
        user2 = config.require_object("user2")
        test = huaweicloud.dms.KafkaPermissions("test",
            instance_id=kafka_instance_id,
            topic_name=kafka_topic_name,
            policies=[
                huaweicloud.dms.KafkaPermissionsPolicyArgs(
                    user_name=user1,
                    access_policy="all",
                ),
                huaweicloud.dms.KafkaPermissionsPolicyArgs(
                    user_name=user2,
                    access_policy="pub",
                ),
            ])
        ```

        ## Import

        DMS kafka permissions can be imported using the kafka instance ID and topic name separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Dms/kafkaPermissions:KafkaPermissions permissions c8057fe5-23a8-46ef-ad83-c0055b4e0c5c/topic_1
        ```

        :param str resource_name: The name of the resource.
        :param KafkaPermissionsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KafkaPermissionsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KafkaPermissionsPolicyArgs']]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 topic_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KafkaPermissionsArgs.__new__(KafkaPermissionsArgs)

            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if policies is None and not opts.urn:
                raise TypeError("Missing required property 'policies'")
            __props__.__dict__["policies"] = policies
            __props__.__dict__["region"] = region
            if topic_name is None and not opts.urn:
                raise TypeError("Missing required property 'topic_name'")
            __props__.__dict__["topic_name"] = topic_name
        super(KafkaPermissions, __self__).__init__(
            'huaweicloud:Dms/kafkaPermissions:KafkaPermissions',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KafkaPermissionsPolicyArgs']]]]] = None,
            region: Optional[pulumi.Input[str]] = None,
            topic_name: Optional[pulumi.Input[str]] = None) -> 'KafkaPermissions':
        """
        Get an existing KafkaPermissions resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] instance_id: Specifies the ID of the DMS kafka instance to which the permissions belongs.
               Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KafkaPermissionsPolicyArgs']]]] policies: Specifies the permissions policies. The object structure is
               documented below.
        :param pulumi.Input[str] region: The region in which to create the DMS kafka permissions resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] topic_name: Specifies the name of the topic to which the permissions belongs.
               Changing this creates a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KafkaPermissionsState.__new__(_KafkaPermissionsState)

        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["policies"] = policies
        __props__.__dict__["region"] = region
        __props__.__dict__["topic_name"] = topic_name
        return KafkaPermissions(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of the DMS kafka instance to which the permissions belongs.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def policies(self) -> pulumi.Output[Sequence['outputs.KafkaPermissionsPolicy']]:
        """
        Specifies the permissions policies. The object structure is
        documented below.
        """
        return pulumi.get(self, "policies")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the DMS kafka permissions resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the topic to which the permissions belongs.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "topic_name")

