# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetInstancesResult',
    'AwaitableGetInstancesResult',
    'get_instances',
    'get_instances_output',
]

@pulumi.output_type
class GetInstancesResult:
    """
    A collection of values returned by getInstances.
    """
    def __init__(__self__, enterprise_project_id=None, fuzzy_match=None, id=None, include_failure=None, instance_id=None, instances=None, name=None, region=None, status=None):
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if fuzzy_match and not isinstance(fuzzy_match, bool):
            raise TypeError("Expected argument 'fuzzy_match' to be a bool")
        pulumi.set(__self__, "fuzzy_match", fuzzy_match)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if include_failure and not isinstance(include_failure, bool):
            raise TypeError("Expected argument 'include_failure' to be a bool")
        pulumi.set(__self__, "include_failure", include_failure)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if instances and not isinstance(instances, list):
            raise TypeError("Expected argument 'instances' to be a list")
        pulumi.set(__self__, "instances", instances)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[str]:
        """
        The enterprise project ID to which the instance belongs.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter(name="fuzzyMatch")
    def fuzzy_match(self) -> Optional[bool]:
        return pulumi.get(self, "fuzzy_match")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="includeFailure")
    def include_failure(self) -> Optional[bool]:
        return pulumi.get(self, "include_failure")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[str]:
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetInstancesInstanceResult']:
        """
        The result of the query's list of kafka instances. The structure is documented below.
        """
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The instance name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The instance status.
        """
        return pulumi.get(self, "status")


class AwaitableGetInstancesResult(GetInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstancesResult(
            enterprise_project_id=self.enterprise_project_id,
            fuzzy_match=self.fuzzy_match,
            id=self.id,
            include_failure=self.include_failure,
            instance_id=self.instance_id,
            instances=self.instances,
            name=self.name,
            region=self.region,
            status=self.status)


def get_instances(enterprise_project_id: Optional[str] = None,
                  fuzzy_match: Optional[bool] = None,
                  include_failure: Optional[bool] = None,
                  instance_id: Optional[str] = None,
                  name: Optional[str] = None,
                  region: Optional[str] = None,
                  status: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstancesResult:
    """
    Use this data source to query the available instances within HuaweiCloud DMS service.

    ## Example Usage
    ### Query all instances with the keyword in the name

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    keyword = config.require_object("keyword")
    test = huaweicloud.Dms.get_instances(name=keyword,
        fuzzy_match=True)
    ```
    ### Query the instance with the specified name

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    instance_name = config.require_object("instanceName")
    test = huaweicloud.Dms.get_instances(name=instance_name)
    ```


    :param str enterprise_project_id: Specifies the enterprise project ID to which all instances of the list
           belong.
    :param bool fuzzy_match: Specifies whether to match the instance name fuzzily, the default is a exact
           match (`flase`).
    :param bool include_failure: Specifies whether the query results contain instances that failed to create.
    :param str instance_id: Specifies the kafka instance ID to match exactly.
    :param str name: Specifies the kafka instance name for data-source queries.
    :param str region: The region in which to query the kafka instance list.
           If omitted, the provider-level region will be used.
    :param str status: Specifies the kafka instance status for data-source queries.
    """
    __args__ = dict()
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['fuzzyMatch'] = fuzzy_match
    __args__['includeFailure'] = include_failure
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Dms/getInstances:getInstances', __args__, opts=opts, typ=GetInstancesResult).value

    return AwaitableGetInstancesResult(
        enterprise_project_id=__ret__.enterprise_project_id,
        fuzzy_match=__ret__.fuzzy_match,
        id=__ret__.id,
        include_failure=__ret__.include_failure,
        instance_id=__ret__.instance_id,
        instances=__ret__.instances,
        name=__ret__.name,
        region=__ret__.region,
        status=__ret__.status)


@_utilities.lift_output_func(get_instances)
def get_instances_output(enterprise_project_id: Optional[pulumi.Input[Optional[str]]] = None,
                         fuzzy_match: Optional[pulumi.Input[Optional[bool]]] = None,
                         include_failure: Optional[pulumi.Input[Optional[bool]]] = None,
                         instance_id: Optional[pulumi.Input[Optional[str]]] = None,
                         name: Optional[pulumi.Input[Optional[str]]] = None,
                         region: Optional[pulumi.Input[Optional[str]]] = None,
                         status: Optional[pulumi.Input[Optional[str]]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetInstancesResult]:
    """
    Use this data source to query the available instances within HuaweiCloud DMS service.

    ## Example Usage
    ### Query all instances with the keyword in the name

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    keyword = config.require_object("keyword")
    test = huaweicloud.Dms.get_instances(name=keyword,
        fuzzy_match=True)
    ```
    ### Query the instance with the specified name

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    instance_name = config.require_object("instanceName")
    test = huaweicloud.Dms.get_instances(name=instance_name)
    ```


    :param str enterprise_project_id: Specifies the enterprise project ID to which all instances of the list
           belong.
    :param bool fuzzy_match: Specifies whether to match the instance name fuzzily, the default is a exact
           match (`flase`).
    :param bool include_failure: Specifies whether the query results contain instances that failed to create.
    :param str instance_id: Specifies the kafka instance ID to match exactly.
    :param str name: Specifies the kafka instance name for data-source queries.
    :param str region: The region in which to query the kafka instance list.
           If omitted, the provider-level region will be used.
    :param str status: Specifies the kafka instance status for data-source queries.
    """
    ...
