# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['FlinksqlJobArgs', 'FlinksqlJob']

@pulumi.input_type
class FlinksqlJobArgs:
    def __init__(__self__, *,
                 checkpoint_enabled: Optional[pulumi.Input[bool]] = None,
                 checkpoint_interval: Optional[pulumi.Input[int]] = None,
                 checkpoint_mode: Optional[pulumi.Input[str]] = None,
                 cu_number: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dirty_data_strategy: Optional[pulumi.Input[str]] = None,
                 edge_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 idle_state_retention: Optional[pulumi.Input[int]] = None,
                 log_enabled: Optional[pulumi.Input[bool]] = None,
                 manager_cu_number: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 obs_bucket: Optional[pulumi.Input[str]] = None,
                 parallel_number: Optional[pulumi.Input[int]] = None,
                 queue_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 restart_when_exception: Optional[pulumi.Input[bool]] = None,
                 resume_checkpoint: Optional[pulumi.Input[bool]] = None,
                 resume_max_num: Optional[pulumi.Input[int]] = None,
                 run_mode: Optional[pulumi.Input[str]] = None,
                 runtime_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 smn_topic: Optional[pulumi.Input[str]] = None,
                 sql: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tm_cus: Optional[pulumi.Input[int]] = None,
                 tm_slot_num: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 udf_jar_url: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a FlinksqlJob resource.
        :param pulumi.Input[bool] checkpoint_enabled: Specifies whether to enable the automatic job snapshot function.
               + **true**: indicates to enable the automatic job snapshot function.
               + **false**: indicates to disable the automatic job snapshot function.
        :param pulumi.Input[int] checkpoint_interval: Specifies snapshot interval. The unit is second.
               The default value is 10.
        :param pulumi.Input[str] checkpoint_mode: Specifies snapshot mode. There are two options:
               + **exactly_once**: indicates that data is processed only once.
               + **at_least_once**: indicates that data is processed at least once.
        :param pulumi.Input[int] cu_number: Specifies number of CUs selected for a job. The default value is 2.
        :param pulumi.Input[str] description: Specifies job description. Length range: 1 to 512 characters.
        :param pulumi.Input[str] dirty_data_strategy: Specifies dirty data policy of a job.
               + **2:obsDir**: Save the dirty data to the obs path `obsDir`. For example: `2:yourBucket/output_path`
               + **1**: Trigger a job exception
               + **0**: Ignore
        :param pulumi.Input[Sequence[pulumi.Input[str]]] edge_group_ids: Specifies edge computing group IDs.
        :param pulumi.Input[int] idle_state_retention: Specifies retention time of the idle state. The unit is hour.
               The default value is 1.
        :param pulumi.Input[bool] log_enabled: Specifies whether to enable the function of uploading job logs to
               users' OBS buckets. The default value is false.
        :param pulumi.Input[int] manager_cu_number: Specifies number of CUs in the JobManager selected for a job.
               The default value is 1.
        :param pulumi.Input[str] name: Specifies the name of the job. Length range: 1 to 57 characters.
               which may consist of letters, digits, underscores (_) and hyphens (-).
        :param pulumi.Input[str] obs_bucket: Specifies OBS path. OBS path where users are authorized to save the
               snapshot. This parameter is valid only when `checkpoint_enabled` is set to `true`. OBS path where users are authorized
               to save the snapshot. This parameter is valid only when `log_enabled` is set to `true`.
        :param pulumi.Input[int] parallel_number: Specifies number of parallel for a job. The default value is 1.
        :param pulumi.Input[str] queue_name: Specifies name of a queue.
        :param pulumi.Input[str] region: The region in which to create the DLI flink job resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[bool] restart_when_exception: Specifies whether to enable the function of automatically
               restarting a job upon job exceptions. The default value is false.
        :param pulumi.Input[bool] resume_checkpoint: Specifies whether the abnormal restart is recovered from the
               checkpoint.
        :param pulumi.Input[int] resume_max_num: Specifies maximum number of retry times upon exceptions. The unit is
               `times/hour`. Value range: `-1` or greater than `0`. The default value is `-1`, indicating that the number of times is
               unlimited.
        :param pulumi.Input[str] run_mode: Specifies job running mode. The options are as follows:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] runtime_config: Specifies customizes optimization parameters when a Flink job is
               running.
        :param pulumi.Input[str] smn_topic: Specifies SMN topic. If a job fails, the system will send a message to
               users subscribed to the SMN topic.
        :param pulumi.Input[str] sql: Specifies stream SQL statement, which includes at least the following
               three parts: source, query, and sink. Length range: 1024x1024 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the resource.
        :param pulumi.Input[int] tm_cus: Specifies number of CUs for each Task Manager. The default value is 1.
        :param pulumi.Input[int] tm_slot_num: Specifies number of slots in each Task Manager.
               The default value is (**parallel_number** * **tm_cus**)/(**cu_number** - **manager_cu_number**).
        :param pulumi.Input[str] type: Specifies the type of the job. The valid values are `flink_sql_job`,
               `flink_opensource_sql_job` and `flink_sql_edge_job`. Default value is `flink_sql_job`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] udf_jar_url: Specifies name of the resource package that has been uploaded to the
               DLI resource management system. The UDF Jar file of the SQL job is specified by this parameter.
        """
        if checkpoint_enabled is not None:
            pulumi.set(__self__, "checkpoint_enabled", checkpoint_enabled)
        if checkpoint_interval is not None:
            pulumi.set(__self__, "checkpoint_interval", checkpoint_interval)
        if checkpoint_mode is not None:
            pulumi.set(__self__, "checkpoint_mode", checkpoint_mode)
        if cu_number is not None:
            pulumi.set(__self__, "cu_number", cu_number)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dirty_data_strategy is not None:
            pulumi.set(__self__, "dirty_data_strategy", dirty_data_strategy)
        if edge_group_ids is not None:
            pulumi.set(__self__, "edge_group_ids", edge_group_ids)
        if idle_state_retention is not None:
            pulumi.set(__self__, "idle_state_retention", idle_state_retention)
        if log_enabled is not None:
            pulumi.set(__self__, "log_enabled", log_enabled)
        if manager_cu_number is not None:
            pulumi.set(__self__, "manager_cu_number", manager_cu_number)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if obs_bucket is not None:
            pulumi.set(__self__, "obs_bucket", obs_bucket)
        if parallel_number is not None:
            pulumi.set(__self__, "parallel_number", parallel_number)
        if queue_name is not None:
            pulumi.set(__self__, "queue_name", queue_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if restart_when_exception is not None:
            pulumi.set(__self__, "restart_when_exception", restart_when_exception)
        if resume_checkpoint is not None:
            pulumi.set(__self__, "resume_checkpoint", resume_checkpoint)
        if resume_max_num is not None:
            pulumi.set(__self__, "resume_max_num", resume_max_num)
        if run_mode is not None:
            pulumi.set(__self__, "run_mode", run_mode)
        if runtime_config is not None:
            pulumi.set(__self__, "runtime_config", runtime_config)
        if smn_topic is not None:
            pulumi.set(__self__, "smn_topic", smn_topic)
        if sql is not None:
            pulumi.set(__self__, "sql", sql)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tm_cus is not None:
            pulumi.set(__self__, "tm_cus", tm_cus)
        if tm_slot_num is not None:
            pulumi.set(__self__, "tm_slot_num", tm_slot_num)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if udf_jar_url is not None:
            pulumi.set(__self__, "udf_jar_url", udf_jar_url)

    @property
    @pulumi.getter(name="checkpointEnabled")
    def checkpoint_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the automatic job snapshot function.
        + **true**: indicates to enable the automatic job snapshot function.
        + **false**: indicates to disable the automatic job snapshot function.
        """
        return pulumi.get(self, "checkpoint_enabled")

    @checkpoint_enabled.setter
    def checkpoint_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "checkpoint_enabled", value)

    @property
    @pulumi.getter(name="checkpointInterval")
    def checkpoint_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies snapshot interval. The unit is second.
        The default value is 10.
        """
        return pulumi.get(self, "checkpoint_interval")

    @checkpoint_interval.setter
    def checkpoint_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "checkpoint_interval", value)

    @property
    @pulumi.getter(name="checkpointMode")
    def checkpoint_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies snapshot mode. There are two options:
        + **exactly_once**: indicates that data is processed only once.
        + **at_least_once**: indicates that data is processed at least once.
        """
        return pulumi.get(self, "checkpoint_mode")

    @checkpoint_mode.setter
    def checkpoint_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "checkpoint_mode", value)

    @property
    @pulumi.getter(name="cuNumber")
    def cu_number(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies number of CUs selected for a job. The default value is 2.
        """
        return pulumi.get(self, "cu_number")

    @cu_number.setter
    def cu_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cu_number", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies job description. Length range: 1 to 512 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dirtyDataStrategy")
    def dirty_data_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies dirty data policy of a job.
        + **2:obsDir**: Save the dirty data to the obs path `obsDir`. For example: `2:yourBucket/output_path`
        + **1**: Trigger a job exception
        + **0**: Ignore
        """
        return pulumi.get(self, "dirty_data_strategy")

    @dirty_data_strategy.setter
    def dirty_data_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dirty_data_strategy", value)

    @property
    @pulumi.getter(name="edgeGroupIds")
    def edge_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies edge computing group IDs.
        """
        return pulumi.get(self, "edge_group_ids")

    @edge_group_ids.setter
    def edge_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "edge_group_ids", value)

    @property
    @pulumi.getter(name="idleStateRetention")
    def idle_state_retention(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies retention time of the idle state. The unit is hour.
        The default value is 1.
        """
        return pulumi.get(self, "idle_state_retention")

    @idle_state_retention.setter
    def idle_state_retention(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_state_retention", value)

    @property
    @pulumi.getter(name="logEnabled")
    def log_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the function of uploading job logs to
        users' OBS buckets. The default value is false.
        """
        return pulumi.get(self, "log_enabled")

    @log_enabled.setter
    def log_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "log_enabled", value)

    @property
    @pulumi.getter(name="managerCuNumber")
    def manager_cu_number(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies number of CUs in the JobManager selected for a job.
        The default value is 1.
        """
        return pulumi.get(self, "manager_cu_number")

    @manager_cu_number.setter
    def manager_cu_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "manager_cu_number", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the job. Length range: 1 to 57 characters.
        which may consist of letters, digits, underscores (_) and hyphens (-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="obsBucket")
    def obs_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies OBS path. OBS path where users are authorized to save the
        snapshot. This parameter is valid only when `checkpoint_enabled` is set to `true`. OBS path where users are authorized
        to save the snapshot. This parameter is valid only when `log_enabled` is set to `true`.
        """
        return pulumi.get(self, "obs_bucket")

    @obs_bucket.setter
    def obs_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "obs_bucket", value)

    @property
    @pulumi.getter(name="parallelNumber")
    def parallel_number(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies number of parallel for a job. The default value is 1.
        """
        return pulumi.get(self, "parallel_number")

    @parallel_number.setter
    def parallel_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "parallel_number", value)

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies name of a queue.
        """
        return pulumi.get(self, "queue_name")

    @queue_name.setter
    def queue_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "queue_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the DLI flink job resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="restartWhenException")
    def restart_when_exception(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the function of automatically
        restarting a job upon job exceptions. The default value is false.
        """
        return pulumi.get(self, "restart_when_exception")

    @restart_when_exception.setter
    def restart_when_exception(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "restart_when_exception", value)

    @property
    @pulumi.getter(name="resumeCheckpoint")
    def resume_checkpoint(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the abnormal restart is recovered from the
        checkpoint.
        """
        return pulumi.get(self, "resume_checkpoint")

    @resume_checkpoint.setter
    def resume_checkpoint(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "resume_checkpoint", value)

    @property
    @pulumi.getter(name="resumeMaxNum")
    def resume_max_num(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies maximum number of retry times upon exceptions. The unit is
        `times/hour`. Value range: `-1` or greater than `0`. The default value is `-1`, indicating that the number of times is
        unlimited.
        """
        return pulumi.get(self, "resume_max_num")

    @resume_max_num.setter
    def resume_max_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "resume_max_num", value)

    @property
    @pulumi.getter(name="runMode")
    def run_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies job running mode. The options are as follows:
        """
        return pulumi.get(self, "run_mode")

    @run_mode.setter
    def run_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "run_mode", value)

    @property
    @pulumi.getter(name="runtimeConfig")
    def runtime_config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies customizes optimization parameters when a Flink job is
        running.
        """
        return pulumi.get(self, "runtime_config")

    @runtime_config.setter
    def runtime_config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "runtime_config", value)

    @property
    @pulumi.getter(name="smnTopic")
    def smn_topic(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies SMN topic. If a job fails, the system will send a message to
        users subscribed to the SMN topic.
        """
        return pulumi.get(self, "smn_topic")

    @smn_topic.setter
    def smn_topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "smn_topic", value)

    @property
    @pulumi.getter
    def sql(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies stream SQL statement, which includes at least the following
        three parts: source, query, and sink. Length range: 1024x1024 characters.
        """
        return pulumi.get(self, "sql")

    @sql.setter
    def sql(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sql", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the key/value pairs to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tmCus")
    def tm_cus(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies number of CUs for each Task Manager. The default value is 1.
        """
        return pulumi.get(self, "tm_cus")

    @tm_cus.setter
    def tm_cus(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tm_cus", value)

    @property
    @pulumi.getter(name="tmSlotNum")
    def tm_slot_num(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies number of slots in each Task Manager.
        The default value is (**parallel_number** * **tm_cus**)/(**cu_number** - **manager_cu_number**).
        """
        return pulumi.get(self, "tm_slot_num")

    @tm_slot_num.setter
    def tm_slot_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tm_slot_num", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of the job. The valid values are `flink_sql_job`,
        `flink_opensource_sql_job` and `flink_sql_edge_job`. Default value is `flink_sql_job`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="udfJarUrl")
    def udf_jar_url(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies name of the resource package that has been uploaded to the
        DLI resource management system. The UDF Jar file of the SQL job is specified by this parameter.
        """
        return pulumi.get(self, "udf_jar_url")

    @udf_jar_url.setter
    def udf_jar_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "udf_jar_url", value)


@pulumi.input_type
class _FlinksqlJobState:
    def __init__(__self__, *,
                 checkpoint_enabled: Optional[pulumi.Input[bool]] = None,
                 checkpoint_interval: Optional[pulumi.Input[int]] = None,
                 checkpoint_mode: Optional[pulumi.Input[str]] = None,
                 cu_number: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dirty_data_strategy: Optional[pulumi.Input[str]] = None,
                 edge_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 idle_state_retention: Optional[pulumi.Input[int]] = None,
                 log_enabled: Optional[pulumi.Input[bool]] = None,
                 manager_cu_number: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 obs_bucket: Optional[pulumi.Input[str]] = None,
                 parallel_number: Optional[pulumi.Input[int]] = None,
                 queue_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 restart_when_exception: Optional[pulumi.Input[bool]] = None,
                 resume_checkpoint: Optional[pulumi.Input[bool]] = None,
                 resume_max_num: Optional[pulumi.Input[int]] = None,
                 run_mode: Optional[pulumi.Input[str]] = None,
                 runtime_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 smn_topic: Optional[pulumi.Input[str]] = None,
                 sql: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tm_cus: Optional[pulumi.Input[int]] = None,
                 tm_slot_num: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 udf_jar_url: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering FlinksqlJob resources.
        :param pulumi.Input[bool] checkpoint_enabled: Specifies whether to enable the automatic job snapshot function.
               + **true**: indicates to enable the automatic job snapshot function.
               + **false**: indicates to disable the automatic job snapshot function.
        :param pulumi.Input[int] checkpoint_interval: Specifies snapshot interval. The unit is second.
               The default value is 10.
        :param pulumi.Input[str] checkpoint_mode: Specifies snapshot mode. There are two options:
               + **exactly_once**: indicates that data is processed only once.
               + **at_least_once**: indicates that data is processed at least once.
        :param pulumi.Input[int] cu_number: Specifies number of CUs selected for a job. The default value is 2.
        :param pulumi.Input[str] description: Specifies job description. Length range: 1 to 512 characters.
        :param pulumi.Input[str] dirty_data_strategy: Specifies dirty data policy of a job.
               + **2:obsDir**: Save the dirty data to the obs path `obsDir`. For example: `2:yourBucket/output_path`
               + **1**: Trigger a job exception
               + **0**: Ignore
        :param pulumi.Input[Sequence[pulumi.Input[str]]] edge_group_ids: Specifies edge computing group IDs.
        :param pulumi.Input[int] idle_state_retention: Specifies retention time of the idle state. The unit is hour.
               The default value is 1.
        :param pulumi.Input[bool] log_enabled: Specifies whether to enable the function of uploading job logs to
               users' OBS buckets. The default value is false.
        :param pulumi.Input[int] manager_cu_number: Specifies number of CUs in the JobManager selected for a job.
               The default value is 1.
        :param pulumi.Input[str] name: Specifies the name of the job. Length range: 1 to 57 characters.
               which may consist of letters, digits, underscores (_) and hyphens (-).
        :param pulumi.Input[str] obs_bucket: Specifies OBS path. OBS path where users are authorized to save the
               snapshot. This parameter is valid only when `checkpoint_enabled` is set to `true`. OBS path where users are authorized
               to save the snapshot. This parameter is valid only when `log_enabled` is set to `true`.
        :param pulumi.Input[int] parallel_number: Specifies number of parallel for a job. The default value is 1.
        :param pulumi.Input[str] queue_name: Specifies name of a queue.
        :param pulumi.Input[str] region: The region in which to create the DLI flink job resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[bool] restart_when_exception: Specifies whether to enable the function of automatically
               restarting a job upon job exceptions. The default value is false.
        :param pulumi.Input[bool] resume_checkpoint: Specifies whether the abnormal restart is recovered from the
               checkpoint.
        :param pulumi.Input[int] resume_max_num: Specifies maximum number of retry times upon exceptions. The unit is
               `times/hour`. Value range: `-1` or greater than `0`. The default value is `-1`, indicating that the number of times is
               unlimited.
        :param pulumi.Input[str] run_mode: Specifies job running mode. The options are as follows:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] runtime_config: Specifies customizes optimization parameters when a Flink job is
               running.
        :param pulumi.Input[str] smn_topic: Specifies SMN topic. If a job fails, the system will send a message to
               users subscribed to the SMN topic.
        :param pulumi.Input[str] sql: Specifies stream SQL statement, which includes at least the following
               three parts: source, query, and sink. Length range: 1024x1024 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the resource.
        :param pulumi.Input[int] tm_cus: Specifies number of CUs for each Task Manager. The default value is 1.
        :param pulumi.Input[int] tm_slot_num: Specifies number of slots in each Task Manager.
               The default value is (**parallel_number** * **tm_cus**)/(**cu_number** - **manager_cu_number**).
        :param pulumi.Input[str] type: Specifies the type of the job. The valid values are `flink_sql_job`,
               `flink_opensource_sql_job` and `flink_sql_edge_job`. Default value is `flink_sql_job`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] udf_jar_url: Specifies name of the resource package that has been uploaded to the
               DLI resource management system. The UDF Jar file of the SQL job is specified by this parameter.
        """
        if checkpoint_enabled is not None:
            pulumi.set(__self__, "checkpoint_enabled", checkpoint_enabled)
        if checkpoint_interval is not None:
            pulumi.set(__self__, "checkpoint_interval", checkpoint_interval)
        if checkpoint_mode is not None:
            pulumi.set(__self__, "checkpoint_mode", checkpoint_mode)
        if cu_number is not None:
            pulumi.set(__self__, "cu_number", cu_number)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dirty_data_strategy is not None:
            pulumi.set(__self__, "dirty_data_strategy", dirty_data_strategy)
        if edge_group_ids is not None:
            pulumi.set(__self__, "edge_group_ids", edge_group_ids)
        if idle_state_retention is not None:
            pulumi.set(__self__, "idle_state_retention", idle_state_retention)
        if log_enabled is not None:
            pulumi.set(__self__, "log_enabled", log_enabled)
        if manager_cu_number is not None:
            pulumi.set(__self__, "manager_cu_number", manager_cu_number)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if obs_bucket is not None:
            pulumi.set(__self__, "obs_bucket", obs_bucket)
        if parallel_number is not None:
            pulumi.set(__self__, "parallel_number", parallel_number)
        if queue_name is not None:
            pulumi.set(__self__, "queue_name", queue_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if restart_when_exception is not None:
            pulumi.set(__self__, "restart_when_exception", restart_when_exception)
        if resume_checkpoint is not None:
            pulumi.set(__self__, "resume_checkpoint", resume_checkpoint)
        if resume_max_num is not None:
            pulumi.set(__self__, "resume_max_num", resume_max_num)
        if run_mode is not None:
            pulumi.set(__self__, "run_mode", run_mode)
        if runtime_config is not None:
            pulumi.set(__self__, "runtime_config", runtime_config)
        if smn_topic is not None:
            pulumi.set(__self__, "smn_topic", smn_topic)
        if sql is not None:
            pulumi.set(__self__, "sql", sql)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tm_cus is not None:
            pulumi.set(__self__, "tm_cus", tm_cus)
        if tm_slot_num is not None:
            pulumi.set(__self__, "tm_slot_num", tm_slot_num)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if udf_jar_url is not None:
            pulumi.set(__self__, "udf_jar_url", udf_jar_url)

    @property
    @pulumi.getter(name="checkpointEnabled")
    def checkpoint_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the automatic job snapshot function.
        + **true**: indicates to enable the automatic job snapshot function.
        + **false**: indicates to disable the automatic job snapshot function.
        """
        return pulumi.get(self, "checkpoint_enabled")

    @checkpoint_enabled.setter
    def checkpoint_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "checkpoint_enabled", value)

    @property
    @pulumi.getter(name="checkpointInterval")
    def checkpoint_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies snapshot interval. The unit is second.
        The default value is 10.
        """
        return pulumi.get(self, "checkpoint_interval")

    @checkpoint_interval.setter
    def checkpoint_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "checkpoint_interval", value)

    @property
    @pulumi.getter(name="checkpointMode")
    def checkpoint_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies snapshot mode. There are two options:
        + **exactly_once**: indicates that data is processed only once.
        + **at_least_once**: indicates that data is processed at least once.
        """
        return pulumi.get(self, "checkpoint_mode")

    @checkpoint_mode.setter
    def checkpoint_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "checkpoint_mode", value)

    @property
    @pulumi.getter(name="cuNumber")
    def cu_number(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies number of CUs selected for a job. The default value is 2.
        """
        return pulumi.get(self, "cu_number")

    @cu_number.setter
    def cu_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cu_number", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies job description. Length range: 1 to 512 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dirtyDataStrategy")
    def dirty_data_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies dirty data policy of a job.
        + **2:obsDir**: Save the dirty data to the obs path `obsDir`. For example: `2:yourBucket/output_path`
        + **1**: Trigger a job exception
        + **0**: Ignore
        """
        return pulumi.get(self, "dirty_data_strategy")

    @dirty_data_strategy.setter
    def dirty_data_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dirty_data_strategy", value)

    @property
    @pulumi.getter(name="edgeGroupIds")
    def edge_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies edge computing group IDs.
        """
        return pulumi.get(self, "edge_group_ids")

    @edge_group_ids.setter
    def edge_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "edge_group_ids", value)

    @property
    @pulumi.getter(name="idleStateRetention")
    def idle_state_retention(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies retention time of the idle state. The unit is hour.
        The default value is 1.
        """
        return pulumi.get(self, "idle_state_retention")

    @idle_state_retention.setter
    def idle_state_retention(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_state_retention", value)

    @property
    @pulumi.getter(name="logEnabled")
    def log_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the function of uploading job logs to
        users' OBS buckets. The default value is false.
        """
        return pulumi.get(self, "log_enabled")

    @log_enabled.setter
    def log_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "log_enabled", value)

    @property
    @pulumi.getter(name="managerCuNumber")
    def manager_cu_number(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies number of CUs in the JobManager selected for a job.
        The default value is 1.
        """
        return pulumi.get(self, "manager_cu_number")

    @manager_cu_number.setter
    def manager_cu_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "manager_cu_number", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the job. Length range: 1 to 57 characters.
        which may consist of letters, digits, underscores (_) and hyphens (-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="obsBucket")
    def obs_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies OBS path. OBS path where users are authorized to save the
        snapshot. This parameter is valid only when `checkpoint_enabled` is set to `true`. OBS path where users are authorized
        to save the snapshot. This parameter is valid only when `log_enabled` is set to `true`.
        """
        return pulumi.get(self, "obs_bucket")

    @obs_bucket.setter
    def obs_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "obs_bucket", value)

    @property
    @pulumi.getter(name="parallelNumber")
    def parallel_number(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies number of parallel for a job. The default value is 1.
        """
        return pulumi.get(self, "parallel_number")

    @parallel_number.setter
    def parallel_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "parallel_number", value)

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies name of a queue.
        """
        return pulumi.get(self, "queue_name")

    @queue_name.setter
    def queue_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "queue_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the DLI flink job resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="restartWhenException")
    def restart_when_exception(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the function of automatically
        restarting a job upon job exceptions. The default value is false.
        """
        return pulumi.get(self, "restart_when_exception")

    @restart_when_exception.setter
    def restart_when_exception(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "restart_when_exception", value)

    @property
    @pulumi.getter(name="resumeCheckpoint")
    def resume_checkpoint(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the abnormal restart is recovered from the
        checkpoint.
        """
        return pulumi.get(self, "resume_checkpoint")

    @resume_checkpoint.setter
    def resume_checkpoint(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "resume_checkpoint", value)

    @property
    @pulumi.getter(name="resumeMaxNum")
    def resume_max_num(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies maximum number of retry times upon exceptions. The unit is
        `times/hour`. Value range: `-1` or greater than `0`. The default value is `-1`, indicating that the number of times is
        unlimited.
        """
        return pulumi.get(self, "resume_max_num")

    @resume_max_num.setter
    def resume_max_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "resume_max_num", value)

    @property
    @pulumi.getter(name="runMode")
    def run_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies job running mode. The options are as follows:
        """
        return pulumi.get(self, "run_mode")

    @run_mode.setter
    def run_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "run_mode", value)

    @property
    @pulumi.getter(name="runtimeConfig")
    def runtime_config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies customizes optimization parameters when a Flink job is
        running.
        """
        return pulumi.get(self, "runtime_config")

    @runtime_config.setter
    def runtime_config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "runtime_config", value)

    @property
    @pulumi.getter(name="smnTopic")
    def smn_topic(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies SMN topic. If a job fails, the system will send a message to
        users subscribed to the SMN topic.
        """
        return pulumi.get(self, "smn_topic")

    @smn_topic.setter
    def smn_topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "smn_topic", value)

    @property
    @pulumi.getter
    def sql(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies stream SQL statement, which includes at least the following
        three parts: source, query, and sink. Length range: 1024x1024 characters.
        """
        return pulumi.get(self, "sql")

    @sql.setter
    def sql(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sql", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the key/value pairs to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tmCus")
    def tm_cus(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies number of CUs for each Task Manager. The default value is 1.
        """
        return pulumi.get(self, "tm_cus")

    @tm_cus.setter
    def tm_cus(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tm_cus", value)

    @property
    @pulumi.getter(name="tmSlotNum")
    def tm_slot_num(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies number of slots in each Task Manager.
        The default value is (**parallel_number** * **tm_cus**)/(**cu_number** - **manager_cu_number**).
        """
        return pulumi.get(self, "tm_slot_num")

    @tm_slot_num.setter
    def tm_slot_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tm_slot_num", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of the job. The valid values are `flink_sql_job`,
        `flink_opensource_sql_job` and `flink_sql_edge_job`. Default value is `flink_sql_job`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="udfJarUrl")
    def udf_jar_url(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies name of the resource package that has been uploaded to the
        DLI resource management system. The UDF Jar file of the SQL job is specified by this parameter.
        """
        return pulumi.get(self, "udf_jar_url")

    @udf_jar_url.setter
    def udf_jar_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "udf_jar_url", value)


class FlinksqlJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 checkpoint_enabled: Optional[pulumi.Input[bool]] = None,
                 checkpoint_interval: Optional[pulumi.Input[int]] = None,
                 checkpoint_mode: Optional[pulumi.Input[str]] = None,
                 cu_number: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dirty_data_strategy: Optional[pulumi.Input[str]] = None,
                 edge_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 idle_state_retention: Optional[pulumi.Input[int]] = None,
                 log_enabled: Optional[pulumi.Input[bool]] = None,
                 manager_cu_number: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 obs_bucket: Optional[pulumi.Input[str]] = None,
                 parallel_number: Optional[pulumi.Input[int]] = None,
                 queue_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 restart_when_exception: Optional[pulumi.Input[bool]] = None,
                 resume_checkpoint: Optional[pulumi.Input[bool]] = None,
                 resume_max_num: Optional[pulumi.Input[int]] = None,
                 run_mode: Optional[pulumi.Input[str]] = None,
                 runtime_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 smn_topic: Optional[pulumi.Input[str]] = None,
                 sql: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tm_cus: Optional[pulumi.Input[int]] = None,
                 tm_slot_num: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 udf_jar_url: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a flink sql job resource within HuaweiCloud DLI.

        ## Example Usage
        ### Create a flink job

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        sql = config.require_object("sql")
        job_name = config.require_object("jobName")
        test = huaweicloud.dli.FlinksqlJob("test",
            type="flink_sql_job",
            sql=sql)
        ```

        ## Import

        Clusters can be imported by their `id`. For example,

        ```sh
         $ pulumi import huaweicloud:Dli/flinksqlJob:FlinksqlJob test 12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] checkpoint_enabled: Specifies whether to enable the automatic job snapshot function.
               + **true**: indicates to enable the automatic job snapshot function.
               + **false**: indicates to disable the automatic job snapshot function.
        :param pulumi.Input[int] checkpoint_interval: Specifies snapshot interval. The unit is second.
               The default value is 10.
        :param pulumi.Input[str] checkpoint_mode: Specifies snapshot mode. There are two options:
               + **exactly_once**: indicates that data is processed only once.
               + **at_least_once**: indicates that data is processed at least once.
        :param pulumi.Input[int] cu_number: Specifies number of CUs selected for a job. The default value is 2.
        :param pulumi.Input[str] description: Specifies job description. Length range: 1 to 512 characters.
        :param pulumi.Input[str] dirty_data_strategy: Specifies dirty data policy of a job.
               + **2:obsDir**: Save the dirty data to the obs path `obsDir`. For example: `2:yourBucket/output_path`
               + **1**: Trigger a job exception
               + **0**: Ignore
        :param pulumi.Input[Sequence[pulumi.Input[str]]] edge_group_ids: Specifies edge computing group IDs.
        :param pulumi.Input[int] idle_state_retention: Specifies retention time of the idle state. The unit is hour.
               The default value is 1.
        :param pulumi.Input[bool] log_enabled: Specifies whether to enable the function of uploading job logs to
               users' OBS buckets. The default value is false.
        :param pulumi.Input[int] manager_cu_number: Specifies number of CUs in the JobManager selected for a job.
               The default value is 1.
        :param pulumi.Input[str] name: Specifies the name of the job. Length range: 1 to 57 characters.
               which may consist of letters, digits, underscores (_) and hyphens (-).
        :param pulumi.Input[str] obs_bucket: Specifies OBS path. OBS path where users are authorized to save the
               snapshot. This parameter is valid only when `checkpoint_enabled` is set to `true`. OBS path where users are authorized
               to save the snapshot. This parameter is valid only when `log_enabled` is set to `true`.
        :param pulumi.Input[int] parallel_number: Specifies number of parallel for a job. The default value is 1.
        :param pulumi.Input[str] queue_name: Specifies name of a queue.
        :param pulumi.Input[str] region: The region in which to create the DLI flink job resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[bool] restart_when_exception: Specifies whether to enable the function of automatically
               restarting a job upon job exceptions. The default value is false.
        :param pulumi.Input[bool] resume_checkpoint: Specifies whether the abnormal restart is recovered from the
               checkpoint.
        :param pulumi.Input[int] resume_max_num: Specifies maximum number of retry times upon exceptions. The unit is
               `times/hour`. Value range: `-1` or greater than `0`. The default value is `-1`, indicating that the number of times is
               unlimited.
        :param pulumi.Input[str] run_mode: Specifies job running mode. The options are as follows:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] runtime_config: Specifies customizes optimization parameters when a Flink job is
               running.
        :param pulumi.Input[str] smn_topic: Specifies SMN topic. If a job fails, the system will send a message to
               users subscribed to the SMN topic.
        :param pulumi.Input[str] sql: Specifies stream SQL statement, which includes at least the following
               three parts: source, query, and sink. Length range: 1024x1024 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the resource.
        :param pulumi.Input[int] tm_cus: Specifies number of CUs for each Task Manager. The default value is 1.
        :param pulumi.Input[int] tm_slot_num: Specifies number of slots in each Task Manager.
               The default value is (**parallel_number** * **tm_cus**)/(**cu_number** - **manager_cu_number**).
        :param pulumi.Input[str] type: Specifies the type of the job. The valid values are `flink_sql_job`,
               `flink_opensource_sql_job` and `flink_sql_edge_job`. Default value is `flink_sql_job`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] udf_jar_url: Specifies name of the resource package that has been uploaded to the
               DLI resource management system. The UDF Jar file of the SQL job is specified by this parameter.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[FlinksqlJobArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a flink sql job resource within HuaweiCloud DLI.

        ## Example Usage
        ### Create a flink job

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        sql = config.require_object("sql")
        job_name = config.require_object("jobName")
        test = huaweicloud.dli.FlinksqlJob("test",
            type="flink_sql_job",
            sql=sql)
        ```

        ## Import

        Clusters can be imported by their `id`. For example,

        ```sh
         $ pulumi import huaweicloud:Dli/flinksqlJob:FlinksqlJob test 12345
        ```

        :param str resource_name: The name of the resource.
        :param FlinksqlJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FlinksqlJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 checkpoint_enabled: Optional[pulumi.Input[bool]] = None,
                 checkpoint_interval: Optional[pulumi.Input[int]] = None,
                 checkpoint_mode: Optional[pulumi.Input[str]] = None,
                 cu_number: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dirty_data_strategy: Optional[pulumi.Input[str]] = None,
                 edge_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 idle_state_retention: Optional[pulumi.Input[int]] = None,
                 log_enabled: Optional[pulumi.Input[bool]] = None,
                 manager_cu_number: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 obs_bucket: Optional[pulumi.Input[str]] = None,
                 parallel_number: Optional[pulumi.Input[int]] = None,
                 queue_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 restart_when_exception: Optional[pulumi.Input[bool]] = None,
                 resume_checkpoint: Optional[pulumi.Input[bool]] = None,
                 resume_max_num: Optional[pulumi.Input[int]] = None,
                 run_mode: Optional[pulumi.Input[str]] = None,
                 runtime_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 smn_topic: Optional[pulumi.Input[str]] = None,
                 sql: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tm_cus: Optional[pulumi.Input[int]] = None,
                 tm_slot_num: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 udf_jar_url: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FlinksqlJobArgs.__new__(FlinksqlJobArgs)

            __props__.__dict__["checkpoint_enabled"] = checkpoint_enabled
            __props__.__dict__["checkpoint_interval"] = checkpoint_interval
            __props__.__dict__["checkpoint_mode"] = checkpoint_mode
            __props__.__dict__["cu_number"] = cu_number
            __props__.__dict__["description"] = description
            __props__.__dict__["dirty_data_strategy"] = dirty_data_strategy
            __props__.__dict__["edge_group_ids"] = edge_group_ids
            __props__.__dict__["idle_state_retention"] = idle_state_retention
            __props__.__dict__["log_enabled"] = log_enabled
            __props__.__dict__["manager_cu_number"] = manager_cu_number
            __props__.__dict__["name"] = name
            __props__.__dict__["obs_bucket"] = obs_bucket
            __props__.__dict__["parallel_number"] = parallel_number
            __props__.__dict__["queue_name"] = queue_name
            __props__.__dict__["region"] = region
            __props__.__dict__["restart_when_exception"] = restart_when_exception
            __props__.__dict__["resume_checkpoint"] = resume_checkpoint
            __props__.__dict__["resume_max_num"] = resume_max_num
            __props__.__dict__["run_mode"] = run_mode
            __props__.__dict__["runtime_config"] = runtime_config
            __props__.__dict__["smn_topic"] = smn_topic
            __props__.__dict__["sql"] = sql
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tm_cus"] = tm_cus
            __props__.__dict__["tm_slot_num"] = tm_slot_num
            __props__.__dict__["type"] = type
            __props__.__dict__["udf_jar_url"] = udf_jar_url
            __props__.__dict__["status"] = None
        super(FlinksqlJob, __self__).__init__(
            'huaweicloud:Dli/flinksqlJob:FlinksqlJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            checkpoint_enabled: Optional[pulumi.Input[bool]] = None,
            checkpoint_interval: Optional[pulumi.Input[int]] = None,
            checkpoint_mode: Optional[pulumi.Input[str]] = None,
            cu_number: Optional[pulumi.Input[int]] = None,
            description: Optional[pulumi.Input[str]] = None,
            dirty_data_strategy: Optional[pulumi.Input[str]] = None,
            edge_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            idle_state_retention: Optional[pulumi.Input[int]] = None,
            log_enabled: Optional[pulumi.Input[bool]] = None,
            manager_cu_number: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            obs_bucket: Optional[pulumi.Input[str]] = None,
            parallel_number: Optional[pulumi.Input[int]] = None,
            queue_name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            restart_when_exception: Optional[pulumi.Input[bool]] = None,
            resume_checkpoint: Optional[pulumi.Input[bool]] = None,
            resume_max_num: Optional[pulumi.Input[int]] = None,
            run_mode: Optional[pulumi.Input[str]] = None,
            runtime_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            smn_topic: Optional[pulumi.Input[str]] = None,
            sql: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tm_cus: Optional[pulumi.Input[int]] = None,
            tm_slot_num: Optional[pulumi.Input[int]] = None,
            type: Optional[pulumi.Input[str]] = None,
            udf_jar_url: Optional[pulumi.Input[str]] = None) -> 'FlinksqlJob':
        """
        Get an existing FlinksqlJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] checkpoint_enabled: Specifies whether to enable the automatic job snapshot function.
               + **true**: indicates to enable the automatic job snapshot function.
               + **false**: indicates to disable the automatic job snapshot function.
        :param pulumi.Input[int] checkpoint_interval: Specifies snapshot interval. The unit is second.
               The default value is 10.
        :param pulumi.Input[str] checkpoint_mode: Specifies snapshot mode. There are two options:
               + **exactly_once**: indicates that data is processed only once.
               + **at_least_once**: indicates that data is processed at least once.
        :param pulumi.Input[int] cu_number: Specifies number of CUs selected for a job. The default value is 2.
        :param pulumi.Input[str] description: Specifies job description. Length range: 1 to 512 characters.
        :param pulumi.Input[str] dirty_data_strategy: Specifies dirty data policy of a job.
               + **2:obsDir**: Save the dirty data to the obs path `obsDir`. For example: `2:yourBucket/output_path`
               + **1**: Trigger a job exception
               + **0**: Ignore
        :param pulumi.Input[Sequence[pulumi.Input[str]]] edge_group_ids: Specifies edge computing group IDs.
        :param pulumi.Input[int] idle_state_retention: Specifies retention time of the idle state. The unit is hour.
               The default value is 1.
        :param pulumi.Input[bool] log_enabled: Specifies whether to enable the function of uploading job logs to
               users' OBS buckets. The default value is false.
        :param pulumi.Input[int] manager_cu_number: Specifies number of CUs in the JobManager selected for a job.
               The default value is 1.
        :param pulumi.Input[str] name: Specifies the name of the job. Length range: 1 to 57 characters.
               which may consist of letters, digits, underscores (_) and hyphens (-).
        :param pulumi.Input[str] obs_bucket: Specifies OBS path. OBS path where users are authorized to save the
               snapshot. This parameter is valid only when `checkpoint_enabled` is set to `true`. OBS path where users are authorized
               to save the snapshot. This parameter is valid only when `log_enabled` is set to `true`.
        :param pulumi.Input[int] parallel_number: Specifies number of parallel for a job. The default value is 1.
        :param pulumi.Input[str] queue_name: Specifies name of a queue.
        :param pulumi.Input[str] region: The region in which to create the DLI flink job resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[bool] restart_when_exception: Specifies whether to enable the function of automatically
               restarting a job upon job exceptions. The default value is false.
        :param pulumi.Input[bool] resume_checkpoint: Specifies whether the abnormal restart is recovered from the
               checkpoint.
        :param pulumi.Input[int] resume_max_num: Specifies maximum number of retry times upon exceptions. The unit is
               `times/hour`. Value range: `-1` or greater than `0`. The default value is `-1`, indicating that the number of times is
               unlimited.
        :param pulumi.Input[str] run_mode: Specifies job running mode. The options are as follows:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] runtime_config: Specifies customizes optimization parameters when a Flink job is
               running.
        :param pulumi.Input[str] smn_topic: Specifies SMN topic. If a job fails, the system will send a message to
               users subscribed to the SMN topic.
        :param pulumi.Input[str] sql: Specifies stream SQL statement, which includes at least the following
               three parts: source, query, and sink. Length range: 1024x1024 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs to associate with the resource.
        :param pulumi.Input[int] tm_cus: Specifies number of CUs for each Task Manager. The default value is 1.
        :param pulumi.Input[int] tm_slot_num: Specifies number of slots in each Task Manager.
               The default value is (**parallel_number** * **tm_cus**)/(**cu_number** - **manager_cu_number**).
        :param pulumi.Input[str] type: Specifies the type of the job. The valid values are `flink_sql_job`,
               `flink_opensource_sql_job` and `flink_sql_edge_job`. Default value is `flink_sql_job`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] udf_jar_url: Specifies name of the resource package that has been uploaded to the
               DLI resource management system. The UDF Jar file of the SQL job is specified by this parameter.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FlinksqlJobState.__new__(_FlinksqlJobState)

        __props__.__dict__["checkpoint_enabled"] = checkpoint_enabled
        __props__.__dict__["checkpoint_interval"] = checkpoint_interval
        __props__.__dict__["checkpoint_mode"] = checkpoint_mode
        __props__.__dict__["cu_number"] = cu_number
        __props__.__dict__["description"] = description
        __props__.__dict__["dirty_data_strategy"] = dirty_data_strategy
        __props__.__dict__["edge_group_ids"] = edge_group_ids
        __props__.__dict__["idle_state_retention"] = idle_state_retention
        __props__.__dict__["log_enabled"] = log_enabled
        __props__.__dict__["manager_cu_number"] = manager_cu_number
        __props__.__dict__["name"] = name
        __props__.__dict__["obs_bucket"] = obs_bucket
        __props__.__dict__["parallel_number"] = parallel_number
        __props__.__dict__["queue_name"] = queue_name
        __props__.__dict__["region"] = region
        __props__.__dict__["restart_when_exception"] = restart_when_exception
        __props__.__dict__["resume_checkpoint"] = resume_checkpoint
        __props__.__dict__["resume_max_num"] = resume_max_num
        __props__.__dict__["run_mode"] = run_mode
        __props__.__dict__["runtime_config"] = runtime_config
        __props__.__dict__["smn_topic"] = smn_topic
        __props__.__dict__["sql"] = sql
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tm_cus"] = tm_cus
        __props__.__dict__["tm_slot_num"] = tm_slot_num
        __props__.__dict__["type"] = type
        __props__.__dict__["udf_jar_url"] = udf_jar_url
        return FlinksqlJob(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="checkpointEnabled")
    def checkpoint_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to enable the automatic job snapshot function.
        + **true**: indicates to enable the automatic job snapshot function.
        + **false**: indicates to disable the automatic job snapshot function.
        """
        return pulumi.get(self, "checkpoint_enabled")

    @property
    @pulumi.getter(name="checkpointInterval")
    def checkpoint_interval(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies snapshot interval. The unit is second.
        The default value is 10.
        """
        return pulumi.get(self, "checkpoint_interval")

    @property
    @pulumi.getter(name="checkpointMode")
    def checkpoint_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies snapshot mode. There are two options:
        + **exactly_once**: indicates that data is processed only once.
        + **at_least_once**: indicates that data is processed at least once.
        """
        return pulumi.get(self, "checkpoint_mode")

    @property
    @pulumi.getter(name="cuNumber")
    def cu_number(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies number of CUs selected for a job. The default value is 2.
        """
        return pulumi.get(self, "cu_number")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies job description. Length range: 1 to 512 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dirtyDataStrategy")
    def dirty_data_strategy(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies dirty data policy of a job.
        + **2:obsDir**: Save the dirty data to the obs path `obsDir`. For example: `2:yourBucket/output_path`
        + **1**: Trigger a job exception
        + **0**: Ignore
        """
        return pulumi.get(self, "dirty_data_strategy")

    @property
    @pulumi.getter(name="edgeGroupIds")
    def edge_group_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specifies edge computing group IDs.
        """
        return pulumi.get(self, "edge_group_ids")

    @property
    @pulumi.getter(name="idleStateRetention")
    def idle_state_retention(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies retention time of the idle state. The unit is hour.
        The default value is 1.
        """
        return pulumi.get(self, "idle_state_retention")

    @property
    @pulumi.getter(name="logEnabled")
    def log_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to enable the function of uploading job logs to
        users' OBS buckets. The default value is false.
        """
        return pulumi.get(self, "log_enabled")

    @property
    @pulumi.getter(name="managerCuNumber")
    def manager_cu_number(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies number of CUs in the JobManager selected for a job.
        The default value is 1.
        """
        return pulumi.get(self, "manager_cu_number")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the job. Length range: 1 to 57 characters.
        which may consist of letters, digits, underscores (_) and hyphens (-).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="obsBucket")
    def obs_bucket(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies OBS path. OBS path where users are authorized to save the
        snapshot. This parameter is valid only when `checkpoint_enabled` is set to `true`. OBS path where users are authorized
        to save the snapshot. This parameter is valid only when `log_enabled` is set to `true`.
        """
        return pulumi.get(self, "obs_bucket")

    @property
    @pulumi.getter(name="parallelNumber")
    def parallel_number(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies number of parallel for a job. The default value is 1.
        """
        return pulumi.get(self, "parallel_number")

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> pulumi.Output[str]:
        """
        Specifies name of a queue.
        """
        return pulumi.get(self, "queue_name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the DLI flink job resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="restartWhenException")
    def restart_when_exception(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to enable the function of automatically
        restarting a job upon job exceptions. The default value is false.
        """
        return pulumi.get(self, "restart_when_exception")

    @property
    @pulumi.getter(name="resumeCheckpoint")
    def resume_checkpoint(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether the abnormal restart is recovered from the
        checkpoint.
        """
        return pulumi.get(self, "resume_checkpoint")

    @property
    @pulumi.getter(name="resumeMaxNum")
    def resume_max_num(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies maximum number of retry times upon exceptions. The unit is
        `times/hour`. Value range: `-1` or greater than `0`. The default value is `-1`, indicating that the number of times is
        unlimited.
        """
        return pulumi.get(self, "resume_max_num")

    @property
    @pulumi.getter(name="runMode")
    def run_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies job running mode. The options are as follows:
        """
        return pulumi.get(self, "run_mode")

    @property
    @pulumi.getter(name="runtimeConfig")
    def runtime_config(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specifies customizes optimization parameters when a Flink job is
        running.
        """
        return pulumi.get(self, "runtime_config")

    @property
    @pulumi.getter(name="smnTopic")
    def smn_topic(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies SMN topic. If a job fails, the system will send a message to
        users subscribed to the SMN topic.
        """
        return pulumi.get(self, "smn_topic")

    @property
    @pulumi.getter
    def sql(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies stream SQL statement, which includes at least the following
        three parts: source, query, and sink. Length range: 1024x1024 characters.
        """
        return pulumi.get(self, "sql")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specifies the key/value pairs to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tmCus")
    def tm_cus(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies number of CUs for each Task Manager. The default value is 1.
        """
        return pulumi.get(self, "tm_cus")

    @property
    @pulumi.getter(name="tmSlotNum")
    def tm_slot_num(self) -> pulumi.Output[int]:
        """
        Specifies number of slots in each Task Manager.
        The default value is (**parallel_number** * **tm_cus**)/(**cu_number** - **manager_cu_number**).
        """
        return pulumi.get(self, "tm_slot_num")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the type of the job. The valid values are `flink_sql_job`,
        `flink_opensource_sql_job` and `flink_sql_edge_job`. Default value is `flink_sql_job`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="udfJarUrl")
    def udf_jar_url(self) -> pulumi.Output[str]:
        """
        Specifies name of the resource package that has been uploaded to the
        DLI resource management system. The UDF Jar file of the SQL job is specified by this parameter.
        """
        return pulumi.get(self, "udf_jar_url")

