# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetKeyResult',
    'AwaitableGetKeyResult',
    'get_key',
    'get_key_output',
]

@pulumi.output_type
class GetKeyResult:
    """
    A collection of values returned by getKey.
    """
    def __init__(__self__, creation_date=None, default_key_flag=None, domain_id=None, enterprise_project_id=None, expiration_time=None, id=None, key_alias=None, key_description=None, key_id=None, key_state=None, region=None, rotation_enabled=None, rotation_interval=None, rotation_number=None, scheduled_deletion_date=None, tags=None):
        if creation_date and not isinstance(creation_date, str):
            raise TypeError("Expected argument 'creation_date' to be a str")
        pulumi.set(__self__, "creation_date", creation_date)
        if default_key_flag and not isinstance(default_key_flag, str):
            raise TypeError("Expected argument 'default_key_flag' to be a str")
        pulumi.set(__self__, "default_key_flag", default_key_flag)
        if domain_id and not isinstance(domain_id, str):
            raise TypeError("Expected argument 'domain_id' to be a str")
        pulumi.set(__self__, "domain_id", domain_id)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if expiration_time and not isinstance(expiration_time, str):
            raise TypeError("Expected argument 'expiration_time' to be a str")
        pulumi.set(__self__, "expiration_time", expiration_time)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_alias and not isinstance(key_alias, str):
            raise TypeError("Expected argument 'key_alias' to be a str")
        pulumi.set(__self__, "key_alias", key_alias)
        if key_description and not isinstance(key_description, str):
            raise TypeError("Expected argument 'key_description' to be a str")
        pulumi.set(__self__, "key_description", key_description)
        if key_id and not isinstance(key_id, str):
            raise TypeError("Expected argument 'key_id' to be a str")
        pulumi.set(__self__, "key_id", key_id)
        if key_state and not isinstance(key_state, str):
            raise TypeError("Expected argument 'key_state' to be a str")
        pulumi.set(__self__, "key_state", key_state)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if rotation_enabled and not isinstance(rotation_enabled, bool):
            raise TypeError("Expected argument 'rotation_enabled' to be a bool")
        pulumi.set(__self__, "rotation_enabled", rotation_enabled)
        if rotation_interval and not isinstance(rotation_interval, int):
            raise TypeError("Expected argument 'rotation_interval' to be a int")
        pulumi.set(__self__, "rotation_interval", rotation_interval)
        if rotation_number and not isinstance(rotation_number, int):
            raise TypeError("Expected argument 'rotation_number' to be a int")
        pulumi.set(__self__, "rotation_number", rotation_number)
        if scheduled_deletion_date and not isinstance(scheduled_deletion_date, str):
            raise TypeError("Expected argument 'scheduled_deletion_date' to be a str")
        pulumi.set(__self__, "scheduled_deletion_date", scheduled_deletion_date)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> str:
        """
        Creation time (time stamp) of a key.
        """
        return pulumi.get(self, "creation_date")

    @property
    @pulumi.getter(name="defaultKeyFlag")
    def default_key_flag(self) -> str:
        return pulumi.get(self, "default_key_flag")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> str:
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> str:
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> str:
        """
        Expiration time.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="keyAlias")
    def key_alias(self) -> str:
        return pulumi.get(self, "key_alias")

    @property
    @pulumi.getter(name="keyDescription")
    def key_description(self) -> str:
        return pulumi.get(self, "key_description")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="keyState")
    def key_state(self) -> str:
        return pulumi.get(self, "key_state")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="rotationEnabled")
    def rotation_enabled(self) -> bool:
        """
        Indicates whether the key rotation is enabled or not.
        """
        return pulumi.get(self, "rotation_enabled")

    @property
    @pulumi.getter(name="rotationInterval")
    def rotation_interval(self) -> int:
        """
        The key rotation interval. It's valid when rotation is enabled.
        """
        return pulumi.get(self, "rotation_interval")

    @property
    @pulumi.getter(name="rotationNumber")
    def rotation_number(self) -> int:
        """
        The total number of key rotations. It's valid when rotation is enabled.
        """
        return pulumi.get(self, "rotation_number")

    @property
    @pulumi.getter(name="scheduledDeletionDate")
    def scheduled_deletion_date(self) -> str:
        """
        Scheduled deletion time (time stamp) of a key.
        """
        return pulumi.get(self, "scheduled_deletion_date")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        The key/value pairs to associate with the kms key.
        """
        return pulumi.get(self, "tags")


class AwaitableGetKeyResult(GetKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKeyResult(
            creation_date=self.creation_date,
            default_key_flag=self.default_key_flag,
            domain_id=self.domain_id,
            enterprise_project_id=self.enterprise_project_id,
            expiration_time=self.expiration_time,
            id=self.id,
            key_alias=self.key_alias,
            key_description=self.key_description,
            key_id=self.key_id,
            key_state=self.key_state,
            region=self.region,
            rotation_enabled=self.rotation_enabled,
            rotation_interval=self.rotation_interval,
            rotation_number=self.rotation_number,
            scheduled_deletion_date=self.scheduled_deletion_date,
            tags=self.tags)


def get_key(default_key_flag: Optional[str] = None,
            domain_id: Optional[str] = None,
            enterprise_project_id: Optional[str] = None,
            key_alias: Optional[str] = None,
            key_description: Optional[str] = None,
            key_id: Optional[str] = None,
            key_state: Optional[str] = None,
            region: Optional[str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKeyResult:
    """
    Use this data source to get the ID of an available HuaweiCloud KMS key.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    key1 = huaweicloud.Dew.get_key(default_key_flag="0",
        domain_id="b168fe00ff56492495a7d22974df2d0b",
        key_alias="test_key",
        key_description="test key description",
        key_id="af650527-a0ff-4527-aef3-c493df1f3012",
        key_state="2")
    ```


    :param str default_key_flag: Identification of a Master Key. The value "1" indicates a Default Master Key,
           and the value "0" indicates a key. Changing this gets a new key.
    :param str domain_id: - ID of a user domain for the key. Changing this gets a new key.
    :param str enterprise_project_id: The enterprise project id of the kms key.
    :param str key_alias: The alias in which to create the key. It is required when we create a new key.
           Changing this gets the new key.
    :param str key_description: The description of the key as viewed in Huawei console. Changing this gets a
           new key.
    :param str key_id: The globally unique identifier for the key. Changing this gets the new key.
    :param str key_state: The state of a key. "1" indicates that the key is waiting to be activated.
           "2" indicates that the key is enabled. "3" indicates that the key is disabled. "4" indicates that the key is scheduled
           for deletion. Changing this gets a new key.
    :param str region: The region in which to obtain the keys. If omitted, the provider-level region will be
           used.
    """
    __args__ = dict()
    __args__['defaultKeyFlag'] = default_key_flag
    __args__['domainId'] = domain_id
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['keyAlias'] = key_alias
    __args__['keyDescription'] = key_description
    __args__['keyId'] = key_id
    __args__['keyState'] = key_state
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Dew/getKey:getKey', __args__, opts=opts, typ=GetKeyResult).value

    return AwaitableGetKeyResult(
        creation_date=__ret__.creation_date,
        default_key_flag=__ret__.default_key_flag,
        domain_id=__ret__.domain_id,
        enterprise_project_id=__ret__.enterprise_project_id,
        expiration_time=__ret__.expiration_time,
        id=__ret__.id,
        key_alias=__ret__.key_alias,
        key_description=__ret__.key_description,
        key_id=__ret__.key_id,
        key_state=__ret__.key_state,
        region=__ret__.region,
        rotation_enabled=__ret__.rotation_enabled,
        rotation_interval=__ret__.rotation_interval,
        rotation_number=__ret__.rotation_number,
        scheduled_deletion_date=__ret__.scheduled_deletion_date,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_key)
def get_key_output(default_key_flag: Optional[pulumi.Input[Optional[str]]] = None,
                   domain_id: Optional[pulumi.Input[Optional[str]]] = None,
                   enterprise_project_id: Optional[pulumi.Input[Optional[str]]] = None,
                   key_alias: Optional[pulumi.Input[Optional[str]]] = None,
                   key_description: Optional[pulumi.Input[Optional[str]]] = None,
                   key_id: Optional[pulumi.Input[Optional[str]]] = None,
                   key_state: Optional[pulumi.Input[Optional[str]]] = None,
                   region: Optional[pulumi.Input[Optional[str]]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetKeyResult]:
    """
    Use this data source to get the ID of an available HuaweiCloud KMS key.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    key1 = huaweicloud.Dew.get_key(default_key_flag="0",
        domain_id="b168fe00ff56492495a7d22974df2d0b",
        key_alias="test_key",
        key_description="test key description",
        key_id="af650527-a0ff-4527-aef3-c493df1f3012",
        key_state="2")
    ```


    :param str default_key_flag: Identification of a Master Key. The value "1" indicates a Default Master Key,
           and the value "0" indicates a key. Changing this gets a new key.
    :param str domain_id: - ID of a user domain for the key. Changing this gets a new key.
    :param str enterprise_project_id: The enterprise project id of the kms key.
    :param str key_alias: The alias in which to create the key. It is required when we create a new key.
           Changing this gets the new key.
    :param str key_description: The description of the key as viewed in Huawei console. Changing this gets a
           new key.
    :param str key_id: The globally unique identifier for the key. Changing this gets the new key.
    :param str key_state: The state of a key. "1" indicates that the key is waiting to be activated.
           "2" indicates that the key is enabled. "3" indicates that the key is disabled. "4" indicates that the key is scheduled
           for deletion. Changing this gets a new key.
    :param str region: The region in which to obtain the keys. If omitted, the provider-level region will be
           used.
    """
    ...
