# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['MonitorArgs', 'Monitor']

@pulumi.input_type
class MonitorArgs:
    def __init__(__self__, *,
                 interval: pulumi.Input[int],
                 max_retries: pulumi.Input[int],
                 pool_id: pulumi.Input[str],
                 protocol: pulumi.Input[str],
                 timeout: pulumi.Input[int],
                 domain_name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 url_path: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Monitor resource.
        :param pulumi.Input[int] interval: The time, in seconds, between sending probes to members.
        :param pulumi.Input[int] max_retries: Number of permissible ping failures before changing the member's status to INACTIVE.
               Must be a number between 1 and 10.
        :param pulumi.Input[str] pool_id: The id of the pool that this monitor will be assigned to.
        :param pulumi.Input[str] protocol: The type of probe, which is TCP, HTTP, or HTTPS, that is sent by the load
               balancer to verify the member state. Changing this creates a new monitor.
        :param pulumi.Input[int] timeout: Maximum number of seconds for a monitor to wait for a ping reply before it times out. The
               value must be less than the delay value.
        :param pulumi.Input[str] domain_name: The Domain Name of the Monitor.
        :param pulumi.Input[int] port: Specifies the health check port. The value ranges from 1 to 65535.
        :param pulumi.Input[str] region: The region in which to create the ELB monitor resource. If omitted, the
               provider-level region will be used. Changing this creates a new monitor.
        :param pulumi.Input[str] url_path: Required for HTTP(S) types. URI path that will be accessed if monitor type is HTTP or
               HTTPS.
        """
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "max_retries", max_retries)
        pulumi.set(__self__, "pool_id", pool_id)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "timeout", timeout)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if url_path is not None:
            pulumi.set(__self__, "url_path", url_path)

    @property
    @pulumi.getter
    def interval(self) -> pulumi.Input[int]:
        """
        The time, in seconds, between sending probes to members.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: pulumi.Input[int]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> pulumi.Input[int]:
        """
        Number of permissible ping failures before changing the member's status to INACTIVE.
        Must be a number between 1 and 10.
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_retries", value)

    @property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> pulumi.Input[str]:
        """
        The id of the pool that this monitor will be assigned to.
        """
        return pulumi.get(self, "pool_id")

    @pool_id.setter
    def pool_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "pool_id", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        The type of probe, which is TCP, HTTP, or HTTPS, that is sent by the load
        balancer to verify the member state. Changing this creates a new monitor.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Input[int]:
        """
        Maximum number of seconds for a monitor to wait for a ping reply before it times out. The
        value must be less than the delay value.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: pulumi.Input[int]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Domain Name of the Monitor.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the health check port. The value ranges from 1 to 65535.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the ELB monitor resource. If omitted, the
        provider-level region will be used. Changing this creates a new monitor.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="urlPath")
    def url_path(self) -> Optional[pulumi.Input[str]]:
        """
        Required for HTTP(S) types. URI path that will be accessed if monitor type is HTTP or
        HTTPS.
        """
        return pulumi.get(self, "url_path")

    @url_path.setter
    def url_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url_path", value)


@pulumi.input_type
class _MonitorState:
    def __init__(__self__, *,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 interval: Optional[pulumi.Input[int]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 pool_id: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 url_path: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Monitor resources.
        :param pulumi.Input[str] domain_name: The Domain Name of the Monitor.
        :param pulumi.Input[int] interval: The time, in seconds, between sending probes to members.
        :param pulumi.Input[int] max_retries: Number of permissible ping failures before changing the member's status to INACTIVE.
               Must be a number between 1 and 10.
        :param pulumi.Input[str] pool_id: The id of the pool that this monitor will be assigned to.
        :param pulumi.Input[int] port: Specifies the health check port. The value ranges from 1 to 65535.
        :param pulumi.Input[str] protocol: The type of probe, which is TCP, HTTP, or HTTPS, that is sent by the load
               balancer to verify the member state. Changing this creates a new monitor.
        :param pulumi.Input[str] region: The region in which to create the ELB monitor resource. If omitted, the
               provider-level region will be used. Changing this creates a new monitor.
        :param pulumi.Input[int] timeout: Maximum number of seconds for a monitor to wait for a ping reply before it times out. The
               value must be less than the delay value.
        :param pulumi.Input[str] url_path: Required for HTTP(S) types. URI path that will be accessed if monitor type is HTTP or
               HTTPS.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if pool_id is not None:
            pulumi.set(__self__, "pool_id", pool_id)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if url_path is not None:
            pulumi.set(__self__, "url_path", url_path)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Domain Name of the Monitor.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[int]]:
        """
        The time, in seconds, between sending probes to members.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[int]]:
        """
        Number of permissible ping failures before changing the member's status to INACTIVE.
        Must be a number between 1 and 10.
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_retries", value)

    @property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the pool that this monitor will be assigned to.
        """
        return pulumi.get(self, "pool_id")

    @pool_id.setter
    def pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pool_id", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the health check port. The value ranges from 1 to 65535.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The type of probe, which is TCP, HTTP, or HTTPS, that is sent by the load
        balancer to verify the member state. Changing this creates a new monitor.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the ELB monitor resource. If omitted, the
        provider-level region will be used. Changing this creates a new monitor.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of seconds for a monitor to wait for a ping reply before it times out. The
        value must be less than the delay value.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="urlPath")
    def url_path(self) -> Optional[pulumi.Input[str]]:
        """
        Required for HTTP(S) types. URI path that will be accessed if monitor type is HTTP or
        HTTPS.
        """
        return pulumi.get(self, "url_path")

    @url_path.setter
    def url_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url_path", value)


class Monitor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 interval: Optional[pulumi.Input[int]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 pool_id: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 url_path: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages an ELB monitor resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        monitor1 = huaweicloud.dedicated_elb.Monitor("monitor1",
            protocol="HTTP",
            interval=30,
            timeout=15,
            max_retries=10,
            url_path="/api",
            port=8888,
            pool_id=huaweicloud_elb_pool["test"]["id"])
        ```

        ## Import

        ELB monitor can be imported using the monitor ID, e.g.

        ```sh
         $ pulumi import huaweicloud:DedicatedElb/monitor:Monitor monitor_1 5c20fdad-7288-11eb-b817-0255ac10158b
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] domain_name: The Domain Name of the Monitor.
        :param pulumi.Input[int] interval: The time, in seconds, between sending probes to members.
        :param pulumi.Input[int] max_retries: Number of permissible ping failures before changing the member's status to INACTIVE.
               Must be a number between 1 and 10.
        :param pulumi.Input[str] pool_id: The id of the pool that this monitor will be assigned to.
        :param pulumi.Input[int] port: Specifies the health check port. The value ranges from 1 to 65535.
        :param pulumi.Input[str] protocol: The type of probe, which is TCP, HTTP, or HTTPS, that is sent by the load
               balancer to verify the member state. Changing this creates a new monitor.
        :param pulumi.Input[str] region: The region in which to create the ELB monitor resource. If omitted, the
               provider-level region will be used. Changing this creates a new monitor.
        :param pulumi.Input[int] timeout: Maximum number of seconds for a monitor to wait for a ping reply before it times out. The
               value must be less than the delay value.
        :param pulumi.Input[str] url_path: Required for HTTP(S) types. URI path that will be accessed if monitor type is HTTP or
               HTTPS.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MonitorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an ELB monitor resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        monitor1 = huaweicloud.dedicated_elb.Monitor("monitor1",
            protocol="HTTP",
            interval=30,
            timeout=15,
            max_retries=10,
            url_path="/api",
            port=8888,
            pool_id=huaweicloud_elb_pool["test"]["id"])
        ```

        ## Import

        ELB monitor can be imported using the monitor ID, e.g.

        ```sh
         $ pulumi import huaweicloud:DedicatedElb/monitor:Monitor monitor_1 5c20fdad-7288-11eb-b817-0255ac10158b
        ```

        :param str resource_name: The name of the resource.
        :param MonitorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MonitorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 interval: Optional[pulumi.Input[int]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 pool_id: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 url_path: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MonitorArgs.__new__(MonitorArgs)

            __props__.__dict__["domain_name"] = domain_name
            if interval is None and not opts.urn:
                raise TypeError("Missing required property 'interval'")
            __props__.__dict__["interval"] = interval
            if max_retries is None and not opts.urn:
                raise TypeError("Missing required property 'max_retries'")
            __props__.__dict__["max_retries"] = max_retries
            if pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'pool_id'")
            __props__.__dict__["pool_id"] = pool_id
            __props__.__dict__["port"] = port
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["region"] = region
            if timeout is None and not opts.urn:
                raise TypeError("Missing required property 'timeout'")
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["url_path"] = url_path
        super(Monitor, __self__).__init__(
            'huaweicloud:DedicatedElb/monitor:Monitor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            domain_name: Optional[pulumi.Input[str]] = None,
            interval: Optional[pulumi.Input[int]] = None,
            max_retries: Optional[pulumi.Input[int]] = None,
            pool_id: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[int]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            timeout: Optional[pulumi.Input[int]] = None,
            url_path: Optional[pulumi.Input[str]] = None) -> 'Monitor':
        """
        Get an existing Monitor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] domain_name: The Domain Name of the Monitor.
        :param pulumi.Input[int] interval: The time, in seconds, between sending probes to members.
        :param pulumi.Input[int] max_retries: Number of permissible ping failures before changing the member's status to INACTIVE.
               Must be a number between 1 and 10.
        :param pulumi.Input[str] pool_id: The id of the pool that this monitor will be assigned to.
        :param pulumi.Input[int] port: Specifies the health check port. The value ranges from 1 to 65535.
        :param pulumi.Input[str] protocol: The type of probe, which is TCP, HTTP, or HTTPS, that is sent by the load
               balancer to verify the member state. Changing this creates a new monitor.
        :param pulumi.Input[str] region: The region in which to create the ELB monitor resource. If omitted, the
               provider-level region will be used. Changing this creates a new monitor.
        :param pulumi.Input[int] timeout: Maximum number of seconds for a monitor to wait for a ping reply before it times out. The
               value must be less than the delay value.
        :param pulumi.Input[str] url_path: Required for HTTP(S) types. URI path that will be accessed if monitor type is HTTP or
               HTTPS.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MonitorState.__new__(_MonitorState)

        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["interval"] = interval
        __props__.__dict__["max_retries"] = max_retries
        __props__.__dict__["pool_id"] = pool_id
        __props__.__dict__["port"] = port
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["region"] = region
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["url_path"] = url_path
        return Monitor(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[Optional[str]]:
        """
        The Domain Name of the Monitor.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def interval(self) -> pulumi.Output[int]:
        """
        The time, in seconds, between sending probes to members.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> pulumi.Output[int]:
        """
        Number of permissible ping failures before changing the member's status to INACTIVE.
        Must be a number between 1 and 10.
        """
        return pulumi.get(self, "max_retries")

    @property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> pulumi.Output[str]:
        """
        The id of the pool that this monitor will be assigned to.
        """
        return pulumi.get(self, "pool_id")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the health check port. The value ranges from 1 to 65535.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[str]:
        """
        The type of probe, which is TCP, HTTP, or HTTPS, that is sent by the load
        balancer to verify the member state. Changing this creates a new monitor.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the ELB monitor resource. If omitted, the
        provider-level region will be used. Changing this creates a new monitor.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[int]:
        """
        Maximum number of seconds for a monitor to wait for a ping reply before it times out. The
        value must be less than the delay value.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="urlPath")
    def url_path(self) -> pulumi.Output[str]:
        """
        Required for HTTP(S) types. URI path that will be accessed if monitor type is HTTP or
        HTTPS.
        """
        return pulumi.get(self, "url_path")

