# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['LoadbalancerArgs', 'Loadbalancer']

@pulumi.input_type
class LoadbalancerArgs:
    def __init__(__self__, *,
                 availability_zones: pulumi.Input[Sequence[pulumi.Input[str]]],
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 bandwidth_charge_mode: Optional[pulumi.Input[str]] = None,
                 bandwidth_size: Optional[pulumi.Input[int]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 cross_vpc_backend: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 iptype: Optional[pulumi.Input[str]] = None,
                 ipv4_address: Optional[pulumi.Input[str]] = None,
                 ipv4_eip_id: Optional[pulumi.Input[str]] = None,
                 ipv4_subnet_id: Optional[pulumi.Input[str]] = None,
                 ipv6_bandwidth_id: Optional[pulumi.Input[str]] = None,
                 ipv6_network_id: Optional[pulumi.Input[str]] = None,
                 l4_flavor_id: Optional[pulumi.Input[str]] = None,
                 l7_flavor_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 sharetype: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Loadbalancer resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: Specifies the list of AZ names. Changing this parameter will create a
               new resource.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled. Valid values are **true** and
               **false**. Changing this parameter will create a new resource.
        :param pulumi.Input[str] bandwidth_charge_mode: Bandwidth billing type. Changing this parameter will create a
               new resource.
        :param pulumi.Input[int] bandwidth_size: Bandwidth size. Changing this parameter will create a new resource.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the ELB loadbalancer.
               Valid values are **prePaid** and **postPaid**, defaults to **postPaid**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[bool] cross_vpc_backend: Enable this if you want to associate the IP addresses of backend servers with
               your load balancer. Can only be true when updating.
        :param pulumi.Input[str] description: Human-readable description for the loadbalancer.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the loadbalancer. Changing this
               creates a new loadbalancer.
        :param pulumi.Input[str] iptype: Elastic IP type. Changing this parameter will create a new resource.
        :param pulumi.Input[str] ipv4_address: The ipv4 address of the load balancer.
        :param pulumi.Input[str] ipv4_eip_id: The ID of the EIP. Changing this parameter will create a new resource.
        :param pulumi.Input[str] ipv4_subnet_id: The subnet on which to allocate the loadbalancer's ipv4 address.
        :param pulumi.Input[str] ipv6_bandwidth_id: The ipv6 bandwidth id. Only support shared bandwidth.
        :param pulumi.Input[str] ipv6_network_id: The network on which to allocate the loadbalancer's ipv6 address.
        :param pulumi.Input[str] l4_flavor_id: The L4 flavor id of the load balancer.
        :param pulumi.Input[str] l7_flavor_id: The L7 flavor id of the load balancer.
        :param pulumi.Input[str] name: Human-readable name for the loadbalancer.
        :param pulumi.Input[int] period: Specifies the charging period of the ELB loadbalancer.
               If `period_unit` is set to **month**, the value ranges from 1 to 9.
               If `period_unit` is set to **year**, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the ELB loadbalancer.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the loadbalancer resource. If omitted, the
               provider-level region will be used. Changing this creates a new loadbalancer.
        :param pulumi.Input[str] sharetype: Bandwidth sharing type. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the loadbalancer.
        :param pulumi.Input[str] vpc_id: The vpc on which to create the loadbalancer. Changing this creates a new
               loadbalancer.
        """
        pulumi.set(__self__, "availability_zones", availability_zones)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if bandwidth_charge_mode is not None:
            pulumi.set(__self__, "bandwidth_charge_mode", bandwidth_charge_mode)
        if bandwidth_size is not None:
            pulumi.set(__self__, "bandwidth_size", bandwidth_size)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if cross_vpc_backend is not None:
            pulumi.set(__self__, "cross_vpc_backend", cross_vpc_backend)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if iptype is not None:
            pulumi.set(__self__, "iptype", iptype)
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)
        if ipv4_eip_id is not None:
            pulumi.set(__self__, "ipv4_eip_id", ipv4_eip_id)
        if ipv4_subnet_id is not None:
            pulumi.set(__self__, "ipv4_subnet_id", ipv4_subnet_id)
        if ipv6_bandwidth_id is not None:
            pulumi.set(__self__, "ipv6_bandwidth_id", ipv6_bandwidth_id)
        if ipv6_network_id is not None:
            pulumi.set(__self__, "ipv6_network_id", ipv6_network_id)
        if l4_flavor_id is not None:
            pulumi.set(__self__, "l4_flavor_id", l4_flavor_id)
        if l7_flavor_id is not None:
            pulumi.set(__self__, "l7_flavor_id", l7_flavor_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sharetype is not None:
            pulumi.set(__self__, "sharetype", sharetype)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies the list of AZ names. Changing this parameter will create a
        new resource.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_pay", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether auto renew is enabled. Valid values are **true** and
        **false**. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="bandwidthChargeMode")
    def bandwidth_charge_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Bandwidth billing type. Changing this parameter will create a
        new resource.
        """
        return pulumi.get(self, "bandwidth_charge_mode")

    @bandwidth_charge_mode.setter
    def bandwidth_charge_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth_charge_mode", value)

    @property
    @pulumi.getter(name="bandwidthSize")
    def bandwidth_size(self) -> Optional[pulumi.Input[int]]:
        """
        Bandwidth size. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "bandwidth_size")

    @bandwidth_size.setter
    def bandwidth_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth_size", value)

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging mode of the ELB loadbalancer.
        Valid values are **prePaid** and **postPaid**, defaults to **postPaid**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charging_mode", value)

    @property
    @pulumi.getter(name="crossVpcBackend")
    def cross_vpc_backend(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable this if you want to associate the IP addresses of backend servers with
        your load balancer. Can only be true when updating.
        """
        return pulumi.get(self, "cross_vpc_backend")

    @cross_vpc_backend.setter
    def cross_vpc_backend(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cross_vpc_backend", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable description for the loadbalancer.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The enterprise project id of the loadbalancer. Changing this
        creates a new loadbalancer.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def iptype(self) -> Optional[pulumi.Input[str]]:
        """
        Elastic IP type. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "iptype")

    @iptype.setter
    def iptype(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iptype", value)

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[pulumi.Input[str]]:
        """
        The ipv4 address of the load balancer.
        """
        return pulumi.get(self, "ipv4_address")

    @ipv4_address.setter
    def ipv4_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_address", value)

    @property
    @pulumi.getter(name="ipv4EipId")
    def ipv4_eip_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the EIP. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ipv4_eip_id")

    @ipv4_eip_id.setter
    def ipv4_eip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_eip_id", value)

    @property
    @pulumi.getter(name="ipv4SubnetId")
    def ipv4_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet on which to allocate the loadbalancer's ipv4 address.
        """
        return pulumi.get(self, "ipv4_subnet_id")

    @ipv4_subnet_id.setter
    def ipv4_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_subnet_id", value)

    @property
    @pulumi.getter(name="ipv6BandwidthId")
    def ipv6_bandwidth_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ipv6 bandwidth id. Only support shared bandwidth.
        """
        return pulumi.get(self, "ipv6_bandwidth_id")

    @ipv6_bandwidth_id.setter
    def ipv6_bandwidth_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_bandwidth_id", value)

    @property
    @pulumi.getter(name="ipv6NetworkId")
    def ipv6_network_id(self) -> Optional[pulumi.Input[str]]:
        """
        The network on which to allocate the loadbalancer's ipv6 address.
        """
        return pulumi.get(self, "ipv6_network_id")

    @ipv6_network_id.setter
    def ipv6_network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_network_id", value)

    @property
    @pulumi.getter(name="l4FlavorId")
    def l4_flavor_id(self) -> Optional[pulumi.Input[str]]:
        """
        The L4 flavor id of the load balancer.
        """
        return pulumi.get(self, "l4_flavor_id")

    @l4_flavor_id.setter
    def l4_flavor_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "l4_flavor_id", value)

    @property
    @pulumi.getter(name="l7FlavorId")
    def l7_flavor_id(self) -> Optional[pulumi.Input[str]]:
        """
        The L7 flavor id of the load balancer.
        """
        return pulumi.get(self, "l7_flavor_id")

    @l7_flavor_id.setter
    def l7_flavor_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "l7_flavor_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable name for the loadbalancer.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the charging period of the ELB loadbalancer.
        If `period_unit` is set to **month**, the value ranges from 1 to 9.
        If `period_unit` is set to **year**, the value ranges from 1 to 3.
        This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging period unit of the ELB loadbalancer.
        Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the loadbalancer resource. If omitted, the
        provider-level region will be used. Changing this creates a new loadbalancer.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def sharetype(self) -> Optional[pulumi.Input[str]]:
        """
        Bandwidth sharing type. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "sharetype")

    @sharetype.setter
    def sharetype(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sharetype", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value pairs to associate with the loadbalancer.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The vpc on which to create the loadbalancer. Changing this creates a new
        loadbalancer.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.input_type
class _LoadbalancerState:
    def __init__(__self__, *,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 bandwidth_charge_mode: Optional[pulumi.Input[str]] = None,
                 bandwidth_size: Optional[pulumi.Input[int]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 cross_vpc_backend: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 iptype: Optional[pulumi.Input[str]] = None,
                 ipv4_address: Optional[pulumi.Input[str]] = None,
                 ipv4_eip: Optional[pulumi.Input[str]] = None,
                 ipv4_eip_id: Optional[pulumi.Input[str]] = None,
                 ipv4_subnet_id: Optional[pulumi.Input[str]] = None,
                 ipv6_address: Optional[pulumi.Input[str]] = None,
                 ipv6_bandwidth_id: Optional[pulumi.Input[str]] = None,
                 ipv6_eip: Optional[pulumi.Input[str]] = None,
                 ipv6_eip_id: Optional[pulumi.Input[str]] = None,
                 ipv6_network_id: Optional[pulumi.Input[str]] = None,
                 l4_flavor_id: Optional[pulumi.Input[str]] = None,
                 l7_flavor_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 sharetype: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Loadbalancer resources.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled. Valid values are **true** and
               **false**. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: Specifies the list of AZ names. Changing this parameter will create a
               new resource.
        :param pulumi.Input[str] bandwidth_charge_mode: Bandwidth billing type. Changing this parameter will create a
               new resource.
        :param pulumi.Input[int] bandwidth_size: Bandwidth size. Changing this parameter will create a new resource.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the ELB loadbalancer.
               Valid values are **prePaid** and **postPaid**, defaults to **postPaid**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[bool] cross_vpc_backend: Enable this if you want to associate the IP addresses of backend servers with
               your load balancer. Can only be true when updating.
        :param pulumi.Input[str] description: Human-readable description for the loadbalancer.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the loadbalancer. Changing this
               creates a new loadbalancer.
        :param pulumi.Input[str] iptype: Elastic IP type. Changing this parameter will create a new resource.
        :param pulumi.Input[str] ipv4_address: The ipv4 address of the load balancer.
        :param pulumi.Input[str] ipv4_eip: The ipv4 eip address of the Load Balancer.
        :param pulumi.Input[str] ipv4_eip_id: The ID of the EIP. Changing this parameter will create a new resource.
        :param pulumi.Input[str] ipv4_subnet_id: The subnet on which to allocate the loadbalancer's ipv4 address.
        :param pulumi.Input[str] ipv6_address: The ipv6 address of the Load Balancer.
        :param pulumi.Input[str] ipv6_bandwidth_id: The ipv6 bandwidth id. Only support shared bandwidth.
        :param pulumi.Input[str] ipv6_eip: The ipv6 eip address of the Load Balancer.
        :param pulumi.Input[str] ipv6_eip_id: The ipv6 eip id of the Load Balancer.
        :param pulumi.Input[str] ipv6_network_id: The network on which to allocate the loadbalancer's ipv6 address.
        :param pulumi.Input[str] l4_flavor_id: The L4 flavor id of the load balancer.
        :param pulumi.Input[str] l7_flavor_id: The L7 flavor id of the load balancer.
        :param pulumi.Input[str] name: Human-readable name for the loadbalancer.
        :param pulumi.Input[int] period: Specifies the charging period of the ELB loadbalancer.
               If `period_unit` is set to **month**, the value ranges from 1 to 9.
               If `period_unit` is set to **year**, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the ELB loadbalancer.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the loadbalancer resource. If omitted, the
               provider-level region will be used. Changing this creates a new loadbalancer.
        :param pulumi.Input[str] sharetype: Bandwidth sharing type. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the loadbalancer.
        :param pulumi.Input[str] vpc_id: The vpc on which to create the loadbalancer. Changing this creates a new
               loadbalancer.
        """
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if bandwidth_charge_mode is not None:
            pulumi.set(__self__, "bandwidth_charge_mode", bandwidth_charge_mode)
        if bandwidth_size is not None:
            pulumi.set(__self__, "bandwidth_size", bandwidth_size)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if cross_vpc_backend is not None:
            pulumi.set(__self__, "cross_vpc_backend", cross_vpc_backend)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if iptype is not None:
            pulumi.set(__self__, "iptype", iptype)
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)
        if ipv4_eip is not None:
            pulumi.set(__self__, "ipv4_eip", ipv4_eip)
        if ipv4_eip_id is not None:
            pulumi.set(__self__, "ipv4_eip_id", ipv4_eip_id)
        if ipv4_subnet_id is not None:
            pulumi.set(__self__, "ipv4_subnet_id", ipv4_subnet_id)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if ipv6_bandwidth_id is not None:
            pulumi.set(__self__, "ipv6_bandwidth_id", ipv6_bandwidth_id)
        if ipv6_eip is not None:
            pulumi.set(__self__, "ipv6_eip", ipv6_eip)
        if ipv6_eip_id is not None:
            pulumi.set(__self__, "ipv6_eip_id", ipv6_eip_id)
        if ipv6_network_id is not None:
            pulumi.set(__self__, "ipv6_network_id", ipv6_network_id)
        if l4_flavor_id is not None:
            pulumi.set(__self__, "l4_flavor_id", l4_flavor_id)
        if l7_flavor_id is not None:
            pulumi.set(__self__, "l7_flavor_id", l7_flavor_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sharetype is not None:
            pulumi.set(__self__, "sharetype", sharetype)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_pay", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether auto renew is enabled. Valid values are **true** and
        **false**. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the list of AZ names. Changing this parameter will create a
        new resource.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="bandwidthChargeMode")
    def bandwidth_charge_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Bandwidth billing type. Changing this parameter will create a
        new resource.
        """
        return pulumi.get(self, "bandwidth_charge_mode")

    @bandwidth_charge_mode.setter
    def bandwidth_charge_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth_charge_mode", value)

    @property
    @pulumi.getter(name="bandwidthSize")
    def bandwidth_size(self) -> Optional[pulumi.Input[int]]:
        """
        Bandwidth size. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "bandwidth_size")

    @bandwidth_size.setter
    def bandwidth_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth_size", value)

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging mode of the ELB loadbalancer.
        Valid values are **prePaid** and **postPaid**, defaults to **postPaid**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charging_mode", value)

    @property
    @pulumi.getter(name="crossVpcBackend")
    def cross_vpc_backend(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable this if you want to associate the IP addresses of backend servers with
        your load balancer. Can only be true when updating.
        """
        return pulumi.get(self, "cross_vpc_backend")

    @cross_vpc_backend.setter
    def cross_vpc_backend(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cross_vpc_backend", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable description for the loadbalancer.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The enterprise project id of the loadbalancer. Changing this
        creates a new loadbalancer.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def iptype(self) -> Optional[pulumi.Input[str]]:
        """
        Elastic IP type. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "iptype")

    @iptype.setter
    def iptype(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iptype", value)

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[pulumi.Input[str]]:
        """
        The ipv4 address of the load balancer.
        """
        return pulumi.get(self, "ipv4_address")

    @ipv4_address.setter
    def ipv4_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_address", value)

    @property
    @pulumi.getter(name="ipv4Eip")
    def ipv4_eip(self) -> Optional[pulumi.Input[str]]:
        """
        The ipv4 eip address of the Load Balancer.
        """
        return pulumi.get(self, "ipv4_eip")

    @ipv4_eip.setter
    def ipv4_eip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_eip", value)

    @property
    @pulumi.getter(name="ipv4EipId")
    def ipv4_eip_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the EIP. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ipv4_eip_id")

    @ipv4_eip_id.setter
    def ipv4_eip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_eip_id", value)

    @property
    @pulumi.getter(name="ipv4SubnetId")
    def ipv4_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet on which to allocate the loadbalancer's ipv4 address.
        """
        return pulumi.get(self, "ipv4_subnet_id")

    @ipv4_subnet_id.setter
    def ipv4_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_subnet_id", value)

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[pulumi.Input[str]]:
        """
        The ipv6 address of the Load Balancer.
        """
        return pulumi.get(self, "ipv6_address")

    @ipv6_address.setter
    def ipv6_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_address", value)

    @property
    @pulumi.getter(name="ipv6BandwidthId")
    def ipv6_bandwidth_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ipv6 bandwidth id. Only support shared bandwidth.
        """
        return pulumi.get(self, "ipv6_bandwidth_id")

    @ipv6_bandwidth_id.setter
    def ipv6_bandwidth_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_bandwidth_id", value)

    @property
    @pulumi.getter(name="ipv6Eip")
    def ipv6_eip(self) -> Optional[pulumi.Input[str]]:
        """
        The ipv6 eip address of the Load Balancer.
        """
        return pulumi.get(self, "ipv6_eip")

    @ipv6_eip.setter
    def ipv6_eip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_eip", value)

    @property
    @pulumi.getter(name="ipv6EipId")
    def ipv6_eip_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ipv6 eip id of the Load Balancer.
        """
        return pulumi.get(self, "ipv6_eip_id")

    @ipv6_eip_id.setter
    def ipv6_eip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_eip_id", value)

    @property
    @pulumi.getter(name="ipv6NetworkId")
    def ipv6_network_id(self) -> Optional[pulumi.Input[str]]:
        """
        The network on which to allocate the loadbalancer's ipv6 address.
        """
        return pulumi.get(self, "ipv6_network_id")

    @ipv6_network_id.setter
    def ipv6_network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_network_id", value)

    @property
    @pulumi.getter(name="l4FlavorId")
    def l4_flavor_id(self) -> Optional[pulumi.Input[str]]:
        """
        The L4 flavor id of the load balancer.
        """
        return pulumi.get(self, "l4_flavor_id")

    @l4_flavor_id.setter
    def l4_flavor_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "l4_flavor_id", value)

    @property
    @pulumi.getter(name="l7FlavorId")
    def l7_flavor_id(self) -> Optional[pulumi.Input[str]]:
        """
        The L7 flavor id of the load balancer.
        """
        return pulumi.get(self, "l7_flavor_id")

    @l7_flavor_id.setter
    def l7_flavor_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "l7_flavor_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable name for the loadbalancer.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the charging period of the ELB loadbalancer.
        If `period_unit` is set to **month**, the value ranges from 1 to 9.
        If `period_unit` is set to **year**, the value ranges from 1 to 3.
        This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging period unit of the ELB loadbalancer.
        Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the loadbalancer resource. If omitted, the
        provider-level region will be used. Changing this creates a new loadbalancer.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def sharetype(self) -> Optional[pulumi.Input[str]]:
        """
        Bandwidth sharing type. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "sharetype")

    @sharetype.setter
    def sharetype(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sharetype", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value pairs to associate with the loadbalancer.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The vpc on which to create the loadbalancer. Changing this creates a new
        loadbalancer.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class Loadbalancer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 bandwidth_charge_mode: Optional[pulumi.Input[str]] = None,
                 bandwidth_size: Optional[pulumi.Input[int]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 cross_vpc_backend: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 iptype: Optional[pulumi.Input[str]] = None,
                 ipv4_address: Optional[pulumi.Input[str]] = None,
                 ipv4_eip_id: Optional[pulumi.Input[str]] = None,
                 ipv4_subnet_id: Optional[pulumi.Input[str]] = None,
                 ipv6_bandwidth_id: Optional[pulumi.Input[str]] = None,
                 ipv6_network_id: Optional[pulumi.Input[str]] = None,
                 l4_flavor_id: Optional[pulumi.Input[str]] = None,
                 l7_flavor_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 sharetype: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a Dedicated Load Balancer resource within HuaweiCloud.

        ## Example Usage
        ### Basic Loadbalancer

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        basic = huaweicloud.dedicated_elb.Loadbalancer("basic",
            availability_zones=[
                "cn-north-4a",
                "cn-north-4b",
            ],
            cross_vpc_backend=True,
            description="basic example",
            enterprise_project_id="{{ eps_id }}",
            ipv4_subnet_id="{{ subnet_id }}",
            l4_flavor_id="{{ l4_flavor_id }}",
            l7_flavor_id="{{ l7_flavor_id }}",
            vpc_id="{{ vpc_id }}")
        ```
        ### Loadbalancer With Existing EIP

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        basic = huaweicloud.dedicated_elb.Loadbalancer("basic",
            availability_zones=[
                "cn-north-4a",
                "cn-north-4b",
            ],
            cross_vpc_backend=True,
            description="basic example",
            enterprise_project_id="{{ eps_id }}",
            ipv4_eip_id="{{ eip_id }}",
            ipv4_subnet_id="{{ subnet_id }}",
            ipv6_bandwidth_id="{{ ipv6_bandwidth_id }}",
            ipv6_network_id="{{ ipv6_network_id }}",
            l4_flavor_id="{{ l4_flavor_id }}",
            l7_flavor_id="{{ l7_flavor_id }}",
            vpc_id="{{ vpc_id }}")
        ```
        ### Loadbalancer With EIP

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        basic = huaweicloud.dedicated_elb.Loadbalancer("basic",
            availability_zones=[
                "cn-north-4a",
                "cn-north-4b",
            ],
            bandwidth_charge_mode="traffic",
            bandwidth_size=10,
            cross_vpc_backend=True,
            description="basic example",
            enterprise_project_id="{{ eps_id }}",
            iptype="5_bgp",
            ipv4_subnet_id="{{ subnet_id }}",
            ipv6_bandwidth_id="{{ ipv6_bandwidth_id }}",
            ipv6_network_id="{{ ipv6_network_id }}",
            l4_flavor_id="{{ l4_flavor_id }}",
            l7_flavor_id="{{ l7_flavor_id }}",
            sharetype="PER",
            vpc_id="{{ vpc_id }}")
        ```

        ## Import

        ELB loadbalancer can be imported using the loadbalancer ID, e.g.

        ```sh
         $ pulumi import huaweicloud:DedicatedElb/loadbalancer:Loadbalancer loadbalancer_1 5c20fdad-7288-11eb-b817-0255ac10158b
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`ipv6_bandwidth_id`, `iptype`, `bandwidth_charge_mode`, `sharetype` and `bandwidth_size`. It is generally recommended running `terraform plan` after importing a loadbalancer. You can then decide if changes should be applied to the loadbalancer, or the resource definition should be updated to align with the loadbalancer. Also you can ignore changes as below. resource "huaweicloud_elb_loadbalancer" "loadbalancer_1" {

         ...

         lifecycle {

         ignore_changes = [

         ipv6_bandwidth_id, iptype, bandwidth_charge_mode, sharetype, bandwidth_size,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled. Valid values are **true** and
               **false**. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: Specifies the list of AZ names. Changing this parameter will create a
               new resource.
        :param pulumi.Input[str] bandwidth_charge_mode: Bandwidth billing type. Changing this parameter will create a
               new resource.
        :param pulumi.Input[int] bandwidth_size: Bandwidth size. Changing this parameter will create a new resource.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the ELB loadbalancer.
               Valid values are **prePaid** and **postPaid**, defaults to **postPaid**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[bool] cross_vpc_backend: Enable this if you want to associate the IP addresses of backend servers with
               your load balancer. Can only be true when updating.
        :param pulumi.Input[str] description: Human-readable description for the loadbalancer.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the loadbalancer. Changing this
               creates a new loadbalancer.
        :param pulumi.Input[str] iptype: Elastic IP type. Changing this parameter will create a new resource.
        :param pulumi.Input[str] ipv4_address: The ipv4 address of the load balancer.
        :param pulumi.Input[str] ipv4_eip_id: The ID of the EIP. Changing this parameter will create a new resource.
        :param pulumi.Input[str] ipv4_subnet_id: The subnet on which to allocate the loadbalancer's ipv4 address.
        :param pulumi.Input[str] ipv6_bandwidth_id: The ipv6 bandwidth id. Only support shared bandwidth.
        :param pulumi.Input[str] ipv6_network_id: The network on which to allocate the loadbalancer's ipv6 address.
        :param pulumi.Input[str] l4_flavor_id: The L4 flavor id of the load balancer.
        :param pulumi.Input[str] l7_flavor_id: The L7 flavor id of the load balancer.
        :param pulumi.Input[str] name: Human-readable name for the loadbalancer.
        :param pulumi.Input[int] period: Specifies the charging period of the ELB loadbalancer.
               If `period_unit` is set to **month**, the value ranges from 1 to 9.
               If `period_unit` is set to **year**, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the ELB loadbalancer.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the loadbalancer resource. If omitted, the
               provider-level region will be used. Changing this creates a new loadbalancer.
        :param pulumi.Input[str] sharetype: Bandwidth sharing type. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the loadbalancer.
        :param pulumi.Input[str] vpc_id: The vpc on which to create the loadbalancer. Changing this creates a new
               loadbalancer.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadbalancerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Dedicated Load Balancer resource within HuaweiCloud.

        ## Example Usage
        ### Basic Loadbalancer

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        basic = huaweicloud.dedicated_elb.Loadbalancer("basic",
            availability_zones=[
                "cn-north-4a",
                "cn-north-4b",
            ],
            cross_vpc_backend=True,
            description="basic example",
            enterprise_project_id="{{ eps_id }}",
            ipv4_subnet_id="{{ subnet_id }}",
            l4_flavor_id="{{ l4_flavor_id }}",
            l7_flavor_id="{{ l7_flavor_id }}",
            vpc_id="{{ vpc_id }}")
        ```
        ### Loadbalancer With Existing EIP

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        basic = huaweicloud.dedicated_elb.Loadbalancer("basic",
            availability_zones=[
                "cn-north-4a",
                "cn-north-4b",
            ],
            cross_vpc_backend=True,
            description="basic example",
            enterprise_project_id="{{ eps_id }}",
            ipv4_eip_id="{{ eip_id }}",
            ipv4_subnet_id="{{ subnet_id }}",
            ipv6_bandwidth_id="{{ ipv6_bandwidth_id }}",
            ipv6_network_id="{{ ipv6_network_id }}",
            l4_flavor_id="{{ l4_flavor_id }}",
            l7_flavor_id="{{ l7_flavor_id }}",
            vpc_id="{{ vpc_id }}")
        ```
        ### Loadbalancer With EIP

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        basic = huaweicloud.dedicated_elb.Loadbalancer("basic",
            availability_zones=[
                "cn-north-4a",
                "cn-north-4b",
            ],
            bandwidth_charge_mode="traffic",
            bandwidth_size=10,
            cross_vpc_backend=True,
            description="basic example",
            enterprise_project_id="{{ eps_id }}",
            iptype="5_bgp",
            ipv4_subnet_id="{{ subnet_id }}",
            ipv6_bandwidth_id="{{ ipv6_bandwidth_id }}",
            ipv6_network_id="{{ ipv6_network_id }}",
            l4_flavor_id="{{ l4_flavor_id }}",
            l7_flavor_id="{{ l7_flavor_id }}",
            sharetype="PER",
            vpc_id="{{ vpc_id }}")
        ```

        ## Import

        ELB loadbalancer can be imported using the loadbalancer ID, e.g.

        ```sh
         $ pulumi import huaweicloud:DedicatedElb/loadbalancer:Loadbalancer loadbalancer_1 5c20fdad-7288-11eb-b817-0255ac10158b
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`ipv6_bandwidth_id`, `iptype`, `bandwidth_charge_mode`, `sharetype` and `bandwidth_size`. It is generally recommended running `terraform plan` after importing a loadbalancer. You can then decide if changes should be applied to the loadbalancer, or the resource definition should be updated to align with the loadbalancer. Also you can ignore changes as below. resource "huaweicloud_elb_loadbalancer" "loadbalancer_1" {

         ...

         lifecycle {

         ignore_changes = [

         ipv6_bandwidth_id, iptype, bandwidth_charge_mode, sharetype, bandwidth_size,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param LoadbalancerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadbalancerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 bandwidth_charge_mode: Optional[pulumi.Input[str]] = None,
                 bandwidth_size: Optional[pulumi.Input[int]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 cross_vpc_backend: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 iptype: Optional[pulumi.Input[str]] = None,
                 ipv4_address: Optional[pulumi.Input[str]] = None,
                 ipv4_eip_id: Optional[pulumi.Input[str]] = None,
                 ipv4_subnet_id: Optional[pulumi.Input[str]] = None,
                 ipv6_bandwidth_id: Optional[pulumi.Input[str]] = None,
                 ipv6_network_id: Optional[pulumi.Input[str]] = None,
                 l4_flavor_id: Optional[pulumi.Input[str]] = None,
                 l7_flavor_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 sharetype: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadbalancerArgs.__new__(LoadbalancerArgs)

            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["auto_renew"] = auto_renew
            if availability_zones is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zones'")
            __props__.__dict__["availability_zones"] = availability_zones
            __props__.__dict__["bandwidth_charge_mode"] = bandwidth_charge_mode
            __props__.__dict__["bandwidth_size"] = bandwidth_size
            __props__.__dict__["charging_mode"] = charging_mode
            __props__.__dict__["cross_vpc_backend"] = cross_vpc_backend
            __props__.__dict__["description"] = description
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["iptype"] = iptype
            __props__.__dict__["ipv4_address"] = ipv4_address
            __props__.__dict__["ipv4_eip_id"] = ipv4_eip_id
            __props__.__dict__["ipv4_subnet_id"] = ipv4_subnet_id
            __props__.__dict__["ipv6_bandwidth_id"] = ipv6_bandwidth_id
            __props__.__dict__["ipv6_network_id"] = ipv6_network_id
            __props__.__dict__["l4_flavor_id"] = l4_flavor_id
            __props__.__dict__["l7_flavor_id"] = l7_flavor_id
            __props__.__dict__["name"] = name
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["region"] = region
            __props__.__dict__["sharetype"] = sharetype
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["ipv4_eip"] = None
            __props__.__dict__["ipv6_address"] = None
            __props__.__dict__["ipv6_eip"] = None
            __props__.__dict__["ipv6_eip_id"] = None
        super(Loadbalancer, __self__).__init__(
            'huaweicloud:DedicatedElb/loadbalancer:Loadbalancer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_pay: Optional[pulumi.Input[str]] = None,
            auto_renew: Optional[pulumi.Input[str]] = None,
            availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            bandwidth_charge_mode: Optional[pulumi.Input[str]] = None,
            bandwidth_size: Optional[pulumi.Input[int]] = None,
            charging_mode: Optional[pulumi.Input[str]] = None,
            cross_vpc_backend: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            iptype: Optional[pulumi.Input[str]] = None,
            ipv4_address: Optional[pulumi.Input[str]] = None,
            ipv4_eip: Optional[pulumi.Input[str]] = None,
            ipv4_eip_id: Optional[pulumi.Input[str]] = None,
            ipv4_subnet_id: Optional[pulumi.Input[str]] = None,
            ipv6_address: Optional[pulumi.Input[str]] = None,
            ipv6_bandwidth_id: Optional[pulumi.Input[str]] = None,
            ipv6_eip: Optional[pulumi.Input[str]] = None,
            ipv6_eip_id: Optional[pulumi.Input[str]] = None,
            ipv6_network_id: Optional[pulumi.Input[str]] = None,
            l4_flavor_id: Optional[pulumi.Input[str]] = None,
            l7_flavor_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            period_unit: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            sharetype: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'Loadbalancer':
        """
        Get an existing Loadbalancer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled. Valid values are **true** and
               **false**. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: Specifies the list of AZ names. Changing this parameter will create a
               new resource.
        :param pulumi.Input[str] bandwidth_charge_mode: Bandwidth billing type. Changing this parameter will create a
               new resource.
        :param pulumi.Input[int] bandwidth_size: Bandwidth size. Changing this parameter will create a new resource.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the ELB loadbalancer.
               Valid values are **prePaid** and **postPaid**, defaults to **postPaid**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[bool] cross_vpc_backend: Enable this if you want to associate the IP addresses of backend servers with
               your load balancer. Can only be true when updating.
        :param pulumi.Input[str] description: Human-readable description for the loadbalancer.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the loadbalancer. Changing this
               creates a new loadbalancer.
        :param pulumi.Input[str] iptype: Elastic IP type. Changing this parameter will create a new resource.
        :param pulumi.Input[str] ipv4_address: The ipv4 address of the load balancer.
        :param pulumi.Input[str] ipv4_eip: The ipv4 eip address of the Load Balancer.
        :param pulumi.Input[str] ipv4_eip_id: The ID of the EIP. Changing this parameter will create a new resource.
        :param pulumi.Input[str] ipv4_subnet_id: The subnet on which to allocate the loadbalancer's ipv4 address.
        :param pulumi.Input[str] ipv6_address: The ipv6 address of the Load Balancer.
        :param pulumi.Input[str] ipv6_bandwidth_id: The ipv6 bandwidth id. Only support shared bandwidth.
        :param pulumi.Input[str] ipv6_eip: The ipv6 eip address of the Load Balancer.
        :param pulumi.Input[str] ipv6_eip_id: The ipv6 eip id of the Load Balancer.
        :param pulumi.Input[str] ipv6_network_id: The network on which to allocate the loadbalancer's ipv6 address.
        :param pulumi.Input[str] l4_flavor_id: The L4 flavor id of the load balancer.
        :param pulumi.Input[str] l7_flavor_id: The L7 flavor id of the load balancer.
        :param pulumi.Input[str] name: Human-readable name for the loadbalancer.
        :param pulumi.Input[int] period: Specifies the charging period of the ELB loadbalancer.
               If `period_unit` is set to **month**, the value ranges from 1 to 9.
               If `period_unit` is set to **year**, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the ELB loadbalancer.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the loadbalancer resource. If omitted, the
               provider-level region will be used. Changing this creates a new loadbalancer.
        :param pulumi.Input[str] sharetype: Bandwidth sharing type. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the loadbalancer.
        :param pulumi.Input[str] vpc_id: The vpc on which to create the loadbalancer. Changing this creates a new
               loadbalancer.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadbalancerState.__new__(_LoadbalancerState)

        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["availability_zones"] = availability_zones
        __props__.__dict__["bandwidth_charge_mode"] = bandwidth_charge_mode
        __props__.__dict__["bandwidth_size"] = bandwidth_size
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["cross_vpc_backend"] = cross_vpc_backend
        __props__.__dict__["description"] = description
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["iptype"] = iptype
        __props__.__dict__["ipv4_address"] = ipv4_address
        __props__.__dict__["ipv4_eip"] = ipv4_eip
        __props__.__dict__["ipv4_eip_id"] = ipv4_eip_id
        __props__.__dict__["ipv4_subnet_id"] = ipv4_subnet_id
        __props__.__dict__["ipv6_address"] = ipv6_address
        __props__.__dict__["ipv6_bandwidth_id"] = ipv6_bandwidth_id
        __props__.__dict__["ipv6_eip"] = ipv6_eip
        __props__.__dict__["ipv6_eip_id"] = ipv6_eip_id
        __props__.__dict__["ipv6_network_id"] = ipv6_network_id
        __props__.__dict__["l4_flavor_id"] = l4_flavor_id
        __props__.__dict__["l7_flavor_id"] = l7_flavor_id
        __props__.__dict__["name"] = name
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["region"] = region
        __props__.__dict__["sharetype"] = sharetype
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_id"] = vpc_id
        return Loadbalancer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "auto_pay")

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies whether auto renew is enabled. Valid values are **true** and
        **false**. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Sequence[str]]:
        """
        Specifies the list of AZ names. Changing this parameter will create a
        new resource.
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="bandwidthChargeMode")
    def bandwidth_charge_mode(self) -> pulumi.Output[str]:
        """
        Bandwidth billing type. Changing this parameter will create a
        new resource.
        """
        return pulumi.get(self, "bandwidth_charge_mode")

    @property
    @pulumi.getter(name="bandwidthSize")
    def bandwidth_size(self) -> pulumi.Output[int]:
        """
        Bandwidth size. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "bandwidth_size")

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[str]:
        """
        Specifies the charging mode of the ELB loadbalancer.
        Valid values are **prePaid** and **postPaid**, defaults to **postPaid**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @property
    @pulumi.getter(name="crossVpcBackend")
    def cross_vpc_backend(self) -> pulumi.Output[bool]:
        """
        Enable this if you want to associate the IP addresses of backend servers with
        your load balancer. Can only be true when updating.
        """
        return pulumi.get(self, "cross_vpc_backend")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Human-readable description for the loadbalancer.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        The enterprise project id of the loadbalancer. Changing this
        creates a new loadbalancer.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def iptype(self) -> pulumi.Output[str]:
        """
        Elastic IP type. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "iptype")

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> pulumi.Output[str]:
        """
        The ipv4 address of the load balancer.
        """
        return pulumi.get(self, "ipv4_address")

    @property
    @pulumi.getter(name="ipv4Eip")
    def ipv4_eip(self) -> pulumi.Output[str]:
        """
        The ipv4 eip address of the Load Balancer.
        """
        return pulumi.get(self, "ipv4_eip")

    @property
    @pulumi.getter(name="ipv4EipId")
    def ipv4_eip_id(self) -> pulumi.Output[str]:
        """
        The ID of the EIP. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ipv4_eip_id")

    @property
    @pulumi.getter(name="ipv4SubnetId")
    def ipv4_subnet_id(self) -> pulumi.Output[Optional[str]]:
        """
        The subnet on which to allocate the loadbalancer's ipv4 address.
        """
        return pulumi.get(self, "ipv4_subnet_id")

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> pulumi.Output[str]:
        """
        The ipv6 address of the Load Balancer.
        """
        return pulumi.get(self, "ipv6_address")

    @property
    @pulumi.getter(name="ipv6BandwidthId")
    def ipv6_bandwidth_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ipv6 bandwidth id. Only support shared bandwidth.
        """
        return pulumi.get(self, "ipv6_bandwidth_id")

    @property
    @pulumi.getter(name="ipv6Eip")
    def ipv6_eip(self) -> pulumi.Output[str]:
        """
        The ipv6 eip address of the Load Balancer.
        """
        return pulumi.get(self, "ipv6_eip")

    @property
    @pulumi.getter(name="ipv6EipId")
    def ipv6_eip_id(self) -> pulumi.Output[str]:
        """
        The ipv6 eip id of the Load Balancer.
        """
        return pulumi.get(self, "ipv6_eip_id")

    @property
    @pulumi.getter(name="ipv6NetworkId")
    def ipv6_network_id(self) -> pulumi.Output[Optional[str]]:
        """
        The network on which to allocate the loadbalancer's ipv6 address.
        """
        return pulumi.get(self, "ipv6_network_id")

    @property
    @pulumi.getter(name="l4FlavorId")
    def l4_flavor_id(self) -> pulumi.Output[str]:
        """
        The L4 flavor id of the load balancer.
        """
        return pulumi.get(self, "l4_flavor_id")

    @property
    @pulumi.getter(name="l7FlavorId")
    def l7_flavor_id(self) -> pulumi.Output[str]:
        """
        The L7 flavor id of the load balancer.
        """
        return pulumi.get(self, "l7_flavor_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Human-readable name for the loadbalancer.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the charging period of the ELB loadbalancer.
        If `period_unit` is set to **month**, the value ranges from 1 to 9.
        If `period_unit` is set to **year**, the value ranges from 1 to 3.
        This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the charging period unit of the ELB loadbalancer.
        Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period_unit")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the loadbalancer resource. If omitted, the
        provider-level region will be used. Changing this creates a new loadbalancer.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def sharetype(self) -> pulumi.Output[str]:
        """
        Bandwidth sharing type. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "sharetype")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The key/value pairs to associate with the loadbalancer.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The vpc on which to create the loadbalancer. Changing this creates a new
        loadbalancer.
        """
        return pulumi.get(self, "vpc_id")

