# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ListenerArgs', 'Listener']

@pulumi.input_type
class ListenerArgs:
    def __init__(__self__, *,
                 loadbalancer_id: pulumi.Input[str],
                 protocol: pulumi.Input[str],
                 protocol_port: pulumi.Input[int],
                 access_policy: Optional[pulumi.Input[str]] = None,
                 ca_certificate: Optional[pulumi.Input[str]] = None,
                 default_pool_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 forward_eip: Optional[pulumi.Input[bool]] = None,
                 http2_enable: Optional[pulumi.Input[bool]] = None,
                 idle_timeout: Optional[pulumi.Input[int]] = None,
                 ip_group: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 request_timeout: Optional[pulumi.Input[int]] = None,
                 response_timeout: Optional[pulumi.Input[int]] = None,
                 server_certificate: Optional[pulumi.Input[str]] = None,
                 sni_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tls_ciphers_policy: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Listener resource.
        :param pulumi.Input[str] loadbalancer_id: The load balancer on which to provision this listener. Changing this
               creates a new listener.
        :param pulumi.Input[str] protocol: The protocol can either be TCP, UDP, HTTP or HTTPS. Changing this creates a
               new listener.
        :param pulumi.Input[int] protocol_port: The port on which to listen for client traffic. Changing this creates a
               new listener.
        :param pulumi.Input[str] access_policy: Specifies the access policy for the listener. Valid options are *white* and
               *black*.
        :param pulumi.Input[str] ca_certificate: Specifies the ID of the CA certificate used by the listener. This parameter is
               valid when protocol is set to *HTTPS*.
        :param pulumi.Input[str] default_pool_id: The ID of the default pool with which the listener is associated. Changing this
               creates a new listener.
        :param pulumi.Input[str] description: Human-readable description for the listener.
        :param pulumi.Input[bool] forward_eip: Specifies whether transfer the load balancer EIP in the X-Forward-EIP header to
               backend servers. The default value is false. This parameter is valid only when the protocol is set to *HTTP* or
               *HTTPS*.
        :param pulumi.Input[bool] http2_enable: Specifies whether to use HTTP/2. The default value is false. This parameter is valid
               only when the protocol is set to *HTTPS*.
        :param pulumi.Input[int] idle_timeout: Specifies the idle timeout for the listener. Value range: 0 to 4000.
        :param pulumi.Input[str] ip_group: Specifies the ip group id for the listener.
        :param pulumi.Input[str] name: Human-readable name for the listener.
        :param pulumi.Input[str] region: The region in which to create the listener resource. If omitted, the
               provider-level region will be used. Changing this creates a new listener.
        :param pulumi.Input[int] request_timeout: Specifies the request timeout for the listener. Value range: 1 to 300. This
               parameter is valid when protocol is set to *HTTP* or *HTTPS*.
        :param pulumi.Input[int] response_timeout: Specifies the response timeout for the listener. Value range: 1 to 300. This
               parameter is valid when protocol is set to *HTTP* or *HTTPS*.
        :param pulumi.Input[str] server_certificate: Specifies the ID of the server certificate used by the listener. This
               parameter is mandatory when protocol is set to *HTTPS*.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sni_certificates: Lists the IDs of SNI certificates (server certificates with a domain name) used
               by the listener. This parameter is valid when protocol is set to *HTTPS*.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the listener.
        :param pulumi.Input[str] tls_ciphers_policy: Specifies the TLS cipher policy for the listener. Valid options are:
               tls-1-0-inherit, tls-1-0, tls-1-1, tls-1-2, tls-1-2-strict, tls-1-2-fs, tls-1-0-with-1-3, and tls-1-2-fs-with-1-3.
               This parameter is valid when protocol is set to *HTTPS*.
        """
        pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "protocol_port", protocol_port)
        if access_policy is not None:
            pulumi.set(__self__, "access_policy", access_policy)
        if ca_certificate is not None:
            pulumi.set(__self__, "ca_certificate", ca_certificate)
        if default_pool_id is not None:
            pulumi.set(__self__, "default_pool_id", default_pool_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if forward_eip is not None:
            pulumi.set(__self__, "forward_eip", forward_eip)
        if http2_enable is not None:
            pulumi.set(__self__, "http2_enable", http2_enable)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if ip_group is not None:
            pulumi.set(__self__, "ip_group", ip_group)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if request_timeout is not None:
            pulumi.set(__self__, "request_timeout", request_timeout)
        if response_timeout is not None:
            pulumi.set(__self__, "response_timeout", response_timeout)
        if server_certificate is not None:
            pulumi.set(__self__, "server_certificate", server_certificate)
        if sni_certificates is not None:
            pulumi.set(__self__, "sni_certificates", sni_certificates)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tls_ciphers_policy is not None:
            pulumi.set(__self__, "tls_ciphers_policy", tls_ciphers_policy)

    @property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> pulumi.Input[str]:
        """
        The load balancer on which to provision this listener. Changing this
        creates a new listener.
        """
        return pulumi.get(self, "loadbalancer_id")

    @loadbalancer_id.setter
    def loadbalancer_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "loadbalancer_id", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        The protocol can either be TCP, UDP, HTTP or HTTPS. Changing this creates a
        new listener.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="protocolPort")
    def protocol_port(self) -> pulumi.Input[int]:
        """
        The port on which to listen for client traffic. Changing this creates a
        new listener.
        """
        return pulumi.get(self, "protocol_port")

    @protocol_port.setter
    def protocol_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "protocol_port", value)

    @property
    @pulumi.getter(name="accessPolicy")
    def access_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the access policy for the listener. Valid options are *white* and
        *black*.
        """
        return pulumi.get(self, "access_policy")

    @access_policy.setter
    def access_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_policy", value)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the CA certificate used by the listener. This parameter is
        valid when protocol is set to *HTTPS*.
        """
        return pulumi.get(self, "ca_certificate")

    @ca_certificate.setter
    def ca_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_certificate", value)

    @property
    @pulumi.getter(name="defaultPoolId")
    def default_pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the default pool with which the listener is associated. Changing this
        creates a new listener.
        """
        return pulumi.get(self, "default_pool_id")

    @default_pool_id.setter
    def default_pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_pool_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable description for the listener.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="forwardEip")
    def forward_eip(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether transfer the load balancer EIP in the X-Forward-EIP header to
        backend servers. The default value is false. This parameter is valid only when the protocol is set to *HTTP* or
        *HTTPS*.
        """
        return pulumi.get(self, "forward_eip")

    @forward_eip.setter
    def forward_eip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "forward_eip", value)

    @property
    @pulumi.getter(name="http2Enable")
    def http2_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to use HTTP/2. The default value is false. This parameter is valid
        only when the protocol is set to *HTTPS*.
        """
        return pulumi.get(self, "http2_enable")

    @http2_enable.setter
    def http2_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "http2_enable", value)

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the idle timeout for the listener. Value range: 0 to 4000.
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_timeout", value)

    @property
    @pulumi.getter(name="ipGroup")
    def ip_group(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ip group id for the listener.
        """
        return pulumi.get(self, "ip_group")

    @ip_group.setter
    def ip_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_group", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable name for the listener.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the listener resource. If omitted, the
        provider-level region will be used. Changing this creates a new listener.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the request timeout for the listener. Value range: 1 to 300. This
        parameter is valid when protocol is set to *HTTP* or *HTTPS*.
        """
        return pulumi.get(self, "request_timeout")

    @request_timeout.setter
    def request_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "request_timeout", value)

    @property
    @pulumi.getter(name="responseTimeout")
    def response_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the response timeout for the listener. Value range: 1 to 300. This
        parameter is valid when protocol is set to *HTTP* or *HTTPS*.
        """
        return pulumi.get(self, "response_timeout")

    @response_timeout.setter
    def response_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "response_timeout", value)

    @property
    @pulumi.getter(name="serverCertificate")
    def server_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the server certificate used by the listener. This
        parameter is mandatory when protocol is set to *HTTPS*.
        """
        return pulumi.get(self, "server_certificate")

    @server_certificate.setter
    def server_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_certificate", value)

    @property
    @pulumi.getter(name="sniCertificates")
    def sni_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Lists the IDs of SNI certificates (server certificates with a domain name) used
        by the listener. This parameter is valid when protocol is set to *HTTPS*.
        """
        return pulumi.get(self, "sni_certificates")

    @sni_certificates.setter
    def sni_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sni_certificates", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value pairs to associate with the listener.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tlsCiphersPolicy")
    def tls_ciphers_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the TLS cipher policy for the listener. Valid options are:
        tls-1-0-inherit, tls-1-0, tls-1-1, tls-1-2, tls-1-2-strict, tls-1-2-fs, tls-1-0-with-1-3, and tls-1-2-fs-with-1-3.
        This parameter is valid when protocol is set to *HTTPS*.
        """
        return pulumi.get(self, "tls_ciphers_policy")

    @tls_ciphers_policy.setter
    def tls_ciphers_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_ciphers_policy", value)


@pulumi.input_type
class _ListenerState:
    def __init__(__self__, *,
                 access_policy: Optional[pulumi.Input[str]] = None,
                 ca_certificate: Optional[pulumi.Input[str]] = None,
                 default_pool_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 forward_eip: Optional[pulumi.Input[bool]] = None,
                 http2_enable: Optional[pulumi.Input[bool]] = None,
                 idle_timeout: Optional[pulumi.Input[int]] = None,
                 ip_group: Optional[pulumi.Input[str]] = None,
                 loadbalancer_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 protocol_port: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 request_timeout: Optional[pulumi.Input[int]] = None,
                 response_timeout: Optional[pulumi.Input[int]] = None,
                 server_certificate: Optional[pulumi.Input[str]] = None,
                 sni_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tls_ciphers_policy: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Listener resources.
        :param pulumi.Input[str] access_policy: Specifies the access policy for the listener. Valid options are *white* and
               *black*.
        :param pulumi.Input[str] ca_certificate: Specifies the ID of the CA certificate used by the listener. This parameter is
               valid when protocol is set to *HTTPS*.
        :param pulumi.Input[str] default_pool_id: The ID of the default pool with which the listener is associated. Changing this
               creates a new listener.
        :param pulumi.Input[str] description: Human-readable description for the listener.
        :param pulumi.Input[bool] forward_eip: Specifies whether transfer the load balancer EIP in the X-Forward-EIP header to
               backend servers. The default value is false. This parameter is valid only when the protocol is set to *HTTP* or
               *HTTPS*.
        :param pulumi.Input[bool] http2_enable: Specifies whether to use HTTP/2. The default value is false. This parameter is valid
               only when the protocol is set to *HTTPS*.
        :param pulumi.Input[int] idle_timeout: Specifies the idle timeout for the listener. Value range: 0 to 4000.
        :param pulumi.Input[str] ip_group: Specifies the ip group id for the listener.
        :param pulumi.Input[str] loadbalancer_id: The load balancer on which to provision this listener. Changing this
               creates a new listener.
        :param pulumi.Input[str] name: Human-readable name for the listener.
        :param pulumi.Input[str] protocol: The protocol can either be TCP, UDP, HTTP or HTTPS. Changing this creates a
               new listener.
        :param pulumi.Input[int] protocol_port: The port on which to listen for client traffic. Changing this creates a
               new listener.
        :param pulumi.Input[str] region: The region in which to create the listener resource. If omitted, the
               provider-level region will be used. Changing this creates a new listener.
        :param pulumi.Input[int] request_timeout: Specifies the request timeout for the listener. Value range: 1 to 300. This
               parameter is valid when protocol is set to *HTTP* or *HTTPS*.
        :param pulumi.Input[int] response_timeout: Specifies the response timeout for the listener. Value range: 1 to 300. This
               parameter is valid when protocol is set to *HTTP* or *HTTPS*.
        :param pulumi.Input[str] server_certificate: Specifies the ID of the server certificate used by the listener. This
               parameter is mandatory when protocol is set to *HTTPS*.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sni_certificates: Lists the IDs of SNI certificates (server certificates with a domain name) used
               by the listener. This parameter is valid when protocol is set to *HTTPS*.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the listener.
        :param pulumi.Input[str] tls_ciphers_policy: Specifies the TLS cipher policy for the listener. Valid options are:
               tls-1-0-inherit, tls-1-0, tls-1-1, tls-1-2, tls-1-2-strict, tls-1-2-fs, tls-1-0-with-1-3, and tls-1-2-fs-with-1-3.
               This parameter is valid when protocol is set to *HTTPS*.
        """
        if access_policy is not None:
            pulumi.set(__self__, "access_policy", access_policy)
        if ca_certificate is not None:
            pulumi.set(__self__, "ca_certificate", ca_certificate)
        if default_pool_id is not None:
            pulumi.set(__self__, "default_pool_id", default_pool_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if forward_eip is not None:
            pulumi.set(__self__, "forward_eip", forward_eip)
        if http2_enable is not None:
            pulumi.set(__self__, "http2_enable", http2_enable)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if ip_group is not None:
            pulumi.set(__self__, "ip_group", ip_group)
        if loadbalancer_id is not None:
            pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if protocol_port is not None:
            pulumi.set(__self__, "protocol_port", protocol_port)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if request_timeout is not None:
            pulumi.set(__self__, "request_timeout", request_timeout)
        if response_timeout is not None:
            pulumi.set(__self__, "response_timeout", response_timeout)
        if server_certificate is not None:
            pulumi.set(__self__, "server_certificate", server_certificate)
        if sni_certificates is not None:
            pulumi.set(__self__, "sni_certificates", sni_certificates)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tls_ciphers_policy is not None:
            pulumi.set(__self__, "tls_ciphers_policy", tls_ciphers_policy)

    @property
    @pulumi.getter(name="accessPolicy")
    def access_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the access policy for the listener. Valid options are *white* and
        *black*.
        """
        return pulumi.get(self, "access_policy")

    @access_policy.setter
    def access_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_policy", value)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the CA certificate used by the listener. This parameter is
        valid when protocol is set to *HTTPS*.
        """
        return pulumi.get(self, "ca_certificate")

    @ca_certificate.setter
    def ca_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_certificate", value)

    @property
    @pulumi.getter(name="defaultPoolId")
    def default_pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the default pool with which the listener is associated. Changing this
        creates a new listener.
        """
        return pulumi.get(self, "default_pool_id")

    @default_pool_id.setter
    def default_pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_pool_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable description for the listener.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="forwardEip")
    def forward_eip(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether transfer the load balancer EIP in the X-Forward-EIP header to
        backend servers. The default value is false. This parameter is valid only when the protocol is set to *HTTP* or
        *HTTPS*.
        """
        return pulumi.get(self, "forward_eip")

    @forward_eip.setter
    def forward_eip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "forward_eip", value)

    @property
    @pulumi.getter(name="http2Enable")
    def http2_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to use HTTP/2. The default value is false. This parameter is valid
        only when the protocol is set to *HTTPS*.
        """
        return pulumi.get(self, "http2_enable")

    @http2_enable.setter
    def http2_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "http2_enable", value)

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the idle timeout for the listener. Value range: 0 to 4000.
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_timeout", value)

    @property
    @pulumi.getter(name="ipGroup")
    def ip_group(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ip group id for the listener.
        """
        return pulumi.get(self, "ip_group")

    @ip_group.setter
    def ip_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_group", value)

    @property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> Optional[pulumi.Input[str]]:
        """
        The load balancer on which to provision this listener. Changing this
        creates a new listener.
        """
        return pulumi.get(self, "loadbalancer_id")

    @loadbalancer_id.setter
    def loadbalancer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "loadbalancer_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable name for the listener.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol can either be TCP, UDP, HTTP or HTTPS. Changing this creates a
        new listener.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="protocolPort")
    def protocol_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port on which to listen for client traffic. Changing this creates a
        new listener.
        """
        return pulumi.get(self, "protocol_port")

    @protocol_port.setter
    def protocol_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "protocol_port", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the listener resource. If omitted, the
        provider-level region will be used. Changing this creates a new listener.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the request timeout for the listener. Value range: 1 to 300. This
        parameter is valid when protocol is set to *HTTP* or *HTTPS*.
        """
        return pulumi.get(self, "request_timeout")

    @request_timeout.setter
    def request_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "request_timeout", value)

    @property
    @pulumi.getter(name="responseTimeout")
    def response_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the response timeout for the listener. Value range: 1 to 300. This
        parameter is valid when protocol is set to *HTTP* or *HTTPS*.
        """
        return pulumi.get(self, "response_timeout")

    @response_timeout.setter
    def response_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "response_timeout", value)

    @property
    @pulumi.getter(name="serverCertificate")
    def server_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the server certificate used by the listener. This
        parameter is mandatory when protocol is set to *HTTPS*.
        """
        return pulumi.get(self, "server_certificate")

    @server_certificate.setter
    def server_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_certificate", value)

    @property
    @pulumi.getter(name="sniCertificates")
    def sni_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Lists the IDs of SNI certificates (server certificates with a domain name) used
        by the listener. This parameter is valid when protocol is set to *HTTPS*.
        """
        return pulumi.get(self, "sni_certificates")

    @sni_certificates.setter
    def sni_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sni_certificates", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value pairs to associate with the listener.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tlsCiphersPolicy")
    def tls_ciphers_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the TLS cipher policy for the listener. Valid options are:
        tls-1-0-inherit, tls-1-0, tls-1-1, tls-1-2, tls-1-2-strict, tls-1-2-fs, tls-1-0-with-1-3, and tls-1-2-fs-with-1-3.
        This parameter is valid when protocol is set to *HTTPS*.
        """
        return pulumi.get(self, "tls_ciphers_policy")

    @tls_ciphers_policy.setter
    def tls_ciphers_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_ciphers_policy", value)


class Listener(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_policy: Optional[pulumi.Input[str]] = None,
                 ca_certificate: Optional[pulumi.Input[str]] = None,
                 default_pool_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 forward_eip: Optional[pulumi.Input[bool]] = None,
                 http2_enable: Optional[pulumi.Input[bool]] = None,
                 idle_timeout: Optional[pulumi.Input[int]] = None,
                 ip_group: Optional[pulumi.Input[str]] = None,
                 loadbalancer_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 protocol_port: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 request_timeout: Optional[pulumi.Input[int]] = None,
                 response_timeout: Optional[pulumi.Input[int]] = None,
                 server_certificate: Optional[pulumi.Input[str]] = None,
                 sni_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tls_ciphers_policy: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages an ELB listener resource within HuaweiCloud.

        ## Import

        ELB listener can be imported using the listener ID, e.g.

        ```sh
         $ pulumi import huaweicloud:DedicatedElb/listener:Listener listener_1 5c20fdad-7288-11eb-b817-0255ac10158b
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_policy: Specifies the access policy for the listener. Valid options are *white* and
               *black*.
        :param pulumi.Input[str] ca_certificate: Specifies the ID of the CA certificate used by the listener. This parameter is
               valid when protocol is set to *HTTPS*.
        :param pulumi.Input[str] default_pool_id: The ID of the default pool with which the listener is associated. Changing this
               creates a new listener.
        :param pulumi.Input[str] description: Human-readable description for the listener.
        :param pulumi.Input[bool] forward_eip: Specifies whether transfer the load balancer EIP in the X-Forward-EIP header to
               backend servers. The default value is false. This parameter is valid only when the protocol is set to *HTTP* or
               *HTTPS*.
        :param pulumi.Input[bool] http2_enable: Specifies whether to use HTTP/2. The default value is false. This parameter is valid
               only when the protocol is set to *HTTPS*.
        :param pulumi.Input[int] idle_timeout: Specifies the idle timeout for the listener. Value range: 0 to 4000.
        :param pulumi.Input[str] ip_group: Specifies the ip group id for the listener.
        :param pulumi.Input[str] loadbalancer_id: The load balancer on which to provision this listener. Changing this
               creates a new listener.
        :param pulumi.Input[str] name: Human-readable name for the listener.
        :param pulumi.Input[str] protocol: The protocol can either be TCP, UDP, HTTP or HTTPS. Changing this creates a
               new listener.
        :param pulumi.Input[int] protocol_port: The port on which to listen for client traffic. Changing this creates a
               new listener.
        :param pulumi.Input[str] region: The region in which to create the listener resource. If omitted, the
               provider-level region will be used. Changing this creates a new listener.
        :param pulumi.Input[int] request_timeout: Specifies the request timeout for the listener. Value range: 1 to 300. This
               parameter is valid when protocol is set to *HTTP* or *HTTPS*.
        :param pulumi.Input[int] response_timeout: Specifies the response timeout for the listener. Value range: 1 to 300. This
               parameter is valid when protocol is set to *HTTP* or *HTTPS*.
        :param pulumi.Input[str] server_certificate: Specifies the ID of the server certificate used by the listener. This
               parameter is mandatory when protocol is set to *HTTPS*.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sni_certificates: Lists the IDs of SNI certificates (server certificates with a domain name) used
               by the listener. This parameter is valid when protocol is set to *HTTPS*.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the listener.
        :param pulumi.Input[str] tls_ciphers_policy: Specifies the TLS cipher policy for the listener. Valid options are:
               tls-1-0-inherit, tls-1-0, tls-1-1, tls-1-2, tls-1-2-strict, tls-1-2-fs, tls-1-0-with-1-3, and tls-1-2-fs-with-1-3.
               This parameter is valid when protocol is set to *HTTPS*.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ListenerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an ELB listener resource within HuaweiCloud.

        ## Import

        ELB listener can be imported using the listener ID, e.g.

        ```sh
         $ pulumi import huaweicloud:DedicatedElb/listener:Listener listener_1 5c20fdad-7288-11eb-b817-0255ac10158b
        ```

        :param str resource_name: The name of the resource.
        :param ListenerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ListenerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_policy: Optional[pulumi.Input[str]] = None,
                 ca_certificate: Optional[pulumi.Input[str]] = None,
                 default_pool_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 forward_eip: Optional[pulumi.Input[bool]] = None,
                 http2_enable: Optional[pulumi.Input[bool]] = None,
                 idle_timeout: Optional[pulumi.Input[int]] = None,
                 ip_group: Optional[pulumi.Input[str]] = None,
                 loadbalancer_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 protocol_port: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 request_timeout: Optional[pulumi.Input[int]] = None,
                 response_timeout: Optional[pulumi.Input[int]] = None,
                 server_certificate: Optional[pulumi.Input[str]] = None,
                 sni_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tls_ciphers_policy: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ListenerArgs.__new__(ListenerArgs)

            __props__.__dict__["access_policy"] = access_policy
            __props__.__dict__["ca_certificate"] = ca_certificate
            __props__.__dict__["default_pool_id"] = default_pool_id
            __props__.__dict__["description"] = description
            __props__.__dict__["forward_eip"] = forward_eip
            __props__.__dict__["http2_enable"] = http2_enable
            __props__.__dict__["idle_timeout"] = idle_timeout
            __props__.__dict__["ip_group"] = ip_group
            if loadbalancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'loadbalancer_id'")
            __props__.__dict__["loadbalancer_id"] = loadbalancer_id
            __props__.__dict__["name"] = name
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            if protocol_port is None and not opts.urn:
                raise TypeError("Missing required property 'protocol_port'")
            __props__.__dict__["protocol_port"] = protocol_port
            __props__.__dict__["region"] = region
            __props__.__dict__["request_timeout"] = request_timeout
            __props__.__dict__["response_timeout"] = response_timeout
            __props__.__dict__["server_certificate"] = server_certificate
            __props__.__dict__["sni_certificates"] = sni_certificates
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tls_ciphers_policy"] = tls_ciphers_policy
        super(Listener, __self__).__init__(
            'huaweicloud:DedicatedElb/listener:Listener',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_policy: Optional[pulumi.Input[str]] = None,
            ca_certificate: Optional[pulumi.Input[str]] = None,
            default_pool_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            forward_eip: Optional[pulumi.Input[bool]] = None,
            http2_enable: Optional[pulumi.Input[bool]] = None,
            idle_timeout: Optional[pulumi.Input[int]] = None,
            ip_group: Optional[pulumi.Input[str]] = None,
            loadbalancer_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            protocol_port: Optional[pulumi.Input[int]] = None,
            region: Optional[pulumi.Input[str]] = None,
            request_timeout: Optional[pulumi.Input[int]] = None,
            response_timeout: Optional[pulumi.Input[int]] = None,
            server_certificate: Optional[pulumi.Input[str]] = None,
            sni_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tls_ciphers_policy: Optional[pulumi.Input[str]] = None) -> 'Listener':
        """
        Get an existing Listener resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_policy: Specifies the access policy for the listener. Valid options are *white* and
               *black*.
        :param pulumi.Input[str] ca_certificate: Specifies the ID of the CA certificate used by the listener. This parameter is
               valid when protocol is set to *HTTPS*.
        :param pulumi.Input[str] default_pool_id: The ID of the default pool with which the listener is associated. Changing this
               creates a new listener.
        :param pulumi.Input[str] description: Human-readable description for the listener.
        :param pulumi.Input[bool] forward_eip: Specifies whether transfer the load balancer EIP in the X-Forward-EIP header to
               backend servers. The default value is false. This parameter is valid only when the protocol is set to *HTTP* or
               *HTTPS*.
        :param pulumi.Input[bool] http2_enable: Specifies whether to use HTTP/2. The default value is false. This parameter is valid
               only when the protocol is set to *HTTPS*.
        :param pulumi.Input[int] idle_timeout: Specifies the idle timeout for the listener. Value range: 0 to 4000.
        :param pulumi.Input[str] ip_group: Specifies the ip group id for the listener.
        :param pulumi.Input[str] loadbalancer_id: The load balancer on which to provision this listener. Changing this
               creates a new listener.
        :param pulumi.Input[str] name: Human-readable name for the listener.
        :param pulumi.Input[str] protocol: The protocol can either be TCP, UDP, HTTP or HTTPS. Changing this creates a
               new listener.
        :param pulumi.Input[int] protocol_port: The port on which to listen for client traffic. Changing this creates a
               new listener.
        :param pulumi.Input[str] region: The region in which to create the listener resource. If omitted, the
               provider-level region will be used. Changing this creates a new listener.
        :param pulumi.Input[int] request_timeout: Specifies the request timeout for the listener. Value range: 1 to 300. This
               parameter is valid when protocol is set to *HTTP* or *HTTPS*.
        :param pulumi.Input[int] response_timeout: Specifies the response timeout for the listener. Value range: 1 to 300. This
               parameter is valid when protocol is set to *HTTP* or *HTTPS*.
        :param pulumi.Input[str] server_certificate: Specifies the ID of the server certificate used by the listener. This
               parameter is mandatory when protocol is set to *HTTPS*.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sni_certificates: Lists the IDs of SNI certificates (server certificates with a domain name) used
               by the listener. This parameter is valid when protocol is set to *HTTPS*.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the listener.
        :param pulumi.Input[str] tls_ciphers_policy: Specifies the TLS cipher policy for the listener. Valid options are:
               tls-1-0-inherit, tls-1-0, tls-1-1, tls-1-2, tls-1-2-strict, tls-1-2-fs, tls-1-0-with-1-3, and tls-1-2-fs-with-1-3.
               This parameter is valid when protocol is set to *HTTPS*.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ListenerState.__new__(_ListenerState)

        __props__.__dict__["access_policy"] = access_policy
        __props__.__dict__["ca_certificate"] = ca_certificate
        __props__.__dict__["default_pool_id"] = default_pool_id
        __props__.__dict__["description"] = description
        __props__.__dict__["forward_eip"] = forward_eip
        __props__.__dict__["http2_enable"] = http2_enable
        __props__.__dict__["idle_timeout"] = idle_timeout
        __props__.__dict__["ip_group"] = ip_group
        __props__.__dict__["loadbalancer_id"] = loadbalancer_id
        __props__.__dict__["name"] = name
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["protocol_port"] = protocol_port
        __props__.__dict__["region"] = region
        __props__.__dict__["request_timeout"] = request_timeout
        __props__.__dict__["response_timeout"] = response_timeout
        __props__.__dict__["server_certificate"] = server_certificate
        __props__.__dict__["sni_certificates"] = sni_certificates
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tls_ciphers_policy"] = tls_ciphers_policy
        return Listener(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessPolicy")
    def access_policy(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the access policy for the listener. Valid options are *white* and
        *black*.
        """
        return pulumi.get(self, "access_policy")

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the ID of the CA certificate used by the listener. This parameter is
        valid when protocol is set to *HTTPS*.
        """
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter(name="defaultPoolId")
    def default_pool_id(self) -> pulumi.Output[str]:
        """
        The ID of the default pool with which the listener is associated. Changing this
        creates a new listener.
        """
        return pulumi.get(self, "default_pool_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Human-readable description for the listener.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="forwardEip")
    def forward_eip(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether transfer the load balancer EIP in the X-Forward-EIP header to
        backend servers. The default value is false. This parameter is valid only when the protocol is set to *HTTP* or
        *HTTPS*.
        """
        return pulumi.get(self, "forward_eip")

    @property
    @pulumi.getter(name="http2Enable")
    def http2_enable(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to use HTTP/2. The default value is false. This parameter is valid
        only when the protocol is set to *HTTPS*.
        """
        return pulumi.get(self, "http2_enable")

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> pulumi.Output[int]:
        """
        Specifies the idle timeout for the listener. Value range: 0 to 4000.
        """
        return pulumi.get(self, "idle_timeout")

    @property
    @pulumi.getter(name="ipGroup")
    def ip_group(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the ip group id for the listener.
        """
        return pulumi.get(self, "ip_group")

    @property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> pulumi.Output[str]:
        """
        The load balancer on which to provision this listener. Changing this
        creates a new listener.
        """
        return pulumi.get(self, "loadbalancer_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Human-readable name for the listener.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[str]:
        """
        The protocol can either be TCP, UDP, HTTP or HTTPS. Changing this creates a
        new listener.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="protocolPort")
    def protocol_port(self) -> pulumi.Output[int]:
        """
        The port on which to listen for client traffic. Changing this creates a
        new listener.
        """
        return pulumi.get(self, "protocol_port")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the listener resource. If omitted, the
        provider-level region will be used. Changing this creates a new listener.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> pulumi.Output[int]:
        """
        Specifies the request timeout for the listener. Value range: 1 to 300. This
        parameter is valid when protocol is set to *HTTP* or *HTTPS*.
        """
        return pulumi.get(self, "request_timeout")

    @property
    @pulumi.getter(name="responseTimeout")
    def response_timeout(self) -> pulumi.Output[int]:
        """
        Specifies the response timeout for the listener. Value range: 1 to 300. This
        parameter is valid when protocol is set to *HTTP* or *HTTPS*.
        """
        return pulumi.get(self, "response_timeout")

    @property
    @pulumi.getter(name="serverCertificate")
    def server_certificate(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the ID of the server certificate used by the listener. This
        parameter is mandatory when protocol is set to *HTTPS*.
        """
        return pulumi.get(self, "server_certificate")

    @property
    @pulumi.getter(name="sniCertificates")
    def sni_certificates(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Lists the IDs of SNI certificates (server certificates with a domain name) used
        by the listener. This parameter is valid when protocol is set to *HTTPS*.
        """
        return pulumi.get(self, "sni_certificates")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The key/value pairs to associate with the listener.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tlsCiphersPolicy")
    def tls_ciphers_policy(self) -> pulumi.Output[str]:
        """
        Specifies the TLS cipher policy for the listener. Valid options are:
        tls-1-0-inherit, tls-1-0, tls-1-1, tls-1-2, tls-1-2-strict, tls-1-2-fs, tls-1-0-with-1-3, and tls-1-2-fs-with-1-3.
        This parameter is valid when protocol is set to *HTTPS*.
        """
        return pulumi.get(self, "tls_ciphers_policy")

