# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['L7ruleArgs', 'L7rule']

@pulumi.input_type
class L7ruleArgs:
    def __init__(__self__, *,
                 compare_type: pulumi.Input[str],
                 l7policy_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 value: pulumi.Input[str],
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a L7rule resource.
        :param pulumi.Input[str] compare_type: The comparison type for the L7 rule - can either be STARTS_WITH, EQUAL_TO or REGEX
        :param pulumi.Input[str] l7policy_id: The ID of the L7 Policy. Changing this creates a new L7 Rule.
        :param pulumi.Input[str] type: The L7 Rule type - can either be HOST_NAME or PATH. Changing this creates a new
               L7 Rule.
        :param pulumi.Input[str] value: The value to use for the comparison.
        :param pulumi.Input[str] region: The region in which to create the L7 Rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new L7 Rule.
        """
        pulumi.set(__self__, "compare_type", compare_type)
        pulumi.set(__self__, "l7policy_id", l7policy_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="compareType")
    def compare_type(self) -> pulumi.Input[str]:
        """
        The comparison type for the L7 rule - can either be STARTS_WITH, EQUAL_TO or REGEX
        """
        return pulumi.get(self, "compare_type")

    @compare_type.setter
    def compare_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compare_type", value)

    @property
    @pulumi.getter(name="l7policyId")
    def l7policy_id(self) -> pulumi.Input[str]:
        """
        The ID of the L7 Policy. Changing this creates a new L7 Rule.
        """
        return pulumi.get(self, "l7policy_id")

    @l7policy_id.setter
    def l7policy_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "l7policy_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The L7 Rule type - can either be HOST_NAME or PATH. Changing this creates a new
        L7 Rule.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value to use for the comparison.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the L7 Rule resource. If omitted, the
        provider-level region will be used. Changing this creates a new L7 Rule.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _L7ruleState:
    def __init__(__self__, *,
                 compare_type: Optional[pulumi.Input[str]] = None,
                 l7policy_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering L7rule resources.
        :param pulumi.Input[str] compare_type: The comparison type for the L7 rule - can either be STARTS_WITH, EQUAL_TO or REGEX
        :param pulumi.Input[str] l7policy_id: The ID of the L7 Policy. Changing this creates a new L7 Rule.
        :param pulumi.Input[str] region: The region in which to create the L7 Rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new L7 Rule.
        :param pulumi.Input[str] type: The L7 Rule type - can either be HOST_NAME or PATH. Changing this creates a new
               L7 Rule.
        :param pulumi.Input[str] value: The value to use for the comparison.
        """
        if compare_type is not None:
            pulumi.set(__self__, "compare_type", compare_type)
        if l7policy_id is not None:
            pulumi.set(__self__, "l7policy_id", l7policy_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="compareType")
    def compare_type(self) -> Optional[pulumi.Input[str]]:
        """
        The comparison type for the L7 rule - can either be STARTS_WITH, EQUAL_TO or REGEX
        """
        return pulumi.get(self, "compare_type")

    @compare_type.setter
    def compare_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compare_type", value)

    @property
    @pulumi.getter(name="l7policyId")
    def l7policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the L7 Policy. Changing this creates a new L7 Rule.
        """
        return pulumi.get(self, "l7policy_id")

    @l7policy_id.setter
    def l7policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "l7policy_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the L7 Rule resource. If omitted, the
        provider-level region will be used. Changing this creates a new L7 Rule.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The L7 Rule type - can either be HOST_NAME or PATH. Changing this creates a new
        L7 Rule.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value to use for the comparison.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


class L7rule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compare_type: Optional[pulumi.Input[str]] = None,
                 l7policy_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages an ELB L7 Rule resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        l7policy_id = config.require_object("l7policyId")
        l7rule1 = huaweicloud.dedicated_elb.L7rule("l7rule1",
            l7policy_id=l7policy_id,
            type="PATH",
            compare_type="EQUAL_TO",
            value="/api")
        ```

        ## Import

        ELB L7 rule can be imported using the L7 policy ID and L7 rule ID separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:DedicatedElb/l7rule:L7rule rule_1 e0bd694a-abbe-450e-b329-0931fd1cc5eb/4086b0c9-b18c-4d1c-b6b8-4c56c3ad2a9e
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compare_type: The comparison type for the L7 rule - can either be STARTS_WITH, EQUAL_TO or REGEX
        :param pulumi.Input[str] l7policy_id: The ID of the L7 Policy. Changing this creates a new L7 Rule.
        :param pulumi.Input[str] region: The region in which to create the L7 Rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new L7 Rule.
        :param pulumi.Input[str] type: The L7 Rule type - can either be HOST_NAME or PATH. Changing this creates a new
               L7 Rule.
        :param pulumi.Input[str] value: The value to use for the comparison.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: L7ruleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an ELB L7 Rule resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        l7policy_id = config.require_object("l7policyId")
        l7rule1 = huaweicloud.dedicated_elb.L7rule("l7rule1",
            l7policy_id=l7policy_id,
            type="PATH",
            compare_type="EQUAL_TO",
            value="/api")
        ```

        ## Import

        ELB L7 rule can be imported using the L7 policy ID and L7 rule ID separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:DedicatedElb/l7rule:L7rule rule_1 e0bd694a-abbe-450e-b329-0931fd1cc5eb/4086b0c9-b18c-4d1c-b6b8-4c56c3ad2a9e
        ```

        :param str resource_name: The name of the resource.
        :param L7ruleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(L7ruleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compare_type: Optional[pulumi.Input[str]] = None,
                 l7policy_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = L7ruleArgs.__new__(L7ruleArgs)

            if compare_type is None and not opts.urn:
                raise TypeError("Missing required property 'compare_type'")
            __props__.__dict__["compare_type"] = compare_type
            if l7policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'l7policy_id'")
            __props__.__dict__["l7policy_id"] = l7policy_id
            __props__.__dict__["region"] = region
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = value
        super(L7rule, __self__).__init__(
            'huaweicloud:DedicatedElb/l7rule:L7rule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compare_type: Optional[pulumi.Input[str]] = None,
            l7policy_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            value: Optional[pulumi.Input[str]] = None) -> 'L7rule':
        """
        Get an existing L7rule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compare_type: The comparison type for the L7 rule - can either be STARTS_WITH, EQUAL_TO or REGEX
        :param pulumi.Input[str] l7policy_id: The ID of the L7 Policy. Changing this creates a new L7 Rule.
        :param pulumi.Input[str] region: The region in which to create the L7 Rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new L7 Rule.
        :param pulumi.Input[str] type: The L7 Rule type - can either be HOST_NAME or PATH. Changing this creates a new
               L7 Rule.
        :param pulumi.Input[str] value: The value to use for the comparison.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _L7ruleState.__new__(_L7ruleState)

        __props__.__dict__["compare_type"] = compare_type
        __props__.__dict__["l7policy_id"] = l7policy_id
        __props__.__dict__["region"] = region
        __props__.__dict__["type"] = type
        __props__.__dict__["value"] = value
        return L7rule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compareType")
    def compare_type(self) -> pulumi.Output[str]:
        """
        The comparison type for the L7 rule - can either be STARTS_WITH, EQUAL_TO or REGEX
        """
        return pulumi.get(self, "compare_type")

    @property
    @pulumi.getter(name="l7policyId")
    def l7policy_id(self) -> pulumi.Output[str]:
        """
        The ID of the L7 Policy. Changing this creates a new L7 Rule.
        """
        return pulumi.get(self, "l7policy_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the L7 Rule resource. If omitted, the
        provider-level region will be used. Changing this creates a new L7 Rule.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The L7 Rule type - can either be HOST_NAME or PATH. Changing this creates a new
        L7 Rule.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output[str]:
        """
        The value to use for the comparison.
        """
        return pulumi.get(self, "value")

