# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatabaseRoleArgs', 'DatabaseRole']

@pulumi.input_type
class DatabaseRoleArgs:
    def __init__(__self__, *,
                 db_name: pulumi.Input[str],
                 instance_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseRoleRoleArgs']]]] = None):
        """
        The set of arguments for constructing a DatabaseRole resource.
        :param pulumi.Input[str] db_name: Specifies the database name to which this owned role belongs.
               Changing this parameter will create a new role.
        :param pulumi.Input[str] instance_id: Specifies the DDS instance ID to which the role belongs.
               Changing this parameter will create a new role.
        :param pulumi.Input[str] name: Specifies the name of role owned by the current role.
               The name can contain `1` to `64` characters, only letters, digits, underscores (_), hyphens (-) and dots (.) are
               allowed. Changing this parameter will create a new role.
        :param pulumi.Input[str] region: Specifies the region where the DDS instance is located.
               Changing this parameter will create a new role.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseRoleRoleArgs']]] roles: Specifies the list of roles owned by the current role.
               The object structure is documented below.
               Changing this parameter will create a new role.
        """
        pulumi.set(__self__, "db_name", db_name)
        pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> pulumi.Input[str]:
        """
        Specifies the database name to which this owned role belongs.
        Changing this parameter will create a new role.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "db_name", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        Specifies the DDS instance ID to which the role belongs.
        Changing this parameter will create a new role.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of role owned by the current role.
        The name can contain `1` to `64` characters, only letters, digits, underscores (_), hyphens (-) and dots (.) are
        allowed. Changing this parameter will create a new role.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region where the DDS instance is located.
        Changing this parameter will create a new role.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseRoleRoleArgs']]]]:
        """
        Specifies the list of roles owned by the current role.
        The object structure is documented below.
        Changing this parameter will create a new role.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseRoleRoleArgs']]]]):
        pulumi.set(self, "roles", value)


@pulumi.input_type
class _DatabaseRoleState:
    def __init__(__self__, *,
                 db_name: Optional[pulumi.Input[str]] = None,
                 inherited_privileges: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseRoleInheritedPrivilegeArgs']]]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 privileges: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseRolePrivilegeArgs']]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseRoleRoleArgs']]]] = None):
        """
        Input properties used for looking up and filtering DatabaseRole resources.
        :param pulumi.Input[str] db_name: Specifies the database name to which this owned role belongs.
               Changing this parameter will create a new role.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseRoleInheritedPrivilegeArgs']]] inherited_privileges: The list of database privileges owned by the current role, includes all privileges
               inherited by owned roles. The object structure is documented below.
        :param pulumi.Input[str] instance_id: Specifies the DDS instance ID to which the role belongs.
               Changing this parameter will create a new role.
        :param pulumi.Input[str] name: Specifies the name of role owned by the current role.
               The name can contain `1` to `64` characters, only letters, digits, underscores (_), hyphens (-) and dots (.) are
               allowed. Changing this parameter will create a new role.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseRolePrivilegeArgs']]] privileges: The list of database privileges owned by the current role.
               The object structure is documented below.
        :param pulumi.Input[str] region: Specifies the region where the DDS instance is located.
               Changing this parameter will create a new role.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseRoleRoleArgs']]] roles: Specifies the list of roles owned by the current role.
               The object structure is documented below.
               Changing this parameter will create a new role.
        """
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if inherited_privileges is not None:
            pulumi.set(__self__, "inherited_privileges", inherited_privileges)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if privileges is not None:
            pulumi.set(__self__, "privileges", privileges)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the database name to which this owned role belongs.
        Changing this parameter will create a new role.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_name", value)

    @property
    @pulumi.getter(name="inheritedPrivileges")
    def inherited_privileges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseRoleInheritedPrivilegeArgs']]]]:
        """
        The list of database privileges owned by the current role, includes all privileges
        inherited by owned roles. The object structure is documented below.
        """
        return pulumi.get(self, "inherited_privileges")

    @inherited_privileges.setter
    def inherited_privileges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseRoleInheritedPrivilegeArgs']]]]):
        pulumi.set(self, "inherited_privileges", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the DDS instance ID to which the role belongs.
        Changing this parameter will create a new role.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of role owned by the current role.
        The name can contain `1` to `64` characters, only letters, digits, underscores (_), hyphens (-) and dots (.) are
        allowed. Changing this parameter will create a new role.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def privileges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseRolePrivilegeArgs']]]]:
        """
        The list of database privileges owned by the current role.
        The object structure is documented below.
        """
        return pulumi.get(self, "privileges")

    @privileges.setter
    def privileges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseRolePrivilegeArgs']]]]):
        pulumi.set(self, "privileges", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region where the DDS instance is located.
        Changing this parameter will create a new role.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseRoleRoleArgs']]]]:
        """
        Specifies the list of roles owned by the current role.
        The object structure is documented below.
        Changing this parameter will create a new role.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseRoleRoleArgs']]]]):
        pulumi.set(self, "roles", value)


class DatabaseRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_name: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseRoleRoleArgs']]]]] = None,
                 __props__=None):
        """
        Manages a database role resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        role_name = config.require_object("roleName")
        db_name = config.require_object("dbName")
        owned_role_name = config.require_object("ownedRoleName")
        owned_role_db_name = config.require_object("ownedRoleDbName")
        test = huaweicloud.dds.DatabaseRole("test",
            instance_id=instance_id,
            db_name=db_name,
            roles=[huaweicloud.dds.DatabaseRoleRoleArgs(
                name=owned_role_name,
                db_name=owned_role_db_name,
            )])
        ```

        ## Import

        Database roles can be imported using their `id` (combination of `instance_id`, `db_name` and `name`), separated by a slash (/), e.g.

        ```sh
         $ pulumi import huaweicloud:Dds/databaseRole:DatabaseRole test &ltinstance_id&gt/&ltdb_name&gt/&ltname&gt
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] db_name: Specifies the database name to which this owned role belongs.
               Changing this parameter will create a new role.
        :param pulumi.Input[str] instance_id: Specifies the DDS instance ID to which the role belongs.
               Changing this parameter will create a new role.
        :param pulumi.Input[str] name: Specifies the name of role owned by the current role.
               The name can contain `1` to `64` characters, only letters, digits, underscores (_), hyphens (-) and dots (.) are
               allowed. Changing this parameter will create a new role.
        :param pulumi.Input[str] region: Specifies the region where the DDS instance is located.
               Changing this parameter will create a new role.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseRoleRoleArgs']]]] roles: Specifies the list of roles owned by the current role.
               The object structure is documented below.
               Changing this parameter will create a new role.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseRoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a database role resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        role_name = config.require_object("roleName")
        db_name = config.require_object("dbName")
        owned_role_name = config.require_object("ownedRoleName")
        owned_role_db_name = config.require_object("ownedRoleDbName")
        test = huaweicloud.dds.DatabaseRole("test",
            instance_id=instance_id,
            db_name=db_name,
            roles=[huaweicloud.dds.DatabaseRoleRoleArgs(
                name=owned_role_name,
                db_name=owned_role_db_name,
            )])
        ```

        ## Import

        Database roles can be imported using their `id` (combination of `instance_id`, `db_name` and `name`), separated by a slash (/), e.g.

        ```sh
         $ pulumi import huaweicloud:Dds/databaseRole:DatabaseRole test &ltinstance_id&gt/&ltdb_name&gt/&ltname&gt
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_name: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseRoleRoleArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseRoleArgs.__new__(DatabaseRoleArgs)

            if db_name is None and not opts.urn:
                raise TypeError("Missing required property 'db_name'")
            __props__.__dict__["db_name"] = db_name
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["roles"] = roles
            __props__.__dict__["inherited_privileges"] = None
            __props__.__dict__["privileges"] = None
        super(DatabaseRole, __self__).__init__(
            'huaweicloud:Dds/databaseRole:DatabaseRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            db_name: Optional[pulumi.Input[str]] = None,
            inherited_privileges: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseRoleInheritedPrivilegeArgs']]]]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            privileges: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseRolePrivilegeArgs']]]]] = None,
            region: Optional[pulumi.Input[str]] = None,
            roles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseRoleRoleArgs']]]]] = None) -> 'DatabaseRole':
        """
        Get an existing DatabaseRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] db_name: Specifies the database name to which this owned role belongs.
               Changing this parameter will create a new role.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseRoleInheritedPrivilegeArgs']]]] inherited_privileges: The list of database privileges owned by the current role, includes all privileges
               inherited by owned roles. The object structure is documented below.
        :param pulumi.Input[str] instance_id: Specifies the DDS instance ID to which the role belongs.
               Changing this parameter will create a new role.
        :param pulumi.Input[str] name: Specifies the name of role owned by the current role.
               The name can contain `1` to `64` characters, only letters, digits, underscores (_), hyphens (-) and dots (.) are
               allowed. Changing this parameter will create a new role.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseRolePrivilegeArgs']]]] privileges: The list of database privileges owned by the current role.
               The object structure is documented below.
        :param pulumi.Input[str] region: Specifies the region where the DDS instance is located.
               Changing this parameter will create a new role.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseRoleRoleArgs']]]] roles: Specifies the list of roles owned by the current role.
               The object structure is documented below.
               Changing this parameter will create a new role.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseRoleState.__new__(_DatabaseRoleState)

        __props__.__dict__["db_name"] = db_name
        __props__.__dict__["inherited_privileges"] = inherited_privileges
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["privileges"] = privileges
        __props__.__dict__["region"] = region
        __props__.__dict__["roles"] = roles
        return DatabaseRole(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> pulumi.Output[str]:
        """
        Specifies the database name to which this owned role belongs.
        Changing this parameter will create a new role.
        """
        return pulumi.get(self, "db_name")

    @property
    @pulumi.getter(name="inheritedPrivileges")
    def inherited_privileges(self) -> pulumi.Output[Sequence['outputs.DatabaseRoleInheritedPrivilege']]:
        """
        The list of database privileges owned by the current role, includes all privileges
        inherited by owned roles. The object structure is documented below.
        """
        return pulumi.get(self, "inherited_privileges")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        Specifies the DDS instance ID to which the role belongs.
        Changing this parameter will create a new role.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of role owned by the current role.
        The name can contain `1` to `64` characters, only letters, digits, underscores (_), hyphens (-) and dots (.) are
        allowed. Changing this parameter will create a new role.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def privileges(self) -> pulumi.Output[Sequence['outputs.DatabaseRolePrivilege']]:
        """
        The list of database privileges owned by the current role.
        The object structure is documented below.
        """
        return pulumi.get(self, "privileges")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region where the DDS instance is located.
        Changing this parameter will create a new role.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Output[Sequence['outputs.DatabaseRoleRole']]:
        """
        Specifies the list of roles owned by the current role.
        The object structure is documented below.
        Changing this parameter will create a new role.
        """
        return pulumi.get(self, "roles")

