# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'InstanceBackupPolicyArgs',
    'InstanceWhitelistArgs',
]

@pulumi.input_type
class InstanceBackupPolicyArgs:
    def __init__(__self__, *,
                 backup_ats: pulumi.Input[Sequence[pulumi.Input[int]]],
                 begin_at: pulumi.Input[str],
                 backup_type: Optional[pulumi.Input[str]] = None,
                 period_type: Optional[pulumi.Input[str]] = None,
                 save_days: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[int]]] backup_ats: Day in a week on which backup starts, the value ranges from 1 to 7.
               Where: 1 indicates Monday; 7 indicates Sunday.
        :param pulumi.Input[str] begin_at: Time at which backup starts.
               Format: `hh24:00-hh24:00`, "00:00-01:00" indicates that backup starts at 00:00:00.
        :param pulumi.Input[str] backup_type: Backup type. Default value is `auto`. The valid values are as follows:
               + `auto`: automatic backup.
               + `manual`: manual backup.
        :param pulumi.Input[str] period_type: Interval at which backup is performed. Default value is `weekly`.
               Currently, only weekly backup is supported.
        :param pulumi.Input[int] save_days: Retention time. Unit: day, the value ranges from 1 to 7.
        """
        pulumi.set(__self__, "backup_ats", backup_ats)
        pulumi.set(__self__, "begin_at", begin_at)
        if backup_type is not None:
            pulumi.set(__self__, "backup_type", backup_type)
        if period_type is not None:
            pulumi.set(__self__, "period_type", period_type)
        if save_days is not None:
            pulumi.set(__self__, "save_days", save_days)

    @property
    @pulumi.getter(name="backupAts")
    def backup_ats(self) -> pulumi.Input[Sequence[pulumi.Input[int]]]:
        """
        Day in a week on which backup starts, the value ranges from 1 to 7.
        Where: 1 indicates Monday; 7 indicates Sunday.
        """
        return pulumi.get(self, "backup_ats")

    @backup_ats.setter
    def backup_ats(self, value: pulumi.Input[Sequence[pulumi.Input[int]]]):
        pulumi.set(self, "backup_ats", value)

    @property
    @pulumi.getter(name="beginAt")
    def begin_at(self) -> pulumi.Input[str]:
        """
        Time at which backup starts.
        Format: `hh24:00-hh24:00`, "00:00-01:00" indicates that backup starts at 00:00:00.
        """
        return pulumi.get(self, "begin_at")

    @begin_at.setter
    def begin_at(self, value: pulumi.Input[str]):
        pulumi.set(self, "begin_at", value)

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> Optional[pulumi.Input[str]]:
        """
        Backup type. Default value is `auto`. The valid values are as follows:
        + `auto`: automatic backup.
        + `manual`: manual backup.
        """
        return pulumi.get(self, "backup_type")

    @backup_type.setter
    def backup_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_type", value)

    @property
    @pulumi.getter(name="periodType")
    def period_type(self) -> Optional[pulumi.Input[str]]:
        """
        Interval at which backup is performed. Default value is `weekly`.
        Currently, only weekly backup is supported.
        """
        return pulumi.get(self, "period_type")

    @period_type.setter
    def period_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_type", value)

    @property
    @pulumi.getter(name="saveDays")
    def save_days(self) -> Optional[pulumi.Input[int]]:
        """
        Retention time. Unit: day, the value ranges from 1 to 7.
        """
        return pulumi.get(self, "save_days")

    @save_days.setter
    def save_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "save_days", value)


@pulumi.input_type
class InstanceWhitelistArgs:
    def __init__(__self__, *,
                 group_name: pulumi.Input[str],
                 ip_addresses: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[str] group_name: Specifies the name of IP address group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_addresses: Specifies the list of IP address or CIDR which can be whitelisted for an instance.
               The maximum is 20.
        """
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Input[str]:
        """
        Specifies the name of IP address group.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "group_name", value)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies the list of IP address or CIDR which can be whitelisted for an instance.
        The maximum is 20.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "ip_addresses", value)


