# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ClusterBackupStrategyArgs',
    'ClusterClientNodeConfigArgs',
    'ClusterClientNodeConfigVolumeArgs',
    'ClusterColdNodeConfigArgs',
    'ClusterColdNodeConfigVolumeArgs',
    'ClusterEssNodeConfigArgs',
    'ClusterEssNodeConfigVolumeArgs',
    'ClusterKibanaPublicAccessArgs',
    'ClusterMasterNodeConfigArgs',
    'ClusterMasterNodeConfigVolumeArgs',
    'ClusterNodeArgs',
    'ClusterNodeConfigArgs',
    'ClusterNodeConfigNetworkInfoArgs',
    'ClusterNodeConfigVolumeArgs',
    'ClusterPublicAccessArgs',
    'ClusterVpcepEndpointArgs',
]

@pulumi.input_type
class ClusterBackupStrategyArgs:
    def __init__(__self__, *,
                 start_time: pulumi.Input[str],
                 agency: Optional[pulumi.Input[str]] = None,
                 backup_path: Optional[pulumi.Input[str]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 keep_days: Optional[pulumi.Input[int]] = None,
                 prefix: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] start_time: Specifies the time when a snapshot is automatically created everyday. Snapshots can
               only be created on the hour. The time format is the time followed by the time zone, specifically, **HH:mm z**. In the
               format, HH:mm refers to the hour time and z refers to the time zone. For example, "00:00 GMT+08:00"
               and "01:00 GMT+08:00".
        :param pulumi.Input[str] agency: Specifies the IAM agency used to access OBS.
        :param pulumi.Input[str] backup_path: Specifies the storage path of the snapshot in the OBS bucket.
        :param pulumi.Input[str] bucket: Specifies the OBS bucket used for index data backup. If there is snapshot data in an OBS
               bucket, only the OBS bucket is used and cannot be changed.
        :param pulumi.Input[int] keep_days: Specifies the number of days to retain the generated snapshots. Snapshots are reserved
               for seven days by default.
        :param pulumi.Input[str] prefix: Specifies the prefix of the snapshot that is automatically created. The default value
               is "snapshot".
        """
        pulumi.set(__self__, "start_time", start_time)
        if agency is not None:
            pulumi.set(__self__, "agency", agency)
        if backup_path is not None:
            pulumi.set(__self__, "backup_path", backup_path)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if keep_days is not None:
            pulumi.set(__self__, "keep_days", keep_days)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Input[str]:
        """
        Specifies the time when a snapshot is automatically created everyday. Snapshots can
        only be created on the hour. The time format is the time followed by the time zone, specifically, **HH:mm z**. In the
        format, HH:mm refers to the hour time and z refers to the time zone. For example, "00:00 GMT+08:00"
        and "01:00 GMT+08:00".
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: pulumi.Input[str]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter
    def agency(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the IAM agency used to access OBS.
        """
        return pulumi.get(self, "agency")

    @agency.setter
    def agency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agency", value)

    @property
    @pulumi.getter(name="backupPath")
    def backup_path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the storage path of the snapshot in the OBS bucket.
        """
        return pulumi.get(self, "backup_path")

    @backup_path.setter
    def backup_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_path", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the OBS bucket used for index data backup. If there is snapshot data in an OBS
        bucket, only the OBS bucket is used and cannot be changed.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="keepDays")
    def keep_days(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of days to retain the generated snapshots. Snapshots are reserved
        for seven days by default.
        """
        return pulumi.get(self, "keep_days")

    @keep_days.setter
    def keep_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "keep_days", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the prefix of the snapshot that is automatically created. The default value
        is "snapshot".
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)


@pulumi.input_type
class ClusterClientNodeConfigArgs:
    def __init__(__self__, *,
                 flavor: pulumi.Input[str],
                 instance_number: pulumi.Input[int],
                 volume: pulumi.Input['ClusterClientNodeConfigVolumeArgs']):
        """
        :param pulumi.Input[str] flavor: Specifies the flavor name. For example: value range of flavor ess.spec-2u8g:
               40 GB to 800 GB, value range of flavor ess.spec-4u16g: 40 GB to 1600 GB, value range of flavor ess.spec-8u32g: 80 GB
               to 3200 GB, value range of flavor ess.spec-16u64g: 100 GB to 6400 GB, value range of flavor ess.spec-32u128g: 100 GB
               to 10240 GB. Changing this parameter will create a new resource.
        :param pulumi.Input[int] instance_number: Specifies the number of cluster instances.
               + When it is `ess_node_config`, The value range is 1 to 200.
               + When it is `master_node_config`, The value range is 3 to 10.
               + When it is `client_node_config`, The value range is 1 to 32.
               + When it is `cold_node_config`, The value range is 1 to 32.
        :param pulumi.Input['ClusterClientNodeConfigVolumeArgs'] volume: Specifies the information about the volume.
               The volume structure is documented below.
        """
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "instance_number", instance_number)
        pulumi.set(__self__, "volume", volume)

    @property
    @pulumi.getter
    def flavor(self) -> pulumi.Input[str]:
        """
        Specifies the flavor name. For example: value range of flavor ess.spec-2u8g:
        40 GB to 800 GB, value range of flavor ess.spec-4u16g: 40 GB to 1600 GB, value range of flavor ess.spec-8u32g: 80 GB
        to 3200 GB, value range of flavor ess.spec-16u64g: 100 GB to 6400 GB, value range of flavor ess.spec-32u128g: 100 GB
        to 10240 GB. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: pulumi.Input[str]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter(name="instanceNumber")
    def instance_number(self) -> pulumi.Input[int]:
        """
        Specifies the number of cluster instances.
        + When it is `ess_node_config`, The value range is 1 to 200.
        + When it is `master_node_config`, The value range is 3 to 10.
        + When it is `client_node_config`, The value range is 1 to 32.
        + When it is `cold_node_config`, The value range is 1 to 32.
        """
        return pulumi.get(self, "instance_number")

    @instance_number.setter
    def instance_number(self, value: pulumi.Input[int]):
        pulumi.set(self, "instance_number", value)

    @property
    @pulumi.getter
    def volume(self) -> pulumi.Input['ClusterClientNodeConfigVolumeArgs']:
        """
        Specifies the information about the volume.
        The volume structure is documented below.
        """
        return pulumi.get(self, "volume")

    @volume.setter
    def volume(self, value: pulumi.Input['ClusterClientNodeConfigVolumeArgs']):
        pulumi.set(self, "volume", value)


@pulumi.input_type
class ClusterClientNodeConfigVolumeArgs:
    def __init__(__self__, *,
                 size: pulumi.Input[int],
                 volume_type: pulumi.Input[str]):
        """
        :param pulumi.Input[int] size: Specifies the volume size in GB, which must be a multiple of 10.
        :param pulumi.Input[str] volume_type: Specifies the volume type. COMMON: Common I/O. The SATA disk is used.
               HIGH: High I/O. The SAS disk is used. ULTRAHIGH: Ultra-high I/O. The solid-state drive (SSD) is used. Changing this
               parameter will create a new resource.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        Specifies the volume size in GB, which must be a multiple of 10.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> pulumi.Input[str]:
        """
        Specifies the volume type. COMMON: Common I/O. The SATA disk is used.
        HIGH: High I/O. The SAS disk is used. ULTRAHIGH: Ultra-high I/O. The solid-state drive (SSD) is used. Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "volume_type", value)


@pulumi.input_type
class ClusterColdNodeConfigArgs:
    def __init__(__self__, *,
                 flavor: pulumi.Input[str],
                 instance_number: pulumi.Input[int],
                 volume: pulumi.Input['ClusterColdNodeConfigVolumeArgs']):
        """
        :param pulumi.Input[str] flavor: Specifies the flavor name. For example: value range of flavor ess.spec-2u8g:
               40 GB to 800 GB, value range of flavor ess.spec-4u16g: 40 GB to 1600 GB, value range of flavor ess.spec-8u32g: 80 GB
               to 3200 GB, value range of flavor ess.spec-16u64g: 100 GB to 6400 GB, value range of flavor ess.spec-32u128g: 100 GB
               to 10240 GB. Changing this parameter will create a new resource.
        :param pulumi.Input[int] instance_number: Specifies the number of cluster instances.
               + When it is `ess_node_config`, The value range is 1 to 200.
               + When it is `master_node_config`, The value range is 3 to 10.
               + When it is `client_node_config`, The value range is 1 to 32.
               + When it is `cold_node_config`, The value range is 1 to 32.
        :param pulumi.Input['ClusterColdNodeConfigVolumeArgs'] volume: Specifies the information about the volume.
               The volume structure is documented below.
        """
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "instance_number", instance_number)
        pulumi.set(__self__, "volume", volume)

    @property
    @pulumi.getter
    def flavor(self) -> pulumi.Input[str]:
        """
        Specifies the flavor name. For example: value range of flavor ess.spec-2u8g:
        40 GB to 800 GB, value range of flavor ess.spec-4u16g: 40 GB to 1600 GB, value range of flavor ess.spec-8u32g: 80 GB
        to 3200 GB, value range of flavor ess.spec-16u64g: 100 GB to 6400 GB, value range of flavor ess.spec-32u128g: 100 GB
        to 10240 GB. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: pulumi.Input[str]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter(name="instanceNumber")
    def instance_number(self) -> pulumi.Input[int]:
        """
        Specifies the number of cluster instances.
        + When it is `ess_node_config`, The value range is 1 to 200.
        + When it is `master_node_config`, The value range is 3 to 10.
        + When it is `client_node_config`, The value range is 1 to 32.
        + When it is `cold_node_config`, The value range is 1 to 32.
        """
        return pulumi.get(self, "instance_number")

    @instance_number.setter
    def instance_number(self, value: pulumi.Input[int]):
        pulumi.set(self, "instance_number", value)

    @property
    @pulumi.getter
    def volume(self) -> pulumi.Input['ClusterColdNodeConfigVolumeArgs']:
        """
        Specifies the information about the volume.
        The volume structure is documented below.
        """
        return pulumi.get(self, "volume")

    @volume.setter
    def volume(self, value: pulumi.Input['ClusterColdNodeConfigVolumeArgs']):
        pulumi.set(self, "volume", value)


@pulumi.input_type
class ClusterColdNodeConfigVolumeArgs:
    def __init__(__self__, *,
                 size: pulumi.Input[int],
                 volume_type: pulumi.Input[str]):
        """
        :param pulumi.Input[int] size: Specifies the volume size in GB, which must be a multiple of 10.
        :param pulumi.Input[str] volume_type: Specifies the volume type. COMMON: Common I/O. The SATA disk is used.
               HIGH: High I/O. The SAS disk is used. ULTRAHIGH: Ultra-high I/O. The solid-state drive (SSD) is used. Changing this
               parameter will create a new resource.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        Specifies the volume size in GB, which must be a multiple of 10.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> pulumi.Input[str]:
        """
        Specifies the volume type. COMMON: Common I/O. The SATA disk is used.
        HIGH: High I/O. The SAS disk is used. ULTRAHIGH: Ultra-high I/O. The solid-state drive (SSD) is used. Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "volume_type", value)


@pulumi.input_type
class ClusterEssNodeConfigArgs:
    def __init__(__self__, *,
                 flavor: pulumi.Input[str],
                 instance_number: pulumi.Input[int],
                 volume: pulumi.Input['ClusterEssNodeConfigVolumeArgs']):
        """
        :param pulumi.Input[str] flavor: Specifies the flavor name. For example: value range of flavor ess.spec-2u8g:
               40 GB to 800 GB, value range of flavor ess.spec-4u16g: 40 GB to 1600 GB, value range of flavor ess.spec-8u32g: 80 GB
               to 3200 GB, value range of flavor ess.spec-16u64g: 100 GB to 6400 GB, value range of flavor ess.spec-32u128g: 100 GB
               to 10240 GB. Changing this parameter will create a new resource.
        :param pulumi.Input[int] instance_number: Specifies the number of cluster instances.
               + When it is `ess_node_config`, The value range is 1 to 200.
               + When it is `master_node_config`, The value range is 3 to 10.
               + When it is `client_node_config`, The value range is 1 to 32.
               + When it is `cold_node_config`, The value range is 1 to 32.
        :param pulumi.Input['ClusterEssNodeConfigVolumeArgs'] volume: Specifies the information about the volume.
               The volume structure is documented below.
        """
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "instance_number", instance_number)
        pulumi.set(__self__, "volume", volume)

    @property
    @pulumi.getter
    def flavor(self) -> pulumi.Input[str]:
        """
        Specifies the flavor name. For example: value range of flavor ess.spec-2u8g:
        40 GB to 800 GB, value range of flavor ess.spec-4u16g: 40 GB to 1600 GB, value range of flavor ess.spec-8u32g: 80 GB
        to 3200 GB, value range of flavor ess.spec-16u64g: 100 GB to 6400 GB, value range of flavor ess.spec-32u128g: 100 GB
        to 10240 GB. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: pulumi.Input[str]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter(name="instanceNumber")
    def instance_number(self) -> pulumi.Input[int]:
        """
        Specifies the number of cluster instances.
        + When it is `ess_node_config`, The value range is 1 to 200.
        + When it is `master_node_config`, The value range is 3 to 10.
        + When it is `client_node_config`, The value range is 1 to 32.
        + When it is `cold_node_config`, The value range is 1 to 32.
        """
        return pulumi.get(self, "instance_number")

    @instance_number.setter
    def instance_number(self, value: pulumi.Input[int]):
        pulumi.set(self, "instance_number", value)

    @property
    @pulumi.getter
    def volume(self) -> pulumi.Input['ClusterEssNodeConfigVolumeArgs']:
        """
        Specifies the information about the volume.
        The volume structure is documented below.
        """
        return pulumi.get(self, "volume")

    @volume.setter
    def volume(self, value: pulumi.Input['ClusterEssNodeConfigVolumeArgs']):
        pulumi.set(self, "volume", value)


@pulumi.input_type
class ClusterEssNodeConfigVolumeArgs:
    def __init__(__self__, *,
                 size: pulumi.Input[int],
                 volume_type: pulumi.Input[str]):
        """
        :param pulumi.Input[int] size: Specifies the volume size in GB, which must be a multiple of 10.
        :param pulumi.Input[str] volume_type: Specifies the volume type. COMMON: Common I/O. The SATA disk is used.
               HIGH: High I/O. The SAS disk is used. ULTRAHIGH: Ultra-high I/O. The solid-state drive (SSD) is used. Changing this
               parameter will create a new resource.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        Specifies the volume size in GB, which must be a multiple of 10.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> pulumi.Input[str]:
        """
        Specifies the volume type. COMMON: Common I/O. The SATA disk is used.
        HIGH: High I/O. The SAS disk is used. ULTRAHIGH: Ultra-high I/O. The solid-state drive (SSD) is used. Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "volume_type", value)


@pulumi.input_type
class ClusterKibanaPublicAccessArgs:
    def __init__(__self__, *,
                 bandwidth: pulumi.Input[int],
                 whitelist_enabled: pulumi.Input[bool],
                 public_ip: Optional[pulumi.Input[str]] = None,
                 whitelist: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] bandwidth: Specifies the public network bandwidth.
        :param pulumi.Input[bool] whitelist_enabled: Specifies whether to enable the public network access control.
        :param pulumi.Input[str] whitelist: Specifies the whitelist of access control.
               Separate the whitelisted Account IDs with commas (,), and each of them must be unique.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "whitelist_enabled", whitelist_enabled)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if whitelist is not None:
            pulumi.set(__self__, "whitelist", whitelist)

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Input[int]:
        """
        Specifies the public network bandwidth.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: pulumi.Input[int]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="whitelistEnabled")
    def whitelist_enabled(self) -> pulumi.Input[bool]:
        """
        Specifies whether to enable the public network access control.
        """
        return pulumi.get(self, "whitelist_enabled")

    @whitelist_enabled.setter
    def whitelist_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "whitelist_enabled", value)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter
    def whitelist(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the whitelist of access control.
        Separate the whitelisted Account IDs with commas (,), and each of them must be unique.
        """
        return pulumi.get(self, "whitelist")

    @whitelist.setter
    def whitelist(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "whitelist", value)


@pulumi.input_type
class ClusterMasterNodeConfigArgs:
    def __init__(__self__, *,
                 flavor: pulumi.Input[str],
                 instance_number: pulumi.Input[int],
                 volume: pulumi.Input['ClusterMasterNodeConfigVolumeArgs']):
        """
        :param pulumi.Input[str] flavor: Specifies the flavor name. For example: value range of flavor ess.spec-2u8g:
               40 GB to 800 GB, value range of flavor ess.spec-4u16g: 40 GB to 1600 GB, value range of flavor ess.spec-8u32g: 80 GB
               to 3200 GB, value range of flavor ess.spec-16u64g: 100 GB to 6400 GB, value range of flavor ess.spec-32u128g: 100 GB
               to 10240 GB. Changing this parameter will create a new resource.
        :param pulumi.Input[int] instance_number: Specifies the number of cluster instances.
               + When it is `ess_node_config`, The value range is 1 to 200.
               + When it is `master_node_config`, The value range is 3 to 10.
               + When it is `client_node_config`, The value range is 1 to 32.
               + When it is `cold_node_config`, The value range is 1 to 32.
        :param pulumi.Input['ClusterMasterNodeConfigVolumeArgs'] volume: Specifies the information about the volume.
               The volume structure is documented below.
        """
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "instance_number", instance_number)
        pulumi.set(__self__, "volume", volume)

    @property
    @pulumi.getter
    def flavor(self) -> pulumi.Input[str]:
        """
        Specifies the flavor name. For example: value range of flavor ess.spec-2u8g:
        40 GB to 800 GB, value range of flavor ess.spec-4u16g: 40 GB to 1600 GB, value range of flavor ess.spec-8u32g: 80 GB
        to 3200 GB, value range of flavor ess.spec-16u64g: 100 GB to 6400 GB, value range of flavor ess.spec-32u128g: 100 GB
        to 10240 GB. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: pulumi.Input[str]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter(name="instanceNumber")
    def instance_number(self) -> pulumi.Input[int]:
        """
        Specifies the number of cluster instances.
        + When it is `ess_node_config`, The value range is 1 to 200.
        + When it is `master_node_config`, The value range is 3 to 10.
        + When it is `client_node_config`, The value range is 1 to 32.
        + When it is `cold_node_config`, The value range is 1 to 32.
        """
        return pulumi.get(self, "instance_number")

    @instance_number.setter
    def instance_number(self, value: pulumi.Input[int]):
        pulumi.set(self, "instance_number", value)

    @property
    @pulumi.getter
    def volume(self) -> pulumi.Input['ClusterMasterNodeConfigVolumeArgs']:
        """
        Specifies the information about the volume.
        The volume structure is documented below.
        """
        return pulumi.get(self, "volume")

    @volume.setter
    def volume(self, value: pulumi.Input['ClusterMasterNodeConfigVolumeArgs']):
        pulumi.set(self, "volume", value)


@pulumi.input_type
class ClusterMasterNodeConfigVolumeArgs:
    def __init__(__self__, *,
                 size: pulumi.Input[int],
                 volume_type: pulumi.Input[str]):
        """
        :param pulumi.Input[int] size: Specifies the volume size in GB, which must be a multiple of 10.
        :param pulumi.Input[str] volume_type: Specifies the volume type. COMMON: Common I/O. The SATA disk is used.
               HIGH: High I/O. The SAS disk is used. ULTRAHIGH: Ultra-high I/O. The solid-state drive (SSD) is used. Changing this
               parameter will create a new resource.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        Specifies the volume size in GB, which must be a multiple of 10.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> pulumi.Input[str]:
        """
        Specifies the volume type. COMMON: Common I/O. The SATA disk is used.
        HIGH: High I/O. The SAS disk is used. ULTRAHIGH: Ultra-high I/O. The solid-state drive (SSD) is used. Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "volume_type", value)


@pulumi.input_type
class ClusterNodeArgs:
    def __init__(__self__, *,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 spec_code: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] availability_zone: Specifies the availability zone name.
               Separate multiple AZs with commas (,), for example, az1,az2. AZs must be unique. The number of nodes must be greater
               than or equal to the number of AZs. If the number of nodes is a multiple of the number of AZs, the nodes are evenly
               distributed to each AZ. If the number of nodes is not a multiple of the number of AZs, the absolute difference
               between node quantity in any two AZs is 1 at most.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] id: Instance ID.
        :param pulumi.Input[str] name: Specifies the cluster name. It contains 4 to 32 characters.
               Only letters, digits, hyphens (-), and underscores (_) are allowed. The value must start with a letter.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] status: The cluster status
               + `100`: The operation, such as instance creation, is in progress.
               + `200`: The cluster is available.
               + `303`: The cluster is unavailable.
        :param pulumi.Input[str] type: Node type. The options are as follows:
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if spec_code is not None:
            pulumi.set(__self__, "spec_code", spec_code)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the availability zone name.
        Separate multiple AZs with commas (,), for example, az1,az2. AZs must be unique. The number of nodes must be greater
        than or equal to the number of AZs. If the number of nodes is a multiple of the number of AZs, the nodes are evenly
        distributed to each AZ. If the number of nodes is not a multiple of the number of AZs, the absolute difference
        between node quantity in any two AZs is 1 at most.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Instance ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the cluster name. It contains 4 to 32 characters.
        Only letters, digits, hyphens (-), and underscores (_) are allowed. The value must start with a letter.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="specCode")
    def spec_code(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "spec_code")

    @spec_code.setter
    def spec_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spec_code", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster status
        + `100`: The operation, such as instance creation, is in progress.
        + `200`: The cluster is available.
        + `303`: The cluster is unavailable.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Node type. The options are as follows:
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ClusterNodeConfigArgs:
    def __init__(__self__, *,
                 availability_zone: pulumi.Input[str],
                 flavor: pulumi.Input[str],
                 network_info: pulumi.Input['ClusterNodeConfigNetworkInfoArgs'],
                 volume: pulumi.Input['ClusterNodeConfigVolumeArgs']):
        """
        :param pulumi.Input[str] availability_zone: Specifies the availability zone name.
               Separate multiple AZs with commas (,), for example, az1,az2. AZs must be unique. The number of nodes must be greater
               than or equal to the number of AZs. If the number of nodes is a multiple of the number of AZs, the nodes are evenly
               distributed to each AZ. If the number of nodes is not a multiple of the number of AZs, the absolute difference
               between node quantity in any two AZs is 1 at most.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] flavor: Specifies the flavor name. For example: value range of flavor ess.spec-2u8g:
               40 GB to 800 GB, value range of flavor ess.spec-4u16g: 40 GB to 1600 GB, value range of flavor ess.spec-8u32g: 80 GB
               to 3200 GB, value range of flavor ess.spec-16u64g: 100 GB to 6400 GB, value range of flavor ess.spec-32u128g: 100 GB
               to 10240 GB. Changing this parameter will create a new resource.
        :param pulumi.Input['ClusterNodeConfigVolumeArgs'] volume: Specifies the information about the volume.
               The volume structure is documented below.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "network_info", network_info)
        pulumi.set(__self__, "volume", volume)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Input[str]:
        """
        Specifies the availability zone name.
        Separate multiple AZs with commas (,), for example, az1,az2. AZs must be unique. The number of nodes must be greater
        than or equal to the number of AZs. If the number of nodes is a multiple of the number of AZs, the nodes are evenly
        distributed to each AZ. If the number of nodes is not a multiple of the number of AZs, the absolute difference
        between node quantity in any two AZs is 1 at most.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: pulumi.Input[str]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter
    def flavor(self) -> pulumi.Input[str]:
        """
        Specifies the flavor name. For example: value range of flavor ess.spec-2u8g:
        40 GB to 800 GB, value range of flavor ess.spec-4u16g: 40 GB to 1600 GB, value range of flavor ess.spec-8u32g: 80 GB
        to 3200 GB, value range of flavor ess.spec-16u64g: 100 GB to 6400 GB, value range of flavor ess.spec-32u128g: 100 GB
        to 10240 GB. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: pulumi.Input[str]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter(name="networkInfo")
    def network_info(self) -> pulumi.Input['ClusterNodeConfigNetworkInfoArgs']:
        return pulumi.get(self, "network_info")

    @network_info.setter
    def network_info(self, value: pulumi.Input['ClusterNodeConfigNetworkInfoArgs']):
        pulumi.set(self, "network_info", value)

    @property
    @pulumi.getter
    def volume(self) -> pulumi.Input['ClusterNodeConfigVolumeArgs']:
        """
        Specifies the information about the volume.
        The volume structure is documented below.
        """
        return pulumi.get(self, "volume")

    @volume.setter
    def volume(self, value: pulumi.Input['ClusterNodeConfigVolumeArgs']):
        pulumi.set(self, "volume", value)


@pulumi.input_type
class ClusterNodeConfigNetworkInfoArgs:
    def __init__(__self__, *,
                 security_group_id: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 vpc_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] security_group_id: Specifies Security group ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] subnet_id: Specifies the Subnet ID. Changing this parameter will create a new resource.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[str]:
        """
        Specifies Security group ID.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        Specifies the Subnet ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        Specifies the VPC ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)


@pulumi.input_type
class ClusterNodeConfigVolumeArgs:
    def __init__(__self__, *,
                 size: pulumi.Input[int],
                 volume_type: pulumi.Input[str]):
        """
        :param pulumi.Input[int] size: Specifies the volume size in GB, which must be a multiple of 10.
        :param pulumi.Input[str] volume_type: Specifies the volume type. COMMON: Common I/O. The SATA disk is used.
               HIGH: High I/O. The SAS disk is used. ULTRAHIGH: Ultra-high I/O. The solid-state drive (SSD) is used. Changing this
               parameter will create a new resource.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        Specifies the volume size in GB, which must be a multiple of 10.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> pulumi.Input[str]:
        """
        Specifies the volume type. COMMON: Common I/O. The SATA disk is used.
        HIGH: High I/O. The SAS disk is used. ULTRAHIGH: Ultra-high I/O. The solid-state drive (SSD) is used. Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "volume_type", value)


@pulumi.input_type
class ClusterPublicAccessArgs:
    def __init__(__self__, *,
                 bandwidth: pulumi.Input[int],
                 whitelist_enabled: pulumi.Input[bool],
                 public_ip: Optional[pulumi.Input[str]] = None,
                 whitelist: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] bandwidth: Specifies the public network bandwidth.
        :param pulumi.Input[bool] whitelist_enabled: Specifies whether to enable the public network access control.
        :param pulumi.Input[str] whitelist: Specifies the whitelist of access control.
               Separate the whitelisted Account IDs with commas (,), and each of them must be unique.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "whitelist_enabled", whitelist_enabled)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if whitelist is not None:
            pulumi.set(__self__, "whitelist", whitelist)

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Input[int]:
        """
        Specifies the public network bandwidth.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: pulumi.Input[int]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="whitelistEnabled")
    def whitelist_enabled(self) -> pulumi.Input[bool]:
        """
        Specifies whether to enable the public network access control.
        """
        return pulumi.get(self, "whitelist_enabled")

    @whitelist_enabled.setter
    def whitelist_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "whitelist_enabled", value)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter
    def whitelist(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the whitelist of access control.
        Separate the whitelisted Account IDs with commas (,), and each of them must be unique.
        """
        return pulumi.get(self, "whitelist")

    @whitelist.setter
    def whitelist(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "whitelist", value)


@pulumi.input_type
class ClusterVpcepEndpointArgs:
    def __init__(__self__, *,
                 endpoint_with_dns_name: pulumi.Input[bool],
                 whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[bool] endpoint_with_dns_name: Specifies whether to enable the private domain name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] whitelists: Specifies the whitelist of access control.
               Separate the whitelisted Account IDs with commas (,), and each of them must be unique.
        """
        pulumi.set(__self__, "endpoint_with_dns_name", endpoint_with_dns_name)
        if whitelists is not None:
            pulumi.set(__self__, "whitelists", whitelists)

    @property
    @pulumi.getter(name="endpointWithDnsName")
    def endpoint_with_dns_name(self) -> pulumi.Input[bool]:
        """
        Specifies whether to enable the private domain name.
        """
        return pulumi.get(self, "endpoint_with_dns_name")

    @endpoint_with_dns_name.setter
    def endpoint_with_dns_name(self, value: pulumi.Input[bool]):
        pulumi.set(self, "endpoint_with_dns_name", value)

    @property
    @pulumi.getter
    def whitelists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the whitelist of access control.
        Separate the whitelisted Account IDs with commas (,), and each of them must be unique.
        """
        return pulumi.get(self, "whitelists")

    @whitelists.setter
    def whitelists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "whitelists", value)


