# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MicroserviceInstanceArgs', 'MicroserviceInstance']

@pulumi.input_type
class MicroserviceInstanceArgs:
    def __init__(__self__, *,
                 connect_address: pulumi.Input[str],
                 endpoints: pulumi.Input[Sequence[pulumi.Input[str]]],
                 host_name: pulumi.Input[str],
                 microservice_id: pulumi.Input[str],
                 admin_pass: Optional[pulumi.Input[str]] = None,
                 admin_user: Optional[pulumi.Input[str]] = None,
                 data_center: Optional[pulumi.Input['MicroserviceInstanceDataCenterArgs']] = None,
                 health_check: Optional[pulumi.Input['MicroserviceInstanceHealthCheckArgs']] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MicroserviceInstance resource.
        :param pulumi.Input[str] connect_address: Specifies the connection address of service registry center for the
               specified dedicated CSE engine. Changing this will create a new microservice instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] endpoints: Specifies the access addresses information.
               Changing this will create a new microservice instance.
        :param pulumi.Input[str] host_name: Specifies the host name, such as `localhost`.
               Changing this will create a new microservice instance.
        :param pulumi.Input[str] microservice_id: Specifies the ID of the dedicated microservice to which the instance
               belongs. Changing this will create a new microservice instance.
        :param pulumi.Input[str] admin_pass: Specifies the account password.
               Required if the `auth_type` of engine is **RBAC**. Changing this will create a new microservice instance.
               The password format must meet the following conditions:
               + Must be `8` to `32` characters long.
               + A password must contain at least one digit, one uppercase letter, one lowercase letter, and one special character
               (-~!@#%^*_=+?$&()|<>{}[]).
               + Cannot be the account name or account name spelled backwards.
               + The password can only start with a letter.
        :param pulumi.Input[str] admin_user: Specifies the account name. The initial account name is **root**.
               Required if the `auth_type` of engine is **RBAC**. Changing this will create a new microservice instance.
        :param pulumi.Input['MicroserviceInstanceDataCenterArgs'] data_center: Specifies the data center configuration.
               The object structure is documented below.
               Changing this will create a new microservice instance.
        :param pulumi.Input['MicroserviceInstanceHealthCheckArgs'] health_check: Specifies the health check configuration.
               The object structure is documented below.
               Changing this will create a new microservice instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Specifies the extended attributes.
               Changing this will create a new microservice instance.
        :param pulumi.Input[str] version: Specifies the verison of the dedicated microservice instance.
               Changing this will create a new microservice instance.
        """
        pulumi.set(__self__, "connect_address", connect_address)
        pulumi.set(__self__, "endpoints", endpoints)
        pulumi.set(__self__, "host_name", host_name)
        pulumi.set(__self__, "microservice_id", microservice_id)
        if admin_pass is not None:
            pulumi.set(__self__, "admin_pass", admin_pass)
        if admin_user is not None:
            pulumi.set(__self__, "admin_user", admin_user)
        if data_center is not None:
            pulumi.set(__self__, "data_center", data_center)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="connectAddress")
    def connect_address(self) -> pulumi.Input[str]:
        """
        Specifies the connection address of service registry center for the
        specified dedicated CSE engine. Changing this will create a new microservice instance.
        """
        return pulumi.get(self, "connect_address")

    @connect_address.setter
    def connect_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "connect_address", value)

    @property
    @pulumi.getter
    def endpoints(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies the access addresses information.
        Changing this will create a new microservice instance.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Input[str]:
        """
        Specifies the host name, such as `localhost`.
        Changing this will create a new microservice instance.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="microserviceId")
    def microservice_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of the dedicated microservice to which the instance
        belongs. Changing this will create a new microservice instance.
        """
        return pulumi.get(self, "microservice_id")

    @microservice_id.setter
    def microservice_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "microservice_id", value)

    @property
    @pulumi.getter(name="adminPass")
    def admin_pass(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the account password.
        Required if the `auth_type` of engine is **RBAC**. Changing this will create a new microservice instance.
        The password format must meet the following conditions:
        + Must be `8` to `32` characters long.
        + A password must contain at least one digit, one uppercase letter, one lowercase letter, and one special character
        (-~!@#%^*_=+?$&()|<>{}[]).
        + Cannot be the account name or account name spelled backwards.
        + The password can only start with a letter.
        """
        return pulumi.get(self, "admin_pass")

    @admin_pass.setter
    def admin_pass(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_pass", value)

    @property
    @pulumi.getter(name="adminUser")
    def admin_user(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the account name. The initial account name is **root**.
        Required if the `auth_type` of engine is **RBAC**. Changing this will create a new microservice instance.
        """
        return pulumi.get(self, "admin_user")

    @admin_user.setter
    def admin_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_user", value)

    @property
    @pulumi.getter(name="dataCenter")
    def data_center(self) -> Optional[pulumi.Input['MicroserviceInstanceDataCenterArgs']]:
        """
        Specifies the data center configuration.
        The object structure is documented below.
        Changing this will create a new microservice instance.
        """
        return pulumi.get(self, "data_center")

    @data_center.setter
    def data_center(self, value: Optional[pulumi.Input['MicroserviceInstanceDataCenterArgs']]):
        pulumi.set(self, "data_center", value)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[pulumi.Input['MicroserviceInstanceHealthCheckArgs']]:
        """
        Specifies the health check configuration.
        The object structure is documented below.
        Changing this will create a new microservice instance.
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[pulumi.Input['MicroserviceInstanceHealthCheckArgs']]):
        pulumi.set(self, "health_check", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the extended attributes.
        Changing this will create a new microservice instance.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the verison of the dedicated microservice instance.
        Changing this will create a new microservice instance.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _MicroserviceInstanceState:
    def __init__(__self__, *,
                 admin_pass: Optional[pulumi.Input[str]] = None,
                 admin_user: Optional[pulumi.Input[str]] = None,
                 connect_address: Optional[pulumi.Input[str]] = None,
                 data_center: Optional[pulumi.Input['MicroserviceInstanceDataCenterArgs']] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 health_check: Optional[pulumi.Input['MicroserviceInstanceHealthCheckArgs']] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 microservice_id: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MicroserviceInstance resources.
        :param pulumi.Input[str] admin_pass: Specifies the account password.
               Required if the `auth_type` of engine is **RBAC**. Changing this will create a new microservice instance.
               The password format must meet the following conditions:
               + Must be `8` to `32` characters long.
               + A password must contain at least one digit, one uppercase letter, one lowercase letter, and one special character
               (-~!@#%^*_=+?$&()|<>{}[]).
               + Cannot be the account name or account name spelled backwards.
               + The password can only start with a letter.
        :param pulumi.Input[str] admin_user: Specifies the account name. The initial account name is **root**.
               Required if the `auth_type` of engine is **RBAC**. Changing this will create a new microservice instance.
        :param pulumi.Input[str] connect_address: Specifies the connection address of service registry center for the
               specified dedicated CSE engine. Changing this will create a new microservice instance.
        :param pulumi.Input['MicroserviceInstanceDataCenterArgs'] data_center: Specifies the data center configuration.
               The object structure is documented below.
               Changing this will create a new microservice instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] endpoints: Specifies the access addresses information.
               Changing this will create a new microservice instance.
        :param pulumi.Input['MicroserviceInstanceHealthCheckArgs'] health_check: Specifies the health check configuration.
               The object structure is documented below.
               Changing this will create a new microservice instance.
        :param pulumi.Input[str] host_name: Specifies the host name, such as `localhost`.
               Changing this will create a new microservice instance.
        :param pulumi.Input[str] microservice_id: Specifies the ID of the dedicated microservice to which the instance
               belongs. Changing this will create a new microservice instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Specifies the extended attributes.
               Changing this will create a new microservice instance.
        :param pulumi.Input[str] status: The microservice instance status. The values supports **UP**, **DOWN**, **STARTING** and **OUTOFSERVICE**.
        :param pulumi.Input[str] version: Specifies the verison of the dedicated microservice instance.
               Changing this will create a new microservice instance.
        """
        if admin_pass is not None:
            pulumi.set(__self__, "admin_pass", admin_pass)
        if admin_user is not None:
            pulumi.set(__self__, "admin_user", admin_user)
        if connect_address is not None:
            pulumi.set(__self__, "connect_address", connect_address)
        if data_center is not None:
            pulumi.set(__self__, "data_center", data_center)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if microservice_id is not None:
            pulumi.set(__self__, "microservice_id", microservice_id)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="adminPass")
    def admin_pass(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the account password.
        Required if the `auth_type` of engine is **RBAC**. Changing this will create a new microservice instance.
        The password format must meet the following conditions:
        + Must be `8` to `32` characters long.
        + A password must contain at least one digit, one uppercase letter, one lowercase letter, and one special character
        (-~!@#%^*_=+?$&()|<>{}[]).
        + Cannot be the account name or account name spelled backwards.
        + The password can only start with a letter.
        """
        return pulumi.get(self, "admin_pass")

    @admin_pass.setter
    def admin_pass(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_pass", value)

    @property
    @pulumi.getter(name="adminUser")
    def admin_user(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the account name. The initial account name is **root**.
        Required if the `auth_type` of engine is **RBAC**. Changing this will create a new microservice instance.
        """
        return pulumi.get(self, "admin_user")

    @admin_user.setter
    def admin_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_user", value)

    @property
    @pulumi.getter(name="connectAddress")
    def connect_address(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the connection address of service registry center for the
        specified dedicated CSE engine. Changing this will create a new microservice instance.
        """
        return pulumi.get(self, "connect_address")

    @connect_address.setter
    def connect_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connect_address", value)

    @property
    @pulumi.getter(name="dataCenter")
    def data_center(self) -> Optional[pulumi.Input['MicroserviceInstanceDataCenterArgs']]:
        """
        Specifies the data center configuration.
        The object structure is documented below.
        Changing this will create a new microservice instance.
        """
        return pulumi.get(self, "data_center")

    @data_center.setter
    def data_center(self, value: Optional[pulumi.Input['MicroserviceInstanceDataCenterArgs']]):
        pulumi.set(self, "data_center", value)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the access addresses information.
        Changing this will create a new microservice instance.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[pulumi.Input['MicroserviceInstanceHealthCheckArgs']]:
        """
        Specifies the health check configuration.
        The object structure is documented below.
        Changing this will create a new microservice instance.
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[pulumi.Input['MicroserviceInstanceHealthCheckArgs']]):
        pulumi.set(self, "health_check", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the host name, such as `localhost`.
        Changing this will create a new microservice instance.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="microserviceId")
    def microservice_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the dedicated microservice to which the instance
        belongs. Changing this will create a new microservice instance.
        """
        return pulumi.get(self, "microservice_id")

    @microservice_id.setter
    def microservice_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "microservice_id", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the extended attributes.
        Changing this will create a new microservice instance.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The microservice instance status. The values supports **UP**, **DOWN**, **STARTING** and **OUTOFSERVICE**.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the verison of the dedicated microservice instance.
        Changing this will create a new microservice instance.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class MicroserviceInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_pass: Optional[pulumi.Input[str]] = None,
                 admin_user: Optional[pulumi.Input[str]] = None,
                 connect_address: Optional[pulumi.Input[str]] = None,
                 data_center: Optional[pulumi.Input[pulumi.InputType['MicroserviceInstanceDataCenterArgs']]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 health_check: Optional[pulumi.Input[pulumi.InputType['MicroserviceInstanceHealthCheckArgs']]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 microservice_id: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a dedicated microservice instance resource within HuaweiCloud.

        ## Example Usage

        ## Import

        Microservices can be imported using related `connect_address`, `microservice_id` and their `id`, separated by a slash (/), e.g.

        ```sh
         $ pulumi import huaweicloud:Cse/microserviceInstance:MicroserviceInstance test https://124.70.26.32:30100/f14960ba495e03f59f85aacaaafbdef3fbff3f0d/336e7428dd9411eca913fa163e7364b7
        ```

         If you enabled the **RBAC** authorization, you also need to provide the account name and password, e.g.

        ```sh
         $ pulumi import huaweicloud:Cse/microserviceInstance:MicroserviceInstance test 'https://124.70.26.32:30100/f14960ba495e03f59f85aacaaafbdef3fbff3f0d/336e7428dd9411eca913fa163e7364b7/root/Test!123'
        ```

         The single quotes can help you solve the problem of special characters reporting errors on bash.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] admin_pass: Specifies the account password.
               Required if the `auth_type` of engine is **RBAC**. Changing this will create a new microservice instance.
               The password format must meet the following conditions:
               + Must be `8` to `32` characters long.
               + A password must contain at least one digit, one uppercase letter, one lowercase letter, and one special character
               (-~!@#%^*_=+?$&()|<>{}[]).
               + Cannot be the account name or account name spelled backwards.
               + The password can only start with a letter.
        :param pulumi.Input[str] admin_user: Specifies the account name. The initial account name is **root**.
               Required if the `auth_type` of engine is **RBAC**. Changing this will create a new microservice instance.
        :param pulumi.Input[str] connect_address: Specifies the connection address of service registry center for the
               specified dedicated CSE engine. Changing this will create a new microservice instance.
        :param pulumi.Input[pulumi.InputType['MicroserviceInstanceDataCenterArgs']] data_center: Specifies the data center configuration.
               The object structure is documented below.
               Changing this will create a new microservice instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] endpoints: Specifies the access addresses information.
               Changing this will create a new microservice instance.
        :param pulumi.Input[pulumi.InputType['MicroserviceInstanceHealthCheckArgs']] health_check: Specifies the health check configuration.
               The object structure is documented below.
               Changing this will create a new microservice instance.
        :param pulumi.Input[str] host_name: Specifies the host name, such as `localhost`.
               Changing this will create a new microservice instance.
        :param pulumi.Input[str] microservice_id: Specifies the ID of the dedicated microservice to which the instance
               belongs. Changing this will create a new microservice instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Specifies the extended attributes.
               Changing this will create a new microservice instance.
        :param pulumi.Input[str] version: Specifies the verison of the dedicated microservice instance.
               Changing this will create a new microservice instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MicroserviceInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a dedicated microservice instance resource within HuaweiCloud.

        ## Example Usage

        ## Import

        Microservices can be imported using related `connect_address`, `microservice_id` and their `id`, separated by a slash (/), e.g.

        ```sh
         $ pulumi import huaweicloud:Cse/microserviceInstance:MicroserviceInstance test https://124.70.26.32:30100/f14960ba495e03f59f85aacaaafbdef3fbff3f0d/336e7428dd9411eca913fa163e7364b7
        ```

         If you enabled the **RBAC** authorization, you also need to provide the account name and password, e.g.

        ```sh
         $ pulumi import huaweicloud:Cse/microserviceInstance:MicroserviceInstance test 'https://124.70.26.32:30100/f14960ba495e03f59f85aacaaafbdef3fbff3f0d/336e7428dd9411eca913fa163e7364b7/root/Test!123'
        ```

         The single quotes can help you solve the problem of special characters reporting errors on bash.

        :param str resource_name: The name of the resource.
        :param MicroserviceInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MicroserviceInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_pass: Optional[pulumi.Input[str]] = None,
                 admin_user: Optional[pulumi.Input[str]] = None,
                 connect_address: Optional[pulumi.Input[str]] = None,
                 data_center: Optional[pulumi.Input[pulumi.InputType['MicroserviceInstanceDataCenterArgs']]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 health_check: Optional[pulumi.Input[pulumi.InputType['MicroserviceInstanceHealthCheckArgs']]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 microservice_id: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MicroserviceInstanceArgs.__new__(MicroserviceInstanceArgs)

            __props__.__dict__["admin_pass"] = admin_pass
            __props__.__dict__["admin_user"] = admin_user
            if connect_address is None and not opts.urn:
                raise TypeError("Missing required property 'connect_address'")
            __props__.__dict__["connect_address"] = connect_address
            __props__.__dict__["data_center"] = data_center
            if endpoints is None and not opts.urn:
                raise TypeError("Missing required property 'endpoints'")
            __props__.__dict__["endpoints"] = endpoints
            __props__.__dict__["health_check"] = health_check
            if host_name is None and not opts.urn:
                raise TypeError("Missing required property 'host_name'")
            __props__.__dict__["host_name"] = host_name
            if microservice_id is None and not opts.urn:
                raise TypeError("Missing required property 'microservice_id'")
            __props__.__dict__["microservice_id"] = microservice_id
            __props__.__dict__["properties"] = properties
            __props__.__dict__["version"] = version
            __props__.__dict__["status"] = None
        super(MicroserviceInstance, __self__).__init__(
            'huaweicloud:Cse/microserviceInstance:MicroserviceInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_pass: Optional[pulumi.Input[str]] = None,
            admin_user: Optional[pulumi.Input[str]] = None,
            connect_address: Optional[pulumi.Input[str]] = None,
            data_center: Optional[pulumi.Input[pulumi.InputType['MicroserviceInstanceDataCenterArgs']]] = None,
            endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            health_check: Optional[pulumi.Input[pulumi.InputType['MicroserviceInstanceHealthCheckArgs']]] = None,
            host_name: Optional[pulumi.Input[str]] = None,
            microservice_id: Optional[pulumi.Input[str]] = None,
            properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            status: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None) -> 'MicroserviceInstance':
        """
        Get an existing MicroserviceInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] admin_pass: Specifies the account password.
               Required if the `auth_type` of engine is **RBAC**. Changing this will create a new microservice instance.
               The password format must meet the following conditions:
               + Must be `8` to `32` characters long.
               + A password must contain at least one digit, one uppercase letter, one lowercase letter, and one special character
               (-~!@#%^*_=+?$&()|<>{}[]).
               + Cannot be the account name or account name spelled backwards.
               + The password can only start with a letter.
        :param pulumi.Input[str] admin_user: Specifies the account name. The initial account name is **root**.
               Required if the `auth_type` of engine is **RBAC**. Changing this will create a new microservice instance.
        :param pulumi.Input[str] connect_address: Specifies the connection address of service registry center for the
               specified dedicated CSE engine. Changing this will create a new microservice instance.
        :param pulumi.Input[pulumi.InputType['MicroserviceInstanceDataCenterArgs']] data_center: Specifies the data center configuration.
               The object structure is documented below.
               Changing this will create a new microservice instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] endpoints: Specifies the access addresses information.
               Changing this will create a new microservice instance.
        :param pulumi.Input[pulumi.InputType['MicroserviceInstanceHealthCheckArgs']] health_check: Specifies the health check configuration.
               The object structure is documented below.
               Changing this will create a new microservice instance.
        :param pulumi.Input[str] host_name: Specifies the host name, such as `localhost`.
               Changing this will create a new microservice instance.
        :param pulumi.Input[str] microservice_id: Specifies the ID of the dedicated microservice to which the instance
               belongs. Changing this will create a new microservice instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Specifies the extended attributes.
               Changing this will create a new microservice instance.
        :param pulumi.Input[str] status: The microservice instance status. The values supports **UP**, **DOWN**, **STARTING** and **OUTOFSERVICE**.
        :param pulumi.Input[str] version: Specifies the verison of the dedicated microservice instance.
               Changing this will create a new microservice instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MicroserviceInstanceState.__new__(_MicroserviceInstanceState)

        __props__.__dict__["admin_pass"] = admin_pass
        __props__.__dict__["admin_user"] = admin_user
        __props__.__dict__["connect_address"] = connect_address
        __props__.__dict__["data_center"] = data_center
        __props__.__dict__["endpoints"] = endpoints
        __props__.__dict__["health_check"] = health_check
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["microservice_id"] = microservice_id
        __props__.__dict__["properties"] = properties
        __props__.__dict__["status"] = status
        __props__.__dict__["version"] = version
        return MicroserviceInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminPass")
    def admin_pass(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the account password.
        Required if the `auth_type` of engine is **RBAC**. Changing this will create a new microservice instance.
        The password format must meet the following conditions:
        + Must be `8` to `32` characters long.
        + A password must contain at least one digit, one uppercase letter, one lowercase letter, and one special character
        (-~!@#%^*_=+?$&()|<>{}[]).
        + Cannot be the account name or account name spelled backwards.
        + The password can only start with a letter.
        """
        return pulumi.get(self, "admin_pass")

    @property
    @pulumi.getter(name="adminUser")
    def admin_user(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the account name. The initial account name is **root**.
        Required if the `auth_type` of engine is **RBAC**. Changing this will create a new microservice instance.
        """
        return pulumi.get(self, "admin_user")

    @property
    @pulumi.getter(name="connectAddress")
    def connect_address(self) -> pulumi.Output[str]:
        """
        Specifies the connection address of service registry center for the
        specified dedicated CSE engine. Changing this will create a new microservice instance.
        """
        return pulumi.get(self, "connect_address")

    @property
    @pulumi.getter(name="dataCenter")
    def data_center(self) -> pulumi.Output['outputs.MicroserviceInstanceDataCenter']:
        """
        Specifies the data center configuration.
        The object structure is documented below.
        Changing this will create a new microservice instance.
        """
        return pulumi.get(self, "data_center")

    @property
    @pulumi.getter
    def endpoints(self) -> pulumi.Output[Sequence[str]]:
        """
        Specifies the access addresses information.
        Changing this will create a new microservice instance.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> pulumi.Output['outputs.MicroserviceInstanceHealthCheck']:
        """
        Specifies the health check configuration.
        The object structure is documented below.
        Changing this will create a new microservice instance.
        """
        return pulumi.get(self, "health_check")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[str]:
        """
        Specifies the host name, such as `localhost`.
        Changing this will create a new microservice instance.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="microserviceId")
    def microservice_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of the dedicated microservice to which the instance
        belongs. Changing this will create a new microservice instance.
        """
        return pulumi.get(self, "microservice_id")

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Specifies the extended attributes.
        Changing this will create a new microservice instance.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The microservice instance status. The values supports **UP**, **DOWN**, **STARTING** and **OUTOFSERVICE**.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        Specifies the verison of the dedicated microservice instance.
        Changing this will create a new microservice instance.
        """
        return pulumi.get(self, "version")

