# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetDomainStatisticsResult',
    'AwaitableGetDomainStatisticsResult',
    'get_domain_statistics',
    'get_domain_statistics_output',
]

@pulumi.output_type
class GetDomainStatisticsResult:
    """
    A collection of values returned by getDomainStatistics.
    """
    def __init__(__self__, action=None, country=None, domain_name=None, end_time=None, enterprise_project_id=None, group_by=None, id=None, interval=None, isp=None, province=None, result=None, start_time=None, stat_type=None):
        if action and not isinstance(action, str):
            raise TypeError("Expected argument 'action' to be a str")
        pulumi.set(__self__, "action", action)
        if country and not isinstance(country, str):
            raise TypeError("Expected argument 'country' to be a str")
        pulumi.set(__self__, "country", country)
        if domain_name and not isinstance(domain_name, str):
            raise TypeError("Expected argument 'domain_name' to be a str")
        pulumi.set(__self__, "domain_name", domain_name)
        if end_time and not isinstance(end_time, int):
            raise TypeError("Expected argument 'end_time' to be a int")
        pulumi.set(__self__, "end_time", end_time)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if group_by and not isinstance(group_by, str):
            raise TypeError("Expected argument 'group_by' to be a str")
        pulumi.set(__self__, "group_by", group_by)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if interval and not isinstance(interval, int):
            raise TypeError("Expected argument 'interval' to be a int")
        pulumi.set(__self__, "interval", interval)
        if isp and not isinstance(isp, str):
            raise TypeError("Expected argument 'isp' to be a str")
        pulumi.set(__self__, "isp", isp)
        if province and not isinstance(province, str):
            raise TypeError("Expected argument 'province' to be a str")
        pulumi.set(__self__, "province", province)
        if result and not isinstance(result, str):
            raise TypeError("Expected argument 'result' to be a str")
        pulumi.set(__self__, "result", result)
        if start_time and not isinstance(start_time, int):
            raise TypeError("Expected argument 'start_time' to be a int")
        pulumi.set(__self__, "start_time", start_time)
        if stat_type and not isinstance(stat_type, str):
            raise TypeError("Expected argument 'stat_type' to be a str")
        pulumi.set(__self__, "stat_type", stat_type)

    @property
    @pulumi.getter
    def action(self) -> str:
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def country(self) -> Optional[str]:
        return pulumi.get(self, "country")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> str:
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> int:
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[str]:
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter(name="groupBy")
    def group_by(self) -> Optional[str]:
        return pulumi.get(self, "group_by")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def interval(self) -> Optional[int]:
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def isp(self) -> Optional[str]:
        return pulumi.get(self, "isp")

    @property
    @pulumi.getter
    def province(self) -> Optional[str]:
        return pulumi.get(self, "province")

    @property
    @pulumi.getter
    def result(self) -> str:
        """
        The data organized according to the specified grouping mode.
        """
        return pulumi.get(self, "result")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> int:
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="statType")
    def stat_type(self) -> str:
        return pulumi.get(self, "stat_type")


class AwaitableGetDomainStatisticsResult(GetDomainStatisticsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDomainStatisticsResult(
            action=self.action,
            country=self.country,
            domain_name=self.domain_name,
            end_time=self.end_time,
            enterprise_project_id=self.enterprise_project_id,
            group_by=self.group_by,
            id=self.id,
            interval=self.interval,
            isp=self.isp,
            province=self.province,
            result=self.result,
            start_time=self.start_time,
            stat_type=self.stat_type)


def get_domain_statistics(action: Optional[str] = None,
                          country: Optional[str] = None,
                          domain_name: Optional[str] = None,
                          end_time: Optional[int] = None,
                          enterprise_project_id: Optional[str] = None,
                          group_by: Optional[str] = None,
                          interval: Optional[int] = None,
                          isp: Optional[str] = None,
                          province: Optional[str] = None,
                          start_time: Optional[int] = None,
                          stat_type: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDomainStatisticsResult:
    """
    Use this data source to get the statistics of CDN domain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    domain_name = config.require_object("domainName")
    test = huaweicloud.Cdn.get_domain_statistics(action="location_detail",
        domain_name="terraform.test.huaweicloud.com",
        end_time=1662021000000,
        start_time=1662019200000,
        stat_type="req_num")
    ```


    :param str action: Specifies the action name. Possible values are: **location_summary** and **location_detail**.
    :param str country: Specifies the country or region code. Use commas (,) to separate multiple codes.
           The value all indicates all country/region codes.
           See the [country and region](https://support.huaweicloud.com/intl/en-us/api-cdn/cdn_02_0089.html) for values.
    :param str domain_name: Specifies the domain name list. Domain names are separated by commas (,),
           for example, www.test1.com,www.test2.com. The value all indicates that all domain names under your account are queried.
    :param int end_time: Specifies the end timestamp of the query.
           The timestamp must be set to a multiple of 5 minutes.
           + If the value of interval is 300, set this parameter to a multiple of 5 minutes,
           for example, 1631243700000, which means 2021-09-10 11:15:00.
           + If the value of interval is 3600, set this parameter to a multiple of 1 hour,
           for example, 1631325600000, which means 2021-09-11 10:00:00.
           + If the value of interval is 86400, set this parameter to 00:00:00 (GMT+08:00),
           for example, 1631376000000, which means 2021-09-12 00:00:00.
    :param str enterprise_project_id: Specifies the enterprise project that the resource belongs to.
           This parameter is valid only when the enterprise project function is enabled.
           The value all indicates all projects. This parameter is mandatory when you use an IAM user.
    :param str group_by: Specifies the data grouping mode. Use commas (,) to separate multiple groups.
           Available data groups are **domain**, **country**, **province**, and **isp**. By default, data is not grouped.
    :param int interval: Specifies the query time interval, in seconds, the value can be,
           + **300**(5 minutes): Maximum query span 2 days
           + **3600**(1 hour): Maximum query span 7 days
           + **86400**(1 day): Maximum query span 31 days
    :param str isp: Specifies the carrier code. Use commas (,) to separate multiple codes.
           The value all indicates all carrier codes.
           See the [carriers](https://support.huaweicloud.com/intl/en-us/api-cdn/cdn_02_0075.html) for values.
    :param str province: Specifies the province code. This parameter is valid when country is set to **cn**.
           Use commas (,) to separate multiple codes. The value all indicates all provinces.
           See the [areas](https://support.huaweicloud.com/intl/en-us/api-cdn/cdn_02_0074.html) for values.
    :param int start_time: Specifies the start timestamp of the query.
           The timestamp must be set to a multiple of 5 minutes.
           + If the value of interval is **300**, set this parameter to a multiple of 5 minutes,
           for example, 1631240100000, which means 2021-09-10 10:15:00.
           + If the value of interval is **3600**, set this parameter to a multiple of 1 hour,
           for example, 1631239200000, which means 2021-09-10 10:00:00.
           + If the value of interval is **86400**, set this parameter to 00:00:00 (GMT+08:00),
           for example, 1631203200000, which means 2021-09-10 00:00:00.
    :param str stat_type: The statistic type.
    """
    __args__ = dict()
    __args__['action'] = action
    __args__['country'] = country
    __args__['domainName'] = domain_name
    __args__['endTime'] = end_time
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['groupBy'] = group_by
    __args__['interval'] = interval
    __args__['isp'] = isp
    __args__['province'] = province
    __args__['startTime'] = start_time
    __args__['statType'] = stat_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Cdn/getDomainStatistics:getDomainStatistics', __args__, opts=opts, typ=GetDomainStatisticsResult).value

    return AwaitableGetDomainStatisticsResult(
        action=__ret__.action,
        country=__ret__.country,
        domain_name=__ret__.domain_name,
        end_time=__ret__.end_time,
        enterprise_project_id=__ret__.enterprise_project_id,
        group_by=__ret__.group_by,
        id=__ret__.id,
        interval=__ret__.interval,
        isp=__ret__.isp,
        province=__ret__.province,
        result=__ret__.result,
        start_time=__ret__.start_time,
        stat_type=__ret__.stat_type)


@_utilities.lift_output_func(get_domain_statistics)
def get_domain_statistics_output(action: Optional[pulumi.Input[str]] = None,
                                 country: Optional[pulumi.Input[Optional[str]]] = None,
                                 domain_name: Optional[pulumi.Input[str]] = None,
                                 end_time: Optional[pulumi.Input[int]] = None,
                                 enterprise_project_id: Optional[pulumi.Input[Optional[str]]] = None,
                                 group_by: Optional[pulumi.Input[Optional[str]]] = None,
                                 interval: Optional[pulumi.Input[Optional[int]]] = None,
                                 isp: Optional[pulumi.Input[Optional[str]]] = None,
                                 province: Optional[pulumi.Input[Optional[str]]] = None,
                                 start_time: Optional[pulumi.Input[int]] = None,
                                 stat_type: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDomainStatisticsResult]:
    """
    Use this data source to get the statistics of CDN domain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    domain_name = config.require_object("domainName")
    test = huaweicloud.Cdn.get_domain_statistics(action="location_detail",
        domain_name="terraform.test.huaweicloud.com",
        end_time=1662021000000,
        start_time=1662019200000,
        stat_type="req_num")
    ```


    :param str action: Specifies the action name. Possible values are: **location_summary** and **location_detail**.
    :param str country: Specifies the country or region code. Use commas (,) to separate multiple codes.
           The value all indicates all country/region codes.
           See the [country and region](https://support.huaweicloud.com/intl/en-us/api-cdn/cdn_02_0089.html) for values.
    :param str domain_name: Specifies the domain name list. Domain names are separated by commas (,),
           for example, www.test1.com,www.test2.com. The value all indicates that all domain names under your account are queried.
    :param int end_time: Specifies the end timestamp of the query.
           The timestamp must be set to a multiple of 5 minutes.
           + If the value of interval is 300, set this parameter to a multiple of 5 minutes,
           for example, 1631243700000, which means 2021-09-10 11:15:00.
           + If the value of interval is 3600, set this parameter to a multiple of 1 hour,
           for example, 1631325600000, which means 2021-09-11 10:00:00.
           + If the value of interval is 86400, set this parameter to 00:00:00 (GMT+08:00),
           for example, 1631376000000, which means 2021-09-12 00:00:00.
    :param str enterprise_project_id: Specifies the enterprise project that the resource belongs to.
           This parameter is valid only when the enterprise project function is enabled.
           The value all indicates all projects. This parameter is mandatory when you use an IAM user.
    :param str group_by: Specifies the data grouping mode. Use commas (,) to separate multiple groups.
           Available data groups are **domain**, **country**, **province**, and **isp**. By default, data is not grouped.
    :param int interval: Specifies the query time interval, in seconds, the value can be,
           + **300**(5 minutes): Maximum query span 2 days
           + **3600**(1 hour): Maximum query span 7 days
           + **86400**(1 day): Maximum query span 31 days
    :param str isp: Specifies the carrier code. Use commas (,) to separate multiple codes.
           The value all indicates all carrier codes.
           See the [carriers](https://support.huaweicloud.com/intl/en-us/api-cdn/cdn_02_0075.html) for values.
    :param str province: Specifies the province code. This parameter is valid when country is set to **cn**.
           Use commas (,) to separate multiple codes. The value all indicates all provinces.
           See the [areas](https://support.huaweicloud.com/intl/en-us/api-cdn/cdn_02_0074.html) for values.
    :param int start_time: Specifies the start timestamp of the query.
           The timestamp must be set to a multiple of 5 minutes.
           + If the value of interval is **300**, set this parameter to a multiple of 5 minutes,
           for example, 1631240100000, which means 2021-09-10 10:15:00.
           + If the value of interval is **3600**, set this parameter to a multiple of 1 hour,
           for example, 1631239200000, which means 2021-09-10 10:00:00.
           + If the value of interval is **86400**, set this parameter to 00:00:00 (GMT+08:00),
           for example, 1631203200000, which means 2021-09-10 00:00:00.
    :param str stat_type: The statistic type.
    """
    ...
