# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['LinkArgs', 'Link']

@pulumi.input_type
class LinkArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[str],
                 config: pulumi.Input[Mapping[str, pulumi.Input[str]]],
                 connector: pulumi.Input[str],
                 access_key: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secret_key: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Link resource.
        :param pulumi.Input[str] cluster_id: Specifies the id of CDM cluster which this link belongs to.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] config: Specifies the link configuration parameters. Each type of the data source to be connected
               has different configuration parameters, please refer to the document link below.
        :param pulumi.Input[str] connector: Specifies the connector that is classified based on the type of the data
               source to be connected. Changing this parameter will create a new resource. The options are as follows:
        :param pulumi.Input[str] access_key: Specifies access key for accessing the data sources.
        :param pulumi.Input[bool] enabled: Specifies whether to enable the link. The default value is `true`.
        :param pulumi.Input[str] name: Specifies the name of the link.
        :param pulumi.Input[str] password: Specifies the password for accessing the data sources.
        :param pulumi.Input[str] region: The region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] secret_key: Specifies security key for accessing the data sources.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "connector", connector)
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[str]:
        """
        Specifies the id of CDM cluster which this link belongs to.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter
    def config(self) -> pulumi.Input[Mapping[str, pulumi.Input[str]]]:
        """
        Specifies the link configuration parameters. Each type of the data source to be connected
        has different configuration parameters, please refer to the document link below.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def connector(self) -> pulumi.Input[str]:
        """
        Specifies the connector that is classified based on the type of the data
        source to be connected. Changing this parameter will create a new resource. The options are as follows:
        """
        return pulumi.get(self, "connector")

    @connector.setter
    def connector(self, value: pulumi.Input[str]):
        pulumi.set(self, "connector", value)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies access key for accessing the data sources.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_key", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the link. The default value is `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the link.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the password for accessing the data sources.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies security key for accessing the data sources.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_key", value)


@pulumi.input_type
class _LinkState:
    def __init__(__self__, *,
                 access_key: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 connector: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secret_key: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Link resources.
        :param pulumi.Input[str] access_key: Specifies access key for accessing the data sources.
        :param pulumi.Input[str] cluster_id: Specifies the id of CDM cluster which this link belongs to.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] config: Specifies the link configuration parameters. Each type of the data source to be connected
               has different configuration parameters, please refer to the document link below.
        :param pulumi.Input[str] connector: Specifies the connector that is classified based on the type of the data
               source to be connected. Changing this parameter will create a new resource. The options are as follows:
        :param pulumi.Input[bool] enabled: Specifies whether to enable the link. The default value is `true`.
        :param pulumi.Input[str] name: Specifies the name of the link.
        :param pulumi.Input[str] password: Specifies the password for accessing the data sources.
        :param pulumi.Input[str] region: The region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] secret_key: Specifies security key for accessing the data sources.
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if connector is not None:
            pulumi.set(__self__, "connector", connector)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies access key for accessing the data sources.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_key", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the id of CDM cluster which this link belongs to.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the link configuration parameters. Each type of the data source to be connected
        has different configuration parameters, please refer to the document link below.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def connector(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the connector that is classified based on the type of the data
        source to be connected. Changing this parameter will create a new resource. The options are as follows:
        """
        return pulumi.get(self, "connector")

    @connector.setter
    def connector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connector", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the link. The default value is `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the link.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the password for accessing the data sources.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies security key for accessing the data sources.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_key", value)


class Link(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 connector: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secret_key: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a link resource within HuaweiCloud. A link enables the CDM cluster to read data from and write data to
         a data source.

        ## Example Usage
        ### Link to MySql

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        mysql_link_name = config.require_object("mysqlLinkName")
        cdm_cluster_id = config.require_object("cdmClusterId")
        mysql_host = config.require_object("mysqlHost")
        db_name = config.require_object("dbName")
        db_password = config.require_object("dbPassword")
        mysql_link = huaweicloud.cdm.Link("mysqlLink",
            connector="generic-jdbc-connector",
            cluster_id=cdm_cluster_id,
            config={
                "databaseType": "MYSQL",
                "host": mysql_host,
                "port": "3306",
                "database": db_name,
                "username": var["username"],
            },
            password=db_password)
        ```

        ## Import

        The link can be imported by `id`, It is composed of the ID of CDM cluster and the name of job, separated by a slash.

        For example,

        ```sh
         $ pulumi import huaweicloud:Cdm/link:Link test b11b407c-e604-4e8d-8bc4-92398320b847/linkName
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`password` and `secret_key`. It is generally recommended running `terraform plan` after importing an instance. You can then decide if changes should be applied to the instance, or the resource definition should be updated to align with the instance. Also you can ignore changes as below. resource "huaweicloud_cdm_link" "test" {

         ...

         lifecycle {

         ignore_changes = [

         password, secret_key,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_key: Specifies access key for accessing the data sources.
        :param pulumi.Input[str] cluster_id: Specifies the id of CDM cluster which this link belongs to.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] config: Specifies the link configuration parameters. Each type of the data source to be connected
               has different configuration parameters, please refer to the document link below.
        :param pulumi.Input[str] connector: Specifies the connector that is classified based on the type of the data
               source to be connected. Changing this parameter will create a new resource. The options are as follows:
        :param pulumi.Input[bool] enabled: Specifies whether to enable the link. The default value is `true`.
        :param pulumi.Input[str] name: Specifies the name of the link.
        :param pulumi.Input[str] password: Specifies the password for accessing the data sources.
        :param pulumi.Input[str] region: The region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] secret_key: Specifies security key for accessing the data sources.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LinkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a link resource within HuaweiCloud. A link enables the CDM cluster to read data from and write data to
         a data source.

        ## Example Usage
        ### Link to MySql

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        mysql_link_name = config.require_object("mysqlLinkName")
        cdm_cluster_id = config.require_object("cdmClusterId")
        mysql_host = config.require_object("mysqlHost")
        db_name = config.require_object("dbName")
        db_password = config.require_object("dbPassword")
        mysql_link = huaweicloud.cdm.Link("mysqlLink",
            connector="generic-jdbc-connector",
            cluster_id=cdm_cluster_id,
            config={
                "databaseType": "MYSQL",
                "host": mysql_host,
                "port": "3306",
                "database": db_name,
                "username": var["username"],
            },
            password=db_password)
        ```

        ## Import

        The link can be imported by `id`, It is composed of the ID of CDM cluster and the name of job, separated by a slash.

        For example,

        ```sh
         $ pulumi import huaweicloud:Cdm/link:Link test b11b407c-e604-4e8d-8bc4-92398320b847/linkName
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`password` and `secret_key`. It is generally recommended running `terraform plan` after importing an instance. You can then decide if changes should be applied to the instance, or the resource definition should be updated to align with the instance. Also you can ignore changes as below. resource "huaweicloud_cdm_link" "test" {

         ...

         lifecycle {

         ignore_changes = [

         password, secret_key,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param LinkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LinkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 connector: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secret_key: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LinkArgs.__new__(LinkArgs)

            __props__.__dict__["access_key"] = access_key
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            if config is None and not opts.urn:
                raise TypeError("Missing required property 'config'")
            __props__.__dict__["config"] = config
            if connector is None and not opts.urn:
                raise TypeError("Missing required property 'connector'")
            __props__.__dict__["connector"] = connector
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["name"] = name
            __props__.__dict__["password"] = password
            __props__.__dict__["region"] = region
            __props__.__dict__["secret_key"] = secret_key
        super(Link, __self__).__init__(
            'huaweicloud:Cdm/link:Link',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_key: Optional[pulumi.Input[str]] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            connector: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            secret_key: Optional[pulumi.Input[str]] = None) -> 'Link':
        """
        Get an existing Link resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_key: Specifies access key for accessing the data sources.
        :param pulumi.Input[str] cluster_id: Specifies the id of CDM cluster which this link belongs to.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] config: Specifies the link configuration parameters. Each type of the data source to be connected
               has different configuration parameters, please refer to the document link below.
        :param pulumi.Input[str] connector: Specifies the connector that is classified based on the type of the data
               source to be connected. Changing this parameter will create a new resource. The options are as follows:
        :param pulumi.Input[bool] enabled: Specifies whether to enable the link. The default value is `true`.
        :param pulumi.Input[str] name: Specifies the name of the link.
        :param pulumi.Input[str] password: Specifies the password for accessing the data sources.
        :param pulumi.Input[str] region: The region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] secret_key: Specifies security key for accessing the data sources.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LinkState.__new__(_LinkState)

        __props__.__dict__["access_key"] = access_key
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["config"] = config
        __props__.__dict__["connector"] = connector
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["region"] = region
        __props__.__dict__["secret_key"] = secret_key
        return Link(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies access key for accessing the data sources.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        Specifies the id of CDM cluster which this link belongs to.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def config(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Specifies the link configuration parameters. Each type of the data source to be connected
        has different configuration parameters, please refer to the document link below.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def connector(self) -> pulumi.Output[str]:
        """
        Specifies the connector that is classified based on the type of the data
        source to be connected. Changing this parameter will create a new resource. The options are as follows:
        """
        return pulumi.get(self, "connector")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to enable the link. The default value is `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the link.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the password for accessing the data sources.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies security key for accessing the data sources.
        """
        return pulumi.get(self, "secret_key")

