# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['NamespaceArgs', 'Namespace']

@pulumi.input_type
class NamespaceArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 prefix: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Namespace resource.
        :param pulumi.Input[str] cluster_id: Specifies the cluster ID to which the CCE namespace belongs.
               Changing this will create a new namespace resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Specifies an unstructured key value map for external parameters.
               Changing this will create a new namespace resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Specifies the map of string keys and values for labels.
               Changing this will create a new namespace resource.
        :param pulumi.Input[str] name: Specifies the unique name of the namespace.
               This parameter can contain a maximum of 63 characters, which may consist of lowercase letters, digits and hyphens (-),
               and must start and end with lowercase letters and digits. Changing this will create a new namespace resource.
               Exactly one of `name` or `prefix` must be provided.
        :param pulumi.Input[str] prefix: Specifies a prefix used by the server to generate a unique name.
               This parameter can contain a maximum of 63 characters, which may consist of lowercase letters, digits and
               hyphens (-), and must start and end with lowercase letters and digits.
               Changing this will create a new namespace resource. Exactly one of `name` or `prefix` must be provided.
        :param pulumi.Input[str] region: Specifies the region in which to create the namespace resource.
               If omitted, the provider-level region will be used. Changing this will create a new namespace resource.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[str]:
        """
        Specifies the cluster ID to which the CCE namespace belongs.
        Changing this will create a new namespace resource.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies an unstructured key value map for external parameters.
        Changing this will create a new namespace resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the map of string keys and values for labels.
        Changing this will create a new namespace resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the unique name of the namespace.
        This parameter can contain a maximum of 63 characters, which may consist of lowercase letters, digits and hyphens (-),
        and must start and end with lowercase letters and digits. Changing this will create a new namespace resource.
        Exactly one of `name` or `prefix` must be provided.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a prefix used by the server to generate a unique name.
        This parameter can contain a maximum of 63 characters, which may consist of lowercase letters, digits and
        hyphens (-), and must start and end with lowercase letters and digits.
        Changing this will create a new namespace resource. Exactly one of `name` or `prefix` must be provided.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the namespace resource.
        If omitted, the provider-level region will be used. Changing this will create a new namespace resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _NamespaceState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 creation_timestamp: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 prefix: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Namespace resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Specifies an unstructured key value map for external parameters.
               Changing this will create a new namespace resource.
        :param pulumi.Input[str] cluster_id: Specifies the cluster ID to which the CCE namespace belongs.
               Changing this will create a new namespace resource.
        :param pulumi.Input[str] creation_timestamp: The server time when namespace was created.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Specifies the map of string keys and values for labels.
               Changing this will create a new namespace resource.
        :param pulumi.Input[str] name: Specifies the unique name of the namespace.
               This parameter can contain a maximum of 63 characters, which may consist of lowercase letters, digits and hyphens (-),
               and must start and end with lowercase letters and digits. Changing this will create a new namespace resource.
               Exactly one of `name` or `prefix` must be provided.
        :param pulumi.Input[str] prefix: Specifies a prefix used by the server to generate a unique name.
               This parameter can contain a maximum of 63 characters, which may consist of lowercase letters, digits and
               hyphens (-), and must start and end with lowercase letters and digits.
               Changing this will create a new namespace resource. Exactly one of `name` or `prefix` must be provided.
        :param pulumi.Input[str] region: Specifies the region in which to create the namespace resource.
               If omitted, the provider-level region will be used. Changing this will create a new namespace resource.
        :param pulumi.Input[str] status: The current phase of the namespace.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies an unstructured key value map for external parameters.
        Changing this will create a new namespace resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the cluster ID to which the CCE namespace belongs.
        Changing this will create a new namespace resource.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        The server time when namespace was created.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the map of string keys and values for labels.
        Changing this will create a new namespace resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the unique name of the namespace.
        This parameter can contain a maximum of 63 characters, which may consist of lowercase letters, digits and hyphens (-),
        and must start and end with lowercase letters and digits. Changing this will create a new namespace resource.
        Exactly one of `name` or `prefix` must be provided.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a prefix used by the server to generate a unique name.
        This parameter can contain a maximum of 63 characters, which may consist of lowercase letters, digits and
        hyphens (-), and must start and end with lowercase letters and digits.
        Changing this will create a new namespace resource. Exactly one of `name` or `prefix` must be provided.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the namespace resource.
        If omitted, the provider-level region will be used. Changing this will create a new namespace resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The current phase of the namespace.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class Namespace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 prefix: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a CCE namespace resource within HuaweiCloud.

        ## Example Usage
        ### Basic

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        cluster_id = config.require_object("clusterId")
        test = huaweicloud.cce.Namespace("test", cluster_id=cluster_id)
        ```

        ## Import

        CCE namespace can be imported using the cluster ID and namespace name separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Cce/namespace:Namespace test bb6923e4-b16e-11eb-b0cd-0255ac101da1/test-namespace
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Specifies an unstructured key value map for external parameters.
               Changing this will create a new namespace resource.
        :param pulumi.Input[str] cluster_id: Specifies the cluster ID to which the CCE namespace belongs.
               Changing this will create a new namespace resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Specifies the map of string keys and values for labels.
               Changing this will create a new namespace resource.
        :param pulumi.Input[str] name: Specifies the unique name of the namespace.
               This parameter can contain a maximum of 63 characters, which may consist of lowercase letters, digits and hyphens (-),
               and must start and end with lowercase letters and digits. Changing this will create a new namespace resource.
               Exactly one of `name` or `prefix` must be provided.
        :param pulumi.Input[str] prefix: Specifies a prefix used by the server to generate a unique name.
               This parameter can contain a maximum of 63 characters, which may consist of lowercase letters, digits and
               hyphens (-), and must start and end with lowercase letters and digits.
               Changing this will create a new namespace resource. Exactly one of `name` or `prefix` must be provided.
        :param pulumi.Input[str] region: Specifies the region in which to create the namespace resource.
               If omitted, the provider-level region will be used. Changing this will create a new namespace resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NamespaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a CCE namespace resource within HuaweiCloud.

        ## Example Usage
        ### Basic

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        cluster_id = config.require_object("clusterId")
        test = huaweicloud.cce.Namespace("test", cluster_id=cluster_id)
        ```

        ## Import

        CCE namespace can be imported using the cluster ID and namespace name separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Cce/namespace:Namespace test bb6923e4-b16e-11eb-b0cd-0255ac101da1/test-namespace
        ```

        :param str resource_name: The name of the resource.
        :param NamespaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NamespaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 prefix: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NamespaceArgs.__new__(NamespaceArgs)

            __props__.__dict__["annotations"] = annotations
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["prefix"] = prefix
            __props__.__dict__["region"] = region
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["status"] = None
        super(Namespace, __self__).__init__(
            'huaweicloud:Cce/namespace:Namespace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            creation_timestamp: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            prefix: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'Namespace':
        """
        Get an existing Namespace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Specifies an unstructured key value map for external parameters.
               Changing this will create a new namespace resource.
        :param pulumi.Input[str] cluster_id: Specifies the cluster ID to which the CCE namespace belongs.
               Changing this will create a new namespace resource.
        :param pulumi.Input[str] creation_timestamp: The server time when namespace was created.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Specifies the map of string keys and values for labels.
               Changing this will create a new namespace resource.
        :param pulumi.Input[str] name: Specifies the unique name of the namespace.
               This parameter can contain a maximum of 63 characters, which may consist of lowercase letters, digits and hyphens (-),
               and must start and end with lowercase letters and digits. Changing this will create a new namespace resource.
               Exactly one of `name` or `prefix` must be provided.
        :param pulumi.Input[str] prefix: Specifies a prefix used by the server to generate a unique name.
               This parameter can contain a maximum of 63 characters, which may consist of lowercase letters, digits and
               hyphens (-), and must start and end with lowercase letters and digits.
               Changing this will create a new namespace resource. Exactly one of `name` or `prefix` must be provided.
        :param pulumi.Input[str] region: Specifies the region in which to create the namespace resource.
               If omitted, the provider-level region will be used. Changing this will create a new namespace resource.
        :param pulumi.Input[str] status: The current phase of the namespace.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NamespaceState.__new__(_NamespaceState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["prefix"] = prefix
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        return Namespace(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Specifies an unstructured key value map for external parameters.
        Changing this will create a new namespace resource.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        Specifies the cluster ID to which the CCE namespace belongs.
        Changing this will create a new namespace resource.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[str]:
        """
        The server time when namespace was created.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Specifies the map of string keys and values for labels.
        Changing this will create a new namespace resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the unique name of the namespace.
        This parameter can contain a maximum of 63 characters, which may consist of lowercase letters, digits and hyphens (-),
        and must start and end with lowercase letters and digits. Changing this will create a new namespace resource.
        Exactly one of `name` or `prefix` must be provided.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def prefix(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies a prefix used by the server to generate a unique name.
        This parameter can contain a maximum of 63 characters, which may consist of lowercase letters, digits and
        hyphens (-), and must start and end with lowercase letters and digits.
        Changing this will create a new namespace resource. Exactly one of `name` or `prefix` must be provided.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the namespace resource.
        If omitted, the provider-level region will be used. Changing this will create a new namespace resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The current phase of the namespace.
        """
        return pulumi.get(self, "status")

