# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetClustersResult',
    'AwaitableGetClustersResult',
    'get_clusters',
    'get_clusters_output',
]

@pulumi.output_type
class GetClustersResult:
    """
    A collection of values returned by getClusters.
    """
    def __init__(__self__, cluster_id=None, cluster_type=None, clusters=None, enterprise_project_id=None, id=None, ids=None, name=None, region=None, status=None, vpc_id=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if cluster_type and not isinstance(cluster_type, str):
            raise TypeError("Expected argument 'cluster_type' to be a str")
        pulumi.set(__self__, "cluster_type", cluster_type)
        if clusters and not isinstance(clusters, list):
            raise TypeError("Expected argument 'clusters' to be a list")
        pulumi.set(__self__, "clusters", clusters)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[str]:
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> Optional[str]:
        """
        The type of the cluster. Possible values: **VirtualMachine**, **ARM64**.
        """
        return pulumi.get(self, "cluster_type")

    @property
    @pulumi.getter
    def clusters(self) -> Sequence['outputs.GetClustersClusterResult']:
        """
        Indicates a list of CCE clusters found. Structure is documented below.
        """
        return pulumi.get(self, "clusters")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[str]:
        """
        The enterprise project ID of the CCE cluster.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        """
        Indicates a list of IDs of all CCE clusters found.
        """
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The user name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the cluster.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[str]:
        """
        The vpc ID of the cluster.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetClustersResult(GetClustersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClustersResult(
            cluster_id=self.cluster_id,
            cluster_type=self.cluster_type,
            clusters=self.clusters,
            enterprise_project_id=self.enterprise_project_id,
            id=self.id,
            ids=self.ids,
            name=self.name,
            region=self.region,
            status=self.status,
            vpc_id=self.vpc_id)


def get_clusters(cluster_id: Optional[str] = None,
                 cluster_type: Optional[str] = None,
                 enterprise_project_id: Optional[str] = None,
                 name: Optional[str] = None,
                 region: Optional[str] = None,
                 status: Optional[str] = None,
                 vpc_id: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClustersResult:
    """
    Use this data source to get a list of CCE clusters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    cluster_name = config.require_object("clusterName")
    clusters = huaweicloud.Cce.get_clusters(name=cluster_name,
        status="Available")
    ```


    :param str cluster_id: Specifies the ID of the cluster.
    :param str cluster_type: Specifies the type of the cluster. Possible values: **VirtualMachine**, **BareMetal**.
    :param str enterprise_project_id: Specifies the enterprise project ID of the cluster.
    :param str name: Specifies the name of the cluster.
    :param str region: Specifies the region in which to obtain the CCE clusters. If omitted, the
           provider-level region will be used.
    :param str status: Specifies the status of the cluster.
    :param str vpc_id: Specifies the VPC ID to which the cluster belongs.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['clusterType'] = cluster_type
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['status'] = status
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Cce/getClusters:getClusters', __args__, opts=opts, typ=GetClustersResult).value

    return AwaitableGetClustersResult(
        cluster_id=__ret__.cluster_id,
        cluster_type=__ret__.cluster_type,
        clusters=__ret__.clusters,
        enterprise_project_id=__ret__.enterprise_project_id,
        id=__ret__.id,
        ids=__ret__.ids,
        name=__ret__.name,
        region=__ret__.region,
        status=__ret__.status,
        vpc_id=__ret__.vpc_id)


@_utilities.lift_output_func(get_clusters)
def get_clusters_output(cluster_id: Optional[pulumi.Input[Optional[str]]] = None,
                        cluster_type: Optional[pulumi.Input[Optional[str]]] = None,
                        enterprise_project_id: Optional[pulumi.Input[Optional[str]]] = None,
                        name: Optional[pulumi.Input[Optional[str]]] = None,
                        region: Optional[pulumi.Input[Optional[str]]] = None,
                        status: Optional[pulumi.Input[Optional[str]]] = None,
                        vpc_id: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetClustersResult]:
    """
    Use this data source to get a list of CCE clusters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    cluster_name = config.require_object("clusterName")
    clusters = huaweicloud.Cce.get_clusters(name=cluster_name,
        status="Available")
    ```


    :param str cluster_id: Specifies the ID of the cluster.
    :param str cluster_type: Specifies the type of the cluster. Possible values: **VirtualMachine**, **BareMetal**.
    :param str enterprise_project_id: Specifies the enterprise project ID of the cluster.
    :param str name: Specifies the name of the cluster.
    :param str region: Specifies the region in which to obtain the CCE clusters. If omitted, the
           provider-level region will be used.
    :param str status: Specifies the status of the cluster.
    :param str vpc_id: Specifies the VPC ID to which the cluster belongs.
    """
    ...
