# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['NetworkInstanceArgs', 'NetworkInstance']

@pulumi.input_type
class NetworkInstanceArgs:
    def __init__(__self__, *,
                 cidrs: pulumi.Input[Sequence[pulumi.Input[str]]],
                 cloud_connection_id: pulumi.Input[str],
                 instance_id: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 region_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 instance_domain_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a NetworkInstance resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cidrs: List of routes advertised by the VPC or virtual gateway.
        :param pulumi.Input[str] cloud_connection_id: Cloud connection ID.
        :param pulumi.Input[str] instance_id: ID of the VPC or virtual gateway to be loaded to the cloud connection.
        :param pulumi.Input[str] project_id: Project ID of the VPC or virtual gateway.
        :param pulumi.Input[str] region_id: Region ID of the VPC or virtual gateway.
        :param pulumi.Input[str] type: Type of the network instance to be loaded to the cloud connection.  
               The options are as follows:
               + **vpc**: Virtual Private Cloud.
               + **vgw**: virtual gateway.
        :param pulumi.Input[str] description: The description about the network instance.  
               The description can contain a maximum of 255 characters.
        :param pulumi.Input[str] instance_domain_id: Account ID of the VPC or virtual gateway.
        :param pulumi.Input[str] name: The network instance name.  
               The name can contain 1 to 64 characters, only letters, Chinese characters, digits, hyphens (-),
               underscores (_) and dots (.).
        :param pulumi.Input[str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "cidrs", cidrs)
        pulumi.set(__self__, "cloud_connection_id", cloud_connection_id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_domain_id is not None:
            pulumi.set(__self__, "instance_domain_id", instance_domain_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def cidrs(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of routes advertised by the VPC or virtual gateway.
        """
        return pulumi.get(self, "cidrs")

    @cidrs.setter
    def cidrs(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "cidrs", value)

    @property
    @pulumi.getter(name="cloudConnectionId")
    def cloud_connection_id(self) -> pulumi.Input[str]:
        """
        Cloud connection ID.
        """
        return pulumi.get(self, "cloud_connection_id")

    @cloud_connection_id.setter
    def cloud_connection_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cloud_connection_id", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        ID of the VPC or virtual gateway to be loaded to the cloud connection.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        Project ID of the VPC or virtual gateway.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Input[str]:
        """
        Region ID of the VPC or virtual gateway.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "region_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of the network instance to be loaded to the cloud connection.  
        The options are as follows:
        + **vpc**: Virtual Private Cloud.
        + **vgw**: virtual gateway.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description about the network instance.  
        The description can contain a maximum of 255 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="instanceDomainId")
    def instance_domain_id(self) -> Optional[pulumi.Input[str]]:
        """
        Account ID of the VPC or virtual gateway.
        """
        return pulumi.get(self, "instance_domain_id")

    @instance_domain_id.setter
    def instance_domain_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_domain_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The network instance name.  
        The name can contain 1 to 64 characters, only letters, Chinese characters, digits, hyphens (-),
        underscores (_) and dots (.).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _NetworkInstanceState:
    def __init__(__self__, *,
                 cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cloud_connection_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 domain_id: Optional[pulumi.Input[str]] = None,
                 instance_domain_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 region_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering NetworkInstance resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cidrs: List of routes advertised by the VPC or virtual gateway.
        :param pulumi.Input[str] cloud_connection_id: Cloud connection ID.
        :param pulumi.Input[str] description: The description about the network instance.  
               The description can contain a maximum of 255 characters.
        :param pulumi.Input[str] domain_id: Account ID.
        :param pulumi.Input[str] instance_domain_id: Account ID of the VPC or virtual gateway.
        :param pulumi.Input[str] instance_id: ID of the VPC or virtual gateway to be loaded to the cloud connection.
        :param pulumi.Input[str] name: The network instance name.  
               The name can contain 1 to 64 characters, only letters, Chinese characters, digits, hyphens (-),
               underscores (_) and dots (.).
        :param pulumi.Input[str] project_id: Project ID of the VPC or virtual gateway.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] region_id: Region ID of the VPC or virtual gateway.
        :param pulumi.Input[str] status: Network instance status.  
               The options are as follows:
               + **ACTIVE**: The network instance is available.
        :param pulumi.Input[str] type: Type of the network instance to be loaded to the cloud connection.  
               The options are as follows:
               + **vpc**: Virtual Private Cloud.
               + **vgw**: virtual gateway.
        """
        if cidrs is not None:
            pulumi.set(__self__, "cidrs", cidrs)
        if cloud_connection_id is not None:
            pulumi.set(__self__, "cloud_connection_id", cloud_connection_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_id is not None:
            pulumi.set(__self__, "domain_id", domain_id)
        if instance_domain_id is not None:
            pulumi.set(__self__, "instance_domain_id", instance_domain_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of routes advertised by the VPC or virtual gateway.
        """
        return pulumi.get(self, "cidrs")

    @cidrs.setter
    def cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "cidrs", value)

    @property
    @pulumi.getter(name="cloudConnectionId")
    def cloud_connection_id(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud connection ID.
        """
        return pulumi.get(self, "cloud_connection_id")

    @cloud_connection_id.setter
    def cloud_connection_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_connection_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description about the network instance.  
        The description can contain a maximum of 255 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[pulumi.Input[str]]:
        """
        Account ID.
        """
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_id", value)

    @property
    @pulumi.getter(name="instanceDomainId")
    def instance_domain_id(self) -> Optional[pulumi.Input[str]]:
        """
        Account ID of the VPC or virtual gateway.
        """
        return pulumi.get(self, "instance_domain_id")

    @instance_domain_id.setter
    def instance_domain_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_domain_id", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the VPC or virtual gateway to be loaded to the cloud connection.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The network instance name.  
        The name can contain 1 to 64 characters, only letters, Chinese characters, digits, hyphens (-),
        underscores (_) and dots (.).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Project ID of the VPC or virtual gateway.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[str]]:
        """
        Region ID of the VPC or virtual gateway.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Network instance status.  
        The options are as follows:
        + **ACTIVE**: The network instance is available.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the network instance to be loaded to the cloud connection.  
        The options are as follows:
        + **vpc**: Virtual Private Cloud.
        + **vgw**: virtual gateway.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class NetworkInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cloud_connection_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_domain_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 region_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a network instance resource within HuaweiCloud.

        Load VPCs or virtual gateways to the cloud connection. If you load virtual gateways, your on-premises data center
        can access multiple VPCs to build a hybrid cloud.

        Each network instance can be loaded onto only one cloud connection.

        ## Import

        The network instance can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Cc/networkInstance:NetworkInstance test 0ce123456a00f2591fabc00385ff1234
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cidrs: List of routes advertised by the VPC or virtual gateway.
        :param pulumi.Input[str] cloud_connection_id: Cloud connection ID.
        :param pulumi.Input[str] description: The description about the network instance.  
               The description can contain a maximum of 255 characters.
        :param pulumi.Input[str] instance_domain_id: Account ID of the VPC or virtual gateway.
        :param pulumi.Input[str] instance_id: ID of the VPC or virtual gateway to be loaded to the cloud connection.
        :param pulumi.Input[str] name: The network instance name.  
               The name can contain 1 to 64 characters, only letters, Chinese characters, digits, hyphens (-),
               underscores (_) and dots (.).
        :param pulumi.Input[str] project_id: Project ID of the VPC or virtual gateway.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] region_id: Region ID of the VPC or virtual gateway.
        :param pulumi.Input[str] type: Type of the network instance to be loaded to the cloud connection.  
               The options are as follows:
               + **vpc**: Virtual Private Cloud.
               + **vgw**: virtual gateway.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a network instance resource within HuaweiCloud.

        Load VPCs or virtual gateways to the cloud connection. If you load virtual gateways, your on-premises data center
        can access multiple VPCs to build a hybrid cloud.

        Each network instance can be loaded onto only one cloud connection.

        ## Import

        The network instance can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Cc/networkInstance:NetworkInstance test 0ce123456a00f2591fabc00385ff1234
        ```

        :param str resource_name: The name of the resource.
        :param NetworkInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cloud_connection_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_domain_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 region_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkInstanceArgs.__new__(NetworkInstanceArgs)

            if cidrs is None and not opts.urn:
                raise TypeError("Missing required property 'cidrs'")
            __props__.__dict__["cidrs"] = cidrs
            if cloud_connection_id is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_connection_id'")
            __props__.__dict__["cloud_connection_id"] = cloud_connection_id
            __props__.__dict__["description"] = description
            __props__.__dict__["instance_domain_id"] = instance_domain_id
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            if region_id is None and not opts.urn:
                raise TypeError("Missing required property 'region_id'")
            __props__.__dict__["region_id"] = region_id
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["domain_id"] = None
            __props__.__dict__["status"] = None
        super(NetworkInstance, __self__).__init__(
            'huaweicloud:Cc/networkInstance:NetworkInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            cloud_connection_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            domain_id: Optional[pulumi.Input[str]] = None,
            instance_domain_id: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            region_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'NetworkInstance':
        """
        Get an existing NetworkInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cidrs: List of routes advertised by the VPC or virtual gateway.
        :param pulumi.Input[str] cloud_connection_id: Cloud connection ID.
        :param pulumi.Input[str] description: The description about the network instance.  
               The description can contain a maximum of 255 characters.
        :param pulumi.Input[str] domain_id: Account ID.
        :param pulumi.Input[str] instance_domain_id: Account ID of the VPC or virtual gateway.
        :param pulumi.Input[str] instance_id: ID of the VPC or virtual gateway to be loaded to the cloud connection.
        :param pulumi.Input[str] name: The network instance name.  
               The name can contain 1 to 64 characters, only letters, Chinese characters, digits, hyphens (-),
               underscores (_) and dots (.).
        :param pulumi.Input[str] project_id: Project ID of the VPC or virtual gateway.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] region_id: Region ID of the VPC or virtual gateway.
        :param pulumi.Input[str] status: Network instance status.  
               The options are as follows:
               + **ACTIVE**: The network instance is available.
        :param pulumi.Input[str] type: Type of the network instance to be loaded to the cloud connection.  
               The options are as follows:
               + **vpc**: Virtual Private Cloud.
               + **vgw**: virtual gateway.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkInstanceState.__new__(_NetworkInstanceState)

        __props__.__dict__["cidrs"] = cidrs
        __props__.__dict__["cloud_connection_id"] = cloud_connection_id
        __props__.__dict__["description"] = description
        __props__.__dict__["domain_id"] = domain_id
        __props__.__dict__["instance_domain_id"] = instance_domain_id
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["status"] = status
        __props__.__dict__["type"] = type
        return NetworkInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def cidrs(self) -> pulumi.Output[Sequence[str]]:
        """
        List of routes advertised by the VPC or virtual gateway.
        """
        return pulumi.get(self, "cidrs")

    @property
    @pulumi.getter(name="cloudConnectionId")
    def cloud_connection_id(self) -> pulumi.Output[str]:
        """
        Cloud connection ID.
        """
        return pulumi.get(self, "cloud_connection_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description about the network instance.  
        The description can contain a maximum of 255 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Output[str]:
        """
        Account ID.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="instanceDomainId")
    def instance_domain_id(self) -> pulumi.Output[str]:
        """
        Account ID of the VPC or virtual gateway.
        """
        return pulumi.get(self, "instance_domain_id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        ID of the VPC or virtual gateway to be loaded to the cloud connection.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The network instance name.  
        The name can contain 1 to 64 characters, only letters, Chinese characters, digits, hyphens (-),
        underscores (_) and dots (.).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        Project ID of the VPC or virtual gateway.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[str]:
        """
        Region ID of the VPC or virtual gateway.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Network instance status.  
        The options are as follows:
        + **ACTIVE**: The network instance is available.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Type of the network instance to be loaded to the cloud connection.  
        The options are as follows:
        + **vpc**: Virtual Private Cloud.
        + **vgw**: virtual gateway.
        """
        return pulumi.get(self, "type")

