# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ConnectionArgs', 'Connection']

@pulumi.input_type
class ConnectionArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Connection resource.
        :param pulumi.Input[str] description: The Description about the cloud connection.  
               The description can contain a maximum of 255 characters.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the cloud connection.  
               Value 0 indicates the default enterprise project.
        :param pulumi.Input[str] name: The cloud connection name.  
               The name can contain 1 to 64 characters, only letters, Chinese characters, digits, hyphens (-),
               underscores (_) and dots (.).
        :param pulumi.Input[str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The Description about the cloud connection.  
        The description can contain a maximum of 255 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The enterprise project id of the cloud connection.  
        Value 0 indicates the default enterprise project.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The cloud connection name.  
        The name can contain 1 to 64 characters, only letters, Chinese characters, digits, hyphens (-),
        underscores (_) and dots (.).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ConnectionState:
    def __init__(__self__, *,
                 bandwidth_package_number: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 domain_id: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 inter_region_bandwidth_number: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_instance_number: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 used_scene: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Connection resources.
        :param pulumi.Input[int] bandwidth_package_number: The number of bandwidth packages associated with the cloud connection instance.
        :param pulumi.Input[str] description: The Description about the cloud connection.  
               The description can contain a maximum of 255 characters.
        :param pulumi.Input[str] domain_id: The Domain ID.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the cloud connection.  
               Value 0 indicates the default enterprise project.
        :param pulumi.Input[int] inter_region_bandwidth_number: The number of inter-domain bandwidths associated with the cloud connection instance.
        :param pulumi.Input[str] name: The cloud connection name.  
               The name can contain 1 to 64 characters, only letters, Chinese characters, digits, hyphens (-),
               underscores (_) and dots (.).
        :param pulumi.Input[int] network_instance_number: The number of network instances associated with the cloud connection instance.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] status: The status of the cloud connection.  
               The options are as follows:
               + **ACTIVE**: Device deleted.
        :param pulumi.Input[str] used_scene: The Scenario.  
               The options are as follows:
               + **vpc**: VPCs or virtual gateways can use this cloud connection.
        """
        if bandwidth_package_number is not None:
            pulumi.set(__self__, "bandwidth_package_number", bandwidth_package_number)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_id is not None:
            pulumi.set(__self__, "domain_id", domain_id)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if inter_region_bandwidth_number is not None:
            pulumi.set(__self__, "inter_region_bandwidth_number", inter_region_bandwidth_number)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_instance_number is not None:
            pulumi.set(__self__, "network_instance_number", network_instance_number)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if used_scene is not None:
            pulumi.set(__self__, "used_scene", used_scene)

    @property
    @pulumi.getter(name="bandwidthPackageNumber")
    def bandwidth_package_number(self) -> Optional[pulumi.Input[int]]:
        """
        The number of bandwidth packages associated with the cloud connection instance.
        """
        return pulumi.get(self, "bandwidth_package_number")

    @bandwidth_package_number.setter
    def bandwidth_package_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth_package_number", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The Description about the cloud connection.  
        The description can contain a maximum of 255 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Domain ID.
        """
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_id", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The enterprise project id of the cloud connection.  
        Value 0 indicates the default enterprise project.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="interRegionBandwidthNumber")
    def inter_region_bandwidth_number(self) -> Optional[pulumi.Input[int]]:
        """
        The number of inter-domain bandwidths associated with the cloud connection instance.
        """
        return pulumi.get(self, "inter_region_bandwidth_number")

    @inter_region_bandwidth_number.setter
    def inter_region_bandwidth_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "inter_region_bandwidth_number", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The cloud connection name.  
        The name can contain 1 to 64 characters, only letters, Chinese characters, digits, hyphens (-),
        underscores (_) and dots (.).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkInstanceNumber")
    def network_instance_number(self) -> Optional[pulumi.Input[int]]:
        """
        The number of network instances associated with the cloud connection instance.
        """
        return pulumi.get(self, "network_instance_number")

    @network_instance_number.setter
    def network_instance_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "network_instance_number", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the cloud connection.  
        The options are as follows:
        + **ACTIVE**: Device deleted.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="usedScene")
    def used_scene(self) -> Optional[pulumi.Input[str]]:
        """
        The Scenario.  
        The options are as follows:
        + **vpc**: VPCs or virtual gateways can use this cloud connection.
        """
        return pulumi.get(self, "used_scene")

    @used_scene.setter
    def used_scene(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "used_scene", value)


class Connection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a Cloud Connection resource within HuaweiCloud.

        Cloud Connect (CC) is a service that enables you to quickly build ultra-fast, high-quality, and stable networks
        between VPCs across regions and between VPCs and on-premises data centers.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test = huaweicloud.cc.Connection("test")
        ```

        ## Import

        The cloud connection can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Cc/connection:Connection test 0ce123456a00f2591fabc00385ff1234
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The Description about the cloud connection.  
               The description can contain a maximum of 255 characters.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the cloud connection.  
               Value 0 indicates the default enterprise project.
        :param pulumi.Input[str] name: The cloud connection name.  
               The name can contain 1 to 64 characters, only letters, Chinese characters, digits, hyphens (-),
               underscores (_) and dots (.).
        :param pulumi.Input[str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ConnectionArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Cloud Connection resource within HuaweiCloud.

        Cloud Connect (CC) is a service that enables you to quickly build ultra-fast, high-quality, and stable networks
        between VPCs across regions and between VPCs and on-premises data centers.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test = huaweicloud.cc.Connection("test")
        ```

        ## Import

        The cloud connection can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Cc/connection:Connection test 0ce123456a00f2591fabc00385ff1234
        ```

        :param str resource_name: The name of the resource.
        :param ConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionArgs.__new__(ConnectionArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["bandwidth_package_number"] = None
            __props__.__dict__["domain_id"] = None
            __props__.__dict__["inter_region_bandwidth_number"] = None
            __props__.__dict__["network_instance_number"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["used_scene"] = None
        super(Connection, __self__).__init__(
            'huaweicloud:Cc/connection:Connection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bandwidth_package_number: Optional[pulumi.Input[int]] = None,
            description: Optional[pulumi.Input[str]] = None,
            domain_id: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            inter_region_bandwidth_number: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_instance_number: Optional[pulumi.Input[int]] = None,
            region: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            used_scene: Optional[pulumi.Input[str]] = None) -> 'Connection':
        """
        Get an existing Connection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] bandwidth_package_number: The number of bandwidth packages associated with the cloud connection instance.
        :param pulumi.Input[str] description: The Description about the cloud connection.  
               The description can contain a maximum of 255 characters.
        :param pulumi.Input[str] domain_id: The Domain ID.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the cloud connection.  
               Value 0 indicates the default enterprise project.
        :param pulumi.Input[int] inter_region_bandwidth_number: The number of inter-domain bandwidths associated with the cloud connection instance.
        :param pulumi.Input[str] name: The cloud connection name.  
               The name can contain 1 to 64 characters, only letters, Chinese characters, digits, hyphens (-),
               underscores (_) and dots (.).
        :param pulumi.Input[int] network_instance_number: The number of network instances associated with the cloud connection instance.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] status: The status of the cloud connection.  
               The options are as follows:
               + **ACTIVE**: Device deleted.
        :param pulumi.Input[str] used_scene: The Scenario.  
               The options are as follows:
               + **vpc**: VPCs or virtual gateways can use this cloud connection.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectionState.__new__(_ConnectionState)

        __props__.__dict__["bandwidth_package_number"] = bandwidth_package_number
        __props__.__dict__["description"] = description
        __props__.__dict__["domain_id"] = domain_id
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["inter_region_bandwidth_number"] = inter_region_bandwidth_number
        __props__.__dict__["name"] = name
        __props__.__dict__["network_instance_number"] = network_instance_number
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["used_scene"] = used_scene
        return Connection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bandwidthPackageNumber")
    def bandwidth_package_number(self) -> pulumi.Output[int]:
        """
        The number of bandwidth packages associated with the cloud connection instance.
        """
        return pulumi.get(self, "bandwidth_package_number")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The Description about the cloud connection.  
        The description can contain a maximum of 255 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Output[str]:
        """
        The Domain ID.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        The enterprise project id of the cloud connection.  
        Value 0 indicates the default enterprise project.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter(name="interRegionBandwidthNumber")
    def inter_region_bandwidth_number(self) -> pulumi.Output[int]:
        """
        The number of inter-domain bandwidths associated with the cloud connection instance.
        """
        return pulumi.get(self, "inter_region_bandwidth_number")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The cloud connection name.  
        The name can contain 1 to 64 characters, only letters, Chinese characters, digits, hyphens (-),
        underscores (_) and dots (.).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkInstanceNumber")
    def network_instance_number(self) -> pulumi.Output[int]:
        """
        The number of network instances associated with the cloud connection instance.
        """
        return pulumi.get(self, "network_instance_number")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the cloud connection.  
        The options are as follows:
        + **ACTIVE**: Device deleted.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="usedScene")
    def used_scene(self) -> pulumi.Output[str]:
        """
        The Scenario.  
        The options are as follows:
        + **vpc**: VPCs or virtual gateways can use this cloud connection.
        """
        return pulumi.get(self, "used_scene")

