# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVaultsResult',
    'AwaitableGetVaultsResult',
    'get_vaults',
    'get_vaults_output',
]

@pulumi.output_type
class GetVaultsResult:
    """
    A collection of values returned by getVaults.
    """
    def __init__(__self__, auto_expand_enabled=None, consistent_level=None, enterprise_project_id=None, id=None, name=None, policy_id=None, protection_type=None, region=None, size=None, status=None, type=None, vaults=None):
        if auto_expand_enabled and not isinstance(auto_expand_enabled, bool):
            raise TypeError("Expected argument 'auto_expand_enabled' to be a bool")
        pulumi.set(__self__, "auto_expand_enabled", auto_expand_enabled)
        if consistent_level and not isinstance(consistent_level, str):
            raise TypeError("Expected argument 'consistent_level' to be a str")
        pulumi.set(__self__, "consistent_level", consistent_level)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if policy_id and not isinstance(policy_id, str):
            raise TypeError("Expected argument 'policy_id' to be a str")
        pulumi.set(__self__, "policy_id", policy_id)
        if protection_type and not isinstance(protection_type, str):
            raise TypeError("Expected argument 'protection_type' to be a str")
        pulumi.set(__self__, "protection_type", protection_type)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if size and not isinstance(size, int):
            raise TypeError("Expected argument 'size' to be a int")
        pulumi.set(__self__, "size", size)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if vaults and not isinstance(vaults, list):
            raise TypeError("Expected argument 'vaults' to be a list")
        pulumi.set(__self__, "vaults", vaults)

    @property
    @pulumi.getter(name="autoExpandEnabled")
    def auto_expand_enabled(self) -> Optional[bool]:
        """
        Whether to enable automatic expansion of the backup protection type vault.
        """
        return pulumi.get(self, "auto_expand_enabled")

    @property
    @pulumi.getter(name="consistentLevel")
    def consistent_level(self) -> Optional[str]:
        """
        The backup specifications.
        """
        return pulumi.get(self, "consistent_level")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[str]:
        """
        The enterprise project ID.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The CBR vault name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        The policy associated with the CBR vault.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="protectionType")
    def protection_type(self) -> Optional[str]:
        """
        The protection type of the CBR vault.
        """
        return pulumi.get(self, "protection_type")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def size(self) -> Optional[int]:
        """
        The vault capacity, in GB.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The vault status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The object type of the CBR vault.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def vaults(self) -> Optional[Sequence['outputs.GetVaultsVaultResult']]:
        """
        List of CBR vault details. The object structure of each CBR vault is documented below.
        """
        return pulumi.get(self, "vaults")


class AwaitableGetVaultsResult(GetVaultsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVaultsResult(
            auto_expand_enabled=self.auto_expand_enabled,
            consistent_level=self.consistent_level,
            enterprise_project_id=self.enterprise_project_id,
            id=self.id,
            name=self.name,
            policy_id=self.policy_id,
            protection_type=self.protection_type,
            region=self.region,
            size=self.size,
            status=self.status,
            type=self.type,
            vaults=self.vaults)


def get_vaults(auto_expand_enabled: Optional[bool] = None,
               consistent_level: Optional[str] = None,
               enterprise_project_id: Optional[str] = None,
               name: Optional[str] = None,
               policy_id: Optional[str] = None,
               protection_type: Optional[str] = None,
               region: Optional[str] = None,
               size: Optional[int] = None,
               status: Optional[str] = None,
               type: Optional[str] = None,
               vaults: Optional[Sequence[pulumi.InputType['GetVaultsVaultArgs']]] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVaultsResult:
    """
    Use this data source to get available CBR vaults within Huaweicloud.

    ## Example Usage
    ### Get vaults for all server type

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    test = huaweicloud.Cbr.get_vaults(type="server")
    ```


    :param bool auto_expand_enabled: Specifies whether to enable automatic expansion of the backup protection
           type vault. Default to **false**.
    :param str consistent_level: Specifies the backup specifications.
           The valid values are as follows:
           + **[crash_consistent](https://support.huaweicloud.com/intl/en-us/usermanual-cbr/cbr_03_0109.html)**
           + **[app_consistent](https://support.huaweicloud.com/intl/en-us/usermanual-cbr/cbr_03_0109.html)**
    :param str enterprise_project_id: Specifies a unique ID in UUID format of enterprise project.
    :param str name: Specifies a unique name of the CBR vault. This parameter can contain a maximum of 64
           characters, which may consist of letters, digits, underscores(_) and hyphens (-).
    :param str policy_id: Specifies a policy to associate with the CBR vault.
           The `policy_id` cannot be used with the vault of replicate protection type.
    :param str protection_type: Specifies the protection type of the CBR vault.
           The valid values are **backup** and **replication**. Vaults of type **disk** don't support **replication**.
    :param str region: Specifies the region in which to query the CBR vaults.
           If omitted, the provider-level region will be used.
    :param int size: Specifies the vault sapacity, in GB. The valid value range is `1` to `10,485,760`.
    :param str status: Specifies the CBR vault status, including **available**, **lock**, **frozen** and **error**.
    :param str type: Specifies the object type of the CBR vault. The vaild values are as follows:
           + **server** (Cloud Servers)
           + **disk** (EVS Disks)
           + **turbo** (SFS Turbo file systems)
    :param Sequence[pulumi.InputType['GetVaultsVaultArgs']] vaults: List of CBR vault details. The object structure of each CBR vault is documented below.
    """
    __args__ = dict()
    __args__['autoExpandEnabled'] = auto_expand_enabled
    __args__['consistentLevel'] = consistent_level
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['name'] = name
    __args__['policyId'] = policy_id
    __args__['protectionType'] = protection_type
    __args__['region'] = region
    __args__['size'] = size
    __args__['status'] = status
    __args__['type'] = type
    __args__['vaults'] = vaults
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Cbr/getVaults:getVaults', __args__, opts=opts, typ=GetVaultsResult).value

    return AwaitableGetVaultsResult(
        auto_expand_enabled=__ret__.auto_expand_enabled,
        consistent_level=__ret__.consistent_level,
        enterprise_project_id=__ret__.enterprise_project_id,
        id=__ret__.id,
        name=__ret__.name,
        policy_id=__ret__.policy_id,
        protection_type=__ret__.protection_type,
        region=__ret__.region,
        size=__ret__.size,
        status=__ret__.status,
        type=__ret__.type,
        vaults=__ret__.vaults)


@_utilities.lift_output_func(get_vaults)
def get_vaults_output(auto_expand_enabled: Optional[pulumi.Input[Optional[bool]]] = None,
                      consistent_level: Optional[pulumi.Input[Optional[str]]] = None,
                      enterprise_project_id: Optional[pulumi.Input[Optional[str]]] = None,
                      name: Optional[pulumi.Input[Optional[str]]] = None,
                      policy_id: Optional[pulumi.Input[Optional[str]]] = None,
                      protection_type: Optional[pulumi.Input[Optional[str]]] = None,
                      region: Optional[pulumi.Input[Optional[str]]] = None,
                      size: Optional[pulumi.Input[Optional[int]]] = None,
                      status: Optional[pulumi.Input[Optional[str]]] = None,
                      type: Optional[pulumi.Input[Optional[str]]] = None,
                      vaults: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetVaultsVaultArgs']]]]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVaultsResult]:
    """
    Use this data source to get available CBR vaults within Huaweicloud.

    ## Example Usage
    ### Get vaults for all server type

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    test = huaweicloud.Cbr.get_vaults(type="server")
    ```


    :param bool auto_expand_enabled: Specifies whether to enable automatic expansion of the backup protection
           type vault. Default to **false**.
    :param str consistent_level: Specifies the backup specifications.
           The valid values are as follows:
           + **[crash_consistent](https://support.huaweicloud.com/intl/en-us/usermanual-cbr/cbr_03_0109.html)**
           + **[app_consistent](https://support.huaweicloud.com/intl/en-us/usermanual-cbr/cbr_03_0109.html)**
    :param str enterprise_project_id: Specifies a unique ID in UUID format of enterprise project.
    :param str name: Specifies a unique name of the CBR vault. This parameter can contain a maximum of 64
           characters, which may consist of letters, digits, underscores(_) and hyphens (-).
    :param str policy_id: Specifies a policy to associate with the CBR vault.
           The `policy_id` cannot be used with the vault of replicate protection type.
    :param str protection_type: Specifies the protection type of the CBR vault.
           The valid values are **backup** and **replication**. Vaults of type **disk** don't support **replication**.
    :param str region: Specifies the region in which to query the CBR vaults.
           If omitted, the provider-level region will be used.
    :param int size: Specifies the vault sapacity, in GB. The valid value range is `1` to `10,485,760`.
    :param str status: Specifies the CBR vault status, including **available**, **lock**, **frozen** and **error**.
    :param str type: Specifies the object type of the CBR vault. The vaild values are as follows:
           + **server** (Cloud Servers)
           + **disk** (EVS Disks)
           + **turbo** (SFS Turbo file systems)
    :param Sequence[pulumi.InputType['GetVaultsVaultArgs']] vaults: List of CBR vault details. The object structure of each CBR vault is documented below.
    """
    ...
