# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetFlavorsResult',
    'AwaitableGetFlavorsResult',
    'get_flavors',
    'get_flavors_output',
]

@pulumi.output_type
class GetFlavorsResult:
    """
    A collection of values returned by getFlavors.
    """
    def __init__(__self__, availability_zone=None, cpu_arch=None, flavors=None, id=None, memory=None, region=None, vcpus=None):
        if availability_zone and not isinstance(availability_zone, str):
            raise TypeError("Expected argument 'availability_zone' to be a str")
        pulumi.set(__self__, "availability_zone", availability_zone)
        if cpu_arch and not isinstance(cpu_arch, str):
            raise TypeError("Expected argument 'cpu_arch' to be a str")
        pulumi.set(__self__, "cpu_arch", cpu_arch)
        if flavors and not isinstance(flavors, list):
            raise TypeError("Expected argument 'flavors' to be a list")
        pulumi.set(__self__, "flavors", flavors)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if memory and not isinstance(memory, int):
            raise TypeError("Expected argument 'memory' to be a int")
        pulumi.set(__self__, "memory", memory)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if vcpus and not isinstance(vcpus, int):
            raise TypeError("Expected argument 'vcpus' to be a int")
        pulumi.set(__self__, "vcpus", vcpus)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[str]:
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="cpuArch")
    def cpu_arch(self) -> Optional[str]:
        """
        The CPU architecture of the BMS flavor.
        """
        return pulumi.get(self, "cpu_arch")

    @property
    @pulumi.getter
    def flavors(self) -> Sequence['outputs.GetFlavorsFlavorResult']:
        """
        Indicates the flavors information. Structure is documented below.
        """
        return pulumi.get(self, "flavors")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def memory(self) -> Optional[int]:
        """
        The memory size in GB.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def vcpus(self) -> Optional[int]:
        """
        The number of vCPUs.
        """
        return pulumi.get(self, "vcpus")


class AwaitableGetFlavorsResult(GetFlavorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFlavorsResult(
            availability_zone=self.availability_zone,
            cpu_arch=self.cpu_arch,
            flavors=self.flavors,
            id=self.id,
            memory=self.memory,
            region=self.region,
            vcpus=self.vcpus)


def get_flavors(availability_zone: Optional[str] = None,
                cpu_arch: Optional[str] = None,
                memory: Optional[int] = None,
                region: Optional[str] = None,
                vcpus: Optional[int] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFlavorsResult:
    """
    Use this data source to get available BMS flavors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    demo = huaweicloud.Bms.get_flavors(availability_zone="cn-north-1a",
        vcpus=48)
    # Create BMS instance with the matched flavor
    instance = huaweicloud.bms.Instance("instance", flavor_id=demo.flavors[0].id)
    # Other properties...
    ```


    :param str availability_zone: Specifies the AZ name.
    :param str cpu_arch: Specifies the CPU architecture of the BMS flavor.
           The value can be x86_64 and aarch64, defaults to **x86_64**.
    :param int memory: Specifies the memory size(GB) in the BMS flavor.
    :param str region: The region in which to obtain the flavors.
           If omitted, the provider-level region will be used.
    :param int vcpus: Specifies the number of vCPUs in the BMS flavor.
    """
    __args__ = dict()
    __args__['availabilityZone'] = availability_zone
    __args__['cpuArch'] = cpu_arch
    __args__['memory'] = memory
    __args__['region'] = region
    __args__['vcpus'] = vcpus
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Bms/getFlavors:getFlavors', __args__, opts=opts, typ=GetFlavorsResult).value

    return AwaitableGetFlavorsResult(
        availability_zone=__ret__.availability_zone,
        cpu_arch=__ret__.cpu_arch,
        flavors=__ret__.flavors,
        id=__ret__.id,
        memory=__ret__.memory,
        region=__ret__.region,
        vcpus=__ret__.vcpus)


@_utilities.lift_output_func(get_flavors)
def get_flavors_output(availability_zone: Optional[pulumi.Input[Optional[str]]] = None,
                       cpu_arch: Optional[pulumi.Input[Optional[str]]] = None,
                       memory: Optional[pulumi.Input[Optional[int]]] = None,
                       region: Optional[pulumi.Input[Optional[str]]] = None,
                       vcpus: Optional[pulumi.Input[Optional[int]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFlavorsResult]:
    """
    Use this data source to get available BMS flavors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    demo = huaweicloud.Bms.get_flavors(availability_zone="cn-north-1a",
        vcpus=48)
    # Create BMS instance with the matched flavor
    instance = huaweicloud.bms.Instance("instance", flavor_id=demo.flavors[0].id)
    # Other properties...
    ```


    :param str availability_zone: Specifies the AZ name.
    :param str cpu_arch: Specifies the CPU architecture of the BMS flavor.
           The value can be x86_64 and aarch64, defaults to **x86_64**.
    :param int memory: Specifies the memory size(GB) in the BMS flavor.
    :param str region: The region in which to obtain the flavors.
           If omitted, the provider-level region will be used.
    :param int vcpus: Specifies the number of vCPUs in the BMS flavor.
    """
    ...
