# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 cce_cluster_id: pulumi.Input[str],
                 consensus: pulumi.Input[str],
                 edition: pulumi.Input[int],
                 enterprise_project_id: pulumi.Input[str],
                 fabric_version: pulumi.Input[str],
                 orderer_node_num: pulumi.Input[int],
                 org_disk_size: pulumi.Input[int],
                 password: pulumi.Input[str],
                 volume_type: pulumi.Input[str],
                 block_info: Optional[pulumi.Input['InstanceBlockInfoArgs']] = None,
                 blockchain_type: Optional[pulumi.Input[str]] = None,
                 channels: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceChannelArgs']]]] = None,
                 couchdb: Optional[pulumi.Input['InstanceCouchdbArgs']] = None,
                 database_type: Optional[pulumi.Input[str]] = None,
                 delete_obs: Optional[pulumi.Input[bool]] = None,
                 delete_storage: Optional[pulumi.Input[bool]] = None,
                 eip_enable: Optional[pulumi.Input[bool]] = None,
                 kafka: Optional[pulumi.Input['InstanceKafkaArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 peer_orgs: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePeerOrgArgs']]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 restful_api_support: Optional[pulumi.Input[bool]] = None,
                 security_mechanism: Optional[pulumi.Input[str]] = None,
                 sfs_turbo: Optional[pulumi.Input['InstanceSfsTurboArgs']] = None,
                 tc3_need: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[str] cce_cluster_id: Specifies the ID of the CCE cluster to attach to the BCS instance. The
               BCS service needs to exclusively occupy the CCE cluster. Please make sure that the CCE cluster is not occupied before
               deploying the BCS service. Changing this will create a new instance.
        :param pulumi.Input[str] consensus: Specifies the consensus algorithm used by the BCS instance. The valid
               values of fabric 1.4 are `solo`, `kafka` and `SFLIC`, and the valid values of fabric 2.0 are `SFLIC`
               and `etcdraft`. Changing this will create a new instance.
        :param pulumi.Input[int] edition: Specifies Service edition of the BCS instance. Valid values are `1`, `2` and `4`
               . Changing this will create a new instance.
        :param pulumi.Input[str] enterprise_project_id: Specifies the ID of the enterprise project that the BCS
               instance belong to. Changing this will create a new instance.
        :param pulumi.Input[str] fabric_version: Specifies version of fabric for the BCS instance. Valid values
               are `1.4` and `2.0`
               Changing this will create a new instance.
        :param pulumi.Input[int] orderer_node_num: Specifies the number of peers in the orderer organizaion. Changing this
               will create a new instance.
        :param pulumi.Input[int] org_disk_size: Specifies the storage capacity of peer organization. Changing this will
               create a new instance.
               + The minimum storage capacity of `efs` volume type is 500GB.
        :param pulumi.Input[str] password: Specifies the password of the couch datebase. The password consists of 8 to
               26 characters and must consist at least three of following: uppercase letters, lowercase letters, digits, special
               charactors(!@$%^-_=+[{}]:,./?). Changing this creates a new instance.
        :param pulumi.Input[str] volume_type: Specifies the storage volume type to attach to each organization of the
               BCS instance. Valid values are `nfs` (SFS) and `efs` (SFS Turbo). Changing this will create a new instance.
        :param pulumi.Input['InstanceBlockInfoArgs'] block_info: Specifies the configuration of block generation. The block_info object
               structure is documented below.
        :param pulumi.Input[str] blockchain_type: Specifies the blockchain type of the BCS instance. Valid values
               are `private` and  `union`. Default is `private`. Changing this will create a new instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceChannelArgs']]] channels: Specifies an array of one or more channels to attach to the BCS instance. If
               omitted, the bcs instance will create a `channels` named `channel` by default. Changing this will create a new
               instance. The channels object structure is documented below.
        :param pulumi.Input['InstanceCouchdbArgs'] couchdb: Specifies the NoSQL database used by BCS instance. If omitted, the bcs instance
               will create a `goleveldb`(File Database) database by default. Changing this will create a new instance. The couchdb
               object structure is documented below.
        :param pulumi.Input[bool] delete_obs: Specified whether to delete the associated OBS bucket when deleting BCS instance.
               `delete_obs` is used to delete the OBS created by the BCS instance of the Kafka consensus strategy. Default is false.
        :param pulumi.Input[bool] delete_storage: Specified whether to delete the associated SFS resources when deleting BCS
               instance. Default is false.
        :param pulumi.Input[bool] eip_enable: Specifies whether to use the EIP of the CCE to bind the BCS instance.
               Changing this will create a new instance. Defalut is true.
        :param pulumi.Input['InstanceKafkaArgs'] kafka: Specifies the kafka configuration for the BCS instance. Changing this will create
               a new instance. The kafka object structure is documented below.
        :param pulumi.Input[str] name: Specifies the name of the channel. Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstancePeerOrgArgs']]] peer_orgs: Specifies an array of one or more Peer organizations to attach to the BCS
               instance. Changing this will create a new instance. If omitted, the bcs instance will create a `peer_orgs`
               named `organization` by default and the node count is 2. The peer_orgs object structure is documented below.
        :param pulumi.Input[str] region: Specifies the region in which to create the instance. If omitted, the
               provider-level region will be used. Changing this will create a new instance.
        :param pulumi.Input[bool] restful_api_support: Specified whether to add RESTful API support. Changing this will
               create a new instance.
        :param pulumi.Input[str] security_mechanism: Specifies the secutity mechanism used by the BCS instance. Valid
               values are `ECDSA` and `SM2`(Chinese cryptographic algorithms, The basic and professional don't support this
               algorithm). Default is `ECDSA`. Changing this will create a new instance.
        :param pulumi.Input['InstanceSfsTurboArgs'] sfs_turbo: Specifies the information about the SFS Turbo file system. Changing this will
               create a new instance. The sfs_turbo object structure is documented below.
        :param pulumi.Input[bool] tc3_need: Specified whether to add Trusted computing platform. Changing this will create
               a new instance.
        """
        pulumi.set(__self__, "cce_cluster_id", cce_cluster_id)
        pulumi.set(__self__, "consensus", consensus)
        pulumi.set(__self__, "edition", edition)
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        pulumi.set(__self__, "fabric_version", fabric_version)
        pulumi.set(__self__, "orderer_node_num", orderer_node_num)
        pulumi.set(__self__, "org_disk_size", org_disk_size)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "volume_type", volume_type)
        if block_info is not None:
            pulumi.set(__self__, "block_info", block_info)
        if blockchain_type is not None:
            pulumi.set(__self__, "blockchain_type", blockchain_type)
        if channels is not None:
            pulumi.set(__self__, "channels", channels)
        if couchdb is not None:
            pulumi.set(__self__, "couchdb", couchdb)
        if database_type is not None:
            pulumi.set(__self__, "database_type", database_type)
        if delete_obs is not None:
            pulumi.set(__self__, "delete_obs", delete_obs)
        if delete_storage is not None:
            pulumi.set(__self__, "delete_storage", delete_storage)
        if eip_enable is not None:
            pulumi.set(__self__, "eip_enable", eip_enable)
        if kafka is not None:
            pulumi.set(__self__, "kafka", kafka)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peer_orgs is not None:
            pulumi.set(__self__, "peer_orgs", peer_orgs)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if restful_api_support is not None:
            pulumi.set(__self__, "restful_api_support", restful_api_support)
        if security_mechanism is not None:
            pulumi.set(__self__, "security_mechanism", security_mechanism)
        if sfs_turbo is not None:
            pulumi.set(__self__, "sfs_turbo", sfs_turbo)
        if tc3_need is not None:
            pulumi.set(__self__, "tc3_need", tc3_need)

    @property
    @pulumi.getter(name="cceClusterId")
    def cce_cluster_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of the CCE cluster to attach to the BCS instance. The
        BCS service needs to exclusively occupy the CCE cluster. Please make sure that the CCE cluster is not occupied before
        deploying the BCS service. Changing this will create a new instance.
        """
        return pulumi.get(self, "cce_cluster_id")

    @cce_cluster_id.setter
    def cce_cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cce_cluster_id", value)

    @property
    @pulumi.getter
    def consensus(self) -> pulumi.Input[str]:
        """
        Specifies the consensus algorithm used by the BCS instance. The valid
        values of fabric 1.4 are `solo`, `kafka` and `SFLIC`, and the valid values of fabric 2.0 are `SFLIC`
        and `etcdraft`. Changing this will create a new instance.
        """
        return pulumi.get(self, "consensus")

    @consensus.setter
    def consensus(self, value: pulumi.Input[str]):
        pulumi.set(self, "consensus", value)

    @property
    @pulumi.getter
    def edition(self) -> pulumi.Input[int]:
        """
        Specifies Service edition of the BCS instance. Valid values are `1`, `2` and `4`
        . Changing this will create a new instance.
        """
        return pulumi.get(self, "edition")

    @edition.setter
    def edition(self, value: pulumi.Input[int]):
        pulumi.set(self, "edition", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of the enterprise project that the BCS
        instance belong to. Changing this will create a new instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="fabricVersion")
    def fabric_version(self) -> pulumi.Input[str]:
        """
        Specifies version of fabric for the BCS instance. Valid values
        are `1.4` and `2.0`
        Changing this will create a new instance.
        """
        return pulumi.get(self, "fabric_version")

    @fabric_version.setter
    def fabric_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "fabric_version", value)

    @property
    @pulumi.getter(name="ordererNodeNum")
    def orderer_node_num(self) -> pulumi.Input[int]:
        """
        Specifies the number of peers in the orderer organizaion. Changing this
        will create a new instance.
        """
        return pulumi.get(self, "orderer_node_num")

    @orderer_node_num.setter
    def orderer_node_num(self, value: pulumi.Input[int]):
        pulumi.set(self, "orderer_node_num", value)

    @property
    @pulumi.getter(name="orgDiskSize")
    def org_disk_size(self) -> pulumi.Input[int]:
        """
        Specifies the storage capacity of peer organization. Changing this will
        create a new instance.
        + The minimum storage capacity of `efs` volume type is 500GB.
        """
        return pulumi.get(self, "org_disk_size")

    @org_disk_size.setter
    def org_disk_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "org_disk_size", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        Specifies the password of the couch datebase. The password consists of 8 to
        26 characters and must consist at least three of following: uppercase letters, lowercase letters, digits, special
        charactors(!@$%^-_=+[{}]:,./?). Changing this creates a new instance.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> pulumi.Input[str]:
        """
        Specifies the storage volume type to attach to each organization of the
        BCS instance. Valid values are `nfs` (SFS) and `efs` (SFS Turbo). Changing this will create a new instance.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "volume_type", value)

    @property
    @pulumi.getter(name="blockInfo")
    def block_info(self) -> Optional[pulumi.Input['InstanceBlockInfoArgs']]:
        """
        Specifies the configuration of block generation. The block_info object
        structure is documented below.
        """
        return pulumi.get(self, "block_info")

    @block_info.setter
    def block_info(self, value: Optional[pulumi.Input['InstanceBlockInfoArgs']]):
        pulumi.set(self, "block_info", value)

    @property
    @pulumi.getter(name="blockchainType")
    def blockchain_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the blockchain type of the BCS instance. Valid values
        are `private` and  `union`. Default is `private`. Changing this will create a new instance.
        """
        return pulumi.get(self, "blockchain_type")

    @blockchain_type.setter
    def blockchain_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "blockchain_type", value)

    @property
    @pulumi.getter
    def channels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceChannelArgs']]]]:
        """
        Specifies an array of one or more channels to attach to the BCS instance. If
        omitted, the bcs instance will create a `channels` named `channel` by default. Changing this will create a new
        instance. The channels object structure is documented below.
        """
        return pulumi.get(self, "channels")

    @channels.setter
    def channels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceChannelArgs']]]]):
        pulumi.set(self, "channels", value)

    @property
    @pulumi.getter
    def couchdb(self) -> Optional[pulumi.Input['InstanceCouchdbArgs']]:
        """
        Specifies the NoSQL database used by BCS instance. If omitted, the bcs instance
        will create a `goleveldb`(File Database) database by default. Changing this will create a new instance. The couchdb
        object structure is documented below.
        """
        return pulumi.get(self, "couchdb")

    @couchdb.setter
    def couchdb(self, value: Optional[pulumi.Input['InstanceCouchdbArgs']]):
        pulumi.set(self, "couchdb", value)

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "database_type")

    @database_type.setter
    def database_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_type", value)

    @property
    @pulumi.getter(name="deleteObs")
    def delete_obs(self) -> Optional[pulumi.Input[bool]]:
        """
        Specified whether to delete the associated OBS bucket when deleting BCS instance.
        `delete_obs` is used to delete the OBS created by the BCS instance of the Kafka consensus strategy. Default is false.
        """
        return pulumi.get(self, "delete_obs")

    @delete_obs.setter
    def delete_obs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_obs", value)

    @property
    @pulumi.getter(name="deleteStorage")
    def delete_storage(self) -> Optional[pulumi.Input[bool]]:
        """
        Specified whether to delete the associated SFS resources when deleting BCS
        instance. Default is false.
        """
        return pulumi.get(self, "delete_storage")

    @delete_storage.setter
    def delete_storage(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_storage", value)

    @property
    @pulumi.getter(name="eipEnable")
    def eip_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to use the EIP of the CCE to bind the BCS instance.
        Changing this will create a new instance. Defalut is true.
        """
        return pulumi.get(self, "eip_enable")

    @eip_enable.setter
    def eip_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "eip_enable", value)

    @property
    @pulumi.getter
    def kafka(self) -> Optional[pulumi.Input['InstanceKafkaArgs']]:
        """
        Specifies the kafka configuration for the BCS instance. Changing this will create
        a new instance. The kafka object structure is documented below.
        """
        return pulumi.get(self, "kafka")

    @kafka.setter
    def kafka(self, value: Optional[pulumi.Input['InstanceKafkaArgs']]):
        pulumi.set(self, "kafka", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the channel. Changing this creates a new instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="peerOrgs")
    def peer_orgs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstancePeerOrgArgs']]]]:
        """
        Specifies an array of one or more Peer organizations to attach to the BCS
        instance. Changing this will create a new instance. If omitted, the bcs instance will create a `peer_orgs`
        named `organization` by default and the node count is 2. The peer_orgs object structure is documented below.
        """
        return pulumi.get(self, "peer_orgs")

    @peer_orgs.setter
    def peer_orgs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePeerOrgArgs']]]]):
        pulumi.set(self, "peer_orgs", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the instance. If omitted, the
        provider-level region will be used. Changing this will create a new instance.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="restfulApiSupport")
    def restful_api_support(self) -> Optional[pulumi.Input[bool]]:
        """
        Specified whether to add RESTful API support. Changing this will
        create a new instance.
        """
        return pulumi.get(self, "restful_api_support")

    @restful_api_support.setter
    def restful_api_support(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "restful_api_support", value)

    @property
    @pulumi.getter(name="securityMechanism")
    def security_mechanism(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the secutity mechanism used by the BCS instance. Valid
        values are `ECDSA` and `SM2`(Chinese cryptographic algorithms, The basic and professional don't support this
        algorithm). Default is `ECDSA`. Changing this will create a new instance.
        """
        return pulumi.get(self, "security_mechanism")

    @security_mechanism.setter
    def security_mechanism(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_mechanism", value)

    @property
    @pulumi.getter(name="sfsTurbo")
    def sfs_turbo(self) -> Optional[pulumi.Input['InstanceSfsTurboArgs']]:
        """
        Specifies the information about the SFS Turbo file system. Changing this will
        create a new instance. The sfs_turbo object structure is documented below.
        """
        return pulumi.get(self, "sfs_turbo")

    @sfs_turbo.setter
    def sfs_turbo(self, value: Optional[pulumi.Input['InstanceSfsTurboArgs']]):
        pulumi.set(self, "sfs_turbo", value)

    @property
    @pulumi.getter(name="tc3Need")
    def tc3_need(self) -> Optional[pulumi.Input[bool]]:
        """
        Specified whether to add Trusted computing platform. Changing this will create
        a new instance.
        """
        return pulumi.get(self, "tc3_need")

    @tc3_need.setter
    def tc3_need(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tc3_need", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 agent_portal_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 block_info: Optional[pulumi.Input['InstanceBlockInfoArgs']] = None,
                 blockchain_type: Optional[pulumi.Input[str]] = None,
                 cce_cluster_id: Optional[pulumi.Input[str]] = None,
                 channels: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceChannelArgs']]]] = None,
                 cluster_type: Optional[pulumi.Input[str]] = None,
                 consensus: Optional[pulumi.Input[str]] = None,
                 couchdb: Optional[pulumi.Input['InstanceCouchdbArgs']] = None,
                 cross_region_support: Optional[pulumi.Input[bool]] = None,
                 database_type: Optional[pulumi.Input[str]] = None,
                 delete_obs: Optional[pulumi.Input[bool]] = None,
                 delete_storage: Optional[pulumi.Input[bool]] = None,
                 edition: Optional[pulumi.Input[int]] = None,
                 eip_enable: Optional[pulumi.Input[bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 fabric_version: Optional[pulumi.Input[str]] = None,
                 kafka: Optional[pulumi.Input['InstanceKafkaArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 old_service_version: Optional[pulumi.Input[str]] = None,
                 orderer_node_num: Optional[pulumi.Input[int]] = None,
                 org_disk_size: Optional[pulumi.Input[int]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 peer_orgs: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePeerOrgArgs']]]] = None,
                 purchase_type: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 restful_api_support: Optional[pulumi.Input[bool]] = None,
                 rollback_support: Optional[pulumi.Input[bool]] = None,
                 security_mechanism: Optional[pulumi.Input[str]] = None,
                 sfs_turbo: Optional[pulumi.Input['InstanceSfsTurboArgs']] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tc3_need: Optional[pulumi.Input[bool]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] agent_portal_addresses: The agent addresses and port numbers on the user data plane of the BCS service.
               * `peer_orgs/pvc_name` - The name of the PersistenetVolumeClaim (PVC) used by the peer.
               * `peer_orgs/status` - The peer status. The value contains `IsCreating`, `IsUpgrading`, `Adding/IsScaling`,
               `Isdeleting`, `Normal`, `AbNormal` and `Unknown`.
               * `peer_orgs/status_detail` - The peer status in the format like `1/1`. The denominator is the total number of peers in
               the organization, and the numerator is the number of normal peers.
               * `peer_orgs/address/domain_port` - The domain name address.
               * `peer_orgs/address/ip_port` - The IP address.
               * `kafka/name` - The Kafka instance name.
        :param pulumi.Input['InstanceBlockInfoArgs'] block_info: Specifies the configuration of block generation. The block_info object
               structure is documented below.
        :param pulumi.Input[str] blockchain_type: Specifies the blockchain type of the BCS instance. Valid values
               are `private` and  `union`. Default is `private`. Changing this will create a new instance.
        :param pulumi.Input[str] cce_cluster_id: Specifies the ID of the CCE cluster to attach to the BCS instance. The
               BCS service needs to exclusively occupy the CCE cluster. Please make sure that the CCE cluster is not occupied before
               deploying the BCS service. Changing this will create a new instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceChannelArgs']]] channels: Specifies an array of one or more channels to attach to the BCS instance. If
               omitted, the bcs instance will create a `channels` named `channel` by default. Changing this will create a new
               instance. The channels object structure is documented below.
        :param pulumi.Input[str] consensus: Specifies the consensus algorithm used by the BCS instance. The valid
               values of fabric 1.4 are `solo`, `kafka` and `SFLIC`, and the valid values of fabric 2.0 are `SFLIC`
               and `etcdraft`. Changing this will create a new instance.
        :param pulumi.Input['InstanceCouchdbArgs'] couchdb: Specifies the NoSQL database used by BCS instance. If omitted, the bcs instance
               will create a `goleveldb`(File Database) database by default. Changing this will create a new instance. The couchdb
               object structure is documented below.
        :param pulumi.Input[bool] cross_region_support: Whether the BCS instance is deployed across regions.
        :param pulumi.Input[bool] delete_obs: Specified whether to delete the associated OBS bucket when deleting BCS instance.
               `delete_obs` is used to delete the OBS created by the BCS instance of the Kafka consensus strategy. Default is false.
        :param pulumi.Input[bool] delete_storage: Specified whether to delete the associated SFS resources when deleting BCS
               instance. Default is false.
        :param pulumi.Input[int] edition: Specifies Service edition of the BCS instance. Valid values are `1`, `2` and `4`
               . Changing this will create a new instance.
        :param pulumi.Input[bool] eip_enable: Specifies whether to use the EIP of the CCE to bind the BCS instance.
               Changing this will create a new instance. Defalut is true.
        :param pulumi.Input[str] enterprise_project_id: Specifies the ID of the enterprise project that the BCS
               instance belong to. Changing this will create a new instance.
        :param pulumi.Input[str] fabric_version: Specifies version of fabric for the BCS instance. Valid values
               are `1.4` and `2.0`
               Changing this will create a new instance.
        :param pulumi.Input['InstanceKafkaArgs'] kafka: Specifies the kafka configuration for the BCS instance. Changing this will create
               a new instance. The kafka object structure is documented below.
        :param pulumi.Input[str] name: Specifies the name of the channel. Changing this creates a new instance.
        :param pulumi.Input[str] old_service_version: The version of an old BCS service.
        :param pulumi.Input[int] orderer_node_num: Specifies the number of peers in the orderer organizaion. Changing this
               will create a new instance.
        :param pulumi.Input[int] org_disk_size: Specifies the storage capacity of peer organization. Changing this will
               create a new instance.
               + The minimum storage capacity of `efs` volume type is 500GB.
        :param pulumi.Input[str] password: Specifies the password of the couch datebase. The password consists of 8 to
               26 characters and must consist at least three of following: uppercase letters, lowercase letters, digits, special
               charactors(!@$%^-_=+[{}]:,./?). Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstancePeerOrgArgs']]] peer_orgs: Specifies an array of one or more Peer organizations to attach to the BCS
               instance. Changing this will create a new instance. If omitted, the bcs instance will create a `peer_orgs`
               named `organization` by default and the node count is 2. The peer_orgs object structure is documented below.
        :param pulumi.Input[str] purchase_type: The deployment type of the BCS instance.
        :param pulumi.Input[str] region: Specifies the region in which to create the instance. If omitted, the
               provider-level region will be used. Changing this will create a new instance.
        :param pulumi.Input[bool] restful_api_support: Specified whether to add RESTful API support. Changing this will
               create a new instance.
        :param pulumi.Input[bool] rollback_support: Whether rollback is supported when the BCS service fails to br upgraded.
        :param pulumi.Input[str] security_mechanism: Specifies the secutity mechanism used by the BCS instance. Valid
               values are `ECDSA` and `SM2`(Chinese cryptographic algorithms, The basic and professional don't support this
               algorithm). Default is `ECDSA`. Changing this will create a new instance.
        :param pulumi.Input['InstanceSfsTurboArgs'] sfs_turbo: Specifies the information about the SFS Turbo file system. Changing this will
               create a new instance. The sfs_turbo object structure is documented below.
        :param pulumi.Input[str] status: The status of the BCS instance.
        :param pulumi.Input[bool] tc3_need: Specified whether to add Trusted computing platform. Changing this will create
               a new instance.
        :param pulumi.Input[str] version: The service verison of the BCS instance.
        :param pulumi.Input[str] volume_type: Specifies the storage volume type to attach to each organization of the
               BCS instance. Valid values are `nfs` (SFS) and `efs` (SFS Turbo). Changing this will create a new instance.
        """
        if agent_portal_addresses is not None:
            pulumi.set(__self__, "agent_portal_addresses", agent_portal_addresses)
        if block_info is not None:
            pulumi.set(__self__, "block_info", block_info)
        if blockchain_type is not None:
            pulumi.set(__self__, "blockchain_type", blockchain_type)
        if cce_cluster_id is not None:
            pulumi.set(__self__, "cce_cluster_id", cce_cluster_id)
        if channels is not None:
            pulumi.set(__self__, "channels", channels)
        if cluster_type is not None:
            pulumi.set(__self__, "cluster_type", cluster_type)
        if consensus is not None:
            pulumi.set(__self__, "consensus", consensus)
        if couchdb is not None:
            pulumi.set(__self__, "couchdb", couchdb)
        if cross_region_support is not None:
            pulumi.set(__self__, "cross_region_support", cross_region_support)
        if database_type is not None:
            pulumi.set(__self__, "database_type", database_type)
        if delete_obs is not None:
            pulumi.set(__self__, "delete_obs", delete_obs)
        if delete_storage is not None:
            pulumi.set(__self__, "delete_storage", delete_storage)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if eip_enable is not None:
            pulumi.set(__self__, "eip_enable", eip_enable)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if fabric_version is not None:
            pulumi.set(__self__, "fabric_version", fabric_version)
        if kafka is not None:
            pulumi.set(__self__, "kafka", kafka)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if old_service_version is not None:
            pulumi.set(__self__, "old_service_version", old_service_version)
        if orderer_node_num is not None:
            pulumi.set(__self__, "orderer_node_num", orderer_node_num)
        if org_disk_size is not None:
            pulumi.set(__self__, "org_disk_size", org_disk_size)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if peer_orgs is not None:
            pulumi.set(__self__, "peer_orgs", peer_orgs)
        if purchase_type is not None:
            pulumi.set(__self__, "purchase_type", purchase_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if restful_api_support is not None:
            pulumi.set(__self__, "restful_api_support", restful_api_support)
        if rollback_support is not None:
            pulumi.set(__self__, "rollback_support", rollback_support)
        if security_mechanism is not None:
            pulumi.set(__self__, "security_mechanism", security_mechanism)
        if sfs_turbo is not None:
            pulumi.set(__self__, "sfs_turbo", sfs_turbo)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tc3_need is not None:
            pulumi.set(__self__, "tc3_need", tc3_need)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="agentPortalAddresses")
    def agent_portal_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The agent addresses and port numbers on the user data plane of the BCS service.
        * `peer_orgs/pvc_name` - The name of the PersistenetVolumeClaim (PVC) used by the peer.
        * `peer_orgs/status` - The peer status. The value contains `IsCreating`, `IsUpgrading`, `Adding/IsScaling`,
        `Isdeleting`, `Normal`, `AbNormal` and `Unknown`.
        * `peer_orgs/status_detail` - The peer status in the format like `1/1`. The denominator is the total number of peers in
        the organization, and the numerator is the number of normal peers.
        * `peer_orgs/address/domain_port` - The domain name address.
        * `peer_orgs/address/ip_port` - The IP address.
        * `kafka/name` - The Kafka instance name.
        """
        return pulumi.get(self, "agent_portal_addresses")

    @agent_portal_addresses.setter
    def agent_portal_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "agent_portal_addresses", value)

    @property
    @pulumi.getter(name="blockInfo")
    def block_info(self) -> Optional[pulumi.Input['InstanceBlockInfoArgs']]:
        """
        Specifies the configuration of block generation. The block_info object
        structure is documented below.
        """
        return pulumi.get(self, "block_info")

    @block_info.setter
    def block_info(self, value: Optional[pulumi.Input['InstanceBlockInfoArgs']]):
        pulumi.set(self, "block_info", value)

    @property
    @pulumi.getter(name="blockchainType")
    def blockchain_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the blockchain type of the BCS instance. Valid values
        are `private` and  `union`. Default is `private`. Changing this will create a new instance.
        """
        return pulumi.get(self, "blockchain_type")

    @blockchain_type.setter
    def blockchain_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "blockchain_type", value)

    @property
    @pulumi.getter(name="cceClusterId")
    def cce_cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the CCE cluster to attach to the BCS instance. The
        BCS service needs to exclusively occupy the CCE cluster. Please make sure that the CCE cluster is not occupied before
        deploying the BCS service. Changing this will create a new instance.
        """
        return pulumi.get(self, "cce_cluster_id")

    @cce_cluster_id.setter
    def cce_cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cce_cluster_id", value)

    @property
    @pulumi.getter
    def channels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceChannelArgs']]]]:
        """
        Specifies an array of one or more channels to attach to the BCS instance. If
        omitted, the bcs instance will create a `channels` named `channel` by default. Changing this will create a new
        instance. The channels object structure is documented below.
        """
        return pulumi.get(self, "channels")

    @channels.setter
    def channels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceChannelArgs']]]]):
        pulumi.set(self, "channels", value)

    @property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cluster_type")

    @cluster_type.setter
    def cluster_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_type", value)

    @property
    @pulumi.getter
    def consensus(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the consensus algorithm used by the BCS instance. The valid
        values of fabric 1.4 are `solo`, `kafka` and `SFLIC`, and the valid values of fabric 2.0 are `SFLIC`
        and `etcdraft`. Changing this will create a new instance.
        """
        return pulumi.get(self, "consensus")

    @consensus.setter
    def consensus(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consensus", value)

    @property
    @pulumi.getter
    def couchdb(self) -> Optional[pulumi.Input['InstanceCouchdbArgs']]:
        """
        Specifies the NoSQL database used by BCS instance. If omitted, the bcs instance
        will create a `goleveldb`(File Database) database by default. Changing this will create a new instance. The couchdb
        object structure is documented below.
        """
        return pulumi.get(self, "couchdb")

    @couchdb.setter
    def couchdb(self, value: Optional[pulumi.Input['InstanceCouchdbArgs']]):
        pulumi.set(self, "couchdb", value)

    @property
    @pulumi.getter(name="crossRegionSupport")
    def cross_region_support(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the BCS instance is deployed across regions.
        """
        return pulumi.get(self, "cross_region_support")

    @cross_region_support.setter
    def cross_region_support(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cross_region_support", value)

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "database_type")

    @database_type.setter
    def database_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_type", value)

    @property
    @pulumi.getter(name="deleteObs")
    def delete_obs(self) -> Optional[pulumi.Input[bool]]:
        """
        Specified whether to delete the associated OBS bucket when deleting BCS instance.
        `delete_obs` is used to delete the OBS created by the BCS instance of the Kafka consensus strategy. Default is false.
        """
        return pulumi.get(self, "delete_obs")

    @delete_obs.setter
    def delete_obs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_obs", value)

    @property
    @pulumi.getter(name="deleteStorage")
    def delete_storage(self) -> Optional[pulumi.Input[bool]]:
        """
        Specified whether to delete the associated SFS resources when deleting BCS
        instance. Default is false.
        """
        return pulumi.get(self, "delete_storage")

    @delete_storage.setter
    def delete_storage(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_storage", value)

    @property
    @pulumi.getter
    def edition(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies Service edition of the BCS instance. Valid values are `1`, `2` and `4`
        . Changing this will create a new instance.
        """
        return pulumi.get(self, "edition")

    @edition.setter
    def edition(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "edition", value)

    @property
    @pulumi.getter(name="eipEnable")
    def eip_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to use the EIP of the CCE to bind the BCS instance.
        Changing this will create a new instance. Defalut is true.
        """
        return pulumi.get(self, "eip_enable")

    @eip_enable.setter
    def eip_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "eip_enable", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the enterprise project that the BCS
        instance belong to. Changing this will create a new instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="fabricVersion")
    def fabric_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies version of fabric for the BCS instance. Valid values
        are `1.4` and `2.0`
        Changing this will create a new instance.
        """
        return pulumi.get(self, "fabric_version")

    @fabric_version.setter
    def fabric_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fabric_version", value)

    @property
    @pulumi.getter
    def kafka(self) -> Optional[pulumi.Input['InstanceKafkaArgs']]:
        """
        Specifies the kafka configuration for the BCS instance. Changing this will create
        a new instance. The kafka object structure is documented below.
        """
        return pulumi.get(self, "kafka")

    @kafka.setter
    def kafka(self, value: Optional[pulumi.Input['InstanceKafkaArgs']]):
        pulumi.set(self, "kafka", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the channel. Changing this creates a new instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="oldServiceVersion")
    def old_service_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of an old BCS service.
        """
        return pulumi.get(self, "old_service_version")

    @old_service_version.setter
    def old_service_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "old_service_version", value)

    @property
    @pulumi.getter(name="ordererNodeNum")
    def orderer_node_num(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of peers in the orderer organizaion. Changing this
        will create a new instance.
        """
        return pulumi.get(self, "orderer_node_num")

    @orderer_node_num.setter
    def orderer_node_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "orderer_node_num", value)

    @property
    @pulumi.getter(name="orgDiskSize")
    def org_disk_size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the storage capacity of peer organization. Changing this will
        create a new instance.
        + The minimum storage capacity of `efs` volume type is 500GB.
        """
        return pulumi.get(self, "org_disk_size")

    @org_disk_size.setter
    def org_disk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "org_disk_size", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the password of the couch datebase. The password consists of 8 to
        26 characters and must consist at least three of following: uppercase letters, lowercase letters, digits, special
        charactors(!@$%^-_=+[{}]:,./?). Changing this creates a new instance.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="peerOrgs")
    def peer_orgs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstancePeerOrgArgs']]]]:
        """
        Specifies an array of one or more Peer organizations to attach to the BCS
        instance. Changing this will create a new instance. If omitted, the bcs instance will create a `peer_orgs`
        named `organization` by default and the node count is 2. The peer_orgs object structure is documented below.
        """
        return pulumi.get(self, "peer_orgs")

    @peer_orgs.setter
    def peer_orgs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePeerOrgArgs']]]]):
        pulumi.set(self, "peer_orgs", value)

    @property
    @pulumi.getter(name="purchaseType")
    def purchase_type(self) -> Optional[pulumi.Input[str]]:
        """
        The deployment type of the BCS instance.
        """
        return pulumi.get(self, "purchase_type")

    @purchase_type.setter
    def purchase_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "purchase_type", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the instance. If omitted, the
        provider-level region will be used. Changing this will create a new instance.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="restfulApiSupport")
    def restful_api_support(self) -> Optional[pulumi.Input[bool]]:
        """
        Specified whether to add RESTful API support. Changing this will
        create a new instance.
        """
        return pulumi.get(self, "restful_api_support")

    @restful_api_support.setter
    def restful_api_support(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "restful_api_support", value)

    @property
    @pulumi.getter(name="rollbackSupport")
    def rollback_support(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether rollback is supported when the BCS service fails to br upgraded.
        """
        return pulumi.get(self, "rollback_support")

    @rollback_support.setter
    def rollback_support(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "rollback_support", value)

    @property
    @pulumi.getter(name="securityMechanism")
    def security_mechanism(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the secutity mechanism used by the BCS instance. Valid
        values are `ECDSA` and `SM2`(Chinese cryptographic algorithms, The basic and professional don't support this
        algorithm). Default is `ECDSA`. Changing this will create a new instance.
        """
        return pulumi.get(self, "security_mechanism")

    @security_mechanism.setter
    def security_mechanism(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_mechanism", value)

    @property
    @pulumi.getter(name="sfsTurbo")
    def sfs_turbo(self) -> Optional[pulumi.Input['InstanceSfsTurboArgs']]:
        """
        Specifies the information about the SFS Turbo file system. Changing this will
        create a new instance. The sfs_turbo object structure is documented below.
        """
        return pulumi.get(self, "sfs_turbo")

    @sfs_turbo.setter
    def sfs_turbo(self, value: Optional[pulumi.Input['InstanceSfsTurboArgs']]):
        pulumi.set(self, "sfs_turbo", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the BCS instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="tc3Need")
    def tc3_need(self) -> Optional[pulumi.Input[bool]]:
        """
        Specified whether to add Trusted computing platform. Changing this will create
        a new instance.
        """
        return pulumi.get(self, "tc3_need")

    @tc3_need.setter
    def tc3_need(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tc3_need", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The service verison of the BCS instance.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the storage volume type to attach to each organization of the
        BCS instance. Valid values are `nfs` (SFS) and `efs` (SFS Turbo). Changing this will create a new instance.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_type", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 block_info: Optional[pulumi.Input[pulumi.InputType['InstanceBlockInfoArgs']]] = None,
                 blockchain_type: Optional[pulumi.Input[str]] = None,
                 cce_cluster_id: Optional[pulumi.Input[str]] = None,
                 channels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceChannelArgs']]]]] = None,
                 consensus: Optional[pulumi.Input[str]] = None,
                 couchdb: Optional[pulumi.Input[pulumi.InputType['InstanceCouchdbArgs']]] = None,
                 database_type: Optional[pulumi.Input[str]] = None,
                 delete_obs: Optional[pulumi.Input[bool]] = None,
                 delete_storage: Optional[pulumi.Input[bool]] = None,
                 edition: Optional[pulumi.Input[int]] = None,
                 eip_enable: Optional[pulumi.Input[bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 fabric_version: Optional[pulumi.Input[str]] = None,
                 kafka: Optional[pulumi.Input[pulumi.InputType['InstanceKafkaArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 orderer_node_num: Optional[pulumi.Input[int]] = None,
                 org_disk_size: Optional[pulumi.Input[int]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 peer_orgs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstancePeerOrgArgs']]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 restful_api_support: Optional[pulumi.Input[bool]] = None,
                 security_mechanism: Optional[pulumi.Input[str]] = None,
                 sfs_turbo: Optional[pulumi.Input[pulumi.InputType['InstanceSfsTurboArgs']]] = None,
                 tc3_need: Optional[pulumi.Input[bool]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['InstanceBlockInfoArgs']] block_info: Specifies the configuration of block generation. The block_info object
               structure is documented below.
        :param pulumi.Input[str] blockchain_type: Specifies the blockchain type of the BCS instance. Valid values
               are `private` and  `union`. Default is `private`. Changing this will create a new instance.
        :param pulumi.Input[str] cce_cluster_id: Specifies the ID of the CCE cluster to attach to the BCS instance. The
               BCS service needs to exclusively occupy the CCE cluster. Please make sure that the CCE cluster is not occupied before
               deploying the BCS service. Changing this will create a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceChannelArgs']]]] channels: Specifies an array of one or more channels to attach to the BCS instance. If
               omitted, the bcs instance will create a `channels` named `channel` by default. Changing this will create a new
               instance. The channels object structure is documented below.
        :param pulumi.Input[str] consensus: Specifies the consensus algorithm used by the BCS instance. The valid
               values of fabric 1.4 are `solo`, `kafka` and `SFLIC`, and the valid values of fabric 2.0 are `SFLIC`
               and `etcdraft`. Changing this will create a new instance.
        :param pulumi.Input[pulumi.InputType['InstanceCouchdbArgs']] couchdb: Specifies the NoSQL database used by BCS instance. If omitted, the bcs instance
               will create a `goleveldb`(File Database) database by default. Changing this will create a new instance. The couchdb
               object structure is documented below.
        :param pulumi.Input[bool] delete_obs: Specified whether to delete the associated OBS bucket when deleting BCS instance.
               `delete_obs` is used to delete the OBS created by the BCS instance of the Kafka consensus strategy. Default is false.
        :param pulumi.Input[bool] delete_storage: Specified whether to delete the associated SFS resources when deleting BCS
               instance. Default is false.
        :param pulumi.Input[int] edition: Specifies Service edition of the BCS instance. Valid values are `1`, `2` and `4`
               . Changing this will create a new instance.
        :param pulumi.Input[bool] eip_enable: Specifies whether to use the EIP of the CCE to bind the BCS instance.
               Changing this will create a new instance. Defalut is true.
        :param pulumi.Input[str] enterprise_project_id: Specifies the ID of the enterprise project that the BCS
               instance belong to. Changing this will create a new instance.
        :param pulumi.Input[str] fabric_version: Specifies version of fabric for the BCS instance. Valid values
               are `1.4` and `2.0`
               Changing this will create a new instance.
        :param pulumi.Input[pulumi.InputType['InstanceKafkaArgs']] kafka: Specifies the kafka configuration for the BCS instance. Changing this will create
               a new instance. The kafka object structure is documented below.
        :param pulumi.Input[str] name: Specifies the name of the channel. Changing this creates a new instance.
        :param pulumi.Input[int] orderer_node_num: Specifies the number of peers in the orderer organizaion. Changing this
               will create a new instance.
        :param pulumi.Input[int] org_disk_size: Specifies the storage capacity of peer organization. Changing this will
               create a new instance.
               + The minimum storage capacity of `efs` volume type is 500GB.
        :param pulumi.Input[str] password: Specifies the password of the couch datebase. The password consists of 8 to
               26 characters and must consist at least three of following: uppercase letters, lowercase letters, digits, special
               charactors(!@$%^-_=+[{}]:,./?). Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstancePeerOrgArgs']]]] peer_orgs: Specifies an array of one or more Peer organizations to attach to the BCS
               instance. Changing this will create a new instance. If omitted, the bcs instance will create a `peer_orgs`
               named `organization` by default and the node count is 2. The peer_orgs object structure is documented below.
        :param pulumi.Input[str] region: Specifies the region in which to create the instance. If omitted, the
               provider-level region will be used. Changing this will create a new instance.
        :param pulumi.Input[bool] restful_api_support: Specified whether to add RESTful API support. Changing this will
               create a new instance.
        :param pulumi.Input[str] security_mechanism: Specifies the secutity mechanism used by the BCS instance. Valid
               values are `ECDSA` and `SM2`(Chinese cryptographic algorithms, The basic and professional don't support this
               algorithm). Default is `ECDSA`. Changing this will create a new instance.
        :param pulumi.Input[pulumi.InputType['InstanceSfsTurboArgs']] sfs_turbo: Specifies the information about the SFS Turbo file system. Changing this will
               create a new instance. The sfs_turbo object structure is documented below.
        :param pulumi.Input[bool] tc3_need: Specified whether to add Trusted computing platform. Changing this will create
               a new instance.
        :param pulumi.Input[str] volume_type: Specifies the storage volume type to attach to each organization of the
               BCS instance. Valid values are `nfs` (SFS) and `efs` (SFS Turbo). Changing this will create a new instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 block_info: Optional[pulumi.Input[pulumi.InputType['InstanceBlockInfoArgs']]] = None,
                 blockchain_type: Optional[pulumi.Input[str]] = None,
                 cce_cluster_id: Optional[pulumi.Input[str]] = None,
                 channels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceChannelArgs']]]]] = None,
                 consensus: Optional[pulumi.Input[str]] = None,
                 couchdb: Optional[pulumi.Input[pulumi.InputType['InstanceCouchdbArgs']]] = None,
                 database_type: Optional[pulumi.Input[str]] = None,
                 delete_obs: Optional[pulumi.Input[bool]] = None,
                 delete_storage: Optional[pulumi.Input[bool]] = None,
                 edition: Optional[pulumi.Input[int]] = None,
                 eip_enable: Optional[pulumi.Input[bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 fabric_version: Optional[pulumi.Input[str]] = None,
                 kafka: Optional[pulumi.Input[pulumi.InputType['InstanceKafkaArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 orderer_node_num: Optional[pulumi.Input[int]] = None,
                 org_disk_size: Optional[pulumi.Input[int]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 peer_orgs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstancePeerOrgArgs']]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 restful_api_support: Optional[pulumi.Input[bool]] = None,
                 security_mechanism: Optional[pulumi.Input[str]] = None,
                 sfs_turbo: Optional[pulumi.Input[pulumi.InputType['InstanceSfsTurboArgs']]] = None,
                 tc3_need: Optional[pulumi.Input[bool]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["block_info"] = block_info
            __props__.__dict__["blockchain_type"] = blockchain_type
            if cce_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cce_cluster_id'")
            __props__.__dict__["cce_cluster_id"] = cce_cluster_id
            __props__.__dict__["channels"] = channels
            if consensus is None and not opts.urn:
                raise TypeError("Missing required property 'consensus'")
            __props__.__dict__["consensus"] = consensus
            __props__.__dict__["couchdb"] = couchdb
            __props__.__dict__["database_type"] = database_type
            __props__.__dict__["delete_obs"] = delete_obs
            __props__.__dict__["delete_storage"] = delete_storage
            if edition is None and not opts.urn:
                raise TypeError("Missing required property 'edition'")
            __props__.__dict__["edition"] = edition
            __props__.__dict__["eip_enable"] = eip_enable
            if enterprise_project_id is None and not opts.urn:
                raise TypeError("Missing required property 'enterprise_project_id'")
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            if fabric_version is None and not opts.urn:
                raise TypeError("Missing required property 'fabric_version'")
            __props__.__dict__["fabric_version"] = fabric_version
            __props__.__dict__["kafka"] = kafka
            __props__.__dict__["name"] = name
            if orderer_node_num is None and not opts.urn:
                raise TypeError("Missing required property 'orderer_node_num'")
            __props__.__dict__["orderer_node_num"] = orderer_node_num
            if org_disk_size is None and not opts.urn:
                raise TypeError("Missing required property 'org_disk_size'")
            __props__.__dict__["org_disk_size"] = org_disk_size
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = password
            __props__.__dict__["peer_orgs"] = peer_orgs
            __props__.__dict__["region"] = region
            __props__.__dict__["restful_api_support"] = restful_api_support
            __props__.__dict__["security_mechanism"] = security_mechanism
            __props__.__dict__["sfs_turbo"] = sfs_turbo
            __props__.__dict__["tc3_need"] = tc3_need
            if volume_type is None and not opts.urn:
                raise TypeError("Missing required property 'volume_type'")
            __props__.__dict__["volume_type"] = volume_type
            __props__.__dict__["agent_portal_addresses"] = None
            __props__.__dict__["cluster_type"] = None
            __props__.__dict__["cross_region_support"] = None
            __props__.__dict__["old_service_version"] = None
            __props__.__dict__["purchase_type"] = None
            __props__.__dict__["rollback_support"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["version"] = None
        super(Instance, __self__).__init__(
            'huaweicloud:Bcs/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_portal_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            block_info: Optional[pulumi.Input[pulumi.InputType['InstanceBlockInfoArgs']]] = None,
            blockchain_type: Optional[pulumi.Input[str]] = None,
            cce_cluster_id: Optional[pulumi.Input[str]] = None,
            channels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceChannelArgs']]]]] = None,
            cluster_type: Optional[pulumi.Input[str]] = None,
            consensus: Optional[pulumi.Input[str]] = None,
            couchdb: Optional[pulumi.Input[pulumi.InputType['InstanceCouchdbArgs']]] = None,
            cross_region_support: Optional[pulumi.Input[bool]] = None,
            database_type: Optional[pulumi.Input[str]] = None,
            delete_obs: Optional[pulumi.Input[bool]] = None,
            delete_storage: Optional[pulumi.Input[bool]] = None,
            edition: Optional[pulumi.Input[int]] = None,
            eip_enable: Optional[pulumi.Input[bool]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            fabric_version: Optional[pulumi.Input[str]] = None,
            kafka: Optional[pulumi.Input[pulumi.InputType['InstanceKafkaArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            old_service_version: Optional[pulumi.Input[str]] = None,
            orderer_node_num: Optional[pulumi.Input[int]] = None,
            org_disk_size: Optional[pulumi.Input[int]] = None,
            password: Optional[pulumi.Input[str]] = None,
            peer_orgs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstancePeerOrgArgs']]]]] = None,
            purchase_type: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            restful_api_support: Optional[pulumi.Input[bool]] = None,
            rollback_support: Optional[pulumi.Input[bool]] = None,
            security_mechanism: Optional[pulumi.Input[str]] = None,
            sfs_turbo: Optional[pulumi.Input[pulumi.InputType['InstanceSfsTurboArgs']]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tc3_need: Optional[pulumi.Input[bool]] = None,
            version: Optional[pulumi.Input[str]] = None,
            volume_type: Optional[pulumi.Input[str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] agent_portal_addresses: The agent addresses and port numbers on the user data plane of the BCS service.
               * `peer_orgs/pvc_name` - The name of the PersistenetVolumeClaim (PVC) used by the peer.
               * `peer_orgs/status` - The peer status. The value contains `IsCreating`, `IsUpgrading`, `Adding/IsScaling`,
               `Isdeleting`, `Normal`, `AbNormal` and `Unknown`.
               * `peer_orgs/status_detail` - The peer status in the format like `1/1`. The denominator is the total number of peers in
               the organization, and the numerator is the number of normal peers.
               * `peer_orgs/address/domain_port` - The domain name address.
               * `peer_orgs/address/ip_port` - The IP address.
               * `kafka/name` - The Kafka instance name.
        :param pulumi.Input[pulumi.InputType['InstanceBlockInfoArgs']] block_info: Specifies the configuration of block generation. The block_info object
               structure is documented below.
        :param pulumi.Input[str] blockchain_type: Specifies the blockchain type of the BCS instance. Valid values
               are `private` and  `union`. Default is `private`. Changing this will create a new instance.
        :param pulumi.Input[str] cce_cluster_id: Specifies the ID of the CCE cluster to attach to the BCS instance. The
               BCS service needs to exclusively occupy the CCE cluster. Please make sure that the CCE cluster is not occupied before
               deploying the BCS service. Changing this will create a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceChannelArgs']]]] channels: Specifies an array of one or more channels to attach to the BCS instance. If
               omitted, the bcs instance will create a `channels` named `channel` by default. Changing this will create a new
               instance. The channels object structure is documented below.
        :param pulumi.Input[str] consensus: Specifies the consensus algorithm used by the BCS instance. The valid
               values of fabric 1.4 are `solo`, `kafka` and `SFLIC`, and the valid values of fabric 2.0 are `SFLIC`
               and `etcdraft`. Changing this will create a new instance.
        :param pulumi.Input[pulumi.InputType['InstanceCouchdbArgs']] couchdb: Specifies the NoSQL database used by BCS instance. If omitted, the bcs instance
               will create a `goleveldb`(File Database) database by default. Changing this will create a new instance. The couchdb
               object structure is documented below.
        :param pulumi.Input[bool] cross_region_support: Whether the BCS instance is deployed across regions.
        :param pulumi.Input[bool] delete_obs: Specified whether to delete the associated OBS bucket when deleting BCS instance.
               `delete_obs` is used to delete the OBS created by the BCS instance of the Kafka consensus strategy. Default is false.
        :param pulumi.Input[bool] delete_storage: Specified whether to delete the associated SFS resources when deleting BCS
               instance. Default is false.
        :param pulumi.Input[int] edition: Specifies Service edition of the BCS instance. Valid values are `1`, `2` and `4`
               . Changing this will create a new instance.
        :param pulumi.Input[bool] eip_enable: Specifies whether to use the EIP of the CCE to bind the BCS instance.
               Changing this will create a new instance. Defalut is true.
        :param pulumi.Input[str] enterprise_project_id: Specifies the ID of the enterprise project that the BCS
               instance belong to. Changing this will create a new instance.
        :param pulumi.Input[str] fabric_version: Specifies version of fabric for the BCS instance. Valid values
               are `1.4` and `2.0`
               Changing this will create a new instance.
        :param pulumi.Input[pulumi.InputType['InstanceKafkaArgs']] kafka: Specifies the kafka configuration for the BCS instance. Changing this will create
               a new instance. The kafka object structure is documented below.
        :param pulumi.Input[str] name: Specifies the name of the channel. Changing this creates a new instance.
        :param pulumi.Input[str] old_service_version: The version of an old BCS service.
        :param pulumi.Input[int] orderer_node_num: Specifies the number of peers in the orderer organizaion. Changing this
               will create a new instance.
        :param pulumi.Input[int] org_disk_size: Specifies the storage capacity of peer organization. Changing this will
               create a new instance.
               + The minimum storage capacity of `efs` volume type is 500GB.
        :param pulumi.Input[str] password: Specifies the password of the couch datebase. The password consists of 8 to
               26 characters and must consist at least three of following: uppercase letters, lowercase letters, digits, special
               charactors(!@$%^-_=+[{}]:,./?). Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstancePeerOrgArgs']]]] peer_orgs: Specifies an array of one or more Peer organizations to attach to the BCS
               instance. Changing this will create a new instance. If omitted, the bcs instance will create a `peer_orgs`
               named `organization` by default and the node count is 2. The peer_orgs object structure is documented below.
        :param pulumi.Input[str] purchase_type: The deployment type of the BCS instance.
        :param pulumi.Input[str] region: Specifies the region in which to create the instance. If omitted, the
               provider-level region will be used. Changing this will create a new instance.
        :param pulumi.Input[bool] restful_api_support: Specified whether to add RESTful API support. Changing this will
               create a new instance.
        :param pulumi.Input[bool] rollback_support: Whether rollback is supported when the BCS service fails to br upgraded.
        :param pulumi.Input[str] security_mechanism: Specifies the secutity mechanism used by the BCS instance. Valid
               values are `ECDSA` and `SM2`(Chinese cryptographic algorithms, The basic and professional don't support this
               algorithm). Default is `ECDSA`. Changing this will create a new instance.
        :param pulumi.Input[pulumi.InputType['InstanceSfsTurboArgs']] sfs_turbo: Specifies the information about the SFS Turbo file system. Changing this will
               create a new instance. The sfs_turbo object structure is documented below.
        :param pulumi.Input[str] status: The status of the BCS instance.
        :param pulumi.Input[bool] tc3_need: Specified whether to add Trusted computing platform. Changing this will create
               a new instance.
        :param pulumi.Input[str] version: The service verison of the BCS instance.
        :param pulumi.Input[str] volume_type: Specifies the storage volume type to attach to each organization of the
               BCS instance. Valid values are `nfs` (SFS) and `efs` (SFS Turbo). Changing this will create a new instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["agent_portal_addresses"] = agent_portal_addresses
        __props__.__dict__["block_info"] = block_info
        __props__.__dict__["blockchain_type"] = blockchain_type
        __props__.__dict__["cce_cluster_id"] = cce_cluster_id
        __props__.__dict__["channels"] = channels
        __props__.__dict__["cluster_type"] = cluster_type
        __props__.__dict__["consensus"] = consensus
        __props__.__dict__["couchdb"] = couchdb
        __props__.__dict__["cross_region_support"] = cross_region_support
        __props__.__dict__["database_type"] = database_type
        __props__.__dict__["delete_obs"] = delete_obs
        __props__.__dict__["delete_storage"] = delete_storage
        __props__.__dict__["edition"] = edition
        __props__.__dict__["eip_enable"] = eip_enable
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["fabric_version"] = fabric_version
        __props__.__dict__["kafka"] = kafka
        __props__.__dict__["name"] = name
        __props__.__dict__["old_service_version"] = old_service_version
        __props__.__dict__["orderer_node_num"] = orderer_node_num
        __props__.__dict__["org_disk_size"] = org_disk_size
        __props__.__dict__["password"] = password
        __props__.__dict__["peer_orgs"] = peer_orgs
        __props__.__dict__["purchase_type"] = purchase_type
        __props__.__dict__["region"] = region
        __props__.__dict__["restful_api_support"] = restful_api_support
        __props__.__dict__["rollback_support"] = rollback_support
        __props__.__dict__["security_mechanism"] = security_mechanism
        __props__.__dict__["sfs_turbo"] = sfs_turbo
        __props__.__dict__["status"] = status
        __props__.__dict__["tc3_need"] = tc3_need
        __props__.__dict__["version"] = version
        __props__.__dict__["volume_type"] = volume_type
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="agentPortalAddresses")
    def agent_portal_addresses(self) -> pulumi.Output[Sequence[str]]:
        """
        The agent addresses and port numbers on the user data plane of the BCS service.
        * `peer_orgs/pvc_name` - The name of the PersistenetVolumeClaim (PVC) used by the peer.
        * `peer_orgs/status` - The peer status. The value contains `IsCreating`, `IsUpgrading`, `Adding/IsScaling`,
        `Isdeleting`, `Normal`, `AbNormal` and `Unknown`.
        * `peer_orgs/status_detail` - The peer status in the format like `1/1`. The denominator is the total number of peers in
        the organization, and the numerator is the number of normal peers.
        * `peer_orgs/address/domain_port` - The domain name address.
        * `peer_orgs/address/ip_port` - The IP address.
        * `kafka/name` - The Kafka instance name.
        """
        return pulumi.get(self, "agent_portal_addresses")

    @property
    @pulumi.getter(name="blockInfo")
    def block_info(self) -> pulumi.Output[Optional['outputs.InstanceBlockInfo']]:
        """
        Specifies the configuration of block generation. The block_info object
        structure is documented below.
        """
        return pulumi.get(self, "block_info")

    @property
    @pulumi.getter(name="blockchainType")
    def blockchain_type(self) -> pulumi.Output[str]:
        """
        Specifies the blockchain type of the BCS instance. Valid values
        are `private` and  `union`. Default is `private`. Changing this will create a new instance.
        """
        return pulumi.get(self, "blockchain_type")

    @property
    @pulumi.getter(name="cceClusterId")
    def cce_cluster_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of the CCE cluster to attach to the BCS instance. The
        BCS service needs to exclusively occupy the CCE cluster. Please make sure that the CCE cluster is not occupied before
        deploying the BCS service. Changing this will create a new instance.
        """
        return pulumi.get(self, "cce_cluster_id")

    @property
    @pulumi.getter
    def channels(self) -> pulumi.Output[Sequence['outputs.InstanceChannel']]:
        """
        Specifies an array of one or more channels to attach to the BCS instance. If
        omitted, the bcs instance will create a `channels` named `channel` by default. Changing this will create a new
        instance. The channels object structure is documented below.
        """
        return pulumi.get(self, "channels")

    @property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> pulumi.Output[str]:
        return pulumi.get(self, "cluster_type")

    @property
    @pulumi.getter
    def consensus(self) -> pulumi.Output[str]:
        """
        Specifies the consensus algorithm used by the BCS instance. The valid
        values of fabric 1.4 are `solo`, `kafka` and `SFLIC`, and the valid values of fabric 2.0 are `SFLIC`
        and `etcdraft`. Changing this will create a new instance.
        """
        return pulumi.get(self, "consensus")

    @property
    @pulumi.getter
    def couchdb(self) -> pulumi.Output[Optional['outputs.InstanceCouchdb']]:
        """
        Specifies the NoSQL database used by BCS instance. If omitted, the bcs instance
        will create a `goleveldb`(File Database) database by default. Changing this will create a new instance. The couchdb
        object structure is documented below.
        """
        return pulumi.get(self, "couchdb")

    @property
    @pulumi.getter(name="crossRegionSupport")
    def cross_region_support(self) -> pulumi.Output[bool]:
        """
        Whether the BCS instance is deployed across regions.
        """
        return pulumi.get(self, "cross_region_support")

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> pulumi.Output[str]:
        return pulumi.get(self, "database_type")

    @property
    @pulumi.getter(name="deleteObs")
    def delete_obs(self) -> pulumi.Output[Optional[bool]]:
        """
        Specified whether to delete the associated OBS bucket when deleting BCS instance.
        `delete_obs` is used to delete the OBS created by the BCS instance of the Kafka consensus strategy. Default is false.
        """
        return pulumi.get(self, "delete_obs")

    @property
    @pulumi.getter(name="deleteStorage")
    def delete_storage(self) -> pulumi.Output[Optional[bool]]:
        """
        Specified whether to delete the associated SFS resources when deleting BCS
        instance. Default is false.
        """
        return pulumi.get(self, "delete_storage")

    @property
    @pulumi.getter
    def edition(self) -> pulumi.Output[int]:
        """
        Specifies Service edition of the BCS instance. Valid values are `1`, `2` and `4`
        . Changing this will create a new instance.
        """
        return pulumi.get(self, "edition")

    @property
    @pulumi.getter(name="eipEnable")
    def eip_enable(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to use the EIP of the CCE to bind the BCS instance.
        Changing this will create a new instance. Defalut is true.
        """
        return pulumi.get(self, "eip_enable")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of the enterprise project that the BCS
        instance belong to. Changing this will create a new instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter(name="fabricVersion")
    def fabric_version(self) -> pulumi.Output[str]:
        """
        Specifies version of fabric for the BCS instance. Valid values
        are `1.4` and `2.0`
        Changing this will create a new instance.
        """
        return pulumi.get(self, "fabric_version")

    @property
    @pulumi.getter
    def kafka(self) -> pulumi.Output[Optional['outputs.InstanceKafka']]:
        """
        Specifies the kafka configuration for the BCS instance. Changing this will create
        a new instance. The kafka object structure is documented below.
        """
        return pulumi.get(self, "kafka")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the channel. Changing this creates a new instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="oldServiceVersion")
    def old_service_version(self) -> pulumi.Output[str]:
        """
        The version of an old BCS service.
        """
        return pulumi.get(self, "old_service_version")

    @property
    @pulumi.getter(name="ordererNodeNum")
    def orderer_node_num(self) -> pulumi.Output[int]:
        """
        Specifies the number of peers in the orderer organizaion. Changing this
        will create a new instance.
        """
        return pulumi.get(self, "orderer_node_num")

    @property
    @pulumi.getter(name="orgDiskSize")
    def org_disk_size(self) -> pulumi.Output[int]:
        """
        Specifies the storage capacity of peer organization. Changing this will
        create a new instance.
        + The minimum storage capacity of `efs` volume type is 500GB.
        """
        return pulumi.get(self, "org_disk_size")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        Specifies the password of the couch datebase. The password consists of 8 to
        26 characters and must consist at least three of following: uppercase letters, lowercase letters, digits, special
        charactors(!@$%^-_=+[{}]:,./?). Changing this creates a new instance.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="peerOrgs")
    def peer_orgs(self) -> pulumi.Output[Sequence['outputs.InstancePeerOrg']]:
        """
        Specifies an array of one or more Peer organizations to attach to the BCS
        instance. Changing this will create a new instance. If omitted, the bcs instance will create a `peer_orgs`
        named `organization` by default and the node count is 2. The peer_orgs object structure is documented below.
        """
        return pulumi.get(self, "peer_orgs")

    @property
    @pulumi.getter(name="purchaseType")
    def purchase_type(self) -> pulumi.Output[str]:
        """
        The deployment type of the BCS instance.
        """
        return pulumi.get(self, "purchase_type")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the instance. If omitted, the
        provider-level region will be used. Changing this will create a new instance.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="restfulApiSupport")
    def restful_api_support(self) -> pulumi.Output[bool]:
        """
        Specified whether to add RESTful API support. Changing this will
        create a new instance.
        """
        return pulumi.get(self, "restful_api_support")

    @property
    @pulumi.getter(name="rollbackSupport")
    def rollback_support(self) -> pulumi.Output[bool]:
        """
        Whether rollback is supported when the BCS service fails to br upgraded.
        """
        return pulumi.get(self, "rollback_support")

    @property
    @pulumi.getter(name="securityMechanism")
    def security_mechanism(self) -> pulumi.Output[str]:
        """
        Specifies the secutity mechanism used by the BCS instance. Valid
        values are `ECDSA` and `SM2`(Chinese cryptographic algorithms, The basic and professional don't support this
        algorithm). Default is `ECDSA`. Changing this will create a new instance.
        """
        return pulumi.get(self, "security_mechanism")

    @property
    @pulumi.getter(name="sfsTurbo")
    def sfs_turbo(self) -> pulumi.Output[Optional['outputs.InstanceSfsTurbo']]:
        """
        Specifies the information about the SFS Turbo file system. Changing this will
        create a new instance. The sfs_turbo object structure is documented below.
        """
        return pulumi.get(self, "sfs_turbo")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the BCS instance.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tc3Need")
    def tc3_need(self) -> pulumi.Output[bool]:
        """
        Specified whether to add Trusted computing platform. Changing this will create
        a new instance.
        """
        return pulumi.get(self, "tc3_need")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        The service verison of the BCS instance.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> pulumi.Output[str]:
        """
        Specifies the storage volume type to attach to each organization of the
        BCS instance. Valid values are `nfs` (SFS) and `efs` (SFS Turbo). Changing this will create a new instance.
        """
        return pulumi.get(self, "volume_type")

