# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GroupArgs', 'Group']

@pulumi.input_type
class GroupArgs:
    def __init__(__self__, *,
                 networks: pulumi.Input[Sequence[pulumi.Input['GroupNetworkArgs']]],
                 scaling_group_name: pulumi.Input[str],
                 security_groups: pulumi.Input[Sequence[pulumi.Input['GroupSecurityGroupArgs']]],
                 vpc_id: pulumi.Input[str],
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cool_down_time: Optional[pulumi.Input[int]] = None,
                 delete_instances: Optional[pulumi.Input[str]] = None,
                 delete_publicip: Optional[pulumi.Input[bool]] = None,
                 desire_instance_number: Optional[pulumi.Input[int]] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 health_periodic_audit_method: Optional[pulumi.Input[str]] = None,
                 health_periodic_audit_time: Optional[pulumi.Input[int]] = None,
                 instance_terminate_policy: Optional[pulumi.Input[str]] = None,
                 lb_listener_id: Optional[pulumi.Input[str]] = None,
                 lbaas_listeners: Optional[pulumi.Input[Sequence[pulumi.Input['GroupLbaasListenerArgs']]]] = None,
                 max_instance_number: Optional[pulumi.Input[int]] = None,
                 min_instance_number: Optional[pulumi.Input[int]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 scaling_configuration_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Group resource.
        :param pulumi.Input[Sequence[pulumi.Input['GroupNetworkArgs']]] networks: An array of one or more network IDs. The system supports up to five networks. The
               networks object structure is documented below.
        :param pulumi.Input[str] scaling_group_name: The name of the scaling group. The name can contain letters, digits,
               underscores(_), and hyphens(-),and cannot exceed 64 characters.
        :param pulumi.Input[Sequence[pulumi.Input['GroupSecurityGroupArgs']]] security_groups: An array of one or more security group IDs to associate with the group. The
               security_groups object structure is documented below.
        :param pulumi.Input[str] vpc_id: The VPC ID. Changing this creates a new group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] available_zones: The availability zones in which to create the instances in the autoscaling group.
        :param pulumi.Input[int] cool_down_time: The cooling duration (in seconds). The value ranges from 0 to 86400, and is 300 by
               default.
        :param pulumi.Input[str] delete_instances: Whether to delete the instances in the AS group when deleting the AS group.
               The options are `yes` and `no`.
        :param pulumi.Input[bool] delete_publicip: Whether to delete the elastic IP address bound to the instances of AS group when
               deleting the instances. The options are `true` and `false`.
        :param pulumi.Input[int] desire_instance_number: The expected number of instances. The default value is the minimum number
               of instances. The value ranges from the minimum number of instances to the maximum number of instances.
        :param pulumi.Input[bool] enable: Whether to enable the AS Group. The options are `true` and `false`. The default value
               is `true`.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the AS group.
        :param pulumi.Input[bool] force_delete: Whether to forcibly delete the AS group, remove the ECS instances and release them.
               The default value is `false`.
        :param pulumi.Input[str] health_periodic_audit_method: The health check method for instances in the AS group. The health
               check methods include `ELB_AUDIT` and `NOVA_AUDIT`. If load balancing is configured, the default value of this
               parameter is `ELB_AUDIT`. Otherwise, the default value is `NOVA_AUDIT`.
        :param pulumi.Input[int] health_periodic_audit_time: The health check period for instances. The period has four options: 5
               minutes (default), 15 minutes, 60 minutes, and 180 minutes.
        :param pulumi.Input[str] instance_terminate_policy: The instance removal policy. The policy has four
               options: `OLD_CONFIG_OLD_INSTANCE` (default), `OLD_CONFIG_NEW_INSTANCE`,
               `OLD_INSTANCE`, and `NEW_INSTANCE`.
        :param pulumi.Input[str] lb_listener_id: The system supports the binding of up to six ELB listeners, the IDs of which are separated using a comma.
        :param pulumi.Input[Sequence[pulumi.Input['GroupLbaasListenerArgs']]] lbaas_listeners: An array of one or more enhanced load balancer. The system supports the binding
               of up to six load balancers. The object structure is documented below.
        :param pulumi.Input[int] max_instance_number: The maximum number of instances. The default value is 0.
        :param pulumi.Input[int] min_instance_number: The minimum number of instances. The default value is 0.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notifications: The notification mode. The system only supports `EMAIL`
               mode which refers to notification by email.
        :param pulumi.Input[str] region: The region in which to create the AS group. If omitted, the `region` argument
               of the provider is used. Changing this creates a new AS group.
        :param pulumi.Input[str] scaling_configuration_id: The configuration ID which defines configurations of instances in the
               AS group.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the scaling group.
        """
        pulumi.set(__self__, "networks", networks)
        pulumi.set(__self__, "scaling_group_name", scaling_group_name)
        pulumi.set(__self__, "security_groups", security_groups)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if available_zones is not None:
            pulumi.set(__self__, "available_zones", available_zones)
        if cool_down_time is not None:
            pulumi.set(__self__, "cool_down_time", cool_down_time)
        if delete_instances is not None:
            pulumi.set(__self__, "delete_instances", delete_instances)
        if delete_publicip is not None:
            pulumi.set(__self__, "delete_publicip", delete_publicip)
        if desire_instance_number is not None:
            pulumi.set(__self__, "desire_instance_number", desire_instance_number)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if health_periodic_audit_method is not None:
            pulumi.set(__self__, "health_periodic_audit_method", health_periodic_audit_method)
        if health_periodic_audit_time is not None:
            pulumi.set(__self__, "health_periodic_audit_time", health_periodic_audit_time)
        if instance_terminate_policy is not None:
            pulumi.set(__self__, "instance_terminate_policy", instance_terminate_policy)
        if lb_listener_id is not None:
            warnings.warn("""use lbaas_listeners instead""", DeprecationWarning)
            pulumi.log.warn("""lb_listener_id is deprecated: use lbaas_listeners instead""")
        if lb_listener_id is not None:
            pulumi.set(__self__, "lb_listener_id", lb_listener_id)
        if lbaas_listeners is not None:
            pulumi.set(__self__, "lbaas_listeners", lbaas_listeners)
        if max_instance_number is not None:
            pulumi.set(__self__, "max_instance_number", max_instance_number)
        if min_instance_number is not None:
            pulumi.set(__self__, "min_instance_number", min_instance_number)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scaling_configuration_id is not None:
            pulumi.set(__self__, "scaling_configuration_id", scaling_configuration_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def networks(self) -> pulumi.Input[Sequence[pulumi.Input['GroupNetworkArgs']]]:
        """
        An array of one or more network IDs. The system supports up to five networks. The
        networks object structure is documented below.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: pulumi.Input[Sequence[pulumi.Input['GroupNetworkArgs']]]):
        pulumi.set(self, "networks", value)

    @property
    @pulumi.getter(name="scalingGroupName")
    def scaling_group_name(self) -> pulumi.Input[str]:
        """
        The name of the scaling group. The name can contain letters, digits,
        underscores(_), and hyphens(-),and cannot exceed 64 characters.
        """
        return pulumi.get(self, "scaling_group_name")

    @scaling_group_name.setter
    def scaling_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "scaling_group_name", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Input[Sequence[pulumi.Input['GroupSecurityGroupArgs']]]:
        """
        An array of one or more security group IDs to associate with the group. The
        security_groups object structure is documented below.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: pulumi.Input[Sequence[pulumi.Input['GroupSecurityGroupArgs']]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        The VPC ID. Changing this creates a new group.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="availableZones")
    def available_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The availability zones in which to create the instances in the autoscaling group.
        """
        return pulumi.get(self, "available_zones")

    @available_zones.setter
    def available_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "available_zones", value)

    @property
    @pulumi.getter(name="coolDownTime")
    def cool_down_time(self) -> Optional[pulumi.Input[int]]:
        """
        The cooling duration (in seconds). The value ranges from 0 to 86400, and is 300 by
        default.
        """
        return pulumi.get(self, "cool_down_time")

    @cool_down_time.setter
    def cool_down_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cool_down_time", value)

    @property
    @pulumi.getter(name="deleteInstances")
    def delete_instances(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to delete the instances in the AS group when deleting the AS group.
        The options are `yes` and `no`.
        """
        return pulumi.get(self, "delete_instances")

    @delete_instances.setter
    def delete_instances(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete_instances", value)

    @property
    @pulumi.getter(name="deletePublicip")
    def delete_publicip(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to delete the elastic IP address bound to the instances of AS group when
        deleting the instances. The options are `true` and `false`.
        """
        return pulumi.get(self, "delete_publicip")

    @delete_publicip.setter
    def delete_publicip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_publicip", value)

    @property
    @pulumi.getter(name="desireInstanceNumber")
    def desire_instance_number(self) -> Optional[pulumi.Input[int]]:
        """
        The expected number of instances. The default value is the minimum number
        of instances. The value ranges from the minimum number of instances to the maximum number of instances.
        """
        return pulumi.get(self, "desire_instance_number")

    @desire_instance_number.setter
    def desire_instance_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "desire_instance_number", value)

    @property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable the AS Group. The options are `true` and `false`. The default value
        is `true`.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The enterprise project id of the AS group.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to forcibly delete the AS group, remove the ECS instances and release them.
        The default value is `false`.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_delete", value)

    @property
    @pulumi.getter(name="healthPeriodicAuditMethod")
    def health_periodic_audit_method(self) -> Optional[pulumi.Input[str]]:
        """
        The health check method for instances in the AS group. The health
        check methods include `ELB_AUDIT` and `NOVA_AUDIT`. If load balancing is configured, the default value of this
        parameter is `ELB_AUDIT`. Otherwise, the default value is `NOVA_AUDIT`.
        """
        return pulumi.get(self, "health_periodic_audit_method")

    @health_periodic_audit_method.setter
    def health_periodic_audit_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_periodic_audit_method", value)

    @property
    @pulumi.getter(name="healthPeriodicAuditTime")
    def health_periodic_audit_time(self) -> Optional[pulumi.Input[int]]:
        """
        The health check period for instances. The period has four options: 5
        minutes (default), 15 minutes, 60 minutes, and 180 minutes.
        """
        return pulumi.get(self, "health_periodic_audit_time")

    @health_periodic_audit_time.setter
    def health_periodic_audit_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "health_periodic_audit_time", value)

    @property
    @pulumi.getter(name="instanceTerminatePolicy")
    def instance_terminate_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The instance removal policy. The policy has four
        options: `OLD_CONFIG_OLD_INSTANCE` (default), `OLD_CONFIG_NEW_INSTANCE`,
        `OLD_INSTANCE`, and `NEW_INSTANCE`.
        """
        return pulumi.get(self, "instance_terminate_policy")

    @instance_terminate_policy.setter
    def instance_terminate_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_terminate_policy", value)

    @property
    @pulumi.getter(name="lbListenerId")
    def lb_listener_id(self) -> Optional[pulumi.Input[str]]:
        """
        The system supports the binding of up to six ELB listeners, the IDs of which are separated using a comma.
        """
        return pulumi.get(self, "lb_listener_id")

    @lb_listener_id.setter
    def lb_listener_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lb_listener_id", value)

    @property
    @pulumi.getter(name="lbaasListeners")
    def lbaas_listeners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupLbaasListenerArgs']]]]:
        """
        An array of one or more enhanced load balancer. The system supports the binding
        of up to six load balancers. The object structure is documented below.
        """
        return pulumi.get(self, "lbaas_listeners")

    @lbaas_listeners.setter
    def lbaas_listeners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupLbaasListenerArgs']]]]):
        pulumi.set(self, "lbaas_listeners", value)

    @property
    @pulumi.getter(name="maxInstanceNumber")
    def max_instance_number(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of instances. The default value is 0.
        """
        return pulumi.get(self, "max_instance_number")

    @max_instance_number.setter
    def max_instance_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_instance_number", value)

    @property
    @pulumi.getter(name="minInstanceNumber")
    def min_instance_number(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of instances. The default value is 0.
        """
        return pulumi.get(self, "min_instance_number")

    @min_instance_number.setter
    def min_instance_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_instance_number", value)

    @property
    @pulumi.getter
    def notifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The notification mode. The system only supports `EMAIL`
        mode which refers to notification by email.
        """
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "notifications", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the AS group. If omitted, the `region` argument
        of the provider is used. Changing this creates a new AS group.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="scalingConfigurationId")
    def scaling_configuration_id(self) -> Optional[pulumi.Input[str]]:
        """
        The configuration ID which defines configurations of instances in the
        AS group.
        """
        return pulumi.get(self, "scaling_configuration_id")

    @scaling_configuration_id.setter
    def scaling_configuration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scaling_configuration_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value pairs to associate with the scaling group.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _GroupState:
    def __init__(__self__, *,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cool_down_time: Optional[pulumi.Input[int]] = None,
                 current_instance_number: Optional[pulumi.Input[int]] = None,
                 delete_instances: Optional[pulumi.Input[str]] = None,
                 delete_publicip: Optional[pulumi.Input[bool]] = None,
                 desire_instance_number: Optional[pulumi.Input[int]] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 health_periodic_audit_method: Optional[pulumi.Input[str]] = None,
                 health_periodic_audit_time: Optional[pulumi.Input[int]] = None,
                 instance_terminate_policy: Optional[pulumi.Input[str]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 lb_listener_id: Optional[pulumi.Input[str]] = None,
                 lbaas_listeners: Optional[pulumi.Input[Sequence[pulumi.Input['GroupLbaasListenerArgs']]]] = None,
                 max_instance_number: Optional[pulumi.Input[int]] = None,
                 min_instance_number: Optional[pulumi.Input[int]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['GroupNetworkArgs']]]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 scaling_configuration_id: Optional[pulumi.Input[str]] = None,
                 scaling_group_name: Optional[pulumi.Input[str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input['GroupSecurityGroupArgs']]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Group resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] available_zones: The availability zones in which to create the instances in the autoscaling group.
        :param pulumi.Input[int] cool_down_time: The cooling duration (in seconds). The value ranges from 0 to 86400, and is 300 by
               default.
        :param pulumi.Input[int] current_instance_number: Indicates the number of current instances in the AS group.
        :param pulumi.Input[str] delete_instances: Whether to delete the instances in the AS group when deleting the AS group.
               The options are `yes` and `no`.
        :param pulumi.Input[bool] delete_publicip: Whether to delete the elastic IP address bound to the instances of AS group when
               deleting the instances. The options are `true` and `false`.
        :param pulumi.Input[int] desire_instance_number: The expected number of instances. The default value is the minimum number
               of instances. The value ranges from the minimum number of instances to the maximum number of instances.
        :param pulumi.Input[bool] enable: Whether to enable the AS Group. The options are `true` and `false`. The default value
               is `true`.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the AS group.
        :param pulumi.Input[bool] force_delete: Whether to forcibly delete the AS group, remove the ECS instances and release them.
               The default value is `false`.
        :param pulumi.Input[str] health_periodic_audit_method: The health check method for instances in the AS group. The health
               check methods include `ELB_AUDIT` and `NOVA_AUDIT`. If load balancing is configured, the default value of this
               parameter is `ELB_AUDIT`. Otherwise, the default value is `NOVA_AUDIT`.
        :param pulumi.Input[int] health_periodic_audit_time: The health check period for instances. The period has four options: 5
               minutes (default), 15 minutes, 60 minutes, and 180 minutes.
        :param pulumi.Input[str] instance_terminate_policy: The instance removal policy. The policy has four
               options: `OLD_CONFIG_OLD_INSTANCE` (default), `OLD_CONFIG_NEW_INSTANCE`,
               `OLD_INSTANCE`, and `NEW_INSTANCE`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instances: The instances IDs of the AS group.
        :param pulumi.Input[str] lb_listener_id: The system supports the binding of up to six ELB listeners, the IDs of which are separated using a comma.
        :param pulumi.Input[Sequence[pulumi.Input['GroupLbaasListenerArgs']]] lbaas_listeners: An array of one or more enhanced load balancer. The system supports the binding
               of up to six load balancers. The object structure is documented below.
        :param pulumi.Input[int] max_instance_number: The maximum number of instances. The default value is 0.
        :param pulumi.Input[int] min_instance_number: The minimum number of instances. The default value is 0.
        :param pulumi.Input[Sequence[pulumi.Input['GroupNetworkArgs']]] networks: An array of one or more network IDs. The system supports up to five networks. The
               networks object structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notifications: The notification mode. The system only supports `EMAIL`
               mode which refers to notification by email.
        :param pulumi.Input[str] region: The region in which to create the AS group. If omitted, the `region` argument
               of the provider is used. Changing this creates a new AS group.
        :param pulumi.Input[str] scaling_configuration_id: The configuration ID which defines configurations of instances in the
               AS group.
        :param pulumi.Input[str] scaling_group_name: The name of the scaling group. The name can contain letters, digits,
               underscores(_), and hyphens(-),and cannot exceed 64 characters.
        :param pulumi.Input[Sequence[pulumi.Input['GroupSecurityGroupArgs']]] security_groups: An array of one or more security group IDs to associate with the group. The
               security_groups object structure is documented below.
        :param pulumi.Input[str] status: Indicates the status of the AS group.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the scaling group.
        :param pulumi.Input[str] vpc_id: The VPC ID. Changing this creates a new group.
        """
        if available_zones is not None:
            pulumi.set(__self__, "available_zones", available_zones)
        if cool_down_time is not None:
            pulumi.set(__self__, "cool_down_time", cool_down_time)
        if current_instance_number is not None:
            pulumi.set(__self__, "current_instance_number", current_instance_number)
        if delete_instances is not None:
            pulumi.set(__self__, "delete_instances", delete_instances)
        if delete_publicip is not None:
            pulumi.set(__self__, "delete_publicip", delete_publicip)
        if desire_instance_number is not None:
            pulumi.set(__self__, "desire_instance_number", desire_instance_number)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if health_periodic_audit_method is not None:
            pulumi.set(__self__, "health_periodic_audit_method", health_periodic_audit_method)
        if health_periodic_audit_time is not None:
            pulumi.set(__self__, "health_periodic_audit_time", health_periodic_audit_time)
        if instance_terminate_policy is not None:
            pulumi.set(__self__, "instance_terminate_policy", instance_terminate_policy)
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if lb_listener_id is not None:
            warnings.warn("""use lbaas_listeners instead""", DeprecationWarning)
            pulumi.log.warn("""lb_listener_id is deprecated: use lbaas_listeners instead""")
        if lb_listener_id is not None:
            pulumi.set(__self__, "lb_listener_id", lb_listener_id)
        if lbaas_listeners is not None:
            pulumi.set(__self__, "lbaas_listeners", lbaas_listeners)
        if max_instance_number is not None:
            pulumi.set(__self__, "max_instance_number", max_instance_number)
        if min_instance_number is not None:
            pulumi.set(__self__, "min_instance_number", min_instance_number)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scaling_configuration_id is not None:
            pulumi.set(__self__, "scaling_configuration_id", scaling_configuration_id)
        if scaling_group_name is not None:
            pulumi.set(__self__, "scaling_group_name", scaling_group_name)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="availableZones")
    def available_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The availability zones in which to create the instances in the autoscaling group.
        """
        return pulumi.get(self, "available_zones")

    @available_zones.setter
    def available_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "available_zones", value)

    @property
    @pulumi.getter(name="coolDownTime")
    def cool_down_time(self) -> Optional[pulumi.Input[int]]:
        """
        The cooling duration (in seconds). The value ranges from 0 to 86400, and is 300 by
        default.
        """
        return pulumi.get(self, "cool_down_time")

    @cool_down_time.setter
    def cool_down_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cool_down_time", value)

    @property
    @pulumi.getter(name="currentInstanceNumber")
    def current_instance_number(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates the number of current instances in the AS group.
        """
        return pulumi.get(self, "current_instance_number")

    @current_instance_number.setter
    def current_instance_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "current_instance_number", value)

    @property
    @pulumi.getter(name="deleteInstances")
    def delete_instances(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to delete the instances in the AS group when deleting the AS group.
        The options are `yes` and `no`.
        """
        return pulumi.get(self, "delete_instances")

    @delete_instances.setter
    def delete_instances(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete_instances", value)

    @property
    @pulumi.getter(name="deletePublicip")
    def delete_publicip(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to delete the elastic IP address bound to the instances of AS group when
        deleting the instances. The options are `true` and `false`.
        """
        return pulumi.get(self, "delete_publicip")

    @delete_publicip.setter
    def delete_publicip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_publicip", value)

    @property
    @pulumi.getter(name="desireInstanceNumber")
    def desire_instance_number(self) -> Optional[pulumi.Input[int]]:
        """
        The expected number of instances. The default value is the minimum number
        of instances. The value ranges from the minimum number of instances to the maximum number of instances.
        """
        return pulumi.get(self, "desire_instance_number")

    @desire_instance_number.setter
    def desire_instance_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "desire_instance_number", value)

    @property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable the AS Group. The options are `true` and `false`. The default value
        is `true`.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The enterprise project id of the AS group.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to forcibly delete the AS group, remove the ECS instances and release them.
        The default value is `false`.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_delete", value)

    @property
    @pulumi.getter(name="healthPeriodicAuditMethod")
    def health_periodic_audit_method(self) -> Optional[pulumi.Input[str]]:
        """
        The health check method for instances in the AS group. The health
        check methods include `ELB_AUDIT` and `NOVA_AUDIT`. If load balancing is configured, the default value of this
        parameter is `ELB_AUDIT`. Otherwise, the default value is `NOVA_AUDIT`.
        """
        return pulumi.get(self, "health_periodic_audit_method")

    @health_periodic_audit_method.setter
    def health_periodic_audit_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_periodic_audit_method", value)

    @property
    @pulumi.getter(name="healthPeriodicAuditTime")
    def health_periodic_audit_time(self) -> Optional[pulumi.Input[int]]:
        """
        The health check period for instances. The period has four options: 5
        minutes (default), 15 minutes, 60 minutes, and 180 minutes.
        """
        return pulumi.get(self, "health_periodic_audit_time")

    @health_periodic_audit_time.setter
    def health_periodic_audit_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "health_periodic_audit_time", value)

    @property
    @pulumi.getter(name="instanceTerminatePolicy")
    def instance_terminate_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The instance removal policy. The policy has four
        options: `OLD_CONFIG_OLD_INSTANCE` (default), `OLD_CONFIG_NEW_INSTANCE`,
        `OLD_INSTANCE`, and `NEW_INSTANCE`.
        """
        return pulumi.get(self, "instance_terminate_policy")

    @instance_terminate_policy.setter
    def instance_terminate_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_terminate_policy", value)

    @property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The instances IDs of the AS group.
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instances", value)

    @property
    @pulumi.getter(name="lbListenerId")
    def lb_listener_id(self) -> Optional[pulumi.Input[str]]:
        """
        The system supports the binding of up to six ELB listeners, the IDs of which are separated using a comma.
        """
        return pulumi.get(self, "lb_listener_id")

    @lb_listener_id.setter
    def lb_listener_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lb_listener_id", value)

    @property
    @pulumi.getter(name="lbaasListeners")
    def lbaas_listeners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupLbaasListenerArgs']]]]:
        """
        An array of one or more enhanced load balancer. The system supports the binding
        of up to six load balancers. The object structure is documented below.
        """
        return pulumi.get(self, "lbaas_listeners")

    @lbaas_listeners.setter
    def lbaas_listeners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupLbaasListenerArgs']]]]):
        pulumi.set(self, "lbaas_listeners", value)

    @property
    @pulumi.getter(name="maxInstanceNumber")
    def max_instance_number(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of instances. The default value is 0.
        """
        return pulumi.get(self, "max_instance_number")

    @max_instance_number.setter
    def max_instance_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_instance_number", value)

    @property
    @pulumi.getter(name="minInstanceNumber")
    def min_instance_number(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of instances. The default value is 0.
        """
        return pulumi.get(self, "min_instance_number")

    @min_instance_number.setter
    def min_instance_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_instance_number", value)

    @property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupNetworkArgs']]]]:
        """
        An array of one or more network IDs. The system supports up to five networks. The
        networks object structure is documented below.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupNetworkArgs']]]]):
        pulumi.set(self, "networks", value)

    @property
    @pulumi.getter
    def notifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The notification mode. The system only supports `EMAIL`
        mode which refers to notification by email.
        """
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "notifications", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the AS group. If omitted, the `region` argument
        of the provider is used. Changing this creates a new AS group.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="scalingConfigurationId")
    def scaling_configuration_id(self) -> Optional[pulumi.Input[str]]:
        """
        The configuration ID which defines configurations of instances in the
        AS group.
        """
        return pulumi.get(self, "scaling_configuration_id")

    @scaling_configuration_id.setter
    def scaling_configuration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scaling_configuration_id", value)

    @property
    @pulumi.getter(name="scalingGroupName")
    def scaling_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the scaling group. The name can contain letters, digits,
        underscores(_), and hyphens(-),and cannot exceed 64 characters.
        """
        return pulumi.get(self, "scaling_group_name")

    @scaling_group_name.setter
    def scaling_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scaling_group_name", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupSecurityGroupArgs']]]]:
        """
        An array of one or more security group IDs to associate with the group. The
        security_groups object structure is documented below.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupSecurityGroupArgs']]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the status of the AS group.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value pairs to associate with the scaling group.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The VPC ID. Changing this creates a new group.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class Group(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cool_down_time: Optional[pulumi.Input[int]] = None,
                 delete_instances: Optional[pulumi.Input[str]] = None,
                 delete_publicip: Optional[pulumi.Input[bool]] = None,
                 desire_instance_number: Optional[pulumi.Input[int]] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 health_periodic_audit_method: Optional[pulumi.Input[str]] = None,
                 health_periodic_audit_time: Optional[pulumi.Input[int]] = None,
                 instance_terminate_policy: Optional[pulumi.Input[str]] = None,
                 lb_listener_id: Optional[pulumi.Input[str]] = None,
                 lbaas_listeners: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GroupLbaasListenerArgs']]]]] = None,
                 max_instance_number: Optional[pulumi.Input[int]] = None,
                 min_instance_number: Optional[pulumi.Input[int]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GroupNetworkArgs']]]]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 scaling_configuration_id: Optional[pulumi.Input[str]] = None,
                 scaling_group_name: Optional[pulumi.Input[str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GroupSecurityGroupArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a Autoscaling Group resource within HuaweiCloud.

        ## Example Usage
        ### Basic Autoscaling Group

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        my_as_group = huaweicloud.as_.Group("myAsGroup",
            delete_instances="yes",
            delete_publicip=True,
            desire_instance_number=2,
            max_instance_number=10,
            min_instance_number=0,
            networks=[huaweicloud.as_.GroupNetworkArgs(
                id="ad091b52-742f-469e-8f3c-fd81cadf0743",
            )],
            scaling_configuration_id="37e310f5-db9d-446e-9135-c625f9c2bbfc",
            scaling_group_name="my_as_group",
            security_groups=[huaweicloud.as_.GroupSecurityGroupArgs(
                id="45e4c6de-6bf0-4843-8953-2babde3d4810",
            )],
            vpc_id="1d8f7e7c-fe04-4cf5-85ac-08b478c290e9")
        ```
        ### Autoscaling Group with tags

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        my_as_group_tags = huaweicloud.as_.Group("myAsGroupTags",
            delete_instances="yes",
            delete_publicip=True,
            desire_instance_number=2,
            max_instance_number=10,
            min_instance_number=0,
            networks=[huaweicloud.as_.GroupNetworkArgs(
                id="ad091b52-742f-469e-8f3c-fd81cadf0743",
            )],
            scaling_configuration_id="37e310f5-db9d-446e-9135-c625f9c2bbfc",
            scaling_group_name="my_as_group_tags",
            security_groups=[huaweicloud.as_.GroupSecurityGroupArgs(
                id="45e4c6de-6bf0-4843-8953-2babde3d4810",
            )],
            tags={
                "foo": "bar",
                "key": "value",
            },
            vpc_id="1d8f7e7c-fe04-4cf5-85ac-08b478c290e9")
        ```
        ### Autoscaling Group Only Remove Members When Scaling Down

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        my_as_group_only_remove_members = huaweicloud.as_.Group("myAsGroupOnlyRemoveMembers",
            delete_instances="no",
            delete_publicip=True,
            desire_instance_number=2,
            max_instance_number=10,
            min_instance_number=0,
            networks=[huaweicloud.as_.GroupNetworkArgs(
                id="ad091b52-742f-469e-8f3c-fd81cadf0743",
            )],
            scaling_configuration_id="37e310f5-db9d-446e-9135-c625f9c2bbfc",
            scaling_group_name="my_as_group_only_remove_members",
            security_groups=[huaweicloud.as_.GroupSecurityGroupArgs(
                id="45e4c6de-6bf0-4843-8953-2babde3d4810",
            )],
            vpc_id="1d8f7e7c-fe04-4cf5-85ac-08b478c290e9")
        ```
        ### Autoscaling Group With Enhanced Load Balancer Listener

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        loadbalancer1 = huaweicloud.elb.Loadbalancer("loadbalancer1", vip_subnet_id="d9415786-5f1a-428b-b35f-2f1523e146d2")
        listener1 = huaweicloud.elb.Listener("listener1",
            protocol="HTTP",
            protocol_port=8080,
            loadbalancer_id=loadbalancer1.id)
        pool1 = huaweicloud.elb.Pool("pool1",
            protocol="HTTP",
            lb_method="ROUND_ROBIN",
            listener_id=listener1.id)
        my_as_group_with_enhanced_lb = huaweicloud.as_.Group("myAsGroupWithEnhancedLb",
            scaling_group_name="my_as_group_with_enhanced_lb",
            scaling_configuration_id="37e310f5-db9d-446e-9135-c625f9c2bbfc",
            desire_instance_number=2,
            min_instance_number=0,
            max_instance_number=10,
            vpc_id="1d8f7e7c-fe04-4cf5-85ac-08b478c290e9",
            networks=[huaweicloud.as_.GroupNetworkArgs(
                id="ad091b52-742f-469e-8f3c-fd81cadf0743",
            )],
            security_groups=[huaweicloud.as_.GroupSecurityGroupArgs(
                id="45e4c6de-6bf0-4843-8953-2babde3d4810",
            )],
            lbaas_listeners=[huaweicloud.as_.GroupLbaasListenerArgs(
                pool_id=pool1.id,
                protocol_port=listener1.protocol_port,
            )])
        ```

        ## Import

        AS groups can be imported by their `id`. For example,

        ```sh
         $ pulumi import huaweicloud:As/group:Group my_as_group 9ec5bea6-a728-4082-8109-5a7dc5c7af74
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] available_zones: The availability zones in which to create the instances in the autoscaling group.
        :param pulumi.Input[int] cool_down_time: The cooling duration (in seconds). The value ranges from 0 to 86400, and is 300 by
               default.
        :param pulumi.Input[str] delete_instances: Whether to delete the instances in the AS group when deleting the AS group.
               The options are `yes` and `no`.
        :param pulumi.Input[bool] delete_publicip: Whether to delete the elastic IP address bound to the instances of AS group when
               deleting the instances. The options are `true` and `false`.
        :param pulumi.Input[int] desire_instance_number: The expected number of instances. The default value is the minimum number
               of instances. The value ranges from the minimum number of instances to the maximum number of instances.
        :param pulumi.Input[bool] enable: Whether to enable the AS Group. The options are `true` and `false`. The default value
               is `true`.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the AS group.
        :param pulumi.Input[bool] force_delete: Whether to forcibly delete the AS group, remove the ECS instances and release them.
               The default value is `false`.
        :param pulumi.Input[str] health_periodic_audit_method: The health check method for instances in the AS group. The health
               check methods include `ELB_AUDIT` and `NOVA_AUDIT`. If load balancing is configured, the default value of this
               parameter is `ELB_AUDIT`. Otherwise, the default value is `NOVA_AUDIT`.
        :param pulumi.Input[int] health_periodic_audit_time: The health check period for instances. The period has four options: 5
               minutes (default), 15 minutes, 60 minutes, and 180 minutes.
        :param pulumi.Input[str] instance_terminate_policy: The instance removal policy. The policy has four
               options: `OLD_CONFIG_OLD_INSTANCE` (default), `OLD_CONFIG_NEW_INSTANCE`,
               `OLD_INSTANCE`, and `NEW_INSTANCE`.
        :param pulumi.Input[str] lb_listener_id: The system supports the binding of up to six ELB listeners, the IDs of which are separated using a comma.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GroupLbaasListenerArgs']]]] lbaas_listeners: An array of one or more enhanced load balancer. The system supports the binding
               of up to six load balancers. The object structure is documented below.
        :param pulumi.Input[int] max_instance_number: The maximum number of instances. The default value is 0.
        :param pulumi.Input[int] min_instance_number: The minimum number of instances. The default value is 0.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GroupNetworkArgs']]]] networks: An array of one or more network IDs. The system supports up to five networks. The
               networks object structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notifications: The notification mode. The system only supports `EMAIL`
               mode which refers to notification by email.
        :param pulumi.Input[str] region: The region in which to create the AS group. If omitted, the `region` argument
               of the provider is used. Changing this creates a new AS group.
        :param pulumi.Input[str] scaling_configuration_id: The configuration ID which defines configurations of instances in the
               AS group.
        :param pulumi.Input[str] scaling_group_name: The name of the scaling group. The name can contain letters, digits,
               underscores(_), and hyphens(-),and cannot exceed 64 characters.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GroupSecurityGroupArgs']]]] security_groups: An array of one or more security group IDs to associate with the group. The
               security_groups object structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the scaling group.
        :param pulumi.Input[str] vpc_id: The VPC ID. Changing this creates a new group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Autoscaling Group resource within HuaweiCloud.

        ## Example Usage
        ### Basic Autoscaling Group

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        my_as_group = huaweicloud.as_.Group("myAsGroup",
            delete_instances="yes",
            delete_publicip=True,
            desire_instance_number=2,
            max_instance_number=10,
            min_instance_number=0,
            networks=[huaweicloud.as_.GroupNetworkArgs(
                id="ad091b52-742f-469e-8f3c-fd81cadf0743",
            )],
            scaling_configuration_id="37e310f5-db9d-446e-9135-c625f9c2bbfc",
            scaling_group_name="my_as_group",
            security_groups=[huaweicloud.as_.GroupSecurityGroupArgs(
                id="45e4c6de-6bf0-4843-8953-2babde3d4810",
            )],
            vpc_id="1d8f7e7c-fe04-4cf5-85ac-08b478c290e9")
        ```
        ### Autoscaling Group with tags

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        my_as_group_tags = huaweicloud.as_.Group("myAsGroupTags",
            delete_instances="yes",
            delete_publicip=True,
            desire_instance_number=2,
            max_instance_number=10,
            min_instance_number=0,
            networks=[huaweicloud.as_.GroupNetworkArgs(
                id="ad091b52-742f-469e-8f3c-fd81cadf0743",
            )],
            scaling_configuration_id="37e310f5-db9d-446e-9135-c625f9c2bbfc",
            scaling_group_name="my_as_group_tags",
            security_groups=[huaweicloud.as_.GroupSecurityGroupArgs(
                id="45e4c6de-6bf0-4843-8953-2babde3d4810",
            )],
            tags={
                "foo": "bar",
                "key": "value",
            },
            vpc_id="1d8f7e7c-fe04-4cf5-85ac-08b478c290e9")
        ```
        ### Autoscaling Group Only Remove Members When Scaling Down

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        my_as_group_only_remove_members = huaweicloud.as_.Group("myAsGroupOnlyRemoveMembers",
            delete_instances="no",
            delete_publicip=True,
            desire_instance_number=2,
            max_instance_number=10,
            min_instance_number=0,
            networks=[huaweicloud.as_.GroupNetworkArgs(
                id="ad091b52-742f-469e-8f3c-fd81cadf0743",
            )],
            scaling_configuration_id="37e310f5-db9d-446e-9135-c625f9c2bbfc",
            scaling_group_name="my_as_group_only_remove_members",
            security_groups=[huaweicloud.as_.GroupSecurityGroupArgs(
                id="45e4c6de-6bf0-4843-8953-2babde3d4810",
            )],
            vpc_id="1d8f7e7c-fe04-4cf5-85ac-08b478c290e9")
        ```
        ### Autoscaling Group With Enhanced Load Balancer Listener

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        loadbalancer1 = huaweicloud.elb.Loadbalancer("loadbalancer1", vip_subnet_id="d9415786-5f1a-428b-b35f-2f1523e146d2")
        listener1 = huaweicloud.elb.Listener("listener1",
            protocol="HTTP",
            protocol_port=8080,
            loadbalancer_id=loadbalancer1.id)
        pool1 = huaweicloud.elb.Pool("pool1",
            protocol="HTTP",
            lb_method="ROUND_ROBIN",
            listener_id=listener1.id)
        my_as_group_with_enhanced_lb = huaweicloud.as_.Group("myAsGroupWithEnhancedLb",
            scaling_group_name="my_as_group_with_enhanced_lb",
            scaling_configuration_id="37e310f5-db9d-446e-9135-c625f9c2bbfc",
            desire_instance_number=2,
            min_instance_number=0,
            max_instance_number=10,
            vpc_id="1d8f7e7c-fe04-4cf5-85ac-08b478c290e9",
            networks=[huaweicloud.as_.GroupNetworkArgs(
                id="ad091b52-742f-469e-8f3c-fd81cadf0743",
            )],
            security_groups=[huaweicloud.as_.GroupSecurityGroupArgs(
                id="45e4c6de-6bf0-4843-8953-2babde3d4810",
            )],
            lbaas_listeners=[huaweicloud.as_.GroupLbaasListenerArgs(
                pool_id=pool1.id,
                protocol_port=listener1.protocol_port,
            )])
        ```

        ## Import

        AS groups can be imported by their `id`. For example,

        ```sh
         $ pulumi import huaweicloud:As/group:Group my_as_group 9ec5bea6-a728-4082-8109-5a7dc5c7af74
        ```

        :param str resource_name: The name of the resource.
        :param GroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cool_down_time: Optional[pulumi.Input[int]] = None,
                 delete_instances: Optional[pulumi.Input[str]] = None,
                 delete_publicip: Optional[pulumi.Input[bool]] = None,
                 desire_instance_number: Optional[pulumi.Input[int]] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 health_periodic_audit_method: Optional[pulumi.Input[str]] = None,
                 health_periodic_audit_time: Optional[pulumi.Input[int]] = None,
                 instance_terminate_policy: Optional[pulumi.Input[str]] = None,
                 lb_listener_id: Optional[pulumi.Input[str]] = None,
                 lbaas_listeners: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GroupLbaasListenerArgs']]]]] = None,
                 max_instance_number: Optional[pulumi.Input[int]] = None,
                 min_instance_number: Optional[pulumi.Input[int]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GroupNetworkArgs']]]]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 scaling_configuration_id: Optional[pulumi.Input[str]] = None,
                 scaling_group_name: Optional[pulumi.Input[str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GroupSecurityGroupArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupArgs.__new__(GroupArgs)

            __props__.__dict__["available_zones"] = available_zones
            __props__.__dict__["cool_down_time"] = cool_down_time
            __props__.__dict__["delete_instances"] = delete_instances
            __props__.__dict__["delete_publicip"] = delete_publicip
            __props__.__dict__["desire_instance_number"] = desire_instance_number
            __props__.__dict__["enable"] = enable
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["force_delete"] = force_delete
            __props__.__dict__["health_periodic_audit_method"] = health_periodic_audit_method
            __props__.__dict__["health_periodic_audit_time"] = health_periodic_audit_time
            __props__.__dict__["instance_terminate_policy"] = instance_terminate_policy
            if lb_listener_id is not None and not opts.urn:
                warnings.warn("""use lbaas_listeners instead""", DeprecationWarning)
                pulumi.log.warn("""lb_listener_id is deprecated: use lbaas_listeners instead""")
            __props__.__dict__["lb_listener_id"] = lb_listener_id
            __props__.__dict__["lbaas_listeners"] = lbaas_listeners
            __props__.__dict__["max_instance_number"] = max_instance_number
            __props__.__dict__["min_instance_number"] = min_instance_number
            if networks is None and not opts.urn:
                raise TypeError("Missing required property 'networks'")
            __props__.__dict__["networks"] = networks
            __props__.__dict__["notifications"] = notifications
            __props__.__dict__["region"] = region
            __props__.__dict__["scaling_configuration_id"] = scaling_configuration_id
            if scaling_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'scaling_group_name'")
            __props__.__dict__["scaling_group_name"] = scaling_group_name
            if security_groups is None and not opts.urn:
                raise TypeError("Missing required property 'security_groups'")
            __props__.__dict__["security_groups"] = security_groups
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["current_instance_number"] = None
            __props__.__dict__["instances"] = None
            __props__.__dict__["status"] = None
        super(Group, __self__).__init__(
            'huaweicloud:As/group:Group',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            cool_down_time: Optional[pulumi.Input[int]] = None,
            current_instance_number: Optional[pulumi.Input[int]] = None,
            delete_instances: Optional[pulumi.Input[str]] = None,
            delete_publicip: Optional[pulumi.Input[bool]] = None,
            desire_instance_number: Optional[pulumi.Input[int]] = None,
            enable: Optional[pulumi.Input[bool]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            force_delete: Optional[pulumi.Input[bool]] = None,
            health_periodic_audit_method: Optional[pulumi.Input[str]] = None,
            health_periodic_audit_time: Optional[pulumi.Input[int]] = None,
            instance_terminate_policy: Optional[pulumi.Input[str]] = None,
            instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            lb_listener_id: Optional[pulumi.Input[str]] = None,
            lbaas_listeners: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GroupLbaasListenerArgs']]]]] = None,
            max_instance_number: Optional[pulumi.Input[int]] = None,
            min_instance_number: Optional[pulumi.Input[int]] = None,
            networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GroupNetworkArgs']]]]] = None,
            notifications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            region: Optional[pulumi.Input[str]] = None,
            scaling_configuration_id: Optional[pulumi.Input[str]] = None,
            scaling_group_name: Optional[pulumi.Input[str]] = None,
            security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GroupSecurityGroupArgs']]]]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'Group':
        """
        Get an existing Group resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] available_zones: The availability zones in which to create the instances in the autoscaling group.
        :param pulumi.Input[int] cool_down_time: The cooling duration (in seconds). The value ranges from 0 to 86400, and is 300 by
               default.
        :param pulumi.Input[int] current_instance_number: Indicates the number of current instances in the AS group.
        :param pulumi.Input[str] delete_instances: Whether to delete the instances in the AS group when deleting the AS group.
               The options are `yes` and `no`.
        :param pulumi.Input[bool] delete_publicip: Whether to delete the elastic IP address bound to the instances of AS group when
               deleting the instances. The options are `true` and `false`.
        :param pulumi.Input[int] desire_instance_number: The expected number of instances. The default value is the minimum number
               of instances. The value ranges from the minimum number of instances to the maximum number of instances.
        :param pulumi.Input[bool] enable: Whether to enable the AS Group. The options are `true` and `false`. The default value
               is `true`.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the AS group.
        :param pulumi.Input[bool] force_delete: Whether to forcibly delete the AS group, remove the ECS instances and release them.
               The default value is `false`.
        :param pulumi.Input[str] health_periodic_audit_method: The health check method for instances in the AS group. The health
               check methods include `ELB_AUDIT` and `NOVA_AUDIT`. If load balancing is configured, the default value of this
               parameter is `ELB_AUDIT`. Otherwise, the default value is `NOVA_AUDIT`.
        :param pulumi.Input[int] health_periodic_audit_time: The health check period for instances. The period has four options: 5
               minutes (default), 15 minutes, 60 minutes, and 180 minutes.
        :param pulumi.Input[str] instance_terminate_policy: The instance removal policy. The policy has four
               options: `OLD_CONFIG_OLD_INSTANCE` (default), `OLD_CONFIG_NEW_INSTANCE`,
               `OLD_INSTANCE`, and `NEW_INSTANCE`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instances: The instances IDs of the AS group.
        :param pulumi.Input[str] lb_listener_id: The system supports the binding of up to six ELB listeners, the IDs of which are separated using a comma.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GroupLbaasListenerArgs']]]] lbaas_listeners: An array of one or more enhanced load balancer. The system supports the binding
               of up to six load balancers. The object structure is documented below.
        :param pulumi.Input[int] max_instance_number: The maximum number of instances. The default value is 0.
        :param pulumi.Input[int] min_instance_number: The minimum number of instances. The default value is 0.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GroupNetworkArgs']]]] networks: An array of one or more network IDs. The system supports up to five networks. The
               networks object structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notifications: The notification mode. The system only supports `EMAIL`
               mode which refers to notification by email.
        :param pulumi.Input[str] region: The region in which to create the AS group. If omitted, the `region` argument
               of the provider is used. Changing this creates a new AS group.
        :param pulumi.Input[str] scaling_configuration_id: The configuration ID which defines configurations of instances in the
               AS group.
        :param pulumi.Input[str] scaling_group_name: The name of the scaling group. The name can contain letters, digits,
               underscores(_), and hyphens(-),and cannot exceed 64 characters.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GroupSecurityGroupArgs']]]] security_groups: An array of one or more security group IDs to associate with the group. The
               security_groups object structure is documented below.
        :param pulumi.Input[str] status: Indicates the status of the AS group.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the scaling group.
        :param pulumi.Input[str] vpc_id: The VPC ID. Changing this creates a new group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GroupState.__new__(_GroupState)

        __props__.__dict__["available_zones"] = available_zones
        __props__.__dict__["cool_down_time"] = cool_down_time
        __props__.__dict__["current_instance_number"] = current_instance_number
        __props__.__dict__["delete_instances"] = delete_instances
        __props__.__dict__["delete_publicip"] = delete_publicip
        __props__.__dict__["desire_instance_number"] = desire_instance_number
        __props__.__dict__["enable"] = enable
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["force_delete"] = force_delete
        __props__.__dict__["health_periodic_audit_method"] = health_periodic_audit_method
        __props__.__dict__["health_periodic_audit_time"] = health_periodic_audit_time
        __props__.__dict__["instance_terminate_policy"] = instance_terminate_policy
        __props__.__dict__["instances"] = instances
        __props__.__dict__["lb_listener_id"] = lb_listener_id
        __props__.__dict__["lbaas_listeners"] = lbaas_listeners
        __props__.__dict__["max_instance_number"] = max_instance_number
        __props__.__dict__["min_instance_number"] = min_instance_number
        __props__.__dict__["networks"] = networks
        __props__.__dict__["notifications"] = notifications
        __props__.__dict__["region"] = region
        __props__.__dict__["scaling_configuration_id"] = scaling_configuration_id
        __props__.__dict__["scaling_group_name"] = scaling_group_name
        __props__.__dict__["security_groups"] = security_groups
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_id"] = vpc_id
        return Group(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availableZones")
    def available_zones(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The availability zones in which to create the instances in the autoscaling group.
        """
        return pulumi.get(self, "available_zones")

    @property
    @pulumi.getter(name="coolDownTime")
    def cool_down_time(self) -> pulumi.Output[Optional[int]]:
        """
        The cooling duration (in seconds). The value ranges from 0 to 86400, and is 300 by
        default.
        """
        return pulumi.get(self, "cool_down_time")

    @property
    @pulumi.getter(name="currentInstanceNumber")
    def current_instance_number(self) -> pulumi.Output[int]:
        """
        Indicates the number of current instances in the AS group.
        """
        return pulumi.get(self, "current_instance_number")

    @property
    @pulumi.getter(name="deleteInstances")
    def delete_instances(self) -> pulumi.Output[Optional[str]]:
        """
        Whether to delete the instances in the AS group when deleting the AS group.
        The options are `yes` and `no`.
        """
        return pulumi.get(self, "delete_instances")

    @property
    @pulumi.getter(name="deletePublicip")
    def delete_publicip(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to delete the elastic IP address bound to the instances of AS group when
        deleting the instances. The options are `true` and `false`.
        """
        return pulumi.get(self, "delete_publicip")

    @property
    @pulumi.getter(name="desireInstanceNumber")
    def desire_instance_number(self) -> pulumi.Output[int]:
        """
        The expected number of instances. The default value is the minimum number
        of instances. The value ranges from the minimum number of instances to the maximum number of instances.
        """
        return pulumi.get(self, "desire_instance_number")

    @property
    @pulumi.getter
    def enable(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable the AS Group. The options are `true` and `false`. The default value
        is `true`.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        The enterprise project id of the AS group.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to forcibly delete the AS group, remove the ECS instances and release them.
        The default value is `false`.
        """
        return pulumi.get(self, "force_delete")

    @property
    @pulumi.getter(name="healthPeriodicAuditMethod")
    def health_periodic_audit_method(self) -> pulumi.Output[Optional[str]]:
        """
        The health check method for instances in the AS group. The health
        check methods include `ELB_AUDIT` and `NOVA_AUDIT`. If load balancing is configured, the default value of this
        parameter is `ELB_AUDIT`. Otherwise, the default value is `NOVA_AUDIT`.
        """
        return pulumi.get(self, "health_periodic_audit_method")

    @property
    @pulumi.getter(name="healthPeriodicAuditTime")
    def health_periodic_audit_time(self) -> pulumi.Output[Optional[int]]:
        """
        The health check period for instances. The period has four options: 5
        minutes (default), 15 minutes, 60 minutes, and 180 minutes.
        """
        return pulumi.get(self, "health_periodic_audit_time")

    @property
    @pulumi.getter(name="instanceTerminatePolicy")
    def instance_terminate_policy(self) -> pulumi.Output[Optional[str]]:
        """
        The instance removal policy. The policy has four
        options: `OLD_CONFIG_OLD_INSTANCE` (default), `OLD_CONFIG_NEW_INSTANCE`,
        `OLD_INSTANCE`, and `NEW_INSTANCE`.
        """
        return pulumi.get(self, "instance_terminate_policy")

    @property
    @pulumi.getter
    def instances(self) -> pulumi.Output[Sequence[str]]:
        """
        The instances IDs of the AS group.
        """
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter(name="lbListenerId")
    def lb_listener_id(self) -> pulumi.Output[Optional[str]]:
        """
        The system supports the binding of up to six ELB listeners, the IDs of which are separated using a comma.
        """
        return pulumi.get(self, "lb_listener_id")

    @property
    @pulumi.getter(name="lbaasListeners")
    def lbaas_listeners(self) -> pulumi.Output[Sequence['outputs.GroupLbaasListener']]:
        """
        An array of one or more enhanced load balancer. The system supports the binding
        of up to six load balancers. The object structure is documented below.
        """
        return pulumi.get(self, "lbaas_listeners")

    @property
    @pulumi.getter(name="maxInstanceNumber")
    def max_instance_number(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of instances. The default value is 0.
        """
        return pulumi.get(self, "max_instance_number")

    @property
    @pulumi.getter(name="minInstanceNumber")
    def min_instance_number(self) -> pulumi.Output[Optional[int]]:
        """
        The minimum number of instances. The default value is 0.
        """
        return pulumi.get(self, "min_instance_number")

    @property
    @pulumi.getter
    def networks(self) -> pulumi.Output[Sequence['outputs.GroupNetwork']]:
        """
        An array of one or more network IDs. The system supports up to five networks. The
        networks object structure is documented below.
        """
        return pulumi.get(self, "networks")

    @property
    @pulumi.getter
    def notifications(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The notification mode. The system only supports `EMAIL`
        mode which refers to notification by email.
        """
        return pulumi.get(self, "notifications")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the AS group. If omitted, the `region` argument
        of the provider is used. Changing this creates a new AS group.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="scalingConfigurationId")
    def scaling_configuration_id(self) -> pulumi.Output[str]:
        """
        The configuration ID which defines configurations of instances in the
        AS group.
        """
        return pulumi.get(self, "scaling_configuration_id")

    @property
    @pulumi.getter(name="scalingGroupName")
    def scaling_group_name(self) -> pulumi.Output[str]:
        """
        The name of the scaling group. The name can contain letters, digits,
        underscores(_), and hyphens(-),and cannot exceed 64 characters.
        """
        return pulumi.get(self, "scaling_group_name")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Output[Sequence['outputs.GroupSecurityGroup']]:
        """
        An array of one or more security group IDs to associate with the group. The
        security_groups object structure is documented below.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Indicates the status of the AS group.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The key/value pairs to associate with the scaling group.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The VPC ID. Changing this creates a new group.
        """
        return pulumi.get(self, "vpc_id")

