# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConfigurationArgs', 'Configuration']

@pulumi.input_type
class ConfigurationArgs:
    def __init__(__self__, *,
                 instance_config: pulumi.Input['ConfigurationInstanceConfigArgs'],
                 scaling_configuration_name: pulumi.Input[str],
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Configuration resource.
        :param pulumi.Input['ConfigurationInstanceConfigArgs'] instance_config: Specifies the information about instance configuration.
               The object structure is documented below. Changing this will create a new resource.
        :param pulumi.Input[str] scaling_configuration_name: Specifies the AS configuration name.
               The name contains only letters, digits, underscores (_), and hyphens (-), and cannot exceed 64 characters.
               Changing this will create a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the AS configuration.
               If omitted, the `region` argument of the provider is used. Changing this will create a new resource.
        """
        pulumi.set(__self__, "instance_config", instance_config)
        pulumi.set(__self__, "scaling_configuration_name", scaling_configuration_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="instanceConfig")
    def instance_config(self) -> pulumi.Input['ConfigurationInstanceConfigArgs']:
        """
        Specifies the information about instance configuration.
        The object structure is documented below. Changing this will create a new resource.
        """
        return pulumi.get(self, "instance_config")

    @instance_config.setter
    def instance_config(self, value: pulumi.Input['ConfigurationInstanceConfigArgs']):
        pulumi.set(self, "instance_config", value)

    @property
    @pulumi.getter(name="scalingConfigurationName")
    def scaling_configuration_name(self) -> pulumi.Input[str]:
        """
        Specifies the AS configuration name.
        The name contains only letters, digits, underscores (_), and hyphens (-), and cannot exceed 64 characters.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "scaling_configuration_name")

    @scaling_configuration_name.setter
    def scaling_configuration_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "scaling_configuration_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the AS configuration.
        If omitted, the `region` argument of the provider is used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ConfigurationState:
    def __init__(__self__, *,
                 instance_config: Optional[pulumi.Input['ConfigurationInstanceConfigArgs']] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 scaling_configuration_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Configuration resources.
        :param pulumi.Input['ConfigurationInstanceConfigArgs'] instance_config: Specifies the information about instance configuration.
               The object structure is documented below. Changing this will create a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the AS configuration.
               If omitted, the `region` argument of the provider is used. Changing this will create a new resource.
        :param pulumi.Input[str] scaling_configuration_name: Specifies the AS configuration name.
               The name contains only letters, digits, underscores (_), and hyphens (-), and cannot exceed 64 characters.
               Changing this will create a new resource.
        """
        if instance_config is not None:
            pulumi.set(__self__, "instance_config", instance_config)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scaling_configuration_name is not None:
            pulumi.set(__self__, "scaling_configuration_name", scaling_configuration_name)

    @property
    @pulumi.getter(name="instanceConfig")
    def instance_config(self) -> Optional[pulumi.Input['ConfigurationInstanceConfigArgs']]:
        """
        Specifies the information about instance configuration.
        The object structure is documented below. Changing this will create a new resource.
        """
        return pulumi.get(self, "instance_config")

    @instance_config.setter
    def instance_config(self, value: Optional[pulumi.Input['ConfigurationInstanceConfigArgs']]):
        pulumi.set(self, "instance_config", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the AS configuration.
        If omitted, the `region` argument of the provider is used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="scalingConfigurationName")
    def scaling_configuration_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the AS configuration name.
        The name contains only letters, digits, underscores (_), and hyphens (-), and cannot exceed 64 characters.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "scaling_configuration_name")

    @scaling_configuration_name.setter
    def scaling_configuration_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scaling_configuration_name", value)


class Configuration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_config: Optional[pulumi.Input[pulumi.InputType['ConfigurationInstanceConfigArgs']]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 scaling_configuration_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages an AS Configuration resource within HuaweiCloud.

        ## Example Usage
        ### Basic AS Configuration

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        my_as_config = huaweicloud.as_.Configuration("myAsConfig",
            scaling_configuration_name="my_as_config",
            instance_config=huaweicloud.as_.ConfigurationInstanceConfigArgs(
                flavor=var["flavor"],
                image=var["image_id"],
                disks=[huaweicloud.as_.ConfigurationInstanceConfigDiskArgs(
                    size=40,
                    volume_type="SSD",
                    disk_type="SYS",
                )],
                key_name=var["keyname"],
                user_data=(lambda path: open(path).read())("userdata.txt"),
            ))
        ```
        ### AS Configuration With Encrypted Data Disk

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        my_as_config = huaweicloud.as_.Configuration("myAsConfig",
            scaling_configuration_name="my_as_config",
            instance_config=huaweicloud.as_.ConfigurationInstanceConfigArgs(
                flavor=var["flavor"],
                image=var["image_id"],
                disks=[
                    huaweicloud.as_.ConfigurationInstanceConfigDiskArgs(
                        size=40,
                        volume_type="SSD",
                        disk_type="SYS",
                    ),
                    huaweicloud.as_.ConfigurationInstanceConfigDiskArgs(
                        size=100,
                        volume_type="SSD",
                        disk_type="DATA",
                        kms_id=var["kms_id"],
                    ),
                ],
                key_name=var["keyname"],
                user_data=(lambda path: open(path).read())("userdata.txt"),
            ))
        ```
        ### AS Configuration With User Data and Metadata

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        my_as_config = huaweicloud.as_.Configuration("myAsConfig",
            scaling_configuration_name="my_as_config",
            instance_config=huaweicloud.as_.ConfigurationInstanceConfigArgs(
                flavor=var["flavor"],
                image=var["image_id"],
                disks=[huaweicloud.as_.ConfigurationInstanceConfigDiskArgs(
                    size=40,
                    volume_type="SSD",
                    disk_type="SYS",
                )],
                key_name=var["keyname"],
                user_data=(lambda path: open(path).read())("userdata.txt"),
                metadata={
                    "some_key": "some_value",
                },
            ))
        ```
        ### AS Configuration uses the existing instance specifications as the template

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        my_as_config = huaweicloud.as_.Configuration("myAsConfig",
            scaling_configuration_name="my_as_config",
            instance_config=huaweicloud.as_.ConfigurationInstanceConfigArgs(
                instance_id="4579f2f5-cbe8-425a-8f32-53dcb9d9053a",
                key_name=var["keyname"],
            ))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ConfigurationInstanceConfigArgs']] instance_config: Specifies the information about instance configuration.
               The object structure is documented below. Changing this will create a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the AS configuration.
               If omitted, the `region` argument of the provider is used. Changing this will create a new resource.
        :param pulumi.Input[str] scaling_configuration_name: Specifies the AS configuration name.
               The name contains only letters, digits, underscores (_), and hyphens (-), and cannot exceed 64 characters.
               Changing this will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AS Configuration resource within HuaweiCloud.

        ## Example Usage
        ### Basic AS Configuration

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        my_as_config = huaweicloud.as_.Configuration("myAsConfig",
            scaling_configuration_name="my_as_config",
            instance_config=huaweicloud.as_.ConfigurationInstanceConfigArgs(
                flavor=var["flavor"],
                image=var["image_id"],
                disks=[huaweicloud.as_.ConfigurationInstanceConfigDiskArgs(
                    size=40,
                    volume_type="SSD",
                    disk_type="SYS",
                )],
                key_name=var["keyname"],
                user_data=(lambda path: open(path).read())("userdata.txt"),
            ))
        ```
        ### AS Configuration With Encrypted Data Disk

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        my_as_config = huaweicloud.as_.Configuration("myAsConfig",
            scaling_configuration_name="my_as_config",
            instance_config=huaweicloud.as_.ConfigurationInstanceConfigArgs(
                flavor=var["flavor"],
                image=var["image_id"],
                disks=[
                    huaweicloud.as_.ConfigurationInstanceConfigDiskArgs(
                        size=40,
                        volume_type="SSD",
                        disk_type="SYS",
                    ),
                    huaweicloud.as_.ConfigurationInstanceConfigDiskArgs(
                        size=100,
                        volume_type="SSD",
                        disk_type="DATA",
                        kms_id=var["kms_id"],
                    ),
                ],
                key_name=var["keyname"],
                user_data=(lambda path: open(path).read())("userdata.txt"),
            ))
        ```
        ### AS Configuration With User Data and Metadata

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        my_as_config = huaweicloud.as_.Configuration("myAsConfig",
            scaling_configuration_name="my_as_config",
            instance_config=huaweicloud.as_.ConfigurationInstanceConfigArgs(
                flavor=var["flavor"],
                image=var["image_id"],
                disks=[huaweicloud.as_.ConfigurationInstanceConfigDiskArgs(
                    size=40,
                    volume_type="SSD",
                    disk_type="SYS",
                )],
                key_name=var["keyname"],
                user_data=(lambda path: open(path).read())("userdata.txt"),
                metadata={
                    "some_key": "some_value",
                },
            ))
        ```
        ### AS Configuration uses the existing instance specifications as the template

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        my_as_config = huaweicloud.as_.Configuration("myAsConfig",
            scaling_configuration_name="my_as_config",
            instance_config=huaweicloud.as_.ConfigurationInstanceConfigArgs(
                instance_id="4579f2f5-cbe8-425a-8f32-53dcb9d9053a",
                key_name=var["keyname"],
            ))
        ```

        :param str resource_name: The name of the resource.
        :param ConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_config: Optional[pulumi.Input[pulumi.InputType['ConfigurationInstanceConfigArgs']]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 scaling_configuration_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfigurationArgs.__new__(ConfigurationArgs)

            if instance_config is None and not opts.urn:
                raise TypeError("Missing required property 'instance_config'")
            __props__.__dict__["instance_config"] = instance_config
            __props__.__dict__["region"] = region
            if scaling_configuration_name is None and not opts.urn:
                raise TypeError("Missing required property 'scaling_configuration_name'")
            __props__.__dict__["scaling_configuration_name"] = scaling_configuration_name
        super(Configuration, __self__).__init__(
            'huaweicloud:As/configuration:Configuration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            instance_config: Optional[pulumi.Input[pulumi.InputType['ConfigurationInstanceConfigArgs']]] = None,
            region: Optional[pulumi.Input[str]] = None,
            scaling_configuration_name: Optional[pulumi.Input[str]] = None) -> 'Configuration':
        """
        Get an existing Configuration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ConfigurationInstanceConfigArgs']] instance_config: Specifies the information about instance configuration.
               The object structure is documented below. Changing this will create a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the AS configuration.
               If omitted, the `region` argument of the provider is used. Changing this will create a new resource.
        :param pulumi.Input[str] scaling_configuration_name: Specifies the AS configuration name.
               The name contains only letters, digits, underscores (_), and hyphens (-), and cannot exceed 64 characters.
               Changing this will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConfigurationState.__new__(_ConfigurationState)

        __props__.__dict__["instance_config"] = instance_config
        __props__.__dict__["region"] = region
        __props__.__dict__["scaling_configuration_name"] = scaling_configuration_name
        return Configuration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="instanceConfig")
    def instance_config(self) -> pulumi.Output['outputs.ConfigurationInstanceConfig']:
        """
        Specifies the information about instance configuration.
        The object structure is documented below. Changing this will create a new resource.
        """
        return pulumi.get(self, "instance_config")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the AS configuration.
        If omitted, the `region` argument of the provider is used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="scalingConfigurationName")
    def scaling_configuration_name(self) -> pulumi.Output[str]:
        """
        Specifies the AS configuration name.
        The name contains only letters, digits, underscores (_), and hyphens (-), and cannot exceed 64 characters.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "scaling_configuration_name")

