# coding: utf-8

"""
    Robot API

    Robot REST API  # noqa: E501

    OpenAPI spec version: 1.8.2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from pdhttp.api_client import ApiClient


class EnvironmentApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_to_environment(self, body, **kwargs):  # noqa: E501
        """Add obstacle to robot environment.  # noqa: E501

        Add obstacle to robot environment. Obstacle it is an object that is taken into account in the calculation of collisions. Must be one of the following types: BOX, CAPSULE, PLANE. Example shows possible obstacle definitions. **Note:** Only one obstacle at a time should be passed as request body even though example shows array of items  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_to_environment(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Obstacle body: Request Body (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_to_environment_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_to_environment_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def add_to_environment_with_http_info(self, body, **kwargs):  # noqa: E501
        """Add obstacle to robot environment.  # noqa: E501

        Add obstacle to robot environment. Obstacle it is an object that is taken into account in the calculation of collisions. Must be one of the following types: BOX, CAPSULE, PLANE. Example shows possible obstacle definitions. **Note:** Only one obstacle at a time should be passed as request body even though example shows array of items  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_to_environment_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Obstacle body: Request Body (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_to_environment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_to_environment`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/environment', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_from_environment(self, **kwargs):  # noqa: E501
        """Getting robot environment.  # noqa: E501

        Return all obstacles from environment. Obstacle it is an object that is taken into account in the calculation of collisions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_from_environment(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[Obstacle]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_from_environment_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_from_environment_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_from_environment_with_http_info(self, **kwargs):  # noqa: E501
        """Getting robot environment.  # noqa: E501

        Return all obstacles from environment. Obstacle it is an object that is taken into account in the calculation of collisions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_from_environment_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[Obstacle]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_from_environment" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/environment', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Obstacle]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_from_environment_by_name(self, obstacle, **kwargs):  # noqa: E501
        """Getting obstacle from robot environment by name.  # noqa: E501

        Return obstacle from environment by name. Obstacle it is an object that is taken into account in the calculation of collisions. Response example shows possible obstacle definitions. **Note:** Only one obstacle at a time is returned in response body even though example shows array of items  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_from_environment_by_name(obstacle, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str obstacle: The parameter is the name of element from environment that you want to get. (required)
        :return: Obstacle
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_from_environment_by_name_with_http_info(obstacle, **kwargs)  # noqa: E501
        else:
            (data) = self.get_from_environment_by_name_with_http_info(obstacle, **kwargs)  # noqa: E501
            return data

    def get_from_environment_by_name_with_http_info(self, obstacle, **kwargs):  # noqa: E501
        """Getting obstacle from robot environment by name.  # noqa: E501

        Return obstacle from environment by name. Obstacle it is an object that is taken into account in the calculation of collisions. Response example shows possible obstacle definitions. **Note:** Only one obstacle at a time is returned in response body even though example shows array of items  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_from_environment_by_name_with_http_info(obstacle, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str obstacle: The parameter is the name of element from environment that you want to get. (required)
        :return: Obstacle
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['obstacle']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_from_environment_by_name" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'obstacle' is set
        if ('obstacle' not in params or
                params['obstacle'] is None):
            raise ValueError("Missing the required parameter `obstacle` when calling `get_from_environment_by_name`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'obstacle' in params:
            path_params['obstacle'] = params['obstacle']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/environment/{obstacle}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Obstacle',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_all_from_environment(self, **kwargs):  # noqa: E501
        """Remove all obstacles from robot environment.  # noqa: E501

        Remove all obstacles from robot environment. Obstacle it is an object that is taken into account in the calculation of collisions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_all_from_environment(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_all_from_environment_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.remove_all_from_environment_with_http_info(**kwargs)  # noqa: E501
            return data

    def remove_all_from_environment_with_http_info(self, **kwargs):  # noqa: E501
        """Remove all obstacles from robot environment.  # noqa: E501

        Remove all obstacles from robot environment. Obstacle it is an object that is taken into account in the calculation of collisions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_all_from_environment_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_all_from_environment" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/environment', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_from_environment_by_name(self, obstacle, **kwargs):  # noqa: E501
        """Remove obstacle from robot environment by name.  # noqa: E501

        Remove obstacle from robot environment by name. Obstacle it is an object that is taken into account in the calculation of collisions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_from_environment_by_name(obstacle, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str obstacle: The parameter is the name of element from environment that you want to remove. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_from_environment_by_name_with_http_info(obstacle, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_from_environment_by_name_with_http_info(obstacle, **kwargs)  # noqa: E501
            return data

    def remove_from_environment_by_name_with_http_info(self, obstacle, **kwargs):  # noqa: E501
        """Remove obstacle from robot environment by name.  # noqa: E501

        Remove obstacle from robot environment by name. Obstacle it is an object that is taken into account in the calculation of collisions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_from_environment_by_name_with_http_info(obstacle, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str obstacle: The parameter is the name of element from environment that you want to remove. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['obstacle']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_from_environment_by_name" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'obstacle' is set
        if ('obstacle' not in params or
                params['obstacle'] is None):
            raise ValueError("Missing the required parameter `obstacle` when calling `remove_from_environment_by_name`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'obstacle' in params:
            path_params['obstacle'] = params['obstacle']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/environment/{obstacle}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
