# Math Inspector

<https://mathinspector.com>

[![PyPI](https://img.shields.io/pypi/v/mathinspector)](https://pypi.org/project/mathinspector)
[![License](https://img.shields.io/pypi/l/mathinspector)](https://github.com/MathInspector/MathInspector/blob/master/LICENSE)

Math Inspector is a visual programming environment for scientific computing based on numpy & scipy. Appropriate for users of all ages and skill levels.

Math Inspector will always be 100% free and open source.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

Install
---
`python -m pip install mathinspector`

To start math inspector, run the following command

`mathinspector`

or

`python -m mathinspector`

Overview
---
### Explore
When you import a module in Math Inspector, it automatically imports all submodules at the same time and provides a file explorer style interface, enabling anyone to be able to see everything numpy & scipy are capable of at a glance.

### Learn
Whatever object you are interacting with in Math Inspector, you can always learn more by reading the documentation in the doc viewer, which has been designed to make finding and interacting with the extensive documentation of numpy & scipy as easily as possible.  See a code example in the doc string you want to run?  Just click on it and see what happens.

### Play
The Math Inspector workspace is a visual block coding environment for interacting with all types of objects and functions by connecting wires to widets and adjusting parameter values. See a function in the module explorer that you want to learn more about?  All you have to do is drag and drop it into the workspace.

### Share
Math Inspector makes it easy to save your project and share it with others, and has been designed in particular to supplement mathematics education youtube video's by providing a free tool for content creators to create animations and share projects for viewers to explore and play with after they are done watching the video, reinforcing whatever concepts have been taught and to make it easy to learn more.


Features
---

### Python Interpreter
Math inspector is a traditional python interpreter that has a number of quality of
life improvements; such as syntax highlighting, and lots of hotkeys. Before and after each command is executed, the command string is parsed to keep all of the views synchronized.

### Block Coding
The block coding system in math inspector is capable of representing arbitrary python functions and objects of any kind; it has been designed to make it as easy as possible to experiment and interact with complex programs without the need to write any code.

### Interactive Plots
Math inspector's plotting library updates and modernizes the functionality available in matplotlib.  It provides high performance interactive 2D and 3D plots.  Capable of plotting parametric curves, algebraic varieties, fractals, curved surfaces, and much more.

### Animation
The animation system has been designed to render production quality animations for educational content creators.  A lot of care has been put into optimizing the performance of animations to enable a smooth 60 frames per second while panning and zooming during animations.

### Object Debugger
Variables in the local namespace are displayed in an interactive side panel, from which you can change the value of objects, function arguments, run methods, view source code, and mucn more.  It's similar to the object debugger in modern web browsers, except for python.

### Doc Browser
Most modules and classes in python come with a lot of documentation. The doc browser parses these docstrings to automatically produce a beautiful and well organized interface for exploring the documentation.  See a code sample you want to run?  Just click on it and it will be executed by the interpreter.

### Export Projects
Math inspector was designed to make it as simple as possible to share projects online.
To share a project on social media, simply upload the project folder to a hosting platform like
github and share the link with your friends.
