MAIN_BRANCHES_REGEX = r"main|master|release/.+|feature/.+|dev|develop|development"

INITIAL_COMMIT = [
    "Initial commit",  # Generated by GitLab
    "Add README.md",  # Generated by GitKraken
]

COMMIT_DELIMITER = "--commit-delimiter--"

MIN_COMMIT_DESCR_LENTH = 10

MAX_COMMIT_DESCR_LINES = 20

SUCCESS = "Commit validation: success!"

FAILED = "Commit validation: failed!"

TITLE_FAILED = "Please enter a commit message in the conventional commits format."

BODY_FAILED = (
    "The commit description contains a conventional commit prefix "
    f"or a line of less than {MIN_COMMIT_DESCR_LENTH} characters.\n"
    "Did you forget to edit and clean up the commit message after a squash?"
)

MERGE_FAILED = "Commit merges should have at least one approver."

EMOJI_CHECK = ":check_mark_button:"
EMOJI_CROSS = ":cross_mark:"

COMMIT_TYPE_MUST_HAVE_SCOPE = {
    "fixdefect": (
        "The defect being fixed must be given in argument with the syntax 'fixdefect(JAMA-xxx)' "
        "where 'xxx' is the ID of the associated item in JAMA"
    ),
    "other": (
        "Commits of type '{c_type}' must be of the form '{c_type}(add)', "
        "'{c_type}(change)' or '{c_type}(remove)'"
    ),
}

COMMIT_TYPE_MUST_NOT_HAVE_SCOPE = (
    "Commits of type '{}' must not specify a scope but simply use the form '{}'"
)

PATTERN = (
    r"(?s)"  # To explictly make . match new line
    r"(build|bump|ci|deps|docs|enabler|feat|fixbug|fixdefect|refactor|test)"  # type
    r"(\(\S+\))?!?:"  # scope
    r"( [^\n\r]+)"  # subject
    r"((\n\n.*)|(\s*))?$"
)

MAJOR_COMMIT_TYPES = ["enabler", "feat", "fixbug", "fixdefect", "refactor"]

COMMIT_WITH_SCOPE = ["deps", "feat", "fixdefect"]

JAMA_REGEX = r"SmlPrep-SUBSR-\d+"

JAMA_FIXDEFECT_REGEX = r"\(JAMA-[a-zA-Z0-9-]+\)"

JAMA_TAG = "JAMA:"

IMPACT_TAG = "IMPACT:"
