# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['discord_fate_bot', 'discord_fate_bot.extensions']

package_data = \
{'': ['*']}

install_requires = \
['aiofiles>=0.4.0,<0.5.0',
 'aiorun>=2020.2.1,<2021.0.0',
 'discord.py>=1.3.2,<2.0.0',
 'environ-config>=20.1.0,<21.0.0',
 'mashumaro>=1.12,<2.0',
 'motor>=2.1.0,<3.0.0']

entry_points = \
{'console_scripts': ['discord-fate-bot = discord_fate_bot.console_script:main']}

setup_kwargs = {
    'name': 'discord-fate-bot',
    'version': '0.2.1',
    'description': 'Discord bot to help run a FATE campaign',
    'long_description': "# Discord Fate Bot\n\n[![CircleCI][circleci-dfb-svg]][circleci-dfb]\n[![PyPI Version][shieldsio-pypi-dfb]][pypi-dfb]\n[![PyPI Python][shieldsio-python-dfb]][pypi-dfb]\n\nA [Discord][discordapp] bot to help play the [Fate roleplaying game][fate-rpg].\n\n[discordapp]: https://discordapp.com/\n[fate-rpg]: https://www.evilhat.com/home/fate-core/\n\n[circleci-dfb]: https://circleci.com/gh/chrisbouchard/discord-fate-bot\n[circleci-dfb-svg]: https://circleci.com/gh/chrisbouchard/discord-fate-bot.svg?style=svg\n[pypi-dfb]: https://pypi.org/project/discord-fate-bot/\n[shieldsio-pypi-dfb]: https://img.shields.io/pypi/v/discord-fate-bot\n[shieldsio-python-dfb]: https://img.shields.io/pypi/pyversions/discord-fate-bot\n\n\n## Commands\n\nOnce this bot is invited to a server, it will listen in text channels for\ncommands and reply. All commands start with `!`.\n\n### `!roll`\n\nRoll four Fate dice, with modifiers, optionally against a static opposition.\nThis command has the following forms.\n\n* `!roll` &mdash; Simply roll four Fate dice and see the result\n* `!roll [+|-]MOD...` &mdash; Roll with a modifier. The `+` or `-` is required.\n  Multiple modifiers may be given, separated by spaces.\n    * Example: `!roll +5 -2` to roll with an effective +3 modifier.\n* `!roll MODIFIERS vs OPPOSITION` &mdash; Roll against a static opposition\n  amount. The result will be one of: fail, tie, succeed, or succeed with style.\n    * Example: `!roll +2 vs 3`\n\n### `!scene`\n\nStart a scene in the current channel. Each channel can have one scene active,\nwhich can be used to track situation aspects. The message describing the\ncurrent scene will automatically be pinned (and unpinned when the scene ends).\n\n* `!scene [DESCRIPTION]` &mdash; Start a new scene in the current channel. The\n  entire rest of the message will be used as the description. If a scene is\n  already active, it will be ended automatically.\n    * Example: `!scene Warehouse Five`\n\n* `!scene end` &mdash; End the current scene.\n\n### `!aspect`\n\nAdd or manage aspects in the current scene. There must be an active scene in\nthe current channel to use these commands. Aspects are automatically added to\nthe pinned scene message.\n\nEvery aspect is given an ID &mdash; a unique number within the scene &mdash;\nwhich is used to refer to the aspect after creation (for example, to remove\nit).\n\n* `!aspect [TAGS]... NAME` &mdash; Add a new aspect to the current scene.\n  Tags may be included, separated by spaces. After tags, the rest of the line\n  will be used the aspect name.\n    * `boost` &mdash; Tag this aspect as a boost, which means it automatically\n      disappears when it runs out of invokes. **TODO:** A boost should\n      implicitly add one free invoke if the `invokes` tag is not specified.\n    * `invokes=COUNT` &mdash; Tag this aspect with some number of free\n      invokes attached.\n    * Example: `!aspect Darkness of night`\n    * Example: `!aspect boost invokes=2 Really awesome aspect name`\n* `!aspect remove ID...` &mdash; Remove one or more aspects from the scene.\n* `!aspect modify ID NAME` &mdash; Rename an existing aspect. The rest of the\n  line will be used as the new aspect name.\n    * **TODO:** It will eventually be possible to update tags as well.\n* **TODO:** `!aspect invoke ID` &mdash; Decrease the number of remaining free\n  invokes for the specified aspect.\n\n### Future Commands\n\nI plan to add commands to manage a turn order, and possibly to track fate\npoints. Beyond that, I may add facilities to track PCs and NPCs, though Discord\ntext channels may not be the most convenient interface to manage those.\n\n\n## Inviting the Bot\n\nThere isn't currently a public instance of this bot available for invite. If\nyou host your own copy, the bot will log an invite URL when it connects to\nDiscord. Currently, the bot will ask for the following Discord permissions.\n\n* Add reactions\n    * To leave a :+1: once it has processed a message.\n* Manage messages\n    * To pin and unpin the scene message.\n* Read message history\n    * Not currently used, but I have a half-thought that there could be a\n      feature to recover scenes from message history if the database is\n      out-of-sync with the channel.\n* Read messages\n    * To read commands.\n* Send messages\n    * To reply with results.\n\nThis list may grow and change while the bot is in development, but I'll try to\nfreeze it once I release a stable public version.\n\n\n## Installing\n\nThere project is available on Docker Hub at\n[chrisbouchard/discord-fate-bot][docker-dfb]. Images are automatically built\nand published based on our `Dockerfile`. There is also a `docker-compose.yml`\nfile to deploy the app in Docker Swarm as a Stack, including a Mongo DB\nservice.\n\n[docker-dfb]: https://hub.docker.com/repository/docker/chrisbouchard/discord-fate-bot\n\n### Installing in Docker Swarm as a Stack\n\nTo install as a Stack, simply deploy our `docker-compose.yml` file. To install\nwithout having to check anything out, you can pipe it directly from GitHub.\n\n```\n$ curl https://raw.githubusercontent.com/chrisbouchard/discord-fate-bot/master/docker-compose.yml | \\\n      docker stack deploy --compose-file - discord-fate-bot\n```\n\n### Installing Other Ways\n\nMore to be written&hellip;\n\n\n## Configuring\n\nThe bot looks for the following environment variables on start-up.\n\n* `DFB_BOT_TOKEN` &mdash; The Discord authentication token for the bot account.\n    * Mutually exclusive with `DFB_BOT_TOKEN_FILE`.\n* `DFB_BOT_TOKEN_FILE` &mdash; The path to a file _containing_ the\n  authentication token.\n    * Mutually exclusive with `DFB_BOT_TOKEN`.\n* `DFB_LOG_CONFIG_FILE` &mdash; _(Optional)_ The path to a Python log config\n  file. See the [Python documentation][python-logging-config] for a description\n  of the file format.\n* `DFB_MONGO_CONNECTION_URL` &mdash; The MongoDB connection URL.\n* `DFB_MONGO_PASSWORD` &mdash; The password for the Mongo DB connection.\n    * Mutually exclusive with `DFB_MONGO_PASSWORD_FILE`.\n* `DFB_MONGO_PASSWORD_FILE` &mdash; The path to a file _containing_ the\n  password for the Mongo DB connection.\n    * Mutually exclusive with `DFB_MONGO_PASSWORD`.\n\n[python-logging-config]: https://docs.python.org/3/library/logging.config.html#configuration-file-format\n\n**Note:** For variables that have a `*_FILE` pair, the direct version is\nprovided as a convenience, e.g., for development. I subscribe to the school of\nthought that it's best not to store production secrets in environment variables\nif at all avoidable. Our Docker Stack definition uses Secrets to share the\nDiscord token and Mongo password into the services.\n\n\n## Architecture\n\nThis bot is written in Python, mostly based on the awesome\n[Discord.py][discord-py] library. We use [MongoDB][mongo-db] for long-term\nstorage when necessary (e.g., for scenes and aspects).\n\n[discord-py]: https://github.com/Rapptz/discord.py\n[mongo-db]: https://www.mongodb.com/\n\n",
    'author': 'Chris Bouchard',
    'author_email': 'chris@upliftinglemma.net',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/chrisbouchard/discord-fate-bot',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
