from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

from pysc2.maps import lib


class MM_Map(lib.Map): # MM_Maps stands for Micro-Management Maps
    directory = "micro_maps"
    download = "https://github.com/oxwhirl/smac#smac-maps"
    players = 2
    step_mul = 8
    game_steps_per_episode = 0


map_param_registry = {
    "1m": {
        "n_agents": 1,
        "n_enemies": 1,
        "limit": 60,
        "a_race": "T",
        "b_race": "T",
        "unit_type_bits": 0,
        "map_content": "marines",
        "map_type": ["homogeneous", "symmeytic"],
    },
    "3m": {
        "n_agents": 3,
        "n_enemies": 3,
        "limit": 60,
        "a_race": "T",
        "b_race": "T",
        "unit_type_bits": 0,
        "map_content": "marines",
        "map_type": ["homogeneous", "symmeytic"],
    },
    "8m": {
        "n_agents": 8,
        "n_enemies": 8,
        "limit": 120,
        "a_race": "T",
        "b_race": "T",
        "unit_type_bits": 0,
        "map_content": "marines",
        "map_type": ["homogeneous", "symmeytic"],
    },
    "25m": {
        "n_agents": 25,
        "n_enemies": 25,
        "limit": 150,
        "a_race": "T",
        "b_race": "T",
        "unit_type_bits": 0,
        "map_content": "marines",
        "map_type": ["homogeneous", "symmeytic"],
    },
    "5m_vs_6m": {
        "n_agents": 5,
        "n_enemies": 6,
        "limit": 70,
        "a_race": "T",
        "b_race": "T",
        "unit_type_bits": 0,
        "map_content": "marines",
        "map_type": ["homogeneous", "asymmeytic"],
    },
    "8m_vs_9m": {
        "n_agents": 8,
        "n_enemies": 9,
        "limit": 120,
        "a_race": "T",
        "b_race": "T",
        "unit_type_bits": 0,
        "map_content": "marines",
        "map_type": ["homogeneous", "asymmeytic"],
    },
    "10m_vs_11m": {
        "n_agents": 10,
        "n_enemies": 11,
        "limit": 150,
        "a_race": "T",
        "b_race": "T",
        "unit_type_bits": 0,
        "map_content": "marines",
        "map_type": ["homogeneous", "asymmeytic"],
    },
    "27m_vs_30m": {
        "n_agents": 27,
        "n_enemies": 30,
        "limit": 180,
        "a_race": "T",
        "b_race": "T",
        "unit_type_bits": 0,
        "map_content": "marines",
        "map_type": ["homogeneous", "asymmeytic"],
    },
    "MMM": {
        "n_agents": 10,
        "n_enemies": 10,
        "limit": 150,
        "a_race": "T",
        "b_race": "T",
        "unit_type_bits": 3,
        "map_content": "MMM",
        "map_type": ["heterogeneous", "symmeytic"],
    },
    "MMM2": {
        "n_agents": 10,
        "n_enemies": 12,
        "limit": 180,
        "a_race": "T",
        "b_race": "T",
        "unit_type_bits": 3,
        "map_content": "MMM",
        "map_type": ["heterogeneous", "asymmeytic"],
    },
    "2s3z": {
        "n_agents": 5,
        "n_enemies": 5,
        "limit": 120,
        "a_race": "P",
        "b_race": "P",
        "unit_type_bits": 2,
        "map_content": "stalkers_and_zealots",
        "map_type": ["heterogeneous", "symmeytic"],
    },
    "3s5z": {
        "n_agents": 8,
        "n_enemies": 8,
        "limit": 150,
        "a_race": "P",
        "b_race": "P",
        "unit_type_bits": 2,
        "map_content": "stalkers_and_zealots",
        "map_type": ["heterogeneous", "symmeytic"],
    },
    "3s5z_vs_3s6z": {
        "n_agents": 8,
        "n_enemies": 9,
        "limit": 170,
        "a_race": "P",
        "b_race": "P",
        "unit_type_bits": 2,
        "map_content": "stalkers_and_zealots",
        "map_type": ["heterogeneous", "asymmeytic"],
    },
    "3s_vs_3z": {
        "n_agents": 3,
        "n_enemies": 3,
        "limit": 150,
        "a_race": "P",
        "b_race": "P",
        "unit_type_bits": 0,
        "map_content": "stalkers",
        "map_type": ["heterogeneous", "asymmeytic"],
    },

    "3s_vs_3z_medium": {
        "n_agents": 3,
        "n_enemies": 3,
        "limit": 150,
        "a_race": "P",
        "b_race": "P",
        "unit_type_bits": 0,
        "map_content": "stalkers",
        "map_type": ["heterogeneous", "asymmeytic"],
    },
    
    "3s_vs_4z": {
        "n_agents": 3,
        "n_enemies": 4,
        "limit": 200,
        "a_race": "P",
        "b_race": "P",
        "unit_type_bits": 0,
        "map_content": "stalkers",
        "map_type": ["heterogeneous", "asymmeytic"],
    },
    
    "3s_vs_4z_medium": {
        "n_agents": 3,
        "n_enemies": 4,
        "limit": 150,
        "a_race": "P",
        "b_race": "P",
        "unit_type_bits": 0,
        "map_content": "stalkers",
        "map_type": ["heterogeneous", "asymmeytic"],
    },
    
    "3s_vs_5z": {
        "n_agents": 3,
        "n_enemies": 5,
        "limit": 250,
        "a_race": "P",
        "b_race": "P",
        "unit_type_bits": 0,
        "map_content": "stalkers",
        "map_type": ["heterogeneous", "asymmeytic"],
    },
    
    "3s_vs_5z_medium": {
        "n_agents": 3,
        "n_enemies": 5,
        "limit": 150,
        "a_race": "P",
        "b_race": "P",
        "unit_type_bits": 0,
        "map_content": "stalkers",
        "map_type": ["heterogeneous", "asymmeytic"],
    },
    
    "1c3s5z": {
        "n_agents": 9,
        "n_enemies": 9,
        "limit": 180,
        "a_race": "P",
        "b_race": "P",
        "unit_type_bits": 3,
        "map_content": "colossi_stalkers_zealots",
        "map_type": ["heterogeneous", "symmeytic"],
    },
    "2m_vs_1z": {
        "n_agents": 2,
        "n_enemies": 1,
        "limit": 150,
        "a_race": "T",
        "b_race": "P",
        "unit_type_bits": 0,
        "map_content": "marines",
        "map_type": ["trick", "asymmeytic", "alternating_fire"],
    },
    "corridor": {
        "n_agents": 6,
        "n_enemies": 24,
        "limit": 400,
        "a_race": "P",
        "b_race": "Z",
        "unit_type_bits": 0,
        "map_content": "zealots",
        "map_type": ["trick", "asymmeytic", "wall_off"],
    },
    "6h_vs_8z": {
        "n_agents": 6,
        "n_enemies": 8,
        "limit": 150,
        "a_race": "Z",
        "b_race": "P",
        "unit_type_bits": 0,
        "map_content": "hydralisks",
        "map_type": ["trick", "asymmeytic", "focus_fire"],
    },
    "2s_vs_1sc": {
        "n_agents": 2,
        "n_enemies": 1,
        "limit": 300,
        "a_race": "P",
        "b_race": "Z",
        "unit_type_bits": 0,
        "map_content": "stalkers",
        "map_type": ["trick", "asymmeytic", "alternating_fire"],
    },
    "so_many_baneling": {
        "n_agents": 7,
        "n_enemies": 32,
        "limit": 100,
        "a_race": "P",
        "b_race": "Z",
        "unit_type_bits": 0,
        "map_content": "zealots",
        "map_type": ["trick", "asymmeytic", "positioning"],
    },
    "bane_vs_bane": {
        "n_agents": 24,
        "n_enemies": 24,
        "limit": 200,
        "a_race": "Z",
        "b_race": "Z",
        "unit_type_bits": 2,
        "map_content": "bane",
        "map_type": ["trick", "asymmeytic", "positioning"],
    },
    "2c_vs_64zg": {
        "n_agents": 2,
        "n_enemies": 64,
        "limit": 400,
        "a_race": "P",
        "b_race": "Z",
        "unit_type_bits": 0,
        "map_content": "colossus",
        "map_type": ["trick", "asymmeytic", "positioning"],
    },
    "half_6m_vs_full_4m": {
        "n_agents": 6,
        "n_enemies": 4,
        "limit": 90,
        "a_race": "T",
        "b_race": "T",
        "unit_type_bits": 0,
        "map_content": "marines",
        "map_type": ["homogeneous", "asymmeytic"],
    },
    "half_11m_vs_full_7m": {
        "n_agents": 11,
        "n_enemies": 7,
        "limit": 120,
        "a_race": "T",
        "b_race": "T",
        "unit_type_bits": 0,
        "map_content": "marines",
        "map_type": ["homogeneous", "asymmeytic"],
    },
    "half_17m_vs_full_11m": {
        "n_agents": 17,
        "n_enemies": 11,
        "limit": 150,
        "a_race": "T",
        "b_race": "T",
        "unit_type_bits": 0,
        "map_content": "marines",
        "map_type": ["homogeneous", "asymmeytic"],
    },
    "6m1r_vs_4g": {
        "n_agents": 7,
        "n_enemies": 4,
        "limit": 100,
        "a_race": "T",
        "b_race": "T",
        "unit_type_bits": 2,
        "map_content": "marines_and_ghosts",
        "map_type": ["heterogeneous", "asymmeytic"],
    },
    "12m2r_vs_7g": {
        "n_agents": 14,
        "n_enemies": 7,
        "limit": 130,
        "a_race": "T",
        "b_race": "T",
        "unit_type_bits": 2,
        "map_content": "marines_and_ghosts",
        "map_type": ["heterogeneous", "asymmeytic"],
    },
    "6s4z_vs_10b30z": {
        "n_agents": 10,
        "n_enemies": 40,
        "limit": 130,
        "a_race": "P",
        "b_race": "Z",
        "unit_type_bits": 2,
        "map_content": "stalkers_zealots_and_zergs",
        "map_type": ["heterogeneous", "asymmeytic"],
    },
    "10z5b_vs_2z3s": {
        "n_agents": 15,
        "n_enemies": 5,
        "limit": 130,
        "a_race": "Z",
        "b_race": "Z",
        "unit_type_bits": 2,
        "map_content": "zergs_and_banes",
        "map_type": ["heterogeneous", "asymmeytic"],
    },
    "1s3m_vs_5m": {
        "n_agents": 4,
        "n_enemies": 5,
        "limit": 130,
        "a_race": "T",
        "b_race": "T",
        "unit_type_bits": 2,
        "map_content": "siege_and_marines",
        "map_type": ["heterogeneous", "asymmeytic"],
    }, 
    "6s1s_vs_10r": {
        "n_agents": 7,
        "n_enemies": 10,
        "limit": 130,
        "a_race": "T",
        "b_race": "T",
        "unit_type_bits": 2,
        "map_content": "sentry_and_stalkers",
        "map_type": ["heterogeneous", "asymmeytic"],
    }, 
    
}


def get_smac_map_registry():
    return map_param_registry


for name in map_param_registry.keys():
    globals()[name] = type(name, (MM_Map,), dict(filename=name))
