# SC2DC
# StarCraft 2 Decentralized Control

A collection of helpful papers for SC2 decentralized control, mainly focused on:
* Micro Management
* Communication
* Planning
* Cooperation
* Coordination

## Review Paper
* [Multi-Agent Reinforcement Learning: A Selective Overview of Theories and Algorithms](https://arxiv.org/pdf/1911.10635.pdf)
* [A Survey of Real-Time Strategy Game AI Research and Competition in StarCraft](https://www.cs.mun.ca/~dchurchill/pdf/starcraft_survey.pdf)

## Research Paper

* [Mutiagent Bidirectionally-Coordinated Nets Emergence of Human-level Coordination in Learning to Play StarCraft Combat Games](https://arxiv.org/pdf/1703.10069.pdf)
* [StarCraft II Build Order Optimization using Deep Reinforcement Learning and Monte-Carlo Tree Search](https://arxiv.org/pdf/2006.10525.pdf)
* [QMIX: Monotonic Value Function Factorisation for Deep Multi-Agent Reinforcement Learning](https://arxiv.org/pdf/1803.11485.pdf)
* [Efficient Communication in Multi-AgentReinforcement Learning via Variance Based Control](https://papers.nips.cc/paper/8586-efficient-communication-in-multi-agent-reinforcement-learning-via-variance-based-control.pdf)
* [Deep Multi-Agent Reinforcement Learning for Decentralised Continuous Cooperative Control](https://arxiv.org/pdf/2003.06709.pdf)
* [Episodic Exploration for Deep Deterministic Policies: An Application to StarCraft Micromanagement Tasks](https://arxiv.org/pdf/1609.02993v3.pdf)
* [Deep Coordination Graphs](https://arxiv.org/pdf/1910.00091.pdf)
* [The StarCraft Multi-Agent Challenge](https://arxiv.org/pdf/1902.04043.pdf)
* [An Analysis of Model-Based Heuristic Search Techniques for StarCraft Combat Scenarios](https://pdfs.semanticscholar.org/376b/ff162fc0143642cc7fa7d3547eef48871b51.pdf)
* [Multi-scale Bayesian modeling for RTS games: an application to StarCraft AI](https://hal.archives-ouvertes.fr/hal-01228961/document)
* [Learning to Select Actions in Starcraft with Genetic Algorithms](https://ieeexplore.ieee.org/stamp/stamp.jsp?tp=&arnumber=7880180)
* [Neuroevolution for RTS Micro](https://arxiv.org/pdf/1803.10288.pdf)
* [Real-time challenge balance in an RTS game using rtNEAT](https://www.csse.uwa.edu.au/cig08/Proceedings/papers/8023.pdf)
* [Neuroevolution Based Multi-Agent System with Ontology Based Template Creation for Micromanagement in Real-Time Strategy Games](https://pdfs.semanticscholar.org/0197/8064174712b42f5c14c01afcba30a736bbfd.pdf)
* [Potential-Field-Based Unit Behavior Optimization for Balancing in StarCraft II](https://dl.acm.org/doi/pdf/10.1145/2739482.2764643)
* [Comparing Three Approaches to Micro in RTS Games](https://ieeexplore.ieee.org/stamp/stamp.jsp?arnumber=8790308&tag=1)
* [Attentive Relational State Representation in Decentralized Multiagent Reinforcement Learning](https://ieeexplore.ieee.org/stamp/stamp.jsp?tp=&arnumber=9049415&tag=1)
* [Spellcaster Control Agent in StarCraft II Using Deep Reinforcement Learning]()
* [Learning to Select Actions in StarCraft with Genetic Algorithms](https://ieeexplore.ieee.org/stamp/stamp.jsp?tp=&arnumber=7880180&tag=1)
* [Comparing Three Approaches to Micro in RTS Games](https://ieeexplore.ieee.org/stamp/stamp.jsp?tp=&arnumber=8790308&tag=1)
* [Neuroevolution for RTS Micro](https://arxiv.org/pdf/1803.10288.pdf)
* [Neuroevolution Based Multi-Agent System with Ontology Based Template Creation for Micromanagement in Real-Time Strategy Games](https://pdfs.semanticscholar.org/0197/8064174712b42f5c14c01afcba30a736bbfd.pdf)
* [Evolving Neural Networks through Augmenting Topologies](https://dl.acm.org/doi/pdf/10.1162/106365602320169811)

## Thesis
* [Heuristic Search Techniques for Real-Time Strategy Games](http://www.cs.mun.ca/~dchurchill/pdf/DavidChurchill_phd_thesis.pdf)

## Environment / Simulation / API
* [pysc2](https://github.com/deepmind/pysc2)
* [SparCraft](https://github.com/davechurchill/ualbertabot/wiki/SparCraft-Home)
* [Brood War API](https://github.com/bwapi/bwapi)
* [SMAC](https://github.com/oxwhirl/smac)

## Maps
* You can find a list of maps [here](https://github.com/caiyangcy/SC2DC/blob/master/docs/map_info.md)

# Run

To get started:

    python -m scdc.agents.scripted..agent_demo
    
# Acknowledgement
* The coding is based on [SMAC](https://github.com/oxwhirl/smac). Refer to the repo for details and license.
