# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/03_metrics.ipynb (unless otherwise specified).

__all__ = ['cm', 'get_starts_from_labels', 'mean_pa_diff', 'mean_target_diff', 'print_all_metrics']

# Cell

from sklearn.metrics import confusion_matrix, classification_report
import seaborn as sns
import numpy as np


def cm(y_test, y_test_pred_probs, thresh):
    """
    confusion matrix
    """
    fig = plt.figure(figsize=(6, 4))
    ax = fig.gca()

    cm = pd.DataFrame(confusion_matrix(y_test, y_test_pred_probs > thresh),
                      columns=["Stayed", "Pulled"],
                      index=["Stayed", "Pulled"])
    #     cm = cm / y_test.shape[0]
    sns.heatmap(cm, ax=ax, cmap=sns.color_palette("ch:2.5,-.2,dark=.3"), annot=True, fmt=",d")  # , fmt=".2%")
    ax.set_ylim(cm.shape[0] + 0.25, -0.25)
    plt.show()


def get_starts_from_labels(y_true, y_pred):
    """
    where y_true and y_pred are both np arrays
    returns two lists of np arrays
    """
    y_true, y_pred = np.array(y_true), np.array(y_pred)
    pulled_idx = np.nonzero(y_true)[0]
    preds = []
    trues = []
    for i in range(pulled_idx.shape[0]):
        if i == 0:
            pred = y_pred[: pulled_idx[i] + 1]
            true = y_true[: pulled_idx[i] + 1]
        else:
            pred = y_pred[pulled_idx[i - 1] + 1: pulled_idx[i] + 1]
            true = y_true[pulled_idx[i - 1] + 1: pulled_idx[i] + 1]

        preds.append(pred)
        trues.append(true)
    return trues, preds


def mean_pa_diff(trues, preds):
    """
    where trues and preds are both lists of numpy arrays
    What this doesn't take into account is if the model
    has many high prob predictions (not necessarily max)
    that are way off
    """
    diffs = []
    for pred in preds:
        indx_of_pulled = pred.shape[0] - 1
        idx_of_pred = pred.argmax()  # argmax takes first max, so if tie, goes to worse guess
        diffs.append(indx_of_pulled - idx_of_pred)

    return np.array(diffs).mean()


def mean_target_diff(trues, preds):
    """
    What this doesn't take into account is how far
    away the max pred is from the actual pulling
    """
    diffs = []
    for true, pred in zip(trues, preds):
        diffs.append(np.abs(true.mean() - pred.mean()))
    return np.array(diffs).mean()


def print_all_metrics(y_test, y_test_pred_probs, thresh):
    print(classification_report(y_test, y_test_pred_probs > thresh))
    trues, preds = get_starts_from_labels(y_test, y_test_pred_probs)
    print(f"mean plate appearance diff: {round(mean_pa_diff(trues, preds), 5)}")
    print(f"mean target diff: {round(mean_target_diff(trues, preds), 5)}")
    cm(y_test, y_test_pred_probs, thresh)