# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/00_data_acquisition.ipynb (unless otherwise specified).

__all__ = ['query_statcast']

# Internal Cell
from pybaseball import statcast
import pandas as pd
from fastscript import *
import sqlite3

# Cell

@call_parse
def query_statcast(start_dt: Param(help="Beginning date to pull data from", type=str)=None,
                   end_dt: Param(help="End date to pull data from", type=str)=None,
                   team: Param(help="Abbreviation for team of interest", type=str)=None,
                   verbose: Param(help="Whether or not to print verbose updates", type=bool_arg)=True,
                   output_type: Param(help="What format to save data in", type=str)="db",
                   overwrite: Param(help="Whether or not to overwrite the db table if it already exists",
                                   type=bool_arg)=True,
                   output_path: Param(help="path to location that data should be saved", type=str)="."):
    """
    Note, working with sqlite files, as opposed to csv files is the recommended usage.
    """
    # pulling data from statcast
    data = statcast(start_dt, end_dt, team, verbose)
    if output_type not in ('db', 'csv'):
        raise ValueError("output_type must be one of {'db', 'csv'}")
    elif output_type == "db":
        conn = sqlite3.connect(f"{output_path}/statcast_pitches.db")
        if overwrite:
            conn.execute(f"DROP TABLE IF EXISTS statcast_{start_dt[:4]}")
        data.to_sql(f"statcast_{start_dt[:4]}", conn)
        conn.close()
    else:
        # output type must be csv
        data.to_csv(f"{output_path}/statcast_{start_dt[:4]}.csv", index=False)

    return None