"""Added video_type column, made character foreign keys not nullable

Revision ID: d51287a30494
Revises: ae93ed2eb8f0
Create Date: 2017-07-30 10:17:12.878851

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql

# revision identifiers, used by Alembic.
revision = "d51287a30494"
down_revision = "ae93ed2eb8f0"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(
        "characters",
        "actor_id",
        existing_type=mysql.INTEGER(display_width=11),
        nullable=False,
    )
    op.alter_column(
        "characters",
        "series_id",
        existing_type=mysql.INTEGER(display_width=11),
        nullable=False,
    )
    op.add_column(
        "videos", sa.Column("video_type", sa.String(length=48), nullable=False)
    )
    op.drop_index("video_display_name", table_name="videos")
    op.drop_column("videos", "video_display_name")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "videos",
        sa.Column("video_display_name", mysql.VARCHAR(length=156), nullable=False),
    )
    op.create_index("video_display_name", "videos", ["video_display_name"], unique=True)
    op.drop_column("videos", "video_type")
    op.alter_column(
        "characters",
        "series_id",
        existing_type=mysql.INTEGER(display_width=11),
        nullable=True,
    )
    op.alter_column(
        "characters",
        "actor_id",
        existing_type=mysql.INTEGER(display_width=11),
        nullable=True,
    )
    # ### end Alembic commands ###
