"""add cols to scene objects

Revision ID: 9ed6a9a6c874
Revises: eae01b0af1c7
Create Date: 2023-02-18 15:11:34.926115

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql

# revision identifiers, used by Alembic.
revision = "9ed6a9a6c874"
down_revision = "eae01b0af1c7"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "scene_objects", sa.Column("video_frame_number", sa.Integer(), nullable=False)
    )
    op.add_column(
        "scene_objects", sa.Column("scene_frame_number", sa.Integer(), nullable=False)
    )
    op.drop_index("scene_object_frame", table_name="scene_objects")
    op.create_unique_constraint(
        "scene_frame_object",
        "scene_objects",
        ["scene_id", "scene_frame_number", "object_number"],
    )
    op.create_unique_constraint(
        "video_frame_object",
        "scene_objects",
        ["video_id", "video_frame_number", "object_number"],
    )
    op.drop_column("scene_objects", "frame_number")
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "scene_objects",
        sa.Column(
            "frame_number",
            mysql.INTEGER(display_width=11),
            autoincrement=False,
            nullable=False,
        ),
    )
    op.drop_constraint("video_frame_object", "scene_objects", type_="unique")
    op.drop_constraint("scene_frame_object", "scene_objects", type_="unique")
    op.create_index(
        "scene_object_frame",
        "scene_objects",
        ["scene_id", "object_number", "frame_number"],
        unique=False,
    )
    op.drop_column("scene_objects", "scene_frame_number")
    op.drop_column("scene_objects", "video_frame_number")
    # ### end Alembic commands ###
