"""added dlib face tables 2

Revision ID: 6b385de534b7
Revises: c56cae55295e
Create Date: 2020-06-03 13:54:49.975618

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql

# revision identifiers, used by Alembic.
revision = "6b385de534b7"
down_revision = "c56cae55295e"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "dlib_faces_aligned",
        sa.Column("dlib_faces_aligned_id", sa.Integer(), nullable=False),
        sa.Column("video_id", sa.Integer(), nullable=True),
        sa.Column("frame_id", sa.Integer(), nullable=True),
        sa.Column("episode_id", sa.Integer(), nullable=True),
        sa.Column("object_number", sa.Integer(), nullable=False),
        sa.Column("object_x", sa.Integer(), nullable=False),
        sa.Column("object_y", sa.Integer(), nullable=False),
        sa.Column("object_w", sa.Integer(), nullable=False),
        sa.Column("object_h", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["episode_id"],
            ["episodes.episode_id"],
        ),
        sa.ForeignKeyConstraint(
            ["frame_id"],
            ["frames.frame_id"],
        ),
        sa.ForeignKeyConstraint(
            ["video_id"],
            ["videos.video_id"],
        ),
        sa.PrimaryKeyConstraint("dlib_faces_aligned_id"),
        sa.UniqueConstraint(
            "video_id", "frame_id", "object_number", name="dlib_faces_aligned"
        ),
    )
    op.create_table(
        "dlib_faces_unaligned",
        sa.Column("dlib_faces_unaligned_id", sa.Integer(), nullable=False),
        sa.Column("video_id", sa.Integer(), nullable=True),
        sa.Column("frame_id", sa.Integer(), nullable=True),
        sa.Column("episode_id", sa.Integer(), nullable=True),
        sa.Column("object_number", sa.Integer(), nullable=False),
        sa.Column("object_x", sa.Integer(), nullable=False),
        sa.Column("object_y", sa.Integer(), nullable=False),
        sa.Column("object_w", sa.Integer(), nullable=False),
        sa.Column("object_h", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["episode_id"],
            ["episodes.episode_id"],
        ),
        sa.ForeignKeyConstraint(
            ["frame_id"],
            ["frames.frame_id"],
        ),
        sa.ForeignKeyConstraint(
            ["video_id"],
            ["videos.video_id"],
        ),
        sa.PrimaryKeyConstraint("dlib_faces_unaligned_id"),
        sa.UniqueConstraint(
            "video_id", "frame_id", "object_number", name="dlib_face_unaligned"
        ),
    )
    op.drop_index("airflow_dag_id", table_name="processes")
    op.drop_index("process_name", table_name="processes")
    op.drop_column("processes", "process_order")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "processes",
        sa.Column(
            "process_order",
            mysql.INTEGER(display_width=11),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.create_index("process_name", "processes", ["process_name"], unique=True)
    op.create_index("airflow_dag_id", "processes", ["airflow_dag_id"], unique=True)
    op.drop_table("dlib_faces_unaligned")
    op.drop_table("dlib_faces_aligned")
    # ### end Alembic commands ###
