"""added processes and triggers tables

Revision ID: 499e890aa148
Revises: babc9bcf7b14
Create Date: 2018-02-11 20:29:01.811394

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "499e890aa148"
down_revision = "babc9bcf7b14"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "processes",
        sa.Column("process_id", sa.Integer(), nullable=False),
        sa.Column("process_name", sa.String(length=32), nullable=False),
        sa.Column("airflow_dag_id", sa.String(length=32), nullable=False),
        sa.PrimaryKeyConstraint("process_id"),
    )
    op.create_table(
        "triggers",
        sa.Column("trigger_id", sa.Integer(), nullable=False),
        sa.Column("video_id", sa.Integer(), nullable=False),
        sa.Column("process_id", sa.Integer(), nullable=False),
        sa.Column("status_complete", sa.Boolean(), nullable=False),
        sa.ForeignKeyConstraint(
            ["process_id"],
            ["processes.process_id"],
        ),
        sa.ForeignKeyConstraint(
            ["video_id"],
            ["videos.video_id"],
        ),
        sa.PrimaryKeyConstraint("trigger_id"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("triggers")
    op.drop_table("processes")
    # ### end Alembic commands ###
