from pytpp.attributes._helper import IterableMeta, Attribute
from pytpp.attributes.schedule_base import ScheduleBaseAttributes
from pytpp.attributes.top import TopAttributes


class CAImportAttributes(ScheduleBaseAttributes, TopAttributes, metaclass=IterableMeta):
    __config_class__ = "{key}"
    amazon_private_ca = Attribute('Amazon Private CA', min_version='21.2')
    assign_contact_value_to_issued_to = Attribute('Assign Contact value to Issued To', min_version='19.1')
    automatically_import = Attribute('Automatically Import')
    aws_credential_dn = Attribute('Aws Credential DN', min_version='21.2')
    bypass_reconciliation = Attribute('Bypass Reconciliation', min_version='15.1')
    ca_type = Attribute('CA Type')
    certificate_credential = Attribute('Certificate Credential', min_version='19.1')
    certificate_origin = Attribute('Certificate Origin', min_version='19.2')
    credential = Attribute('Credential')
    default_container = Attribute('Default Container')
    discover_all = Attribute('Discover All')
    driver_name = Attribute('Driver Name')
    f5_ltm_advanced_hostname = Attribute('F5 LTM Advanced:Hostname', min_version='15.2')
    import_summary = Attribute('Import Summary', min_version='19.1')
    in_progress = Attribute('In Progress')
    include_expired = Attribute('Include Expired')
    include_revoked = Attribute('Include Revoked')
    last_processed_id = Attribute('Last Processed Id', min_version='19.1')
    last_run = Attribute('Last Run')
    last_update = Attribute('Last Update')
    log_debug = Attribute('Log Debug', min_version='19.3')
    microsoft_ca_hostname = Attribute('Microsoft CA:Hostname')
    microsoft_ca_query_by_template_name = Attribute('Microsoft CA:Query By Template Name', min_version='15.3')
    microsoft_ca_request_id = Attribute('Microsoft CA:Request ID')
    microsoft_ca_request_id_by_template_name = Attribute('Microsoft CA:Request ID By Template Name', min_version='15.3')
    microsoft_ca_service_name = Attribute('Microsoft CA:Service Name')
    microsoft_ca_template = Attribute('Microsoft CA:Template')
    page_size = Attribute('Page Size', min_version='16.4')
    placement_rule = Attribute('Placement Rule')
    placement_rule_item = Attribute('Placement Rule Item')
    placement_summary = Attribute('Placement Summary')
    powershell_script = Attribute('PowerShell Script', min_version='19.1')
    powershell_script_hash_vault_id = Attribute('PowerShell Script Hash Vault Id', min_version='19.1')
    profile_string = Attribute('Profile String', min_version='20.1')
    region_code = Attribute('Region Code', min_version='21.2')
    result_count = Attribute('Result Count')
    s3_bucket = Attribute('S3 Bucket', min_version='21.2')
    script_execution_timeout = Attribute('Script Execution Timeout', min_version='20.2')
    script_hash_mismatch_error = Attribute('Script Hash Mismatch Error', min_version='19.1')
    secondary_credential = Attribute('Secondary Credential', min_version='19.1')
    service_address = Attribute('Service Address', min_version='20.1')
    status = Attribute('Status')
    stop_requested = Attribute('Stop Requested')
    template_name_certificate_origin = Attribute('Template Name Certificate Origin', min_version='19.2')
    use_external_msca_communicator = Attribute('Use External MSCA Communicator', min_version='22.1')
