import logging
from logging.config import dictConfig
import json


class Logger:
    def __init__(self, config_dict: dict = None):
        if self.config_dict is not None:
            self.config_dict = config_dict
        else:
            self.config_dict = {
                "formatters": {
                    "f": {
                        {'format': "%(levelname)s: %(message)s"}
                    }
                },
                "handlers": {
                    'h': {
                        {'class': 'logging.StreamHandler',
                            'formatter': "f", "level": 10}
                    }
                },
                "root": {
                    "handlers": ['h'], "level": 10
                }
            }

        dictConfig(self.config_dict)

        self.logger = logging.getLogger()

    def log(self, message: str, level: str) -> None:
        levels = {
            "info": self.logger.info,
            "debug": self.logger.debug,
            "warning": self.logger.warning,
            "error": self.logger.error,
            "critical": self.logger.critical
        }

        levels[level](message)


def config_from_json(path: str) -> dict:
    with open(path, "r") as f:
        config_dict = json.load(f)

    return config_dict
