# Generated by Django 2.2.16 on 2020-10-07 19:07

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django_trips.mixins


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=70)),
                ('slug', models.SlugField(blank=True, max_length=85, null=True)),
                ('deleted', models.BooleanField(default=False)),
            ],
            bases=(django_trips.mixins.SlugMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Facility',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=70)),
                ('slug', models.SlugField(blank=True, max_length=85, null=True)),
                ('deleted', models.BooleanField(default=False)),
            ],
            options={
                'verbose_name_plural': 'Facilities',
                'ordering': ['name'],
            },
            bases=(django_trips.mixins.SlugMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Host',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50)),
                ('slug', models.SlugField(blank=True, max_length=70, null=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('cancellation_policy', models.TextField(blank=True, null=True)),
                ('verified', models.BooleanField(default=False)),
            ],
            options={
                'ordering': ['name', 'verified'],
            },
            bases=(django_trips.mixins.SlugMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Location',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('slug', models.SlugField(blank=True, null=True)),
                ('coordinates', models.CharField(blank=True, max_length=50, null=True)),
                ('is_active', models.BooleanField(default=True)),
            ],
            options={
                'ordering': ['name'],
            },
            bases=(django_trips.mixins.SlugMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Trip',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=500, verbose_name='Title')),
                ('slug', models.SlugField(blank=True, max_length=100, null=True)),
                ('description', models.TextField()),
                ('_metadata', models.TextField(blank=True, default='{}', null=True)),
                ('duration', models.SmallIntegerField(blank=True, default=0, null=True)),
                ('age_limit', models.SmallIntegerField(blank=True, default=0, null=True)),
                ('gear', models.TextField(blank=True, null=True, verbose_name='Recommended Gear')),
                ('deleted', models.BooleanField(default=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('category', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='django_trips.Category')),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='created_by_trips', to=settings.AUTH_USER_MODEL)),
                ('departure', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='trip_departure', to='django_trips.Location')),
                ('destination', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='trip_destination', to='django_trips.Location')),
                ('facilities', models.ManyToManyField(related_name='trip_facilities', to='django_trips.Facility')),
                ('host', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='host_trips', to='django_trips.Host')),
                ('locations', models.ManyToManyField(related_name='trip_locations', to='django_trips.Location')),
            ],
            options={
                'ordering': ['-created_at', '-id'],
            },
            bases=(django_trips.mixins.SlugMixin, models.Model),
        ),
        migrations.CreateModel(
            name='TripSchedule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('price', models.SmallIntegerField(default=0)),
                ('date_from', models.DateTimeField()),
                ('trip', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='trip_schedule', to='django_trips.Trip')),
            ],
        ),
        migrations.CreateModel(
            name='TripReviewSummary',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('meals', models.FloatField(default=0)),
                ('accommodation', models.FloatField(default=0)),
                ('transport', models.FloatField(default=0)),
                ('value_for_money', models.FloatField(default=0)),
                ('overall', models.FloatField(default=0)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('trip', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='trip_review_summary', to='django_trips.Trip')),
            ],
            options={
                'verbose_name_plural': 'Trip review summaries',
            },
        ),
        migrations.CreateModel(
            name='TripReview',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('meals', models.SmallIntegerField(default=0)),
                ('accommodation', models.SmallIntegerField(default=0)),
                ('transport', models.SmallIntegerField(default=0)),
                ('value_for_money', models.SmallIntegerField(default=0)),
                ('overall', models.SmallIntegerField(default=0)),
                ('comment', models.TextField()),
                ('name', models.CharField(max_length=50)),
                ('email', models.EmailField(max_length=254)),
                ('is_verified', models.BooleanField(default=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('trip', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='trip_reviews', to='django_trips.Trip')),
            ],
        ),
        migrations.CreateModel(
            name='TripPickupLocation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('additional_price', models.SmallIntegerField(default=0)),
                ('location', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_trips.Location')),
                ('trip', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='trip_pickup_locations', to='django_trips.TripSchedule')),
            ],
        ),
        migrations.CreateModel(
            name='TripBooking',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=60)),
                ('phone_number', models.CharField(max_length=30)),
                ('cnic_number', models.CharField(max_length=30)),
                ('email', models.EmailField(max_length=254)),
                ('message', models.TextField()),
                ('schedule', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='trip_bookings', to='django_trips.TripSchedule')),
            ],
        ),
        migrations.CreateModel(
            name='CancellationPolicy',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('change_date', models.DateTimeField(auto_now_add=True, verbose_name='Change date')),
                ('enabled', models.BooleanField(default=False, verbose_name='Enabled')),
                ('description', models.TextField()),
                ('changed_by', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL, verbose_name='Changed by')),
            ],
            options={
                'ordering': ('-change_date',),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='TripItinerary',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('day', models.SmallIntegerField(default=0)),
                ('heading', models.CharField(blank=True, max_length=150, null=True)),
                ('description', models.TextField(default='')),
                ('trip', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='trip_itinerary', to='django_trips.Trip')),
            ],
            options={
                'verbose_name_plural': 'Trip Itineraries',
                'ordering': ['trip', 'day'],
                'unique_together': {('trip', 'day')},
            },
        ),
    ]
