import subprocess
from pathlib import Path
from unittest import TestCase

from bx_py_utils.doc_write.api import GeneratedInfo, generate
from bx_py_utils.path import assert_is_file


class DocuWriteApiTestCase(TestCase):
    def test_up2date_docs(self):
        """DocWrite: README.md # Documentation
        Our documentation is generated by `bx_py_utils.doc_write`.
        They automatically updated by the unittests.
        More information here:
            https://github.com/boxine/bx_py_utils/tree/master/bx_py_utils/doc_write
        """
        assert_is_file(Path.cwd() / 'pyproject.toml')  # Test run from project root?

        info: GeneratedInfo = generate()
        self.assertGreaterEqual(len(info.paths), 1)
        try:
            self.assertEqual(info.update_count, 0, 'No files should be updated, commit the changes')
            self.assertEqual(info.remove_count, 0, 'No files should be removed, commit the changes')
        except AssertionError:
            subprocess.call(['git', 'diff'])
            raise
