"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import frogml_proto.qwak.execution.v1.backfill_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _JobStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _JobStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_JobStatus.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    JOB_STATUS_INVALID: _JobStatus.ValueType  # 0
    """Job state"""
    JOB_STATUS_COMPLETED: _JobStatus.ValueType  # 3
    """Job has completed"""
    JOB_STATUS_FAILED: _JobStatus.ValueType  # 4
    """Job has failed"""
    JOB_STATUS_TOO_EARLY: _JobStatus.ValueType  # 5
    """Job is too early - we shouldn't get there but that's a marker"""
    LEGACY_JOB_STATUS_RUNNING: _JobStatus.ValueType  # 6
    """This is for supporting initPagination and showing jobs from the legacy job service - job is running"""
    LEGACY_JOB_STATUS_PENDING: _JobStatus.ValueType  # 7
    """This is for supporting initPagination and showing jobs from the legacy job service - job is pending"""

class JobStatus(_JobStatus, metaclass=_JobStatusEnumTypeWrapper): ...

JOB_STATUS_INVALID: JobStatus.ValueType  # 0
"""Job state"""
JOB_STATUS_COMPLETED: JobStatus.ValueType  # 3
"""Job has completed"""
JOB_STATUS_FAILED: JobStatus.ValueType  # 4
"""Job has failed"""
JOB_STATUS_TOO_EARLY: JobStatus.ValueType  # 5
"""Job is too early - we shouldn't get there but that's a marker"""
LEGACY_JOB_STATUS_RUNNING: JobStatus.ValueType  # 6
"""This is for supporting initPagination and showing jobs from the legacy job service - job is running"""
LEGACY_JOB_STATUS_PENDING: JobStatus.ValueType  # 7
"""This is for supporting initPagination and showing jobs from the legacy job service - job is pending"""
global___JobStatus = JobStatus

class JobRecord(google.protobuf.message.Message):
    """Feature Store Job Record.
    Represents a job generated from featureset
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class JobLabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    JOB_ID_FIELD_NUMBER: builtins.int
    LEGACY_RUN_ID_FIELD_NUMBER: builtins.int
    EXECUTION_ID_FIELD_NUMBER: builtins.int
    FEATURESET_NAME_FIELD_NUMBER: builtins.int
    FEATURESET_ID_FIELD_NUMBER: builtins.int
    ENVIRONMENT_ID_FIELD_NUMBER: builtins.int
    ACCOUNT_ID_FIELD_NUMBER: builtins.int
    JOB_STATUS_FIELD_NUMBER: builtins.int
    CREATION_TIME_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    JOB_METADATA_FIELD_NUMBER: builtins.int
    JOB_LABELS_FIELD_NUMBER: builtins.int
    CODE_FIELD_NUMBER: builtins.int
    INFO_FIELD_NUMBER: builtins.int
    job_id: builtins.str
    """Unique id of the job"""
    legacy_run_id: builtins.int
    """The legacy run id (meaning this job was actually managed by the old job service)"""
    execution_id: builtins.str
    """Execution Manager Execution ID"""
    featureset_name: builtins.str
    """Featureset name"""
    featureset_id: builtins.str
    """Featureset id"""
    environment_id: builtins.str
    """Environment_id"""
    account_id: builtins.str
    """Account ID"""
    job_status: global___JobStatus.ValueType
    """State of the job - whether it's running, failed, pending, etc"""
    @property
    def creation_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Job Creation time - the time at which it arrived at the database"""
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Start time - the time at which the job started executing"""
    @property
    def end_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """End time - the time at which the job attained its final status"""
    @property
    def job_metadata(self) -> global___JobMetadata:
        """Job-Specific metadata"""
    @property
    def job_labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Labels/ Tags associated with this job.
        Stuff like Tshirt size/ comments etc. go here
        """
    code: builtins.str
    """Classify this job with a specific code, whether failed or successful"""
    @property
    def info(self) -> global___FailureInformation: ...
    def __init__(
        self,
        *,
        job_id: builtins.str = ...,
        legacy_run_id: builtins.int = ...,
        execution_id: builtins.str = ...,
        featureset_name: builtins.str = ...,
        featureset_id: builtins.str = ...,
        environment_id: builtins.str = ...,
        account_id: builtins.str = ...,
        job_status: global___JobStatus.ValueType = ...,
        creation_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        job_metadata: global___JobMetadata | None = ...,
        job_labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        code: builtins.str = ...,
        info: global___FailureInformation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["creation_time", b"creation_time", "end_time", b"end_time", "exec_id", b"exec_id", "execution_id", b"execution_id", "failure_info", b"failure_info", "info", b"info", "job_metadata", b"job_metadata", "legacy_run_id", b"legacy_run_id", "start_time", b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["account_id", b"account_id", "code", b"code", "creation_time", b"creation_time", "end_time", b"end_time", "environment_id", b"environment_id", "exec_id", b"exec_id", "execution_id", b"execution_id", "failure_info", b"failure_info", "featureset_id", b"featureset_id", "featureset_name", b"featureset_name", "info", b"info", "job_id", b"job_id", "job_labels", b"job_labels", "job_metadata", b"job_metadata", "job_status", b"job_status", "legacy_run_id", b"legacy_run_id", "start_time", b"start_time"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["exec_id", b"exec_id"]) -> typing_extensions.Literal["legacy_run_id", "execution_id"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["failure_info", b"failure_info"]) -> typing_extensions.Literal["info"] | None: ...

global___JobRecord = JobRecord

class JobMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BATCH_INGESTION_METADATA_FIELD_NUMBER: builtins.int
    BATCH_BACKFILL_INGESTION_METADATA_FIELD_NUMBER: builtins.int
    @property
    def batch_ingestion_metadata(self) -> global___BatchIngestionMetadata:
        """"regular" batch job"""
    @property
    def batch_backfill_ingestion_metadata(self) -> global___BatchBackfillMetadata:
        """batch backfill"""
    def __init__(
        self,
        *,
        batch_ingestion_metadata: global___BatchIngestionMetadata | None = ...,
        batch_backfill_ingestion_metadata: global___BatchBackfillMetadata | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["batch_backfill_ingestion_metadata", b"batch_backfill_ingestion_metadata", "batch_ingestion_metadata", b"batch_ingestion_metadata", "metadata_type", b"metadata_type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["batch_backfill_ingestion_metadata", b"batch_backfill_ingestion_metadata", "batch_ingestion_metadata", b"batch_ingestion_metadata", "metadata_type", b"metadata_type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["metadata_type", b"metadata_type"]) -> typing_extensions.Literal["batch_ingestion_metadata", "batch_backfill_ingestion_metadata"] | None: ...

global___JobMetadata = JobMetadata

class BatchIngestionMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INGESTED_DATA_START_TIME_FIELD_NUMBER: builtins.int
    INGESTED_DATA_END_TIME_FIELD_NUMBER: builtins.int
    NUM_AFFECTED_ROWS_FIELD_NUMBER: builtins.int
    BATCH_EXECUTION_DATE_FIELD_NUMBER: builtins.int
    @property
    def ingested_data_start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Ingested data window start time"""
    @property
    def ingested_data_end_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Ingested data window end time"""
    num_affected_rows: builtins.int
    """Number of affected rows"""
    @property
    def batch_execution_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Logical batch date"""
    def __init__(
        self,
        *,
        ingested_data_start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        ingested_data_end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        num_affected_rows: builtins.int = ...,
        batch_execution_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["batch_execution_date", b"batch_execution_date", "ingested_data_end_time", b"ingested_data_end_time", "ingested_data_start_time", b"ingested_data_start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["batch_execution_date", b"batch_execution_date", "ingested_data_end_time", b"ingested_data_end_time", "ingested_data_start_time", b"ingested_data_start_time", "num_affected_rows", b"num_affected_rows"]) -> None: ...

global___BatchIngestionMetadata = BatchIngestionMetadata

class BatchBackfillMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NUM_INTERVAL_ROWS_FIELD_NUMBER: builtins.int
    BACKFILL_SPEC_FIELD_NUMBER: builtins.int
    NUM_AFFECTED_ROWS_FIELD_NUMBER: builtins.int
    OFFLINE_PROCESSING_START_TIME_FIELD_NUMBER: builtins.int
    OFFLINE_PROCESSING_END_TIME_FIELD_NUMBER: builtins.int
    ONLINE_PROCESSING_START_TIME_FIELD_NUMBER: builtins.int
    ONLINE_PROCESSING_END_TIME_FIELD_NUMBER: builtins.int
    LAST_BATCH_LOGICAL_DATE_FIELD_NUMBER: builtins.int
    num_interval_rows: builtins.int
    """Number of rows in the interval (incoming)"""
    @property
    def backfill_spec(self) -> frogml_proto.qwak.execution.v1.backfill_pb2.BackfillSpec:
        """Backfill spec"""
    num_affected_rows: builtins.int
    """Number of affected rows"""
    @property
    def offline_processing_start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """SYSTEM time where offline processing started"""
    @property
    def offline_processing_end_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """SYSTEM time where offline processing ended"""
    @property
    def online_processing_start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """SYSTEM time when online processing started"""
    @property
    def online_processing_end_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """SYSTEM time when online processing ended"""
    @property
    def last_batch_logical_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Logical time (cron tick) of the last batch in the backfill"""
    def __init__(
        self,
        *,
        num_interval_rows: builtins.int = ...,
        backfill_spec: frogml_proto.qwak.execution.v1.backfill_pb2.BackfillSpec | None = ...,
        num_affected_rows: builtins.int = ...,
        offline_processing_start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        offline_processing_end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        online_processing_start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        online_processing_end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        last_batch_logical_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["backfill_spec", b"backfill_spec", "last_batch_logical_date", b"last_batch_logical_date", "offline_processing_end_time", b"offline_processing_end_time", "offline_processing_start_time", b"offline_processing_start_time", "online_processing_end_time", b"online_processing_end_time", "online_processing_start_time", b"online_processing_start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["backfill_spec", b"backfill_spec", "last_batch_logical_date", b"last_batch_logical_date", "num_affected_rows", b"num_affected_rows", "num_interval_rows", b"num_interval_rows", "offline_processing_end_time", b"offline_processing_end_time", "offline_processing_start_time", b"offline_processing_start_time", "online_processing_end_time", b"online_processing_end_time", "online_processing_start_time", b"online_processing_start_time"]) -> None: ...

global___BatchBackfillMetadata = BatchBackfillMetadata

class FailureInformation(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORIGINAL_ERROR_MESSAGE_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    original_error_message: builtins.str
    """original error message that failed to job"""
    message: builtins.str
    def __init__(
        self,
        *,
        original_error_message: builtins.str = ...,
        message: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["formatted_error_message", b"formatted_error_message", "message", b"message"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["formatted_error_message", b"formatted_error_message", "message", b"message", "original_error_message", b"original_error_message"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["formatted_error_message", b"formatted_error_message"]) -> typing_extensions.Literal["message"] | None: ...

global___FailureInformation = FailureInformation
