"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaFunctionAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
/**
 * (experimental) The action to invoke an AWS Lambda function, passing in an MQTT message.
 *
 * @experimental
 */
class LambdaFunctionAction {
    /**
     * @param func The lambda function to be invoked by this action.
     * @experimental
     */
    constructor(func) {
        this.func = func;
    }
    /**
     * (experimental) (experimental) Returns the topic rule action specification.
     *
     * @experimental
     */
    bind(topicRule) {
        this.func.addPermission('invokedByAwsIotRule', {
            action: 'lambda:InvokeFunction',
            principal: new iam.ServicePrincipal('iot.amazonaws.com'),
            sourceAccount: topicRule.env.account,
            sourceArn: topicRule.topicRuleArn,
        });
        return {
            configuration: {
                lambda: {
                    functionArn: this.func.functionArn,
                },
            },
        };
    }
}
exports.LambdaFunctionAction = LambdaFunctionAction;
_a = JSII_RTTI_SYMBOL_1;
LambdaFunctionAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.LambdaFunctionAction", version: "2.0.0-alpha.5" };
//# sourceMappingURL=data:application/json;base64,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