# This package constructs a suffix tree and then generates suffix-array and lcp-array using gen-lcp and search-st2 creates a suffix tree in linear time using the suffix array and lcp-array generated by the gen-lcp.

## Folder structure
- `resources/` - contains our experiment results and test inputs
- `scripts` - contains python scripts(except the `setup.py` file which is in the root)
- The files under project root is required to properly package our script and build the command line tools
## Requirements:
- python version >= 3.9
- setuptools
- wheel
- pip >= 3.9

## Installation:
- Using Pip:
```commandline
pip install pat-match-st2
```
- Build locally:
    - Make sure you fulfil the requirements.
    - `pip install .`
    - That's it.
- Proceeding with any of the above methods will install the version `1.0.0`(current).
- Finally, both the above methods will install the following cmd tool: `gen-lcp` and `search-st2`.

## Usage:
- `gen-lcp`
```commandline
gen_lcp [-h] fasta_file
```

```text
usage: gen_lcp.py [-h] fasta_file

Matches a pattern using the naive suffix-tree implementation

positional arguments:
  fasta_file  fasta file

optional arguments:
  -h, --help  show this help message and exit
```

When ran successfully, it will generate the output text-file(name based on the fasta input file) in the current directory. E.g.
```commandline
gen_lcp fasta_file.fa
```
outputs
```text
/path/to/current/dir/fasta_file_sa-lcp.txt
```

- `search-st2`

```commandline
search_st2 [-h] [-p] fasta_file [fastq_file]
```

```text
usage: search_st2.py [-h] [-p] fasta_file [fastq_file]

Matches a pattern using the naive suffix-tree implementation

positional arguments:
  fasta_file  fasta file
  fastq_file  fastq file

optional arguments:
  -h, --help  show this help message and exit
  -p          preprocess genome
```

When ran successfully, it will generate the
-  output sam-file(name based on the fasta input file) in the current director when ran without the `-p` option. E.g.
   ```commandline 
   search_st2 fasta_file.fa fastq_file.fq
   ```
   outputs
   ```text
    /path/to/current/dir/fasta_input_exp_output.sam
   ```
   <u>NOTE</u>: Before running this, the tool expects that you have a preprocessed text-file named based on the input fasta file.
   

-  preprocessing text-file(similar to what `gen-lcp` does) in the current directory when ran with `-p` option. E.g.
   ```commandline 
   search_st2 -p fasta_file.fa
   ```
   outputs
   ```text
    /path/to/current/dir/fasta_input_sa-lcp.txt
   ```