"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const lambda = require("@aws-cdk/aws-lambda");
const sfn = require("@aws-cdk/aws-stepfunctions");
const core_1 = require("@aws-cdk/core");
const tasks = require("../../lib");
let stack;
let fn;
beforeEach(() => {
    stack = new core_1.Stack();
    fn = new lambda.Function(stack, 'Fn', {
        code: lambda.Code.fromInline('hello'),
        handler: 'index.hello',
        runtime: lambda.Runtime.PYTHON_2_7,
    });
});
test('Invoke lambda with function ARN', () => {
    // WHEN
    const task = new sfn.Task(stack, 'Task', { task: new tasks.InvokeFunction(fn) });
    new sfn.StateMachine(stack, 'SM', {
        definition: task,
    });
    // THEN
    expect(stack).toHaveResource('AWS::StepFunctions::StateMachine', {
        DefinitionString: {
            'Fn::Join': ['', [
                    '{"StartAt":"Task","States":{"Task":{"End":true,"Type":"Task","Resource":"',
                    { 'Fn::GetAtt': ['Fn9270CBC0', 'Arn'] },
                    '"}}}',
                ]],
        },
    });
});
test('Lambda function payload ends up in Parameters', () => {
    new sfn.StateMachine(stack, 'SM', {
        definition: new sfn.Task(stack, 'Task', {
            task: new tasks.InvokeFunction(fn, {
                payload: {
                    foo: sfn.JsonPath.stringAt('$.bar'),
                },
            }),
        }),
    });
    expect(stack).toHaveResource('AWS::StepFunctions::StateMachine', {
        DefinitionString: {
            'Fn::Join': ['', [
                    '{"StartAt":"Task","States":{"Task":{"End":true,"Parameters":{"foo.$":"$.bar"},"Type":"Task","Resource":"',
                    { 'Fn::GetAtt': ['Fn9270CBC0', 'Arn'] },
                    '"}}}',
                ]],
        },
    });
});
//# sourceMappingURL=data:application/json;base64,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