"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ddb = require("@aws-cdk/aws-dynamodb");
const sfn = require("@aws-cdk/aws-stepfunctions");
const cdk = require("@aws-cdk/core");
const tasks = require("../../lib");
let stack;
let table;
beforeEach(() => {
    // GIVEN
    stack = new cdk.Stack();
    table = new ddb.Table(stack, 'my-table', {
        tableName: 'my-table',
        partitionKey: {
            name: 'name',
            type: ddb.AttributeType.STRING,
        },
    });
});
test('PutItem task', () => {
    // WHEN
    const task = new tasks.DynamoPutItem(stack, 'PutItem', {
        item: { SOME_KEY: tasks.DynamoAttributeValue.fromString('1234') },
        table,
        conditionExpression: 'ForumName <> :f and Subject <> :s',
        expressionAttributeNames: { OTHER_KEY: '#OK' },
        expressionAttributeValues: {
            ':val': tasks.DynamoAttributeValue.numberFromString(sfn.JsonPath.stringAt('$.Item.TotalCount.N')),
            ':bool': tasks.DynamoAttributeValue.booleanFromJsonPath(sfn.JsonPath.stringAt('$.Item.flag')),
        },
        returnConsumedCapacity: tasks.DynamoConsumedCapacity.TOTAL,
        returnItemCollectionMetrics: tasks.DynamoItemCollectionMetrics.SIZE,
        returnValues: tasks.DynamoReturnValues.ALL_NEW,
    });
    // THEN
    expect(stack.resolve(task.toStateJson())).toEqual({
        Type: 'Task',
        Resource: {
            'Fn::Join': [
                '',
                [
                    'arn:',
                    {
                        Ref: 'AWS::Partition',
                    },
                    ':states:::dynamodb:putItem',
                ],
            ],
        },
        End: true,
        Parameters: {
            Item: { SOME_KEY: { S: '1234' } },
            TableName: {
                Ref: 'mytable0324D45C',
            },
            ConditionExpression: 'ForumName <> :f and Subject <> :s',
            ExpressionAttributeNames: { OTHER_KEY: '#OK' },
            ExpressionAttributeValues: {
                ':val': { 'N.$': '$.Item.TotalCount.N' },
                ':bool': { 'BOOL.$': '$.Item.flag' },
            },
            ReturnConsumedCapacity: 'TOTAL',
            ReturnItemCollectionMetrics: 'SIZE',
            ReturnValues: 'ALL_NEW',
        },
    });
});
//# sourceMappingURL=data:application/json;base64,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