# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['pyte_prism']

package_data = \
{'': ['*']}

install_requires = \
['selenium>=3.141.0,<4.0.0', 'uritemplate>=3.0.1,<4.0.0']

setup_kwargs = {
    'name': 'pyte-prism',
    'version': '0.0.3',
    'description': 'A Page Object Model DSL for Python, inspired by Ruby SitePrism',
    'long_description': 'PytePrism - A Page Object Model DSL for Python\n==========================================================\ninspired by Ruby SitePrism https://github.com/site-prism/site_prism\n\n\nSynopsis\n-----------\nHere\'s an overview of how PytePrism is designed to be used:\n\n.. code-block:: Python\n\n    from selenium import webdriver\n    from selenium.webdriver.common.by import By\n    from selenium.webdriver.common.keys import Keys\n    from pyte_prism import Page, PageSection, Element, Section, Sections\n    \n    class Menu(PageSection):\n      gmail = Element(By.XPATH, "//a[text()=\'Gmail\']")\n      images = Element(By.XPATH, "//a[text()=\'Images\']")\n    \n    class SearchResult(PageSection):\n      title = Element(By.CSS_SELECTOR, "div.r > a > h3")\n      title_link = Element(By.CSS_SELECTOR, "div.r > a")\n      blurb = Element(By.CSS_SELECTOR, "div.s > div > span")\n    \n    class Home(Page):\n      _url = "https://www.google.com/"\n    \n      search_field = Element(By.CSS_SELECTOR, "input[name=\'q\'")\n      search_button = Element(By.CSS_SELECTOR, "div.FPdoLc.tfB0Bf input[name=\'btnK\']")\n      footer_links = Element(By.CSS_SELECTOR, "#footer a")\n      menu = Section(Menu, By.CSS_SELECTOR, "#gbw")\n    \n    class SearchResults(Page):\n      _url_matcher = "https://www.google.com/results\\?.*"\n    \n      menu = Section(Menu, By.CSS_SELECTOR, "#gbw")\n      search_results = Sections(SearchResult, By.CSS_SELECTOR, "#search > div > div > div.g")\n    \n      def search_result_links(self):\n        return [result.title.get_attribute(\'href\') for result in self.search_results]\n    \n    def main():\n      driver = webdriver.Chrome()\n    \n      home = Home(driver)\n      home.load()\n      home.wait_until_menu_visible()  # menu loads after a second or 2, give it time to arrive\n    \n      print(home.has_menu())          #=> True\n      print(home.has_search_field())  #=> True\n      print(home.has_search_button()) #=> True\n    \n      home.search_field.send_keys("Sausages")\n      home.search_field.send_keys(Keys.ESCAPE) # Close suggestion box\n      home.wait_until_search_button_visible()  # Wait until suggestion box close\n      home.search_button.click()\n    \n      results_page = SearchResults(driver)\n      results_page.is_loaded()  #=> True ( Does _url_matcher matches current_url? )\n      results_page.wait_until_search_results_visible(timeout=30)  # default timeout is 10 sec\n      print(len(results_page.search_results))  #=> about 10\n    \n      titles = [result.title.text for result in results_page.search_results]\n      links =  [result.title_link.get_attribute(\'href\') for result in results_page.search_results]\n      descr =  [result.blurb.text for result in results_page.search_results]\n    \n      from pprint import pprint\n      pprint(list(zip(titles, links, descr)))\n      """\n      #=> [(\'Sausage - Wikipedia\', \'https://en.wikipedia.org/wiki/Sausage\', \'Sausages are ...\'),\n      #    (\'List of sausages - Wikipedia\', \'https://en.wikipedia.org/wiki/List_of_sausages\', \'This is a lias of ...\'),\n      #    ...]\n      """\n    \n    if __name__ == "__main__":\n        main()\n    \nRequirements\n----------------\n\n- Python 3\n\nFeatures\n-----------\n\n- Multiple platforms support: Linux, macOS, Windows\n- Pure python\n\nThe Installation\n------------------\n\nFrom Pypi with the Python package manager:\n\n.. code-block:: console\n    \n    pip install pyte-prism\n    \nTo install the cutting edge version from the git repository:\n\n.. code-block:: console\n    \n    git clone https://github.com/fkshom/pyte-prism.git\n    cd pyte-prism\n    python setup.py install\n\nExamples\n-----------\n\n.. code-block:: python\n\n    from selenium import webdriver\n    from selenium.webdriver.common.by import By\n    from selenium.webdriver.common.keys import Keys\n    from pyte_prism import Page, PageSection, PageIframe, Element, Section, Sections, Iframe\n\n    # Section must inherit PageSection class\n    class MySection(PageSection):\n      title = Element(By.XPATH, "//div[@class=\'title\']")\n\n    # Iframe must inherit PageIframe class    \n    class MyIframe(PageIframe):\n      title = Element(By.XPATH, "//div[@class=\'title\']")\n\n    # Page must inherit Page class\n    class Home(Page):\n      _url = "http://example.com/"                # _url is used by Page.load() method.\n      _url_matcher = r"https?://example.com/.*"   # _url_matcher is used by Page.is_loaded() method.\n\n      # definition of element\n      go_button = Element(By.ID, "#button")\n      keyword_box = Element(By.ID, "#keyword")\n      items = Elements(By.CSS_SELECTOR, "ul#items > li")\n      section = Setion(MySection, By.ID, "#section")\n      sections = Sections(MySection, By.ID, "#sections")   # MySection is not typo\n      myiframe = IFrame(MyIframe, BY.ID, "#iframe")\n    \n    def main():\n      driver = webdriver.Chrome()\n      home = Home(driver)\n      home.load()                    # visit to "_url"\n      home.wait_until_page_loaded()  # check current_url is  _url or _url_matcher (if defined)\n      home.assert_loaded()           # raise Exception if is_loaded() is False.\n      home.wait_until_page_readystate_is_complete(timeout=10)  # wait until javascript readyState is complete.\n\n      \n      # Defined some supported methods automatically\n      # home.wait_until_<variablename>_visible()          # None or Exception\n      # home.wait_until_<variablename>_invisible()        # None or Exception\n      # home.wait_until_<variablename>_to_be_clickable()  # None or Exception\n      # home.has_<variablename>()                         # True or False\n      # home.has_no_<variablename>()                      # True or False\n      \n      home.keyword_box.send_keys(\'my keyword\')            # element is webdriver element.\n\n      home.wait_until_go_button_visible(timeout=30)       # timeout: default 10\n      home.go_button.click()\n\n      home.section.title.text\n      home.sections[0].title.text\n\n      # swtich to, exit from iframe context automatically\n      with home.myiframe as iframe:\n        iframe.title.text\n\nParametrized URLs\n^^^^^^^^^^^^^^^^^\n\nPytePrism uses the uritemplate module and therefore allows for parameterization of URLs.\nsee https://uritemplate.readthedocs.io/en/latest/\n\n.. code-block:: python\n\n    class Home(Page):\n      _url = \'http://example.com/users{/userid}\'    \n      _url_matcher = \'https?://example.com/users.*\'\n\n    class Home2(Page):\n      _url = \'http://example.com/search{?keyword,lang}\'\n      _url_matcher = \'https?://example.com/search.*\'\n\n    def main():\n      driver = webdriver.Chrome()\n      home = Home(driver)\n      home.load()             # visit to http://example.com/users\n      home.load(userid=100)   # visit to http://example.com/users/100\n\n      home2 = Home2(driver)\n      home2.load(keyword=\'mykeyword\', lang=\'en\')   # visit to http://example.com/saearch?keyword=mykeyword&lang=en\n\n',
    'author': 'Shoma FUKUDA',
    'author_email': 'fkshom+pypi@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/fkshom',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
