# Generated by Django 3.1 on 2020-11-30 15:12

import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ("xlsx_import_tools", "0001_initial"),
    ]

    operations = [
        migrations.AlterField(
            model_name="columndefinition",
            name="aliases",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.CharField(max_length=128),
                help_text="Alternative wordings/spellings for this column header",
                size=None,
            ),
        ),
        migrations.AlterField(
            model_name="columndefinition",
            name="col_name",
            field=models.SlugField(
                help_text="A nicely formatted handle to refer to this column"
            ),
        ),
        migrations.AlterField(
            model_name="sheetdefinition",
            name="aliases",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.CharField(max_length=128),
                help_text="The names which can be used for the workbook sheet to import",
                size=None,
            ),
        ),
        migrations.AlterField(
            model_name="sheetdefinition",
            name="columns",
            field=models.ManyToManyField(
                help_text="Columns to import data from",
                to="xlsx_import_tools.ColumnDefinition",
            ),
        ),
        migrations.AlterField(
            model_name="sheetdefinition",
            name="header_definition",
            field=models.ForeignKey(
                help_text="Aliases of this column are used to search for the header row(s)",
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="xlsx_import_tools.columndefinition",
            ),
        ),
        migrations.AlterField(
            model_name="sheetdefinition",
            name="required",
            field=models.BooleanField(
                default=True,
                help_text="Declare whether this workbook required to be in the excel file",
            ),
        ),
        migrations.AlterField(
            model_name="sheetdefinition",
            name="sheet_name",
            field=models.SlugField(
                help_text="A nicely formatted handle to refer to this sheet"
            ),
        ),
        migrations.CreateModel(
            name="WorkbookDefinition",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "workbook_name",
                    models.SlugField(
                        help_text="A nicely formatted handle to refer to this type of workbook"
                    ),
                ),
                (
                    "sheets",
                    models.ManyToManyField(
                        help_text="Sheets to import data from",
                        to="xlsx_import_tools.SheetDefinition",
                    ),
                ),
            ],
        ),
    ]
